/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis;

import com.docmosis.util.StringUtilities;
import com.docmosis.util.xml.XMLUtilities;
import java.io.Serializable;
import java.util.List;

public class TableCellStyle
implements Serializable {
    private static final String E = "<style:table-cell-properties";
    private static final String C = "fo:background-color";
    public static final char[] ATTRIBUTE_BACKGROUND_COLOUR_CHARS = "fo:background-color".toCharArray();
    public static final String ATTRIBUTE_BORDER_STYLE_TOP = "fo:border-top";
    public static final String ATTRIBUTE_BORDER_STYLE_BOTTOM = "fo:border-bottom";
    public static final String ATTRIBUTE_BORDER_STYLE_LEFT = "fo:border-left";
    public static final String ATTRIBUTE_BORDER_STYLE_RIGHT = "fo:border-right";
    public static final String ATTRIBUTE_BORDER_STYLE = "fo:border";
    private final String B;
    private final CellStyleBreakup A;
    private String D;
    private String H;
    private boolean G;
    private RepeatingRowTopAndBottomBorderStyles F;

    public TableCellStyle(List list) {
        this.A = TableCellStyle.breakup(list);
        this.B = this.A.styleName;
    }

    public TableCellStyle(TableCellStyle tableCellStyle) {
        this.B = tableCellStyle.B;
        this.A = tableCellStyle.A;
        this.H = tableCellStyle.H;
        this.D = tableCellStyle.D;
        this.F = tableCellStyle.F;
        this.G = tableCellStyle.G;
    }

    public void setBorderStyles(String string, String string2) {
        this.F = new RepeatingRowTopAndBottomBorderStyles(string, this.A.borderStyleTop, this.A.borderStyleBottom, string2);
        this.calculateDynamicStyling();
    }

    public boolean borderStylesVary() {
        return this.F != null && this.F.stylesVary();
    }

    private void calculateDynamicStyling() {
        this.G = this.D != null && !this.D.equals(this.H) ? true : this.F != null && this.F.stylesVary();
    }

    public boolean dynamicStylingApplies() {
        return this.G;
    }

    public void setAlternatingBackgroundColours(String string, String string2) {
        this.H = string;
        this.D = string2;
        this.calculateDynamicStyling();
    }

    public char[] getPreStyleName() {
        return this.A.preStyleName;
    }

    public char[] getPostStyleName() {
        return this.A.postStyleName;
    }

    public char[] getRemainder() {
        return this.A.remainder;
    }

    public String getBaseStyleName() {
        return this.B;
    }

    public String getBgColourEven() {
        return this.H;
    }

    public String getBgColourOdd() {
        return this.D;
    }

    public RepeatingRowTopAndBottomBorderStyles getBorderStyles() {
        return this.F;
    }

    public String getOrigBgColour() {
        return this.A.backgroundColour;
    }

    public String getOrigTopBorder() {
        return this.A.borderStyleTop;
    }

    public String getOrigBottomBorder() {
        return this.A.borderStyleBottom;
    }

    public String getOriginalTopBottomBorder() {
        return this.A.originalTopBottomBorderStyleString;
    }

    public String getOriginalLeftBorder() {
        return this.A.borderStyleLeft;
    }

    public String getOriginalRightBorder() {
        return this.A.borderStyleRight;
    }

    static CellStyleBreakup breakup(List list) {
        String string = (String)list.get(0);
        int n = string.indexOf("style:name");
        if (n == -1) {
            throw new IllegalArgumentException("XML Error. Attribute [style:name] not found int style:style tag");
        }
        int n2 = string.indexOf(34, n);
        if (n2 == -1) {
            throw new IllegalArgumentException("XML Error. Attribute [style:name] not followed by value in quotes");
        }
        int n3 = string.indexOf(34, n2 + 1);
        if (n3 == -1) {
            throw new IllegalArgumentException("XML Error. Attribute [style:name] not followed by value in quotes");
        }
        String string2 = string.substring(0, n2 + 1);
        String string3 = string.substring(n2 + 1, n3);
        String string4 = "";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.substring(n3));
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        for (int i = 1; i < list.size(); ++i) {
            String string10 = (String)list.get(i);
            if (string10.startsWith(E)) {
                stringBuffer.append(E).append(' ');
                string4 = stringBuffer.toString();
                stringBuffer.setLength(0);
                string10 = string10.substring(E.length());
                String[] stringArray = TableCellStyle.ripout(C, string10);
                string5 = stringArray[0];
                string10 = stringArray[1];
                stringArray = TableCellStyle.ripout(ATTRIBUTE_BORDER_STYLE_TOP, string10);
                string6 = stringArray[0];
                string10 = stringArray[1];
                stringArray = TableCellStyle.ripout(ATTRIBUTE_BORDER_STYLE_BOTTOM, string10);
                string7 = stringArray[0];
                string10 = stringArray[1];
                stringArray = TableCellStyle.ripout(ATTRIBUTE_BORDER_STYLE_LEFT, string10);
                string8 = stringArray[0];
                string10 = stringArray[1];
                stringArray = TableCellStyle.ripout(ATTRIBUTE_BORDER_STYLE_RIGHT, string10);
                string9 = stringArray[0];
                string10 = stringArray[1];
                stringArray = TableCellStyle.ripout(ATTRIBUTE_BORDER_STYLE, string10);
                if (!StringUtilities.isEmpty(stringArray[0])) {
                    String string11;
                    string6 = string11 = XMLUtilities.getAttributeValue(string10, ATTRIBUTE_BORDER_STYLE);
                    string7 = string11;
                    string8 = string11;
                    string9 = string11;
                    string10 = stringArray[1];
                }
                stringBuffer.append(string10);
                continue;
            }
            stringBuffer.append(string10);
        }
        return new CellStyleBreakup(string2, string3, string4, string5, string6 == null ? "none" : string6, string7 == null ? "none" : string7, string8 == null ? "none" : string8, string9 == null ? "none" : string9, stringBuffer.toString());
    }

    static String[] ripout(String string, String string2) {
        int n;
        int n2;
        String string3 = null;
        int n3 = string2.indexOf(string + "=");
        if (n3 != -1 && (n2 = string2.indexOf(34, n3)) != -1 && (n = string2.indexOf(34, n2 + 1)) != -1) {
            string3 = string2.substring(n2 + 1, n);
            string2 = string2.substring(0, n3) + string2.substring(n + 1);
        }
        return new String[]{string3, string2};
    }

    public static class RepeatingRowTopAndBottomBorderStyles
    implements Serializable {
        private final boolean B;
        private final String[] A = new String[4];

        public RepeatingRowTopAndBottomBorderStyles(String string, String string2, String string3, String string4) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" ").append(TableCellStyle.ATTRIBUTE_BORDER_STYLE_TOP).append("=\"");
            stringBuffer.append(string);
            stringBuffer.append("\" ");
            stringBuffer.append(TableCellStyle.ATTRIBUTE_BORDER_STYLE_BOTTOM).append("=\"");
            stringBuffer.append(string3);
            stringBuffer.append("\" ");
            this.A[0] = stringBuffer.toString();
            stringBuffer.setLength(0);
            stringBuffer.append(" ").append(TableCellStyle.ATTRIBUTE_BORDER_STYLE_TOP).append("=\"");
            stringBuffer.append(string2);
            stringBuffer.append("\" ");
            stringBuffer.append(TableCellStyle.ATTRIBUTE_BORDER_STYLE_BOTTOM).append("=\"");
            stringBuffer.append(string3);
            stringBuffer.append("\" ");
            this.A[1] = stringBuffer.toString();
            stringBuffer.setLength(0);
            stringBuffer.append(" ").append(TableCellStyle.ATTRIBUTE_BORDER_STYLE_TOP).append("=\"");
            stringBuffer.append(string2);
            stringBuffer.append("\" ");
            stringBuffer.append(TableCellStyle.ATTRIBUTE_BORDER_STYLE_BOTTOM).append("=\"");
            stringBuffer.append(string4);
            stringBuffer.append("\" ");
            this.A[2] = stringBuffer.toString();
            stringBuffer.setLength(0);
            stringBuffer.append(" ").append(TableCellStyle.ATTRIBUTE_BORDER_STYLE_TOP).append("=\"");
            stringBuffer.append(string);
            stringBuffer.append("\" ");
            stringBuffer.append(TableCellStyle.ATTRIBUTE_BORDER_STYLE_BOTTOM).append("=\"");
            stringBuffer.append(string4);
            stringBuffer.append("\" ");
            this.A[3] = stringBuffer.toString();
            boolean bl = this.B = !this.A[0].equals(this.A[1]) || !this.A[0].equals(this.A[2]) || !this.A[0].equals(this.A[3]);
            if (!this.B) {
                this.A[1] = this.A[0];
                this.A[2] = this.A[0];
                this.A[3] = this.A[0];
            }
        }

        public String getFirstRowStyle() {
            return this.A[0];
        }

        public String getIntermediateRowStyle() {
            return this.A[1];
        }

        public String getLastRowStyle() {
            return this.A[2];
        }

        public String getOnlyRowStyle() {
            return this.A[3];
        }

        public boolean stylesVary() {
            return this.B;
        }
    }

    static class CellStyleBreakup
    implements Serializable {
        String styleName;
        String backgroundColour;
        String borderStyleTop;
        String borderStyleBottom;
        String borderStyleLeft;
        String borderStyleRight;
        String originalTopBottomBorderStyleString;
        char[] preStyleName;
        char[] postStyleName;
        char[] remainder;

        public CellStyleBreakup(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
            this.preStyleName = string.toCharArray();
            this.styleName = string2;
            this.postStyleName = string3.toCharArray();
            this.backgroundColour = string4;
            this.borderStyleTop = string5;
            this.borderStyleBottom = string6;
            this.borderStyleLeft = string7;
            this.borderStyleRight = string8;
            this.remainder = string9.toCharArray();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" ").append(TableCellStyle.ATTRIBUTE_BORDER_STYLE_TOP).append("=\"");
            stringBuffer.append(string5);
            stringBuffer.append("\" ");
            stringBuffer.append(TableCellStyle.ATTRIBUTE_BORDER_STYLE_BOTTOM).append("=\"");
            stringBuffer.append(string6);
            stringBuffer.append("\" ");
            this.originalTopBottomBorderStyleString = stringBuffer.toString();
        }
    }
}

