/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis;

import com.docmosis.template.analysis.ParsedField;
import com.docmosis.template.analysis.SimpleTemplateSkipSection;
import com.docmosis.template.analysis.TemplateSection;
import java.util.ArrayList;

public class SimpleTemplateSection
implements TemplateSection {
    protected long endIndex;
    protected long startIndex;
    protected TemplateSection[] subSections;
    protected boolean repeatable;
    protected boolean conditional;
    protected boolean container;
    protected SimpleTemplateSection parentSection;
    protected long preAmbleEndIdx;
    protected long postAmbleStartIdx;
    protected boolean skipPreAndPostAmble;
    protected boolean skipSection;
    protected boolean artificial;
    protected transient int depth;
    protected ParsedField parsedFieldDetails;

    protected SimpleTemplateSection() {
    }

    protected void shallowCopyFrom(SimpleTemplateSection simpleTemplateSection) {
        this.endIndex = simpleTemplateSection.endIndex;
        this.startIndex = simpleTemplateSection.startIndex;
        this.subSections = simpleTemplateSection.subSections;
        this.repeatable = simpleTemplateSection.repeatable;
        this.conditional = simpleTemplateSection.conditional;
        this.container = simpleTemplateSection.container;
        this.parentSection = simpleTemplateSection.parentSection;
        this.preAmbleEndIdx = simpleTemplateSection.preAmbleEndIdx;
        this.postAmbleStartIdx = simpleTemplateSection.postAmbleStartIdx;
        this.skipPreAndPostAmble = simpleTemplateSection.skipPreAndPostAmble;
        this.skipSection = simpleTemplateSection.skipSection;
        this.depth = simpleTemplateSection.depth;
        this.parsedFieldDetails = simpleTemplateSection.parsedFieldDetails;
        this.artificial = simpleTemplateSection.artificial;
    }

    @Override
    public long getLength() {
        return this.endIndex - this.startIndex + 1L;
    }

    @Override
    public boolean isConditional() {
        return this.conditional;
    }

    public void setConditional(boolean bl) {
        this.conditional = bl;
    }

    @Override
    public long getEndIndex() {
        return this.endIndex;
    }

    public void setEndIndex(long l) {
        this.endIndex = l;
    }

    @Override
    public boolean isPopulable() {
        return false;
    }

    @Override
    public boolean isRepeatable() {
        return this.repeatable;
    }

    public void setRepeatable(boolean bl) {
        this.repeatable = bl;
    }

    @Override
    public long getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(long l) {
        this.startIndex = l;
    }

    @Override
    public TemplateSection[] getSubSections() {
        return this.subSections;
    }

    public void setSubSections(TemplateSection[] templateSectionArray) {
        this.subSections = templateSectionArray;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int n) {
        this.depth = n;
    }

    @Override
    public boolean isContainer() {
        return this.container;
    }

    @Override
    public boolean isArtificial() {
        return this.artificial;
    }

    public void setArtificial(boolean bl) {
        this.artificial = bl;
    }

    public void addSection(SimpleTemplateSection simpleTemplateSection) {
        if (this.subSections == null) {
            this.subSections = new TemplateSection[]{simpleTemplateSection};
        } else {
            TemplateSection[] templateSectionArray = new TemplateSection[this.subSections.length + 1];
            System.arraycopy(this.subSections, 0, templateSectionArray, 0, this.subSections.length);
            templateSectionArray[templateSectionArray.length - 1] = simpleTemplateSection;
            this.subSections = templateSectionArray;
        }
        simpleTemplateSection.setParentSection(this);
    }

    public void addSection(SimpleTemplateSection simpleTemplateSection, boolean bl) {
        this.addSectionPositioned(simpleTemplateSection, false, bl);
    }

    public void addSectionPositioned(SimpleTemplateSection simpleTemplateSection) {
        this.addSectionPositioned(simpleTemplateSection, false, true);
    }

    public void addSectionPositioned(SimpleTemplateSection simpleTemplateSection, boolean bl, boolean bl2) {
        if (this.subSections == null) {
            this.subSections = new TemplateSection[]{simpleTemplateSection};
        } else {
            if (!bl2) {
                this.addSection(simpleTemplateSection);
                return;
            }
            long l = simpleTemplateSection.getStartIndex();
            long l2 = simpleTemplateSection.getEndIndex();
            ArrayList<TemplateSection> arrayList = new ArrayList<TemplateSection>();
            boolean bl3 = false;
            if (bl && l2 <= 0L) {
                throw new RuntimeException("Need the end idx");
            }
            for (int i = 0; i < this.subSections.length; ++i) {
                TemplateSection templateSection = this.subSections[i];
                if (l < templateSection.getStartIndex()) {
                    if (bl && simpleTemplateSection.isContainer() && l2 > templateSection.getStartIndex()) {
                        simpleTemplateSection.addSection((SimpleTemplateSection)templateSection, bl2);
                        continue;
                    }
                    if (!bl3) {
                        arrayList.add(simpleTemplateSection);
                        bl3 = true;
                    }
                    arrayList.add(templateSection);
                    continue;
                }
                if (l == templateSection.getStartIndex()) {
                    if (bl && simpleTemplateSection.isContainer() && l2 > templateSection.getStartIndex() && templateSection.getEndIndex() >= l) {
                        simpleTemplateSection.addSection((SimpleTemplateSection)templateSection, bl2);
                        if (bl3) continue;
                        arrayList.add(simpleTemplateSection);
                        bl3 = true;
                        continue;
                    }
                    if (l2 == templateSection.getEndIndex() && simpleTemplateSection instanceof SimpleTemplateSkipSection && templateSection instanceof SimpleTemplateSection) {
                        return;
                    }
                    if (templateSection.getEndIndex() < l2) {
                        arrayList.add(templateSection);
                        if (bl3) continue;
                        arrayList.add(simpleTemplateSection);
                        bl3 = true;
                        continue;
                    }
                    if (!bl3) {
                        arrayList.add(simpleTemplateSection);
                        bl3 = true;
                    }
                    arrayList.add(templateSection);
                    continue;
                }
                arrayList.add(templateSection);
            }
            if (!bl3) {
                arrayList.add(simpleTemplateSection);
                bl3 = true;
            }
            this.subSections = new TemplateSection[arrayList.size()];
            arrayList.toArray(this.subSections);
        }
        for (int i = 0; i < this.subSections.length; ++i) {
            if (this.subSections[i] != null) continue;
            throw new IllegalStateException("Sanity check failed during positioned section add");
        }
        simpleTemplateSection.setParentSection(this);
    }

    public void removeSection(SimpleTemplateSection simpleTemplateSection) {
        if (this.subSections != null) {
            int n = -1;
            for (int i = this.subSections.length - 1; i >= 0; --i) {
                if (this.subSections[i] != simpleTemplateSection) continue;
                n = i;
                break;
            }
            if (n != -1) {
                if (this.subSections.length == 1) {
                    this.subSections = null;
                } else {
                    TemplateSection[] templateSectionArray = new TemplateSection[this.subSections.length - 1];
                    int n2 = 0;
                    for (int i = 0; i < this.subSections.length; ++i) {
                        if (i == n) continue;
                        templateSectionArray[n2++] = this.subSections[i];
                    }
                    this.subSections = templateSectionArray;
                }
            }
        }
    }

    public void wrapOverlappedSections(SimpleTemplateSection simpleTemplateSection) {
        if (simpleTemplateSection.isContainer()) {
            this.removeSection(simpleTemplateSection);
            this.addSectionPositioned(simpleTemplateSection, true, true);
        }
    }

    public SimpleTemplateSection getParentSection() {
        return this.parentSection;
    }

    public void setParentSection(SimpleTemplateSection simpleTemplateSection) {
        this.parentSection = simpleTemplateSection;
    }

    @Override
    public long getPostAmbleStartIdx() {
        return this.postAmbleStartIdx;
    }

    public void setPostAmbleStartIdx(long l) {
        this.postAmbleStartIdx = l;
    }

    @Override
    public long getPreAmbleEndIdx() {
        return this.preAmbleEndIdx;
    }

    public void setPreAmbleEndIdx(long l) {
        this.preAmbleEndIdx = l;
    }

    @Override
    public boolean skipPreAndPostAmble() {
        return this.skipPreAndPostAmble;
    }

    public void setSkipPreAndPostAmble(boolean bl) {
        this.skipPreAndPostAmble = bl;
    }

    @Override
    public boolean isSkipSection() {
        return this.skipSection;
    }

    public void setSkipSection(boolean bl) {
        this.skipSection = bl;
    }

    @Override
    public ParsedField getParsedFieldDetails() {
        return this.parsedFieldDetails;
    }

    public void setParsedFieldDetails(ParsedField parsedField) {
        this.parsedFieldDetails = parsedField;
    }

    public boolean encapsulates(TemplateSection templateSection) {
        return this.startIndex < templateSection.getStartIndex() && this.endIndex > templateSection.getEndIndex();
    }

    public boolean equals(Object object) {
        return this.equals(object, false);
    }

    public int hashCode() {
        return (int)(this.startIndex + this.endIndex + this.preAmbleEndIdx + this.postAmbleStartIdx + 10001L * (long)(this.repeatable ? 1 : 0) + 11003L * (long)(this.conditional ? 1 : 0) + 12005L * (long)(this.container ? 1 : 0) + 13005L * (long)(this.skipPreAndPostAmble ? 1 : 0) + 14007L * (long)(this.skipSection ? 1 : 0) + (long)this.depth + 16007L * (long)(this.artificial ? 1 : 0) + 15009L * (long)(this.subSections == null ? 0 : this.subSections.length));
    }

    @Override
    public boolean equals(Object object, boolean bl) {
        if (this == object) {
            return true;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        SimpleTemplateSection simpleTemplateSection = (SimpleTemplateSection)object;
        boolean bl2 = true;
        if (!bl) {
            bl2 = this.startIndex == simpleTemplateSection.startIndex && this.endIndex == simpleTemplateSection.endIndex && this.preAmbleEndIdx == simpleTemplateSection.preAmbleEndIdx && this.postAmbleStartIdx == simpleTemplateSection.postAmbleStartIdx;
        }
        return bl2 &= this.repeatable == simpleTemplateSection.repeatable && this.conditional == simpleTemplateSection.conditional && this.container == simpleTemplateSection.container && this.skipPreAndPostAmble == simpleTemplateSection.skipPreAndPostAmble && this.skipSection == simpleTemplateSection.skipSection && this.depth == simpleTemplateSection.depth && this.artificial == simpleTemplateSection.artificial && this.subSectionsEqual(simpleTemplateSection, bl);
    }

    protected boolean subSectionsEqual(SimpleTemplateSection simpleTemplateSection, boolean bl) {
        if (this.subSections == null && simpleTemplateSection.subSections == null) {
            return true;
        }
        if (this.subSections == null || simpleTemplateSection.subSections == null) {
            return false;
        }
        if (this.subSections.length != simpleTemplateSection.subSections.length) {
            return false;
        }
        for (int i = 0; i < this.subSections.length; ++i) {
            if (this.subSections[i].equals(simpleTemplateSection.subSections[i], bl)) continue;
            return false;
        }
        return true;
    }

    public String toDebugString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("  ");
        }
        String string = stringBuffer.toString();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("\n");
        stringBuffer2.append(string);
        stringBuffer2.append("(");
        stringBuffer2.append(this.getClass().getName());
        stringBuffer2.append(") startIdx=" + this.startIndex + ", endIdx=" + this.endIndex);
        if (this.subSections != null) {
            for (int i = 0; i < this.subSections.length; ++i) {
                if (this.subSections[i] != null) {
                    if (this.subSections[i] instanceof SimpleTemplateSection) {
                        stringBuffer2.append(((SimpleTemplateSection)this.subSections[i]).toDebugString(n + 1));
                        continue;
                    }
                    stringBuffer2.append(this.subSections[i].toString());
                    continue;
                }
                stringBuffer2.append("\n");
                stringBuffer2.append(string);
                stringBuffer2.append("null");
            }
        }
        return stringBuffer2.toString();
    }

    protected static void appendToBuffer(StringBuffer stringBuffer, String string, String string2, long l) {
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append(string2);
        stringBuffer.append(l);
    }

    protected static void appendToBuffer(StringBuffer stringBuffer, String string, String string2, boolean bl) {
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append(string2);
        stringBuffer.append(bl);
    }
}

