/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis;

import com.docmosis.template.TemplateParseException;
import com.docmosis.template.analysis.NonSteppingRangeIterator;
import com.docmosis.template.analysis.RangeIterator;
import com.docmosis.template.analysis.RangeIteratorException;
import com.docmosis.template.analysis.StepNRangeIterator;
import com.docmosis.template.analysis.SteppableRangeIterator;
import com.docmosis.template.analysis.barcode.BarcodeInfo;
import com.docmosis.template.analysis.sorting.SortDescription;
import com.docmosis.util.Equivalence;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.NoSuchElementException;

public class ParsedField
implements Serializable {
    private static final Logger C = LogManager.getLogger(ParsedField.class);
    private final FieldType G;
    private final String H;
    private final String J;
    private NameTerm[] D;
    private Expression F;
    private FieldQualifiers B;
    private String I;
    private BarcodeInfo A;
    private StripParagraphMode E = StripParagraphMode.STRIP_NEVER;

    public ParsedField(FieldType fieldType, String string) {
        this(fieldType, string, string);
    }

    public ParsedField(FieldType fieldType, String string, String string2) {
        this.G = fieldType;
        this.H = string;
        this.J = string2;
    }

    public boolean equals(Object object) {
        if (object instanceof ParsedField) {
            return Equivalence.equivalentObjects(this.H, ((ParsedField)object).H);
        }
        return false;
    }

    public int hashCode() {
        return this.H == null ? 0 : this.H.hashCode();
    }

    public String getOriginalFieldText() {
        return this.H;
    }

    public String getOriginalFieldTextSansPrefix() {
        return this.J;
    }

    public String getVariableName() {
        if (this.isVariableLookup() || this.isSetVariable() || this.isDumpField() || this.isDumpVersionsField()) {
            return this.I;
        }
        return null;
    }

    public void setVariableName(String string) throws TemplateParseException {
        if (!(this.isVariableLookup() || this.isSetVariable() || this.isDumpField() || this.isDumpVersionsField())) {
            throw new TemplateParseException("Attempt to use a template variable name where not supported");
        }
        this.I = string;
    }

    public NameTerm[] getTerms() {
        return this.D;
    }

    public NameTerm getLastTerm() {
        return this.D == null ? null : this.D[this.D.length - 1];
    }

    public void setTerms(NameTerm[] nameTermArray) {
        this.D = nameTermArray;
    }

    public Expression getExpression() {
        return this.F;
    }

    public void setExpression(Expression expression) {
        this.F = expression;
    }

    public boolean isExpression() {
        return this.F != null;
    }

    public FieldType getFieldType() {
        return this.G;
    }

    public boolean allowsMultiRanges() {
        return this.G.allowsMultiRanges();
    }

    public FieldQualifiers getQualifiers() {
        return this.B;
    }

    public void setQualifiers(FieldQualifiers fieldQualifiers) {
        this.B = fieldQualifiers;
    }

    public boolean isRepeatingSectionStart() {
        return FieldType.REPEATING_SECTION_START.equals(this.G);
    }

    public boolean isSectionEnd() {
        return FieldType.SECTION_END.equals(this.G);
    }

    public boolean isConditionalSectionStart() {
        return FieldType.CONDITIONAL_SECTION_START.equals(this.G);
    }

    public boolean isConditionalSectionElseConditionStart() {
        return FieldType.CONDITIONAL_SECTION_ELSECS_START.equals(this.G);
    }

    public boolean isConditionalSectionElseStart() {
        return FieldType.CONDITIONAL_SECTION_ELSE_START.equals(this.G);
    }

    public boolean isRepeatingTableRowStart() {
        return FieldType.REPEATING_TABLE_ROW_START.equals(this.G);
    }

    public boolean isRepeatingOrConditionalTableRowEnd() {
        return FieldType.REPEATING_OR_CONDITIONAL_TABLE_ROW_END.equals(this.G);
    }

    public boolean isConditionalTableRowStart() {
        return FieldType.CONDITIONAL_TABLE_ROW_START.equals(this.G);
    }

    public boolean isConditionalColumn() {
        return FieldType.CONDITIONAL_COLUMN.equals(this.G);
    }

    public boolean isSetVariable() {
        return FieldType.SET_VARIABLE.equals(this.G);
    }

    public boolean isDataLookup() {
        return FieldType.GET_DATA.equals(this.G);
    }

    public boolean isDataLookupStripParaIfBlank() {
        return StripParagraphMode.STRIP_IF_BLANK.equals(this.E);
    }

    public boolean isVariableLookup() {
        return FieldType.GET_VARIABLE.equals(this.G);
    }

    public boolean isHyperlink() {
        return FieldType.HYPERLINK.equals(this.G);
    }

    public boolean isTemplateRef() {
        return FieldType.TEMPLATE_REF.equals(this.G);
    }

    public boolean isTemplateLookupRef() {
        return FieldType.TEMPLATE_LOOKUP_REF.equals(this.G);
    }

    public boolean isTemplateLookupRefOp() {
        return FieldType.TEMPLATE_LOOKUP_REF_OPTIONAL.equals(this.G);
    }

    public boolean isBreakField() {
        return this.isPageBreak() || this.isColumnBreak();
    }

    public boolean isPageBreak() {
        return FieldType.BREAK_PAGE.equals(this.G) || FieldType.BREAK_PAGE_NOT_LAST.equals(this.G);
    }

    public boolean isColumnBreak() {
        return FieldType.BREAK_COLUMN.equals(this.G) || FieldType.BREAK_COLUMN_NOT_LAST.equals(this.G);
    }

    public boolean isBreakFieldNotLast() {
        return FieldType.BREAK_PAGE_NOT_LAST.equals(this.G) || FieldType.BREAK_COLUMN_NOT_LAST.equals(this.G);
    }

    public boolean isOfNoInterest() {
        return FieldType.OF_NO_INTEREST.equals(this.G);
    }

    public boolean isNoTableAlternating() {
        return FieldType.NO_TABLE_ROW_ALTERNATE.equals(this.G);
    }

    public boolean isHtmlInjectLookupRef() {
        return FieldType.HTML_INJECT_LOOKUP_REF.equals(this.G);
    }

    public boolean isBarcode() {
        return FieldType.BARCODE_FIELD.equals(this.G);
    }

    public boolean isListContinue() {
        return FieldType.LIST_CONTINUE.equals(this.G);
    }

    public boolean isListReset() {
        return FieldType.LIST_RESET.equals(this.G);
    }

    public boolean isCoordinator() {
        return FieldType.COORDINATOR_FIELD.equals(this.G);
    }

    public boolean isDumpField() {
        return FieldType.DUMP_FIELD.equals(this.G);
    }

    public boolean isDumpVersionsField() {
        return FieldType.DUMP_VERSIONS_FIELD.equals(this.G);
    }

    public boolean isFieldTextColourOverride() {
        return FieldType.FIELD_TEXT_COLOUR_OVERRIDE.equals(this.G);
    }

    public BarcodeInfo getBarcodeInfo() {
        return this.A;
    }

    public void setBarcodeInfo(BarcodeInfo barcodeInfo) {
        this.A = barcodeInfo;
    }

    public StripParagraphMode getStripParagraphMode() {
        return this.E;
    }

    public void setStripParagraphMode(StripParagraphMode stripParagraphMode) {
        this.E = stripParagraphMode;
    }

    public static class StripParagraphMode
    implements Serializable {
        public static StripParagraphMode STRIP_NEVER = new StripParagraphMode("STRIP_NEVER");
        public static StripParagraphMode STRIP_IF_BLANK = new StripParagraphMode("STRIP_IF_BLANK");
        private final String A;

        private StripParagraphMode(String string) {
            this.A = string;
        }

        public boolean stripPossible() {
            return STRIP_IF_BLANK.equals(this);
        }

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = 31 * n2 + (this.A == null ? 0 : this.A.hashCode());
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            StripParagraphMode stripParagraphMode = (StripParagraphMode)object;
            return !(this.A == null ? stripParagraphMode.A != null : !this.A.equals(stripParagraphMode.A));
        }
    }

    public static abstract class Operator
    implements Serializable {
        private static HashMap C = new HashMap();
        public static Operator NOT = new Operator("!", 1){

            @Override
            Object evaluate(Object object) {
                if (object instanceof Boolean) {
                    return Boolean.TRUE.equals(object) ? Boolean.FALSE : Boolean.TRUE;
                }
                if (object instanceof String) {
                    return Boolean.valueOf((String)object) != false ? Boolean.FALSE : Boolean.TRUE;
                }
                return Boolean.TRUE;
            }
        };
        public static Operator TRUE = new Operator("TRUE", 1){

            @Override
            Object evaluate(Object object) {
                if (object instanceof Boolean) {
                    return Boolean.TRUE.equals(object) ? Boolean.TRUE : Boolean.FALSE;
                }
                if (object instanceof String) {
                    return Boolean.valueOf((String)object) != false ? Boolean.TRUE : Boolean.FALSE;
                }
                return Boolean.FALSE;
            }
        };
        public static Operator EQUAL = new Operator("=", 2){

            @Override
            Object evaluate(Object object, Object object2) {
                return Equivalence.equivalentObjects(object, object2) ? Boolean.TRUE : Boolean.FALSE;
            }
        };
        public static Operator NOT_EQUAL = new Operator("!=", 2){

            @Override
            Object evaluate(Object object, Object object2) {
                return Equivalence.equivalentObjects(object, object2) ? Boolean.FALSE : Boolean.TRUE;
            }
        };
        public static Operator LESS_THAN = new Operator("<", 2){

            @Override
            Object evaluate(Object object, Object object2) {
                String string;
                String string2;
                if (object == null || object2 == null) {
                    return Boolean.FALSE;
                }
                boolean bl = object instanceof Number;
                boolean bl2 = object2 instanceof Number;
                if (bl || bl2) {
                    try {
                        Number number = Operator.getNumber(object);
                        Number number2 = Operator.getNumber(object2);
                        return number.doubleValue() < number2.doubleValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return (string2 = object.toString()).compareTo(string = object2.toString()) < 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        };
        public static Operator GREATER_THAN = new Operator(">", 2){

            @Override
            Object evaluate(Object object, Object object2) {
                String string;
                String string2;
                if (object == null || object2 == null) {
                    return Boolean.FALSE;
                }
                boolean bl = object instanceof Number;
                boolean bl2 = object2 instanceof Number;
                if (bl || bl2) {
                    try {
                        Number number = Operator.getNumber(object);
                        Number number2 = Operator.getNumber(object2);
                        return number.doubleValue() > number2.doubleValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return (string2 = object.toString()).compareTo(string = object2.toString()) > 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        };
        public static Operator LESS_THAN_OR_EQUAL = new Operator("<=", 2){

            @Override
            Object evaluate(Object object, Object object2) {
                String string;
                String string2;
                if (object == null && object2 == null) {
                    return Boolean.TRUE;
                }
                if (object == null || object2 == null) {
                    return Boolean.FALSE;
                }
                boolean bl = object instanceof Number;
                boolean bl2 = object2 instanceof Number;
                if (bl || bl2) {
                    try {
                        Number number = Operator.getNumber(object);
                        Number number2 = Operator.getNumber(object2);
                        return number.doubleValue() <= number2.doubleValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return (string2 = object.toString()).compareTo(string = object2.toString()) <= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        };
        public static Operator GREATER_THAN_OR_EQUAL = new Operator(">=", 2){

            @Override
            Object evaluate(Object object, Object object2) {
                String string;
                String string2;
                if (object == null && object2 == null) {
                    return Boolean.TRUE;
                }
                if (object == null || object2 == null) {
                    return Boolean.FALSE;
                }
                boolean bl = object instanceof Number;
                boolean bl2 = object2 instanceof Number;
                if (bl || bl2) {
                    try {
                        Number number = Operator.getNumber(object);
                        Number number2 = Operator.getNumber(object2);
                        return number.doubleValue() >= number2.doubleValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return (string2 = object.toString()).compareTo(string = object2.toString()) >= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        };
        public static String[] SIZE_ORDERED_OPERATOR_NAME_LIST;
        private final String B;
        private final int A;

        private static Number getNumber(Object object) throws NumberFormatException {
            String string;
            Number number = object instanceof Number ? (Number)((Number)object) : (Number)((string = object.toString()).indexOf(46) != -1 ? (Number)Double.valueOf(string) : (Number)Long.valueOf(string));
            return number;
        }

        private Operator(String string, int n) {
            this.B = string;
            this.A = n;
            if (C.containsKey(string)) {
                String string2 = FieldType.class.getName() + " enum member already exists:" + string;
                C.error(string2);
                throw new IllegalStateException(string2);
            }
            C.put(string, this);
        }

        public String[] getSizeOrderedOperators() {
            return SIZE_ORDERED_OPERATOR_NAME_LIST;
        }

        public static Operator getOperator(String string) {
            Operator operator = (Operator)C.get(string);
            if (operator == null) {
                throw new IllegalArgumentException("Operator :\"" + string + "\" does not exist");
            }
            return operator;
        }

        public Object compute(Object object) {
            if (this.A != 1) {
                throw new IllegalArgumentException("Cannot compute operator \"" + this.B + "\" with only one argument");
            }
            return this.evaluate(object);
        }

        public Object compute(Object object, Object object2) {
            if (this.A != 2) {
                throw new IllegalArgumentException("Cannot compute operator \"" + this.B + "\" with two arguments");
            }
            return this.evaluate(object, object2);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            return object instanceof Operator && this.B.equals(((Operator)object).B);
        }

        public String toString() {
            return this.B;
        }

        Object evaluate(Object object) {
            return null;
        }

        Object evaluate(Object object, Object object2) {
            return null;
        }

        static {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 0;
            int n2 = Integer.MAX_VALUE;
            for (String string : C.keySet()) {
                arrayList.add(string);
                n = string.length() > n ? string.length() : n;
                n2 = string.length() < n2 ? string.length() : n2;
            }
            SIZE_ORDERED_OPERATOR_NAME_LIST = new String[arrayList.size()];
            int n3 = 0;
            for (int i = n; i >= n2; --i) {
                for (String string : arrayList) {
                    if (string.length() != i) continue;
                    Operator.SIZE_ORDERED_OPERATOR_NAME_LIST[n3++] = string;
                }
            }
        }
    }

    public static class Expression
    implements Serializable {
        private String A;
        private NameTerm[][] B;

        public String getExpressionString() {
            return this.A;
        }

        public Expression(String string) {
            this.A = string;
        }

        public void addTerms(NameTerm[] nameTermArray) {
            if (this.B == null) {
                this.B = new NameTerm[][]{nameTermArray};
            } else {
                NameTerm[][] nameTermArrayArray = new NameTerm[this.B.length + 1][];
                System.arraycopy(this.B, 0, nameTermArrayArray, 0, this.B.length);
                nameTermArrayArray[nameTermArrayArray.length - 1] = nameTermArray;
                this.B = nameTermArrayArray;
            }
        }

        public NameTerm[][] getTerms() {
            return this.B;
        }
    }

    public static class MultiRangeRangeIterator
    implements RangeIterator {
        private final MappedRangeIterator[] G;
        protected int currentRange = -1;
        protected int overarchingRangeIdx = -1;

        public MultiRangeRangeIterator(int n, Range[] rangeArray) throws RangeIteratorException {
            if (rangeArray == null || rangeArray.length == 0) {
                throw new RangeIteratorException("Can't create a range over a null or empty Range array");
            }
            this.G = new MappedRangeIterator[rangeArray.length];
            for (int i = 0; i < rangeArray.length; ++i) {
                this.G[i] = new MappedRangeIterator(n, rangeArray[i]);
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentRange != -1 && this.G[this.currentRange].hasNext() || this.currentRange < this.G.length - 1;
        }

        @Override
        public int next() throws NoSuchElementException {
            int n;
            if (!this.hasNext()) {
                throw new NoSuchElementException("Attempt to read past end of iteration");
            }
            if (this.currentRange == -1) {
                this.currentRange = 0;
                this.overarchingRangeIdx = 0;
            } else {
                ++this.overarchingRangeIdx;
            }
            if (this.G[this.currentRange].hasNext()) {
                n = this.G[this.currentRange].next();
            } else if (this.currentRange < this.G.length - 1) {
                ++this.currentRange;
                n = this.G[this.currentRange].next();
            } else {
                throw new NoSuchElementException("Attempt to read past end of iteration");
            }
            return n;
        }

        @Override
        public int rangeIndex() throws NoSuchElementException {
            return this.overarchingRangeIdx;
        }

        @Override
        public int dataIndex() throws NoSuchElementException {
            return this.G[this.currentRange].dataIndex();
        }

        @Override
        public int size() {
            int n = 0;
            for (int i = 0; i < this.G.length; ++i) {
                n += this.G[i].size();
            }
            return n;
        }

        @Override
        public void reset() {
            this.currentRange = -1;
            this.overarchingRangeIdx = -1;
            if (this.G != null) {
                for (MappedRangeIterator mappedRangeIterator : this.G) {
                    mappedRangeIterator.reset();
                }
            }
        }
    }

    public static class MappedRangeIterator
    extends SimpleStartToEndRangeIterator {
        public MappedRangeIterator(int n, Range range) throws RangeIteratorException {
            super(MappedRangeIterator.getStart(n, range), MappedRangeIterator.getEnd(n, range));
        }

        private static int getStart(int n, Range range) {
            int n2 = range.getStartIdx() < 0 ? n + range.getStartIdx() : range.getStartIdx();
            if (range.A && n2 < 0) {
                n2 = 0;
            }
            return n2;
        }

        private static int getEnd(int n, Range range) {
            if (range.getEndIdx() < 0) {
                return n + range.getEndIdx();
            }
            if (range.A) {
                return Math.min(range.getEndIdx(), n - 1);
            }
            return range.getEndIdx();
        }
    }

    public static class SimpleStartToEndRangeIterator
    implements RangeIterator {
        private final int J;
        private final int H;
        private _A I;

        public SimpleStartToEndRangeIterator(int n, int n2) throws RangeIteratorException {
            this.J = n;
            this.H = n2;
            this.I = null;
            if (n2 < n) {
                throw new RangeIteratorException("Can't iterate backwards");
            }
            if (n < 0) {
                throw new RangeIteratorException("Can't start from earlier than zero");
            }
        }

        @Override
        public boolean hasNext() {
            return this.I == null || this.I.A < this.H;
        }

        @Override
        public int next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Attempt to read past end of iteration");
            }
            if (this.I == null) {
                this.I = new _A(0, this.J);
            } else {
                this.I.A();
            }
            return this.I.A;
        }

        @Override
        public int rangeIndex() throws NoSuchElementException {
            if (this.I == null) {
                throw new NoSuchElementException("Iteration has not been started");
            }
            return this.I.B;
        }

        @Override
        public int dataIndex() throws NoSuchElementException {
            if (this.I == null) {
                throw new NoSuchElementException("Iteration has not been started");
            }
            return this.I.A;
        }

        @Override
        public int size() {
            return this.H - this.J + 1;
        }

        @Override
        public void reset() {
            this.I = null;
        }
    }

    private static class _A {
        private int B;
        private int A;

        public _A(int n, int n2) {
            this.B = n;
            this.A = n2;
        }

        public void A() {
            ++this.B;
            ++this.A;
        }
    }

    public static class SpecificIndexesRangeIterator
    implements RangeIterator {
        private final int[] K;
        private int L = -1;

        public SpecificIndexesRangeIterator(int[] nArray) throws RangeIteratorException {
            this.K = nArray;
            if (nArray == null || nArray.length == 0) {
                throw new RangeIteratorException("Can't iterate over null or empty array");
            }
        }

        @Override
        public boolean hasNext() {
            return this.L == -1 || this.L != -1 && this.L < this.K.length - 1;
        }

        @Override
        public int next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Attempt to read past end of iteration");
            }
            this.L = this.L == -1 ? 0 : ++this.L;
            int n = this.dataIndex();
            return n;
        }

        @Override
        public int rangeIndex() throws NoSuchElementException {
            if (this.L == -1) {
                throw new NoSuchElementException("Iteration has not been started");
            }
            return this.L;
        }

        @Override
        public int dataIndex() throws NoSuchElementException {
            if (this.L == -1) {
                throw new NoSuchElementException("Iteration has not been started");
            }
            return this.K[this.L];
        }

        @Override
        public int size() {
            return this.K.length;
        }

        @Override
        public void reset() {
            this.L = -1;
        }
    }

    public static class Range
    implements Serializable {
        private final int C;
        private final int B;
        private final boolean A;
        private final String D;

        public Range(int n, int n2, boolean bl) {
            this.C = n;
            this.B = n2;
            this.A = bl;
            this.D = null;
        }

        public Range(String string) {
            this.C = -1;
            this.B = -1;
            this.A = false;
            this.D = string;
        }

        public int getStartIdx() {
            return this.C;
        }

        public int getEndIdx() {
            return this.B;
        }

        public boolean isBestEffort() {
            return this.A;
        }

        public boolean isMultiValued() {
            return Math.abs(this.B - this.C) > 0;
        }

        public String getExpression() {
            return this.D;
        }
    }

    public static class RangeSpecifier
    implements Serializable {
        private String B;
        private Range[] A;

        public RangeSpecifier(String string, Range[] rangeArray) {
            this.B = string;
            this.A = rangeArray;
        }

        public String getRangeString() {
            return this.B;
        }

        public Range[] getRanges() {
            return this.A;
        }

        public boolean isMultiValued() {
            boolean bl = this.A.length > 1;
            for (int i = 0; !bl && i < this.A.length; ++i) {
                if (!this.A[i].isMultiValued()) continue;
                bl = true;
                break;
            }
            return bl;
        }
    }

    public static class NameTerm
    implements Serializable {
        private final String N;
        private String O;
        private boolean S;
        private String[] I;
        private boolean J;
        private boolean R;
        private RangeSpecifier K;
        private boolean P;
        private Object C;
        private int E = -1;
        private boolean D;
        private boolean G;
        private String B;
        private boolean A;
        private SortDescription[] M;
        private boolean F;
        private String Q;
        private boolean T;
        private String L;
        private boolean H;

        public NameTerm(String string) {
            this.N = string;
        }

        public NameTerm(NameTerm nameTerm) {
            this.N = nameTerm.N;
            this.O = nameTerm.O;
            this.S = nameTerm.S;
            this.I = nameTerm.I == null ? null : (String[])nameTerm.I.clone();
            this.J = nameTerm.J;
            this.R = nameTerm.R;
            this.K = nameTerm.K;
            this.P = nameTerm.P;
            this.C = nameTerm.C;
            this.E = nameTerm.E;
            this.D = nameTerm.D;
            this.G = nameTerm.G;
            this.B = nameTerm.B;
            this.A = nameTerm.A;
            this.M = nameTerm.M == null ? null : (SortDescription[])nameTerm.M.clone();
            this.F = nameTerm.F;
            this.Q = nameTerm.Q;
            this.T = nameTerm.T;
            this.L = nameTerm.L;
            this.H = nameTerm.H;
        }

        public boolean isMethodName() {
            return this.S;
        }

        protected void setMethodName(boolean bl) {
            this.S = bl;
        }

        public String[] getMethodParams() {
            return this.I;
        }

        protected void setMethodParams(String[] stringArray) {
            this.I = stringArray;
        }

        public boolean isLiteral() {
            return this.P;
        }

        public Object getLiteral() {
            return this.C;
        }

        protected void setLiteral(boolean bl, Object object) {
            this.P = bl;
            this.C = object;
        }

        public RangeSpecifier getRange() {
            return this.K;
        }

        protected void setRange(RangeSpecifier rangeSpecifier) {
            this.K = rangeSpecifier;
        }

        public String getLookupName() {
            return this.O;
        }

        protected void setTerm(String string) {
            this.O = string;
        }

        public String getFullTerm() {
            return this.N;
        }

        public SteppableRangeIterator getRangeIterator(int n) throws RangeIteratorException {
            RangeIterator rangeIterator = this.K == null ? new SimpleStartToEndRangeIterator(0, n - 1) : new MultiRangeRangeIterator(n, this.K.getRanges());
            SteppableRangeIterator steppableRangeIterator = this.getStepSize() != -1 ? new StepNRangeIterator(rangeIterator, this.getStepSize(), this.getStepDown()) : new NonSteppingRangeIterator(rangeIterator);
            return steppableRangeIterator;
        }

        public boolean isVariable() {
            return this.J;
        }

        protected void setVariable(boolean bl) {
            this.J = bl;
        }

        public boolean isVariableForgiving() {
            return this.R;
        }

        public void setVariableForgiving(boolean bl) {
            this.R = bl;
        }

        protected void setStepSize(int n) {
            this.E = n;
        }

        protected void setStepDown(boolean bl) {
            this.D = bl;
        }

        public int getStepSize() {
            return this.E;
        }

        public boolean getStepDown() {
            return this.D;
        }

        public boolean isArtificialRS() {
            return this.G;
        }

        protected void setArtificialRS(boolean bl) {
            this.G = bl;
        }

        public String getArtificialRSlength() {
            return this.B;
        }

        protected void setArtificialRSlength(String string) {
            this.B = string;
        }

        public boolean isSorted() {
            return this.A;
        }

        protected void setSorted(boolean bl) {
            this.A = bl;
        }

        public SortDescription[] getSorts() {
            return this.M;
        }

        protected void setSorts(SortDescription[] sortDescriptionArray) {
            this.M = sortDescriptionArray;
        }

        public boolean isFiltered() {
            return this.F;
        }

        protected void setFiltered(boolean bl) {
            this.F = bl;
        }

        public String getFilterExpression() {
            return this.Q;
        }

        protected void setFilterExpression(String string) {
            this.Q = string;
        }

        public boolean isGrouped() {
            return this.T;
        }

        protected void setGrouped(boolean bl) {
            this.T = bl;
        }

        public String getGroupByExpression() {
            return this.L;
        }

        protected void setGroupByExpression(String string) {
            this.L = string;
        }

        public boolean isGroupItems() {
            return this.H;
        }

        protected void setGroupItems(boolean bl) {
            this.H = bl;
        }
    }

    public static class MutableNameTerm
    extends NameTerm {
        public MutableNameTerm(String string) {
            super(string);
        }

        public MutableNameTerm(NameTerm nameTerm) {
            super(nameTerm);
        }

        @Override
        public void setMethodName(boolean bl) {
            super.setMethodName(bl);
        }

        @Override
        public void setMethodParams(String[] stringArray) {
            super.setMethodParams(stringArray);
        }

        @Override
        public void setLiteral(boolean bl, Object object) {
            super.setLiteral(bl, object);
        }

        @Override
        public void setRange(RangeSpecifier rangeSpecifier) {
            super.setRange(rangeSpecifier);
        }

        @Override
        public void setTerm(String string) {
            super.setTerm(string);
        }

        @Override
        public void setVariable(boolean bl) {
            super.setVariable(bl);
        }

        @Override
        public void setVariableForgiving(boolean bl) {
            super.setVariableForgiving(bl);
        }

        @Override
        public void setStepSize(int n) {
            super.setStepSize(n);
        }

        @Override
        public void setStepDown(boolean bl) {
            super.setStepDown(bl);
        }

        @Override
        public void setArtificialRS(boolean bl) {
            super.setArtificialRS(bl);
        }

        @Override
        public void setArtificialRSlength(String string) {
            super.setArtificialRSlength(string);
        }

        @Override
        public void setSorted(boolean bl) {
            super.setSorted(bl);
        }

        @Override
        public void setSorts(SortDescription[] sortDescriptionArray) {
            super.setSorts(sortDescriptionArray);
        }

        @Override
        public void setFiltered(boolean bl) {
            super.setFiltered(bl);
        }

        @Override
        public void setFilterExpression(String string) {
            super.setFilterExpression(string);
        }

        @Override
        public void setGrouped(boolean bl) {
            super.setGrouped(bl);
        }

        @Override
        public void setGroupByExpression(String string) {
            super.setGroupByExpression(string);
        }

        @Override
        public void setGroupItems(boolean bl) {
            super.setGroupItems(bl);
        }
    }

    public static class FieldQualifiers
    implements Serializable {
        private String A;
        private String[] B;
        private String D;
        private String C;

        public String getId() {
            return this.D;
        }

        public void setId(String string) {
            this.D = string;
        }

        public String getRendererName() {
            return this.A;
        }

        public String[] getRendererParams() {
            return this.B;
        }

        public void setRenderer(String string, String[] stringArray) {
            this.A = string;
            this.B = stringArray;
        }

        public String getSectionOverride() {
            return this.C;
        }

        public void setSection(String string) {
            this.C = string;
        }
    }

    public static class FieldType
    implements Serializable {
        private static HashMap A = new HashMap();
        public static FieldType REPEATING_SECTION_START = new FieldType("rsTag", 1);
        public static FieldType CONDITIONAL_SECTION_START = new FieldType("csTag", 0);
        public static FieldType CONDITIONAL_SECTION_ELSECS_START = new FieldType("csEcsTag", 0);
        public static FieldType CONDITIONAL_SECTION_ELSE_START = new FieldType("csETag", 0);
        public static FieldType SECTION_END = new FieldType("esTag", 1);
        public static FieldType REPEATING_TABLE_ROW_START = new FieldType("rrTag", 1);
        public static FieldType CONDITIONAL_TABLE_ROW_START = new FieldType("crTag", 0);
        public static FieldType REPEATING_OR_CONDITIONAL_TABLE_ROW_END = new FieldType("erTag", 1);
        public static FieldType CONDITIONAL_COLUMN = new FieldType("ccTag", 0);
        public static FieldType SET_VARIABLE = new FieldType("setVar", 0);
        public static FieldType GET_VARIABLE = new FieldType("getVar", 0);
        public static FieldType GET_DATA = new FieldType("dataLookup", 0);
        public static FieldType HYPERLINK = new FieldType("hyperlink", 0);
        public static FieldType TEMPLATE_REF = new FieldType("templateRef", 0);
        public static FieldType TEMPLATE_LOOKUP_REF = new FieldType("templateLookupRef", 0);
        public static FieldType TEMPLATE_LOOKUP_REF_OPTIONAL = new FieldType("templateLookupRefOp", 0);
        public static FieldType BREAK_PAGE = new FieldType("pageBreak", 0);
        public static FieldType BREAK_PAGE_NOT_LAST = new FieldType("pageBreakNotLast", 0);
        public static FieldType BREAK_COLUMN = new FieldType("columnBreak", 0);
        public static FieldType BREAK_COLUMN_NOT_LAST = new FieldType("columnBreakNotLast", 0);
        public static FieldType OF_NO_INTEREST = new FieldType("uninteresting", 0);
        public static FieldType NO_TABLE_ROW_ALTERNATE = new FieldType("noTableRowAlternate", 0);
        public static FieldType HTML_INJECT_LOOKUP_REF = new FieldType("HtmlInjectLookupRef", 0);
        public static FieldType EXPRESSION_FIELD = new FieldType("ExpressionField", 0);
        public static FieldType BARCODE_FIELD = new FieldType("barcode", 0);
        public static FieldType LIST_CONTINUE = new FieldType("listContinue", 0);
        public static FieldType LIST_RESET = new FieldType("listReset", 0);
        public static FieldType COORDINATOR_FIELD = new FieldType("coordinator", 0);
        public static FieldType DUMP_FIELD = new FieldType("dump", 0);
        public static FieldType DUMP_VERSIONS_FIELD = new FieldType("dumpVersions", 0);
        public static FieldType FIELD_TEXT_COLOUR_OVERRIDE = new FieldType("fieldTextColourOverride", 0);
        private final String C;
        private final int B;

        private FieldType(String string, int n) {
            this.C = string;
            this.B = n;
            if (A.containsKey(string)) {
                String string2 = FieldType.class.getName() + " enum member already exists:" + string;
                C.error(string2);
                throw new IllegalStateException(string2);
            }
            A.put(string, this);
        }

        public boolean allowsMultiRanges() {
            return this.B > 0;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof FieldType)) {
                return false;
            }
            return Equivalence.equivalentObjects(this.C, ((FieldType)object).C) && this.B == ((FieldType)object).B;
        }

        public int hashCode() {
            return this.C == null ? 0 : this.C.hashCode();
        }

        public String getName() {
            return this.C;
        }
    }
}

