/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template;

import com.docmosis.template.Template;
import com.docmosis.template.TemplateDetails;
import com.docmosis.template.analysis.TemplateAnalysis;
import com.docmosis.template.store.TemplateIdentifier;
import com.docmosis.util.Equivalence;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class SimpleTemplate
implements Template {
    private static final Logger P = LogManager.getLogger(SimpleTemplate.class);
    private long Q;
    private TemplateIdentifier T;
    private TemplateDetails O;
    private TemplateAnalysis S;
    private InputStream N;
    private File R;

    @Override
    public long getLength() {
        return this.Q;
    }

    public void setLength(long l) {
        this.Q = l;
    }

    @Override
    public TemplateAnalysis getAnalysis() {
        return this.S;
    }

    public void setAnalysis(TemplateAnalysis templateAnalysis) {
        this.S = templateAnalysis;
    }

    @Override
    public TemplateDetails getDetails() {
        return this.O;
    }

    public void setDetails(TemplateDetails templateDetails) {
        this.O = templateDetails;
    }

    @Override
    public TemplateIdentifier getId() {
        return this.T;
    }

    public void setId(TemplateIdentifier templateIdentifier) {
        this.T = templateIdentifier;
    }

    @Override
    public InputStream getInputStream() {
        return this.N;
    }

    public void setInputStream(InputStream inputStream) {
        this.N = inputStream;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.Q = objectInput.readLong();
        this.T = (TemplateIdentifier)objectInput.readObject();
        this.O = (TemplateDetails)objectInput.readObject();
        this.S = (TemplateAnalysis)objectInput.readObject();
        File file = File.createTempFile("dm_", "SimpleTemplate");
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[4096];
            while ((n = objectInput.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
            this.N = new FileInputStream(file);
            this.R = file;
        }
        catch (IOException iOException) {
            try {
                FileUtilities.close(fileOutputStream);
                FileUtilities.delete(file);
                FileUtilities.close(this.N);
                throw iOException;
            }
            catch (Throwable throwable) {
                FileUtilities.close(fileOutputStream);
                throw throwable;
            }
        }
        FileUtilities.close(fileOutputStream);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        objectOutput.writeLong(this.Q);
        objectOutput.writeObject(this.T);
        objectOutput.writeObject(this.O);
        objectOutput.writeObject(this.S);
        while ((n = this.N.read(byArray)) != -1) {
            objectOutput.write(byArray, 0, n);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof SimpleTemplate)) {
            return false;
        }
        SimpleTemplate simpleTemplate = (SimpleTemplate)object;
        return this.getLength() == simpleTemplate.getLength() && Equivalence.bothNullOrBothNotNull(this.getInputStream(), simpleTemplate.getInputStream()) && Equivalence.equivalentObjects(this.getId(), simpleTemplate.getId()) && Equivalence.equivalentObjects(this.getDetails(), simpleTemplate.getDetails()) && Equivalence.equivalentObjects(this.getAnalysis(), simpleTemplate.getAnalysis());
    }

    boolean deepEquals(SimpleTemplate simpleTemplate) {
        return this.equals(simpleTemplate) && Equivalence.inputStreamsEqual(this.getInputStream(), simpleTemplate.getInputStream());
    }

    public int hashCode() {
        int n = (int)this.Q * 2;
        if (this.N != null) {
            ++n;
        }
        n += this.T.hashCode();
        n += this.O.hashCode();
        return n += this.S.hashCode();
    }

    @Override
    public void cleanup() {
        FileUtilities.close(this.N);
        this.N = null;
        FileUtilities.delete(this.R);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.N != null) {
                P.warn(" cleanup in finalizer");
            }
            this.cleanup();
        }
        finally {
            super.finalize();
        }
    }
}

