/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template;

import com.docmosis.template.Document;
import com.docmosis.template.analysis.fontmapping.FontInfo;
import com.docmosis.template.analysis.fontmapping.FontMappingUseItem;
import com.docmosis.template.analysis.sensitivitylabel.SensitivityLabelInfo;
import com.docmosis.template.analysis.sensitivitylabel.SensitivityLabelItem;
import com.docmosis.template.analysis.sensitivitylabel.SensitivityLabelType;
import com.docmosis.util.DMProperties;
import com.docmosis.util.Equivalence;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class BasicDocument
implements Document {
    private static final Logger J = LogManager.getLogger(BasicDocument.class);
    private static final boolean D = DMProperties.getBoolean("docmosis.converter.pool.networkDiag.logging.enabled", false);
    private InputStream A;
    private long C;
    private int H;
    private boolean I;
    private long B;
    private FontInfo E;
    private SensitivityLabelInfo K;
    private transient File G;
    private transient File F;

    public BasicDocument() {
    }

    public BasicDocument(InputStream inputStream) {
        this(inputStream, -1L);
    }

    public BasicDocument(File file) throws FileNotFoundException {
        this(file, false);
    }

    public BasicDocument(File file, boolean bl) throws FileNotFoundException {
        this(file, bl, 0, null, null);
    }

    public BasicDocument(File file, boolean bl, int n, FontInfo fontInfo, SensitivityLabelInfo sensitivityLabelInfo) throws FileNotFoundException {
        this(new FileInputStream(file), file.length(), n, fontInfo, sensitivityLabelInfo);
        if (bl) {
            this.F = file;
        }
    }

    public BasicDocument(InputStream inputStream, long l) {
        this(inputStream, l, 0, null, null);
    }

    public BasicDocument(InputStream inputStream, long l, int n, FontInfo fontInfo, SensitivityLabelInfo sensitivityLabelInfo) {
        this.A = inputStream;
        this.C = l;
        this.H = n;
        this.E = fontInfo;
        this.K = sensitivityLabelInfo;
    }

    @Override
    public InputStream getInputStream() {
        return this.A;
    }

    public void setInputStream(InputStream inputStream) {
        this.A = inputStream;
    }

    @Override
    public long getLength() {
        return this.C;
    }

    public void setLength(long l) {
        this.C = l;
    }

    public int getDocumentPageCount() {
        return this.H;
    }

    public void setDocumentPageCount(int n) {
        this.H = n;
    }

    public long getRemoteWaitTime() {
        return this.B;
    }

    public void setRemoteWaitTime(long l) {
        this.B = l;
    }

    public boolean getPocessedByExternalConverter() {
        return this.I;
    }

    public void setProcessedByExternalConverter(boolean bl) {
        this.I = bl;
    }

    public FontInfo getFontInfo() {
        return this.E;
    }

    public void setFontInfo(FontInfo fontInfo) {
        this.E = fontInfo;
    }

    public SensitivityLabelInfo getSensitivityLabelInfo() {
        return this.K;
    }

    public void setSensitivityLabel(SensitivityLabelInfo sensitivityLabelInfo) {
        this.K = sensitivityLabelInfo;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof BasicDocument)) {
            return false;
        }
        BasicDocument basicDocument = (BasicDocument)object;
        if (this.E == null ? basicDocument.E != null : !this.E.equals(basicDocument.E)) {
            return false;
        }
        if (this.K == null ? basicDocument.K != null : !this.K.equals(basicDocument.K)) {
            return false;
        }
        return this.C == basicDocument.C && this.H == basicDocument.H && this.I == basicDocument.I && this.B == basicDocument.B && Equivalence.bothNullOrBothNotNull(this.getInputStream(), basicDocument.getInputStream());
    }

    public int hashCode() {
        int n = (int)(this.C * 2L + (long)(1011 * this.H) + (long)(this.I ? 125 : 161) + this.B * 643L);
        if (this.A != null) {
            n += 153623;
        }
        if (this.E != null) {
            n += this.E.hashCode();
        }
        if (this.K != null) {
            n += this.K.hashCode();
        }
        return n;
    }

    boolean deepEquals(BasicDocument basicDocument) {
        return this.equals(basicDocument) && Equivalence.inputStreamsEqual(this.getInputStream(), basicDocument.getInputStream());
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        String[] stringArray;
        BasicDocument.logDebugOrInfo("readExternal start");
        this.C = objectInput.readLong();
        this.H = objectInput.readInt();
        this.I = objectInput.readBoolean();
        this.B = objectInput.readLong();
        int n2 = objectInput.readInt();
        if (n2 != -1) {
            FontMappingUseItem[] fontMappingUseItemArray = new FontMappingUseItem[n2];
            for (int i = 0; i < n2; ++i) {
                int n3;
                String string = objectInput.readUTF();
                int n4 = objectInput.readInt();
                stringArray = new String[n4];
                for (n3 = 0; n3 < n4; ++n3) {
                    stringArray[n3] = objectInput.readUTF();
                }
                n3 = objectInput.readInt();
                fontMappingUseItemArray[i] = new FontMappingUseItem(string, stringArray, n3);
            }
            this.E = new FontInfo(fontMappingUseItemArray);
        } else {
            this.E = null;
        }
        int n5 = objectInput.readInt();
        if (n5 != -1) {
            SensitivityLabelItem[] sensitivityLabelItemArray = new SensitivityLabelItem[n5];
            for (int i = 0; i < n5; ++i) {
                SensitivityLabelType sensitivityLabelType = SensitivityLabelType.valueOf(objectInput.readUTF());
                stringArray = objectInput.readUTF();
                String string = objectInput.readUTF();
                sensitivityLabelItemArray[i] = new SensitivityLabelItem(sensitivityLabelType, (String)stringArray, string);
            }
            this.K = new SensitivityLabelInfo(sensitivityLabelItemArray);
        } else {
            this.K = null;
        }
        this.G = File.createTempFile("dm_", "BasicDocument");
        FileOutputStream fileOutputStream = new FileOutputStream(this.G);
        byte[] byArray = new byte[4096];
        while ((n = objectInput.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileOutputStream.close();
        this.A = new FileInputStream(this.G);
        BasicDocument.logDebugOrInfo("readExternal end");
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n;
        BasicDocument.logDebugOrInfo("writeExternal start");
        byte[] byArray = new byte[4096];
        objectOutput.writeLong(this.C);
        objectOutput.writeInt(this.H);
        objectOutput.writeBoolean(this.I);
        objectOutput.writeLong(this.B);
        int n2 = this.E != null && this.E.getFontMappings() != null ? this.E.getFontMappings().length : -1;
        objectOutput.writeInt(n2);
        if (n2 != -1) {
            FontMappingUseItem[] fontMappingUseItemArray = this.E.getFontMappings();
            n = fontMappingUseItemArray.length;
            for (int i = 0; i < n; ++i) {
                FontMappingUseItem fontMappingUseItem = fontMappingUseItemArray[i];
                objectOutput.writeUTF(fontMappingUseItem.getOriginalFont());
                objectOutput.writeInt(fontMappingUseItem.getUsedFonts().length);
                for (String string : fontMappingUseItem.getUsedFonts()) {
                    objectOutput.writeUTF(string);
                }
                objectOutput.writeInt(fontMappingUseItem.getCount());
            }
        }
        int n3 = this.K != null && this.K.getSensitivityLabels() != null ? this.K.getSensitivityLabels().length : -1;
        objectOutput.writeInt(n3);
        if (n3 != -1) {
            for (SensitivityLabelItem sensitivityLabelItem : this.K.getSensitivityLabels()) {
                objectOutput.writeUTF(sensitivityLabelItem.getSensitivityLabelType().name());
                objectOutput.writeUTF(sensitivityLabelItem.getKey());
                objectOutput.writeUTF(sensitivityLabelItem.getSensitivityLabelXML());
            }
        }
        while ((n = this.A.read(byArray)) != -1) {
            objectOutput.write(byArray, 0, n);
        }
        BasicDocument.logDebugOrInfo("writeExternal end");
    }

    public static void cleanup(BasicDocument basicDocument) {
        BasicDocument.cleanup(basicDocument, false);
    }

    public static void cleanup(BasicDocument basicDocument, boolean bl) {
        if (basicDocument != null) {
            basicDocument.cleanup();
            if (bl && basicDocument.F != null) {
                FileUtilities.delete(basicDocument.F.getParentFile());
            }
        }
    }

    @Override
    public void cleanup() {
        FileUtilities.close(this.A);
        this.A = null;
        FileUtilities.delete(this.G);
        this.G = null;
        FileUtilities.delete(this.F);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.A != null) {
                J.warn("Cleanup in finalizer");
            }
            this.cleanup();
        }
        finally {
            super.finalize();
        }
    }

    private static void logDebugOrInfo(String string) {
        if (D && J.isInfoEnabled()) {
            J.info(string);
        } else if (J.isDebugEnabled()) {
            J.debug(string);
        }
    }
}

