/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.pipeline.openoffice;

import com.docmosis.template.TemplateParseException;
import com.docmosis.template.population.DataProvider;
import com.docmosis.util.DMProperties;
import com.docmosis.util.J;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class ODFContentManipulator {
    private static final Logger A = LogManager.getLogger(ODFContentManipulator.class);
    private static final int B = DMProperties.getInt("docmosis.stream.buffer.size");
    private final J C = new J(B);
    private DefaultODTHandler D = new DefaultODTHandler();
    int ch;
    boolean tagOpen = false;
    long totalRead = 0L;
    int idx = 0;
    long len = 0L;

    public ODFContentManipulator(DataProvider dataProvider, OutputStream outputStream) {
        this.D.setUp(dataProvider, outputStream);
    }

    public void manipulate(byte[] byArray, int n, int n2) throws IOException, TemplateParseException {
        try {
            for (int i = n; i < n2; ++i) {
                this.ch = (char)byArray[i];
                ++this.totalRead;
                if (this.tagOpen) {
                    if (this.ch == 62) {
                        this.C.B('>');
                        this.D.tag(this.C);
                        this.C.B();
                        this.tagOpen = false;
                        continue;
                    }
                    this.C.B((char)this.ch);
                    continue;
                }
                if (this.ch == 60) {
                    if (this.C.E() != 0) {
                        this.D.contentChunk(this.C);
                        this.C.B();
                    }
                    this.tagOpen = true;
                    this.C.B('<');
                    continue;
                }
                this.C.B((char)this.ch);
            }
            this.D.flush();
        }
        catch (TemplateParseException templateParseException) {
            A.error("Error during manipulate", templateParseException);
        }
    }

    static class DefaultODTHandler {
        private static final String B = "text:description=\"";
        private static final String A = "<text:text-input";
        private static final String D = "</text:text-input";
        private OutputStreamWriter E;
        private DataProvider C;

        public void setUp(DataProvider dataProvider, OutputStream outputStream) {
            this.C = dataProvider;
            this.E = new OutputStreamWriter(outputStream);
        }

        public void cleanup() {
            this.E = null;
            this.C = null;
        }

        public void contentChunk(J j) throws IOException {
            this.processContentChunk(j);
        }

        private void processContentChunk(J j) throws IOException {
            j.A(this.E);
        }

        public void tag(J j) throws IOException, TemplateParseException {
            this.processTag(j);
        }

        private void processTag(J j) throws IOException, TemplateParseException {
            if (j.C(A)) {
                int n = j.D(B);
                if (n == -1) {
                    throw new TemplateParseException("No text:description in tag:" + j);
                }
                int n2 = j.A("\"", n += B.length());
                if (n2 == -1) {
                    throw new TemplateParseException("Can't find end of text:description in tag:" + j);
                }
                String string = j.B(n, n2 - n);
                String string2 = this.C.getString(string);
                if (string2 != null) {
                    this.E.write(string2);
                }
            } else if (!j.C(D)) {
                j.A(this.E);
            }
        }

        public void flush() throws IOException {
            this.E.flush();
        }
    }
}

