/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.example;

import com.docmosis.SystemManager;
import com.docmosis.document.DocumentProcessor;
import com.docmosis.document.ProcessingException;
import com.docmosis.document.converter.ConversionException;
import com.docmosis.document.converter.ConversionFormat;
import com.docmosis.document.converter.ConversionInstruction;
import com.docmosis.document.converter.NoConvertersRunningException;
import com.docmosis.document.converter.pool.ConverterPoolException;
import com.docmosis.template.TemplateStoreException;
import com.docmosis.template.population.DataProviderFactory;
import com.docmosis.template.population.DataProviderGrouping;
import com.docmosis.template.population.DataProviderGroupingException;
import com.docmosis.template.population.DataProviderSQLGrouping;
import com.docmosis.template.population.Discriminator;
import com.docmosis.template.population.MemoryDataProvider;
import com.docmosis.template.population.NoSuchColumnNameException;
import com.docmosis.template.population.SQLDataProvider;
import com.docmosis.template.store.StoreHelper;
import com.docmosis.template.store.TemplateContext;
import com.docmosis.template.store.TemplateIdentifier;
import com.docmosis.template.store.TemplateStoreFactory;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;

public class SQLExample {
    private static final Logger log = LogManager.getLogger(SQLExample.class);

    private static void prepareTemplates() throws IOException, ConversionException, ConverterPoolException, TemplateStoreException, NoConvertersRunningException {
        StoreHelper.storeTemplate("SqlExampleTemplate.odt", new File("SqlExampleTemplate.odt"), TemplateStoreFactory.getStore());
        log.info("Template(s) loaded into store");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderReport() throws IOException, ConversionException, ConverterPoolException, TemplateStoreException, ProcessingException, NoSuchColumnNameException, SQLException, DataProviderGroupingException, ClassNotFoundException {
        TemplateIdentifier templateIdentifier = new TemplateIdentifier("SqlExampleTemplate.odt", new TemplateContext(""));
        ConversionInstruction conversionInstruction = new ConversionInstruction();
        conversionInstruction.setConversionFormats(new ConversionFormat[]{ConversionFormat.FORMAT_PDF});
        conversionInstruction.setCleanupDataProvider(false);
        FileOutputStream fileOutputStream = new FileOutputStream("SqlExample.pdf");
        MemoryDataProvider memoryDataProvider = SQLExample.getSQLData();
        try {
            if (log.isDebugEnabled()) {
                log.debug(memoryDataProvider.toDebugString());
            }
            long l = System.currentTimeMillis();
            DocumentProcessor.renderDoc(templateIdentifier, memoryDataProvider, conversionInstruction, fileOutputStream);
            log.info("SqlExample.pdf written");
            FileUtilities.close(fileOutputStream);
            conversionInstruction.setConversionFormats(new ConversionFormat[]{ConversionFormat.FORMAT_WORD});
            fileOutputStream = new FileOutputStream("SqlExample.doc");
            DocumentProcessor.renderDoc(templateIdentifier, memoryDataProvider, conversionInstruction, fileOutputStream);
            log.info("SqlExample.doc written");
            FileUtilities.close(fileOutputStream);
            conversionInstruction.setConversionFormats(new ConversionFormat[]{ConversionFormat.FORMAT_ODT});
            fileOutputStream = new FileOutputStream("SqlExample.odt");
            DocumentProcessor.renderDoc(templateIdentifier, memoryDataProvider, conversionInstruction, fileOutputStream);
            log.info("SqlExample.odt written");
            log.info("SqlExample generated in 3 separate renders in " + (System.currentTimeMillis() - l) + " milliseconds");
        }
        finally {
            FileUtilities.close(fileOutputStream);
            memoryDataProvider.cleanup();
        }
    }

    private static MemoryDataProvider getSQLData() throws NoSuchColumnNameException, SQLException, DataProviderGroupingException, ClassNotFoundException {
        String string = "select id, heading, district_id, district_name, category, male_count, female_count, district_male_total, district_female_total, district_total from campusSummary";
        ResultSet resultSet = SQLExample.executeQuery(string);
        DataProviderGrouping[] dataProviderGroupingArray = new DataProviderSQLGrouping[]{new DataProviderSQLGrouping("data", new Discriminator("ID"), new String[]{"HEADING", "NDISTRICTS", "MALETOTAL", "MALEPCT", "FEMALETOTAL", "FEMALEPCT", "TOTAL"}), new DataProviderSQLGrouping("districts", new Discriminator("DISTRICT_ID"), new String[]{"DISTRICT_NAME", "DISTRICT_MALE_TOTAL", "DISTRICT_FEMALE_TOTAL", "DISTRICT_TOTAL"}), new DataProviderSQLGrouping("categories", new Discriminator("CATEGORY"), new String[]{"MALE_COUNT", "FEMALE_COUNT", "DISTRICT_COUNT"})};
        SQLDataProvider sQLDataProvider = DataProviderFactory.createDataProvider(resultSet, dataProviderGroupingArray);
        sQLDataProvider.setString("reportDate", new SimpleDateFormat("dd/MM/yyyy HH:mm").format(new java.util.Date()));
        return sQLDataProvider;
    }

    private static ResultSet executeQuery(String string) {
        return new DummyResultSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException, ConversionException, ConverterPoolException, TemplateStoreException, ProcessingException, NoConvertersRunningException, NoSuchColumnNameException, SQLException, DataProviderGroupingException, ClassNotFoundException {
        if (stringArray != null && stringArray.length > 0) {
            SQLExample.printUsageAndExit();
        }
        SystemManager.initialise();
        try {
            SQLExample.prepareTemplates();
            SQLExample.renderReport();
        }
        finally {
            SystemManager.release();
        }
    }

    private static void printUsageAndExit() {
        System.err.println("usage: java " + SQLExample.class.getName() + " [-h]");
        System.err.println("  -h        : print this usage");
        System.err.println("  <no args> : render a CV (creates SqlExample.pdf)");
        System.exit(1);
    }

    private static class DummyMetaData
    implements ResultSetMetaData {
        private String[] columns;
        private String[] columnClasses;

        public DummyMetaData(String[] stringArray, String[] stringArray2) {
            this.columns = stringArray;
            this.columnClasses = stringArray2;
        }

        @Override
        public int getColumnCount() throws SQLException {
            return this.columns.length;
        }

        @Override
        public String getColumnName(int n) throws SQLException {
            return this.columns[n - 1];
        }

        @Override
        public String getCatalogName(int n) throws SQLException {
            return null;
        }

        @Override
        public String getColumnClassName(int n) throws SQLException {
            return this.columnClasses[n - 1];
        }

        @Override
        public int getColumnDisplaySize(int n) throws SQLException {
            return 0;
        }

        @Override
        public String getColumnLabel(int n) throws SQLException {
            return null;
        }

        @Override
        public int getColumnType(int n) throws SQLException {
            return 0;
        }

        @Override
        public String getColumnTypeName(int n) throws SQLException {
            return null;
        }

        @Override
        public int getPrecision(int n) throws SQLException {
            return 0;
        }

        @Override
        public int getScale(int n) throws SQLException {
            return 0;
        }

        @Override
        public String getSchemaName(int n) throws SQLException {
            return null;
        }

        @Override
        public String getTableName(int n) throws SQLException {
            return null;
        }

        @Override
        public boolean isAutoIncrement(int n) throws SQLException {
            return false;
        }

        @Override
        public boolean isCaseSensitive(int n) throws SQLException {
            return false;
        }

        @Override
        public boolean isCurrency(int n) throws SQLException {
            return false;
        }

        @Override
        public boolean isDefinitelyWritable(int n) throws SQLException {
            return false;
        }

        @Override
        public int isNullable(int n) throws SQLException {
            return 0;
        }

        @Override
        public boolean isReadOnly(int n) throws SQLException {
            return false;
        }

        @Override
        public boolean isSearchable(int n) throws SQLException {
            return false;
        }

        @Override
        public boolean isSigned(int n) throws SQLException {
            return false;
        }

        @Override
        public boolean isWritable(int n) throws SQLException {
            return false;
        }

        public boolean isWrapperFor(Class clazz) throws SQLException {
            return false;
        }

        public Object unwrap(Class clazz) throws SQLException {
            return null;
        }
    }

    private static class DummyResultSet
    implements ResultSet {
        private static final String[] COLUMNS = new String[]{"ID", "HEADING", "DISTRICT_ID", "DISTRICT_NAME", "CATEGORY", "MALE_COUNT", "FEMALE_COUNT", "DISTRICT_COUNT", "DISTRICT_MALE_TOTAL", "DISTRICT_FEMALE_TOTAL", "DISTRICT_TOTAL", "NDISTRICTS", "MALETOTAL", "MALEPCT", "FEMALETOTAL", "FEMALEPCT", "TOTAL"};
        private static final String[] COLUMN_CLASSES = new String[]{"java.lang.Long", "java.lang.String", "java.lang.Long", "java.lang.String", "java.lang.String", "java.lang.Integer", "java.lang.Integer", "java.lang.Integer", "java.lang.Integer", "java.lang.Integer", "java.lang.Integer", "java.lang.Integer", "java.lang.Integer", "java.lang.Double", "java.lang.Integer", "java.lang.Double", "java.lang.Integer"};
        private static final String[][] DATA = DummyResultSet.generateData();
        private static final DummyMetaData metaData = new DummyMetaData(COLUMNS, COLUMN_CLASSES);
        private int currentRow = -1;

        private static String[][] generateData() {
            int n;
            int n2;
            int n3;
            String[] stringArray = new String[]{"Wembley", "Booragoon", "Zinnafex", "Plaistowe", "Florida", "New York", "Greater London", "Montreal", "Nanda", "Manchester", "Birmingham", "Denmark", "Paris", "Barcelona"};
            int n4 = stringArray.length;
            String[] stringArray2 = new String[]{"Youth", "Adult", "Senior"};
            int n5 = stringArray2.length;
            boolean bl = true;
            String string = "Districts Population Report";
            int n6 = 0;
            int n7 = 0;
            String[][] stringArray3 = new String[n4 * n5][];
            for (n3 = 0; n3 < n4; ++n3) {
                int n8;
                n2 = 0;
                n = 0;
                int n9 = 0;
                for (n8 = 0; n8 < n5; ++n8) {
                    int n10 = (int)(Math.random() * 3100.0);
                    int n11 = (int)(Math.random() * 3100.0);
                    int n12 = n10 + n11;
                    n2 += n10;
                    n += n11;
                    n9 += n12;
                    stringArray3[n3 * n5 + n8] = new String[]{String.valueOf(1), "Districts Population Report", String.valueOf(n3), stringArray[n3], stringArray2[n8], String.valueOf(n10), String.valueOf(n11), String.valueOf(n12), "", "", "", String.valueOf(n4), "", "", "", "", ""};
                }
                for (n8 = 0; n8 < n5; ++n8) {
                    stringArray3[n3 * n5 + n8][8] = String.valueOf(n2);
                    stringArray3[n3 * n5 + n8][9] = String.valueOf(n);
                    stringArray3[n3 * n5 + n8][10] = String.valueOf(n9);
                }
                n6 += n2;
                n7 += n;
            }
            for (n3 = 0; n3 < n4 * n5; ++n3) {
                n2 = n6 + n7;
                stringArray3[n3][12] = String.valueOf(n6);
                stringArray3[n3][13] = String.valueOf(DummyResultSet.asPct((double)n6 / (double)n2));
                stringArray3[n3][14] = String.valueOf(n7);
                stringArray3[n3][15] = String.valueOf(DummyResultSet.asPct((double)n7 / (double)n2));
                stringArray3[n3][16] = String.valueOf(n2);
            }
            if (log.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer(128);
                for (n2 = 0; n2 < stringArray3.length; ++n2) {
                    stringBuffer.setLength(0);
                    for (n = 0; n < stringArray3[n2].length; ++n) {
                        if (n > 0) {
                            stringBuffer.append(',');
                        }
                        stringBuffer.append(stringArray3[n2][n]);
                    }
                    System.out.println(stringBuffer.toString());
                }
            }
            return stringArray3;
        }

        private static String asPct(double d) {
            return (double)((int)(d * 1000.0)) / 10.0 + "%";
        }

        @Override
        public String getString(int n) throws SQLException {
            return DATA[this.currentRow][n - 1];
        }

        @Override
        public boolean next() throws SQLException {
            if (this.currentRow < DATA.length - 1) {
                ++this.currentRow;
                return true;
            }
            return false;
        }

        @Override
        public String getString(String string) throws SQLException {
            for (int i = 0; i < COLUMNS.length; ++i) {
                if (!COLUMNS[i].equals(string)) continue;
                return this.getString(i + 1);
            }
            throw new SQLException("Column not known:" + string);
        }

        @Override
        public boolean absolute(int n) throws SQLException {
            return false;
        }

        @Override
        public void afterLast() throws SQLException {
        }

        @Override
        public void beforeFirst() throws SQLException {
        }

        @Override
        public void cancelRowUpdates() throws SQLException {
        }

        @Override
        public void clearWarnings() throws SQLException {
        }

        @Override
        public void close() throws SQLException {
        }

        @Override
        public void deleteRow() throws SQLException {
        }

        @Override
        public int findColumn(String string) throws SQLException {
            return 0;
        }

        @Override
        public boolean first() throws SQLException {
            return false;
        }

        @Override
        public Array getArray(int n) throws SQLException {
            return null;
        }

        @Override
        public Array getArray(String string) throws SQLException {
            return null;
        }

        @Override
        public InputStream getAsciiStream(int n) throws SQLException {
            return null;
        }

        @Override
        public InputStream getAsciiStream(String string) throws SQLException {
            return null;
        }

        @Override
        public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
            return null;
        }

        @Override
        public BigDecimal getBigDecimal(int n) throws SQLException {
            return null;
        }

        @Override
        public BigDecimal getBigDecimal(String string, int n) throws SQLException {
            return null;
        }

        @Override
        public BigDecimal getBigDecimal(String string) throws SQLException {
            return null;
        }

        @Override
        public InputStream getBinaryStream(int n) throws SQLException {
            return null;
        }

        @Override
        public InputStream getBinaryStream(String string) throws SQLException {
            return null;
        }

        @Override
        public Blob getBlob(int n) throws SQLException {
            return null;
        }

        @Override
        public Blob getBlob(String string) throws SQLException {
            return null;
        }

        @Override
        public boolean getBoolean(int n) throws SQLException {
            return false;
        }

        @Override
        public boolean getBoolean(String string) throws SQLException {
            return false;
        }

        @Override
        public byte getByte(int n) throws SQLException {
            return 0;
        }

        @Override
        public byte getByte(String string) throws SQLException {
            return 0;
        }

        @Override
        public byte[] getBytes(int n) throws SQLException {
            return null;
        }

        @Override
        public byte[] getBytes(String string) throws SQLException {
            return null;
        }

        @Override
        public Reader getCharacterStream(int n) throws SQLException {
            return null;
        }

        @Override
        public Reader getCharacterStream(String string) throws SQLException {
            return null;
        }

        @Override
        public Clob getClob(int n) throws SQLException {
            return null;
        }

        @Override
        public Clob getClob(String string) throws SQLException {
            return null;
        }

        @Override
        public int getConcurrency() throws SQLException {
            return 0;
        }

        @Override
        public String getCursorName() throws SQLException {
            return null;
        }

        @Override
        public Date getDate(int n, Calendar calendar) throws SQLException {
            return null;
        }

        @Override
        public Date getDate(int n) throws SQLException {
            return null;
        }

        @Override
        public Date getDate(String string, Calendar calendar) throws SQLException {
            return null;
        }

        @Override
        public Date getDate(String string) throws SQLException {
            return null;
        }

        @Override
        public double getDouble(int n) throws SQLException {
            return 0.0;
        }

        @Override
        public double getDouble(String string) throws SQLException {
            return 0.0;
        }

        @Override
        public int getFetchDirection() throws SQLException {
            return 0;
        }

        @Override
        public int getFetchSize() throws SQLException {
            return 0;
        }

        @Override
        public float getFloat(int n) throws SQLException {
            return 0.0f;
        }

        @Override
        public float getFloat(String string) throws SQLException {
            return 0.0f;
        }

        @Override
        public int getInt(int n) throws SQLException {
            return 0;
        }

        @Override
        public int getInt(String string) throws SQLException {
            return 0;
        }

        @Override
        public long getLong(int n) throws SQLException {
            return 0L;
        }

        @Override
        public long getLong(String string) throws SQLException {
            return 0L;
        }

        @Override
        public ResultSetMetaData getMetaData() throws SQLException {
            return metaData;
        }

        public Object getObject(int n, Map map) throws SQLException {
            return null;
        }

        @Override
        public Object getObject(int n) throws SQLException {
            return this.getString(n);
        }

        public Object getObject(String string, Map map) throws SQLException {
            return null;
        }

        @Override
        public Object getObject(String string) throws SQLException {
            return this.getString(string);
        }

        @Override
        public Ref getRef(int n) throws SQLException {
            return null;
        }

        @Override
        public Ref getRef(String string) throws SQLException {
            return null;
        }

        @Override
        public int getRow() throws SQLException {
            return 0;
        }

        @Override
        public short getShort(int n) throws SQLException {
            return 0;
        }

        @Override
        public short getShort(String string) throws SQLException {
            return 0;
        }

        @Override
        public Statement getStatement() throws SQLException {
            return null;
        }

        @Override
        public Time getTime(int n, Calendar calendar) throws SQLException {
            return null;
        }

        @Override
        public Time getTime(int n) throws SQLException {
            return null;
        }

        @Override
        public Time getTime(String string, Calendar calendar) throws SQLException {
            return null;
        }

        @Override
        public Time getTime(String string) throws SQLException {
            return null;
        }

        @Override
        public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
            return null;
        }

        @Override
        public Timestamp getTimestamp(int n) throws SQLException {
            return null;
        }

        @Override
        public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
            return null;
        }

        @Override
        public Timestamp getTimestamp(String string) throws SQLException {
            return null;
        }

        @Override
        public int getType() throws SQLException {
            return 0;
        }

        @Override
        public InputStream getUnicodeStream(int n) throws SQLException {
            return null;
        }

        @Override
        public InputStream getUnicodeStream(String string) throws SQLException {
            return null;
        }

        @Override
        public URL getURL(int n) throws SQLException {
            return null;
        }

        @Override
        public URL getURL(String string) throws SQLException {
            return null;
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return null;
        }

        @Override
        public void insertRow() throws SQLException {
        }

        @Override
        public boolean isAfterLast() throws SQLException {
            return false;
        }

        @Override
        public boolean isBeforeFirst() throws SQLException {
            return false;
        }

        @Override
        public boolean isFirst() throws SQLException {
            return false;
        }

        @Override
        public boolean isLast() throws SQLException {
            return false;
        }

        @Override
        public boolean last() throws SQLException {
            return false;
        }

        @Override
        public void moveToCurrentRow() throws SQLException {
        }

        @Override
        public void moveToInsertRow() throws SQLException {
        }

        @Override
        public boolean previous() throws SQLException {
            return false;
        }

        @Override
        public void refreshRow() throws SQLException {
        }

        @Override
        public boolean relative(int n) throws SQLException {
            return false;
        }

        @Override
        public boolean rowDeleted() throws SQLException {
            return false;
        }

        @Override
        public boolean rowInserted() throws SQLException {
            return false;
        }

        @Override
        public boolean rowUpdated() throws SQLException {
            return false;
        }

        @Override
        public void setFetchDirection(int n) throws SQLException {
        }

        @Override
        public void setFetchSize(int n) throws SQLException {
        }

        @Override
        public void updateArray(int n, Array array) throws SQLException {
        }

        @Override
        public void updateArray(String string, Array array) throws SQLException {
        }

        @Override
        public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        }

        @Override
        public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        }

        @Override
        public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        }

        @Override
        public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        }

        @Override
        public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        }

        @Override
        public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        }

        @Override
        public void updateBlob(int n, Blob blob) throws SQLException {
        }

        @Override
        public void updateBlob(String string, Blob blob) throws SQLException {
        }

        @Override
        public void updateBoolean(int n, boolean bl) throws SQLException {
        }

        @Override
        public void updateBoolean(String string, boolean bl) throws SQLException {
        }

        @Override
        public void updateByte(int n, byte by) throws SQLException {
        }

        @Override
        public void updateByte(String string, byte by) throws SQLException {
        }

        @Override
        public void updateBytes(int n, byte[] byArray) throws SQLException {
        }

        @Override
        public void updateBytes(String string, byte[] byArray) throws SQLException {
        }

        @Override
        public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        }

        @Override
        public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        }

        @Override
        public void updateClob(int n, Clob clob) throws SQLException {
        }

        @Override
        public void updateClob(String string, Clob clob) throws SQLException {
        }

        @Override
        public void updateDate(int n, Date date) throws SQLException {
        }

        @Override
        public void updateDate(String string, Date date) throws SQLException {
        }

        @Override
        public void updateDouble(int n, double d) throws SQLException {
        }

        @Override
        public void updateDouble(String string, double d) throws SQLException {
        }

        @Override
        public void updateFloat(int n, float f) throws SQLException {
        }

        @Override
        public void updateFloat(String string, float f) throws SQLException {
        }

        @Override
        public void updateInt(int n, int n2) throws SQLException {
        }

        @Override
        public void updateInt(String string, int n) throws SQLException {
        }

        @Override
        public void updateLong(int n, long l) throws SQLException {
        }

        @Override
        public void updateLong(String string, long l) throws SQLException {
        }

        @Override
        public void updateNull(int n) throws SQLException {
        }

        @Override
        public void updateNull(String string) throws SQLException {
        }

        @Override
        public void updateObject(int n, Object object, int n2) throws SQLException {
        }

        @Override
        public void updateObject(int n, Object object) throws SQLException {
        }

        @Override
        public void updateObject(String string, Object object, int n) throws SQLException {
        }

        @Override
        public void updateObject(String string, Object object) throws SQLException {
        }

        @Override
        public void updateRef(int n, Ref ref) throws SQLException {
        }

        @Override
        public void updateRef(String string, Ref ref) throws SQLException {
        }

        @Override
        public void updateRow() throws SQLException {
        }

        @Override
        public void updateShort(int n, short s) throws SQLException {
        }

        @Override
        public void updateShort(String string, short s) throws SQLException {
        }

        @Override
        public void updateString(int n, String string) throws SQLException {
        }

        @Override
        public void updateString(String string, String string2) throws SQLException {
        }

        @Override
        public void updateTime(int n, Time time) throws SQLException {
        }

        @Override
        public void updateTime(String string, Time time) throws SQLException {
        }

        @Override
        public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        }

        @Override
        public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        }

        @Override
        public boolean wasNull() throws SQLException {
            return false;
        }

        public boolean isWrapperFor(Class clazz) throws SQLException {
            return false;
        }

        public Object unwrap(Class clazz) throws SQLException {
            return null;
        }

        @Override
        public RowId getRowId(int n) throws SQLException {
            return null;
        }

        @Override
        public RowId getRowId(String string) throws SQLException {
            return null;
        }

        @Override
        public void updateRowId(int n, RowId rowId) throws SQLException {
        }

        @Override
        public void updateRowId(String string, RowId rowId) throws SQLException {
        }

        @Override
        public int getHoldability() throws SQLException {
            return 0;
        }

        @Override
        public boolean isClosed() throws SQLException {
            return false;
        }

        @Override
        public void updateNString(int n, String string) throws SQLException {
        }

        @Override
        public void updateNString(String string, String string2) throws SQLException {
        }

        @Override
        public void updateNClob(int n, NClob nClob) throws SQLException {
        }

        @Override
        public void updateNClob(String string, NClob nClob) throws SQLException {
        }

        @Override
        public NClob getNClob(int n) throws SQLException {
            return null;
        }

        @Override
        public NClob getNClob(String string) throws SQLException {
            return null;
        }

        @Override
        public SQLXML getSQLXML(int n) throws SQLException {
            return null;
        }

        @Override
        public SQLXML getSQLXML(String string) throws SQLException {
            return null;
        }

        @Override
        public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        }

        @Override
        public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        }

        @Override
        public String getNString(int n) throws SQLException {
            return null;
        }

        @Override
        public String getNString(String string) throws SQLException {
            return null;
        }

        @Override
        public Reader getNCharacterStream(int n) throws SQLException {
            return null;
        }

        @Override
        public Reader getNCharacterStream(String string) throws SQLException {
            return null;
        }

        @Override
        public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        }

        @Override
        public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        }

        @Override
        public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        }

        @Override
        public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        }

        @Override
        public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        }

        @Override
        public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        }

        @Override
        public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        }

        @Override
        public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        }

        @Override
        public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        }

        @Override
        public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        }

        @Override
        public void updateClob(int n, Reader reader, long l) throws SQLException {
        }

        @Override
        public void updateClob(String string, Reader reader, long l) throws SQLException {
        }

        @Override
        public void updateNClob(int n, Reader reader, long l) throws SQLException {
        }

        @Override
        public void updateNClob(String string, Reader reader, long l) throws SQLException {
        }

        @Override
        public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        }

        @Override
        public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        }

        @Override
        public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        }

        @Override
        public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        }

        @Override
        public void updateCharacterStream(int n, Reader reader) throws SQLException {
        }

        @Override
        public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        }

        @Override
        public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        }

        @Override
        public void updateCharacterStream(String string, Reader reader) throws SQLException {
        }

        @Override
        public void updateBlob(int n, InputStream inputStream) throws SQLException {
        }

        @Override
        public void updateBlob(String string, InputStream inputStream) throws SQLException {
        }

        @Override
        public void updateClob(int n, Reader reader) throws SQLException {
        }

        @Override
        public void updateClob(String string, Reader reader) throws SQLException {
        }

        @Override
        public void updateNClob(int n, Reader reader) throws SQLException {
        }

        @Override
        public void updateNClob(String string, Reader reader) throws SQLException {
        }
    }
}

