/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.example;

import com.docmosis.SystemManager;
import com.docmosis.document.DocumentProcessor;
import com.docmosis.document.ProcessingException;
import com.docmosis.document.converter.ConversionException;
import com.docmosis.document.converter.ConversionFormat;
import com.docmosis.document.converter.ConversionInstruction;
import com.docmosis.document.converter.NoConvertersRunningException;
import com.docmosis.document.converter.pool.ConverterPoolException;
import com.docmosis.template.TemplateStoreException;
import com.docmosis.template.population.CompoundDataProvider;
import com.docmosis.template.population.DataProvider;
import com.docmosis.template.population.MemoryDataProvider;
import com.docmosis.template.population.ReflectiveDataProvider;
import com.docmosis.template.population.render.FieldDetails;
import com.docmosis.template.population.render.FieldRenderer;
import com.docmosis.template.population.render.RenderedField;
import com.docmosis.template.store.DropStoreHelper;
import com.docmosis.template.store.TemplateContext;
import com.docmosis.template.store.TemplateIdentifier;
import com.docmosis.template.store.TemplateStoreFactory;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class ResumeExample {
    private static final Logger log = LogManager.getLogger(ResumeExample.class);

    private static void prepareTemplates() throws IOException, ConversionException, ConverterPoolException, TemplateStoreException, NoConvertersRunningException {
        DropStoreHelper dropStoreHelper = new DropStoreHelper(TemplateStoreFactory.getStore());
        dropStoreHelper.process(new File("."), false);
        log.info("Template(s) loaded into store");
    }

    private static void prepareRenderer(ConversionInstruction conversionInstruction) {
        conversionInstruction.setRenderer("renderer1", (FieldRenderer)new ResumeFieldRenderer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderCV(DataProvider dataProvider) throws IOException, ConversionException, ConverterPoolException, TemplateStoreException, ProcessingException {
        TemplateIdentifier templateIdentifier = new TemplateIdentifier("resumeTemplate.doc", new TemplateContext(""));
        ConversionInstruction conversionInstruction = new ConversionInstruction();
        conversionInstruction.setConversionFormats(new ConversionFormat[]{ConversionFormat.FORMAT_WORD, ConversionFormat.FORMAT_PDF});
        ResumeExample.prepareRenderer(conversionInstruction);
        String string = dataProvider.getString("personName");
        string = string == null ? "unknown" : string;
        conversionInstruction.setOutputFileName(string + "cv");
        FileOutputStream fileOutputStream = new FileOutputStream("resume.zip");
        try {
            long l = System.currentTimeMillis();
            DocumentProcessor.renderDoc(templateIdentifier, dataProvider, conversionInstruction, fileOutputStream);
            log.info("resume.zip generated in " + (System.currentTimeMillis() - l) + " milliseconds");
        }
        finally {
            FileUtilities.close(fileOutputStream);
        }
    }

    private static DataProvider getPersonData() {
        String string = "James Jowie";
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 1966);
        calendar.set(2, 0);
        calendar.set(5, 15);
        Person person = new Person(string, calendar.getTime());
        person.setSkills(new Skill[]{new Skill(3.0f, "Java Programming (J2EE, Swing)"), new Skill(1.5f, "Database Development (Oracle, Sybase)"), new Skill(2.0f, "Team Leading"), new Skill(7.0f, "CV re-writing")});
        person.setEducation(new Education("Feb 1977", "Nov 1979", "Vancouver Labs", new String[]{"BA Social Engineering", "BA of BS", "Punchcard Mastery"}));
        person.setInterests("Running, swimming, candle-lit dinners for three");
        ArrayList<Job> arrayList = new ArrayList<Job>();
        arrayList.add(new Job("1980", "1984", "Mintwell", "General Hand", "Manual tasks since it was early days for computing.\nMostly photocopying and fetching coffee.  In fact I was affectionately known as 'gofer' during this time."));
        arrayList.add(new Job("1984", "1985", "IBMB", "Punch Card Legend", "Tried my hand at computer programming with the newest punchcard technology.  I got plenty of time to read magazines and drink coffee while the programs compiled"));
        arrayList.add(new Job("1986", "1987", "MacroSAFT", "Team Superior", "Now I was hitting my stride, writing hundreds of lines (of comments) and running a dilligent team of staff (myself included (myself only))"));
        person.setEmploymentHistory(arrayList);
        person.setDriversLicense(Boolean.TRUE);
        Reference[] referenceArray = new Reference[]{new Reference("James Blundo", "552 444 555"), new Reference("Jillie Dava", "+44 022 22221")};
        CVDetails cVDetails = new CVDetails(new Date(), person, referenceArray);
        ReflectiveDataProvider reflectiveDataProvider = ReflectiveDataProvider.getInstance(cVDetails, false);
        MemoryDataProvider memoryDataProvider = new MemoryDataProvider();
        memoryDataProvider.setString("personName", string);
        memoryDataProvider.setString("address", "10 the burbs\nSuburbia 6101");
        memoryDataProvider.setString("objective", "To be the best programmer in the world without the need to go through years of gaining experience");
        CompoundDataProvider compoundDataProvider = new CompoundDataProvider();
        compoundDataProvider.addDataObject(memoryDataProvider);
        compoundDataProvider.addDataObject(reflectiveDataProvider);
        return compoundDataProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException, ConversionException, ConverterPoolException, TemplateStoreException, ProcessingException, NoConvertersRunningException {
        if (stringArray != null && stringArray.length > 0) {
            ResumeExample.printUsageAndExit();
        }
        SystemManager.initialise();
        DataProvider dataProvider = ResumeExample.getPersonData();
        try {
            ResumeExample.prepareTemplates();
            ResumeExample.renderCV(dataProvider);
        }
        finally {
            SystemManager.release();
        }
    }

    private static void printUsageAndExit() {
        System.err.println("usage: java " + ResumeExample.class.getName() + " [-h]");
        System.err.println("  -h        : print this usage");
        System.err.println("  <no args> : render a CV (creates resume.zip)");
        System.exit(1);
    }

    private static class ResumeFieldRenderer
    implements FieldRenderer {
        final SimpleDateFormat dateFormatter = new SimpleDateFormat("dd/MM/yyyy");

        private ResumeFieldRenderer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RenderedField render(FieldDetails fieldDetails, RenderedField renderedField) {
            Object object;
            float f;
            if (log.isDebugEnabled()) {
                log.debug("field=" + fieldDetails.getFieldName() + " val=" + fieldDetails.getFieldValue() + " rendererName=" + fieldDetails.getRendererName() + " row=" + fieldDetails.getRowNum() + " valueClass=" + fieldDetails.getValueClass() + " valueObject=" + fieldDetails.getValueObject() + " containerClass=" + fieldDetails.getContainerClass() + " containerObject=" + fieldDetails.getContainerObject());
            }
            String string = null;
            boolean bl = false;
            if ("yearsExperience".equals(fieldDetails.getFieldName()) && !((f = ((Float)fieldDetails.getValueObject()).floatValue()) <= 1.5f)) {
                if (f <= 3.0f) {
                    string = "#77AA77";
                } else {
                    string = "#77EE77";
                    bl = true;
                }
            }
            String string2 = null;
            if (fieldDetails.getValueClass() != null && fieldDetails.getValueClass().equals(Date.class)) {
                object = this.dateFormatter;
                synchronized (object) {
                    string2 = this.dateFormatter.format((Date)fieldDetails.getValueObject());
                }
            }
            object = renderedField;
            ((RenderedField)object).setCellBackgroundColour(string);
            ((RenderedField)object).setValue(string2);
            ((RenderedField)object).setBold(bl);
            return object;
        }
    }

    public static class Reference {
        private String name;
        private String phone;

        public Reference(String string, String string2) {
            this.name = string;
            this.phone = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getPhone() {
            return this.phone;
        }
    }

    public static class Job {
        String start;
        String end;
        String companyName;
        String jobDesc;
        String title;

        public Job(String string, String string2, String string3, String string4, String string5) {
            this.start = string;
            this.end = string2;
            this.companyName = string3;
            this.title = string4;
            this.jobDesc = string5;
        }

        public String getCompanyName() {
            return this.companyName;
        }

        public String getEnd() {
            return this.end;
        }

        public String getJobDesc() {
            return this.jobDesc;
        }

        public String getStart() {
            return this.start;
        }

        public String getTitle() {
            return this.title;
        }
    }

    public static class Skill {
        float yearsExperience;
        String skillName;

        public Skill(float f, String string) {
            this.yearsExperience = f;
            this.skillName = string;
        }

        public String getSkillName() {
            return this.skillName;
        }

        public float getYearsExperience() {
            return this.yearsExperience;
        }
    }

    public static class Education {
        private String from;
        private String to;
        private String location;
        private String[] history;

        public Education(String string, String string2, String string3, String[] stringArray) {
            this.from = string;
            this.to = string2;
            this.location = string3;
            this.history = stringArray;
        }

        public String getFrom() {
            return this.from;
        }

        public String[] getHistory() {
            return this.history;
        }

        public String getTo() {
            return this.to;
        }

        public String getLocation() {
            return this.location;
        }
    }

    public static class Person {
        String name;
        Date dob;
        Skill[] skills;
        List employmentHistory;
        Education education;
        String interests;
        boolean australianCitizen;
        Boolean driversLicense;

        public Person(String string, Date date) {
            this.name = string;
            this.dob = date;
        }

        public Date getDob() {
            return this.dob;
        }

        public void setDob(Date date) {
            this.dob = date;
        }

        public List getEmploymentHistory() {
            return this.employmentHistory;
        }

        public void setEmploymentHistory(List list) {
            this.employmentHistory = list;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public Skill[] getSkills() {
            return this.skills;
        }

        public void setSkills(Skill[] skillArray) {
            this.skills = skillArray;
        }

        public Education getEducation() {
            return this.education;
        }

        public void setEducation(Education education) {
            this.education = education;
        }

        public String getInterests() {
            return this.interests;
        }

        public void setInterests(String string) {
            this.interests = string;
        }

        public boolean isAustralianCitizen() {
            return this.australianCitizen;
        }

        public void setAustralianCitizen(boolean bl) {
            this.australianCitizen = bl;
        }

        public Boolean getDriversLicense() {
            return this.driversLicense;
        }

        public void setDriversLicense(Boolean bl) {
            this.driversLicense = bl;
        }
    }

    public static class CVDetails {
        Date cvDate;
        Person person;
        Reference[] references;

        public CVDetails(Date date, Person person, Reference[] referenceArray) {
            this.cvDate = date;
            this.person = person;
            this.references = referenceArray;
        }

        public Date getCvDate() {
            return this.cvDate;
        }

        public Person getPerson() {
            return this.person;
        }

        public Reference[] getReferences() {
            return this.references;
        }
    }
}

