/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.example;

import com.docmosis.SystemManager;
import com.docmosis.document.DocumentProcessor;
import com.docmosis.document.ProcessingException;
import com.docmosis.document.converter.ConversionException;
import com.docmosis.document.converter.NoConvertersRunningException;
import com.docmosis.document.converter.pool.ConverterPoolException;
import com.docmosis.template.TemplateStoreException;
import com.docmosis.template.population.DataProvider;
import com.docmosis.template.population.DataProviderBuilder;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;

public class HtmlExample {
    private static final Logger log = LogManager.getLogger(HtmlExample.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void render(File file, DataProvider dataProvider) throws IOException, ProcessingException, TemplateStoreException, ConversionException, NoConvertersRunningException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            long l = System.currentTimeMillis();
            DocumentProcessor.renderDoc(new File("template.doc"), file, dataProvider);
            long l2 = System.currentTimeMillis() - l;
            log.info(file.getName() + " generated in " + l2 + " milliseconds");
        }
        finally {
            FileUtilities.close(fileOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataProvider getData() throws IOException {
        DataProviderBuilder dataProviderBuilder = new DataProviderBuilder();
        dataProviderBuilder.add("title", "HTML Injection Example");
        BufferedReader bufferedReader = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("data.html"), "utf-8"));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        dataProviderBuilder.add("myHtmlData", stringBuffer.toString());
        return dataProviderBuilder.getDataProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException, ConversionException, ConverterPoolException, TemplateStoreException, ProcessingException, URISyntaxException, NoConvertersRunningException {
        if (stringArray.length > 1 || stringArray.length == 1 && "-h".equalsIgnoreCase(stringArray[0])) {
            HtmlExample.printUsageAndExit();
        }
        SystemManager.initialise();
        try {
            String string = stringArray.length == 1 ? stringArray[0].trim() : "result.pdf";
            HtmlExample.render(new File(string), HtmlExample.getData());
        }
        finally {
            SystemManager.release();
        }
    }

    private static void printUsageAndExit() {
        System.err.println("usage: java " + HtmlExample.class.getName() + " [-h] [outputFile]");
        System.err.println("  -h        : print this usage");
        System.err.println("  <no args> : run a simple test render (creates result.pdf)");
        System.err.println("  outputFile: an output file to create");
        System.exit(1);
    }
}

