/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.example;

import com.docmosis.SystemManager;
import com.docmosis.document.DocumentProcessor;
import com.docmosis.document.ProcessingException;
import com.docmosis.document.converter.ConversionException;
import com.docmosis.document.converter.ConversionFormat;
import com.docmosis.document.converter.ConversionInstruction;
import com.docmosis.document.converter.NoConvertersRunningException;
import com.docmosis.document.converter.pool.ConverterPoolException;
import com.docmosis.template.TemplateStoreException;
import com.docmosis.template.population.Cleanable;
import com.docmosis.template.population.DataProvider;
import com.docmosis.template.population.DataProviderBuilder;
import com.docmosis.template.population.render.FieldDetails;
import com.docmosis.template.population.render.FieldRenderer;
import com.docmosis.template.population.render.RenderedField;
import com.docmosis.template.store.DropStoreHelper;
import com.docmosis.template.store.TemplateContext;
import com.docmosis.template.store.TemplateIdentifier;
import com.docmosis.template.store.TemplateStoreFactory;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class ExampleRenders {
    private static final Logger B = LogManager.getLogger(ExampleRenders.class);
    private static final File C = new File("./stats/stats.csv");
    private static BufferedWriter A;

    private static void prepareTemplates() throws IOException, ConversionException, ConverterPoolException, TemplateStoreException, NoConvertersRunningException {
        DropStoreHelper dropStoreHelper = new DropStoreHelper(TemplateStoreFactory.getStore());
        dropStoreHelper.process(new File("."), false);
        B.info("Template(s) loaded into store");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runExampleRender(DataProvider dataProvider) throws IOException, ConversionException, ConverterPoolException, TemplateStoreException, ProcessingException {
        B.info("Performing a test render");
        TemplateIdentifier templateIdentifier = new TemplateIdentifier("exampleTemplate.doc", new TemplateContext(""));
        ConversionInstruction conversionInstruction = new ConversionInstruction();
        conversionInstruction.setConversionFormats(new ConversionFormat[]{ConversionFormat.FORMAT_ODT, ConversionFormat.FORMAT_WORD, ConversionFormat.FORMAT_PDF});
        conversionInstruction.setOutputFileName("exampleTemplate");
        FileOutputStream fileOutputStream = new FileOutputStream("newDocuments.zip");
        try {
            long l = System.currentTimeMillis();
            DocumentProcessor.renderDoc(templateIdentifier, dataProvider, conversionInstruction, fileOutputStream);
            B.info("newDocuments.zip generated in " + (System.currentTimeMillis() - l) + " milliseconds (including wait time)");
        }
        finally {
            FileUtilities.close(fileOutputStream);
        }
    }

    private static void createStatsFile() throws IOException {
        String string = "./stats";
        File file = new File(string);
        if (!file.exists() && !file.mkdir()) {
            throw new IOException("Unable to create dir:" + string);
        }
        C.delete();
        C.createNewFile();
        A = new BufferedWriter(new FileWriter(C));
    }

    private static void recordStatistics(long l) throws IOException {
        A.write(String.valueOf(l));
        A.write(44);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderDoc(File file, boolean bl, DataProvider dataProvider, ConversionInstruction conversionInstruction) throws IOException, ProcessingException, TemplateStoreException {
        TemplateIdentifier templateIdentifier = new TemplateIdentifier("exampleTemplate.doc", new TemplateContext(""));
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            long l = System.currentTimeMillis();
            DocumentProcessor.renderDoc(templateIdentifier, dataProvider, conversionInstruction, fileOutputStream);
            long l2 = System.currentTimeMillis() - l;
            B.info("newDocuments.zip generated in " + l2 + " milliseconds (including wait time)");
            if (bl) {
                ExampleRenders.recordStatistics(l2);
            }
        }
        finally {
            FileUtilities.close(fileOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runConcurrentRenders(int n, final int n2, final boolean bl, final DataProvider dataProvider) throws IOException {
        try {
            int n3;
            long l = System.currentTimeMillis();
            Thread[] threadArray = new Thread[n];
            String string = "./renders";
            final File file = new File(string);
            if (!file.exists() && !file.mkdir()) {
                throw new IOException("Unable to create dir:" + string);
            }
            if (bl) {
                ExampleRenders.createStatsFile();
            }
            _A _A2 = null;
            if (n * n2 > 1000) {
                long l2 = 180000L;
                System.out.println("A cleaner thread is being launched to clean up files greater than 3 minutes old since this kind of test is assumed to be a stamina test rather than a disk filler test.");
                _A2 = new _A(file, 180000L);
                Thread thread = new Thread((Runnable)_A2, "directoryCleaner");
                thread.setDaemon(true);
                thread.start();
            }
            final ConversionInstruction conversionInstruction = new ConversionInstruction();
            conversionInstruction.setConversionFormats(new ConversionFormat[]{ConversionFormat.FORMAT_ODT, ConversionFormat.FORMAT_WORD, ConversionFormat.FORMAT_PDF});
            conversionInstruction.setOutputFileName("exampleTemplate");
            conversionInstruction.setCleanupDataProvider(false);
            for (n3 = 0; n3 < n; ++n3) {
                int n4 = n3;
                final String string2 = "parallelRender" + n3;
                threadArray[n4] = new Thread(string2){

                    @Override
                    public void run() {
                        try {
                            for (int i = 0; i < n2; ++i) {
                                ExampleRenders.renderDoc(new File(file, string2 + "." + i + ".zip"), bl, dataProvider, conversionInstruction);
                                B.info("render completed.  Iteration " + i);
                            }
                        }
                        catch (Exception exception) {
                            throw new RuntimeException(exception);
                        }
                    }
                };
            }
            for (n3 = 0; n3 < threadArray.length; ++n3) {
                threadArray[n3].start();
            }
            for (n3 = 0; n3 < threadArray.length; ++n3) {
                try {
                    threadArray[n3].join();
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (_A2 != null) {
                _A2.A();
                System.out.println("cleaner cleaned up files:" + _A2.C());
                System.out.println("cleaner failed to clean up files:" + _A2.B());
            }
            long l3 = System.currentTimeMillis() - l;
            int n5 = n * n2;
            double d = (double)n5 / ((double)l3 / 1000.0);
            B.info("Rendered " + n5 + " in " + l3 + " millis (" + d + " per sec)");
        }
        finally {
            if (A != null) {
                A.close();
            }
        }
    }

    private static DataProvider buildDataProvider() {
        DataProviderBuilder dataProviderBuilder = new DataProviderBuilder();
        dataProviderBuilder.addAll(new String[][]{{"projectName", "Super Demo Project"}, {"name", " Freddy James"}, {"addr", " my home pad"}, {"DOB", " 10 July 1990"}, {"name.1", " Paul Stuo"}, {"addr.1", " 10 the lane"}, {"DOB.1", " 10 Jan 1956"}, {"name.2", " Sam Wells"}, {"addr.2", ""}, {"DOB.2", " 1 Apr 2000"}, {"name.3", " Superman"}, {"addr.3", " Level 28, The Daily Planet"}, {"DOB.3", " 23 June 1964"}, {"name.4", " Freddy Kruger"}, {"addr.4", " 10 Alexander Heights"}, {"DOB.4", " 28 May 2001"}, {"list.funThings.0", " touch rugby"}, {"list.funThings.1", " golf"}, {"list.funThings.2", " ice cream"}, {"show1", "[[true]]"}, {"repeat1.messages.0", "This is the first of a few messages."}, {"repeat1.messages.1", "Here's a second just for the fun of it."}, {"repeat1.messages.2", "Phew, this is getting boring."}, {"repeat1.messages.3", "Right that's enough."}});
        return dataProviderBuilder.getDataProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException, ConversionException, ConverterPoolException, TemplateStoreException, ProcessingException, URISyntaxException, NoConvertersRunningException {
        if (stringArray == null || stringArray.length > 3 || stringArray.length == 1 || stringArray.length == 3 && !"-s".equals(stringArray[0])) {
            ExampleRenders.printUsageAndExit();
            System.exit(1);
        }
        SystemManager.initialise();
        DataProvider dataProvider = null;
        URL uRL = ClassLoader.getSystemResource("sampleData.txt");
        if (uRL == null) {
            B.info("Unable to locate sampleData.txt in the classpath, creating data in code");
            dataProvider = ExampleRenders.buildDataProvider();
        } else {
            File file = new File(new URI(uRL.toString()).getPath());
            dataProvider = new DataProviderBuilder().addFile(file, '|').getDataProvider();
        }
        DocumentProcessor.setDefaultRenderer("alt1", new FieldRenderer(){

            @Override
            public RenderedField render(FieldDetails fieldDetails, RenderedField renderedField) {
                if ("value".equals(fieldDetails.getFieldName()) && "Beta".equals(fieldDetails.getFieldValue())) {
                    renderedField.setBold(true);
                    renderedField.setItalic(true);
                    renderedField.setUnderline(true);
                    renderedField.setCellBackgroundColour("#ffdddd");
                    renderedField.setValue("Beta (with rendering changes)");
                }
                return renderedField;
            }
        });
        try {
            ExampleRenders.prepareTemplates();
            if (stringArray.length == 0) {
                ExampleRenders.runExampleRender(dataProvider);
            } else {
                try {
                    int n = 0;
                    boolean bl = false;
                    if (stringArray.length == 3) {
                        bl = true;
                    }
                    int n2 = ++n;
                    int n3 = Integer.parseInt(stringArray[n2]);
                    int n4 = ++n;
                    ++n;
                    int n5 = Integer.parseInt(stringArray[n4]);
                    if (n3 * n5 > 1000000) {
                        System.out.println("This test case is limited to 1,000,000 documents total.");
                        ExampleRenders.printUsageAndExit();
                    }
                    ExampleRenders.runConcurrentRenders(n3, n5, bl, dataProvider);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Unknown number encountered.");
                    ExampleRenders.printUsageAndExit();
                }
            }
        }
        finally {
            SystemManager.release();
            if (dataProvider instanceof Cleanable) {
                ((Cleanable)((Object)dataProvider)).cleanup();
            }
        }
    }

    private static void printUsageAndExit() {
        System.err.println("usage: java " + ExampleRenders.class.getName() + " [-h] [nThreads nDocsPerThread]");
        System.err.println("  -h        : print this usage");
        System.err.println("  <no args> : run a simple test render (creates newDocuments.zip)");
        System.err.println("  n m       : run a load test of n threads rendering m documents per thread (creates renders directory)");
        System.err.println("            : (you may want to change your converterPool.xml configuration for this test).");
        System.err.println("  -s n m    : Run the same load test with statistics");
        System.err.println("Each document render takes the exampleTemplate.doc template and the sampleData.txt file and creates ");
        System.err.println("a zip file containing the resulting document in PDF, DOC and ODF formats.");
        System.exit(1);
    }

    private static class _A
    implements Runnable {
        private static final long A = 60000L;
        private File E;
        private long D;
        private int C;
        private int F;
        private boolean B;

        public _A(File file, long l) {
            this.E = file;
            this.D = l;
        }

        public int C() {
            return this.C;
        }

        public int B() {
            return this.F;
        }

        public void A() {
            this.B = false;
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            this.B = true;
            try {
                while (this.B) {
                    final long l = System.currentTimeMillis() - this.D;
                    this.E.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            if (file.lastModified() < l) {
                                if (file.delete()) {
                                    _A.this.C++;
                                } else {
                                    _A.this.F++;
                                }
                            }
                            return false;
                        }
                    });
                    Thread.sleep(60000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

