/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.example;

import com.docmosis.SystemManager;
import com.docmosis.document.DocumentProcessor;
import com.docmosis.document.ProcessingException;
import com.docmosis.document.converter.ConversionException;
import com.docmosis.document.converter.ConversionFormat;
import com.docmosis.document.converter.ConversionInstruction;
import com.docmosis.document.converter.NoConvertersRunningException;
import com.docmosis.document.converter.pool.ConverterPoolException;
import com.docmosis.template.TemplateStoreException;
import com.docmosis.template.population.Cleanable;
import com.docmosis.template.population.DataProviderBuilder;
import com.docmosis.template.store.DropStoreHelper;
import com.docmosis.template.store.TemplateContext;
import com.docmosis.template.store.TemplateIdentifier;
import com.docmosis.template.store.TemplateStoreFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;

public class Example6 {
    private static void printUsageAndExit() {
        System.err.println("usage: java " + Example6.class.getName() + " [-h] <n> ");
        System.err.println("  -h  : print this usage");
        System.err.println("  <n> : create n documents each distinctly numbered");
        System.err.println("Each document render takes the mainTemplate.doc template and the sampleData.txt file and creates result.pdf.");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException, ConversionException, ConverterPoolException, TemplateStoreException, ProcessingException, URISyntaxException, NoConvertersRunningException {
        if (stringArray.length > 1 || stringArray.length > 0 && "-h".equals(stringArray[0])) {
            Example6.printUsageAndExit();
            System.exit(1);
        }
        int n = 1;
        if (stringArray.length > 0) {
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("The argument must be an integer between 0 and 1000");
                System.exit(1);
            }
        }
        if (n > 1000 || n < 1) {
            System.err.println("The argument must be an integer between 0 and 1000");
            System.exit(1);
        }
        SystemManager.initialise();
        DataProviderBuilder dataProviderBuilder = new DataProviderBuilder();
        try {
            TemplateContext templateContext = new TemplateContext("myTemplates");
            new DropStoreHelper(TemplateStoreFactory.getStore()).process(new File("templates"), templateContext);
            dataProviderBuilder.addFile(new File("sampleData.txt"), '|');
            TemplateIdentifier templateIdentifier = new TemplateIdentifier("mainTemplate.doc", templateContext);
            ConversionInstruction conversionInstruction = new ConversionInstruction();
            conversionInstruction.setConversionFormats(new ConversionFormat[]{ConversionFormat.FORMAT_PDF});
            conversionInstruction.setCleanupDataProvider(false);
            System.out.println("About to generate " + n + " document(s).");
            long l = System.currentTimeMillis();
            for (int i = 0; i < n; ++i) {
                FileOutputStream fileOutputStream = null;
                try {
                    String string = n == 1 ? "result.pdf" : "result" + i + ".pdf";
                    fileOutputStream = new FileOutputStream(string);
                    DocumentProcessor.renderDoc(templateIdentifier, dataProviderBuilder.getDataProvider(), conversionInstruction, fileOutputStream);
                    continue;
                }
                finally {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                        fileOutputStream = null;
                    }
                }
            }
            long l2 = System.currentTimeMillis();
            System.out.println(n + " document(s) produced in " + (l2 - l) + " millis (avg = " + (l2 - l) / (long)n + ").");
        }
        finally {
            if (dataProviderBuilder.getDataProvider() instanceof Cleanable) {
                ((Cleanable)((Object)dataProviderBuilder.getDataProvider())).cleanup();
            }
            SystemManager.release();
        }
    }
}

