/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.example;

import com.docmosis.SystemManager;
import com.docmosis.document.converter.ConversionException;
import com.docmosis.document.converter.ConversionFormat;
import com.docmosis.document.converter.ConversionInstruction;
import com.docmosis.document.converter.ConversionSettings;
import com.docmosis.document.converter.DocumentFormatConverter;
import com.docmosis.document.converter.pool.ConverterPool;
import com.docmosis.document.converter.pool.ConverterPoolException;
import com.docmosis.template.Document;
import com.docmosis.template.population.PopulatedFilesCollection;
import com.docmosis.util.FileUtilities;
import java.io.File;
import java.io.IOException;

public class ConversionExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws ConversionException, ConverterPoolException, IOException {
        SystemManager.initialise();
        PopulatedFilesCollection populatedFilesCollection = null;
        Document document = null;
        try {
            File file = new File("exampleTemplate.doc");
            populatedFilesCollection = new PopulatedFilesCollection();
            populatedFilesCollection.add(null, file, true, true, null, null, null, null);
            ConversionInstruction conversionInstruction = new ConversionInstruction();
            ConversionFormat conversionFormat = ConversionFormat.FORMAT_PDF;
            conversionInstruction.setConversionFormats(new ConversionFormat[]{conversionFormat});
            boolean bl = false;
            DocumentFormatConverter documentFormatConverter = ConverterPool.getConverter();
            try {
                document = documentFormatConverter.convert(populatedFilesCollection, conversionInstruction, new ConversionSettings());
            }
            catch (ConversionException conversionException) {
                if (conversionException.isDueToServiceFailure()) {
                    bl = true;
                }
                throw new IOException("Conversion failed :" + conversionException.getMessage());
            }
            finally {
                ConverterPool.returnConverter(documentFormatConverter, bl);
            }
            FileUtilities.storeToFile(document.getInputStream(), new File("result." + conversionFormat.getExtension()));
        }
        finally {
            if (populatedFilesCollection != null) {
                populatedFilesCollection.cleanup();
            }
            if (document != null) {
                document.cleanup();
            }
            SystemManager.release();
        }
    }
}

