/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.document.converter.pool;

import com.docmosis.document.converter.ConversionException;
import com.docmosis.document.converter.DocumentFormatConverter;
import com.docmosis.document.converter.pool.ConverterInstance;
import com.docmosis.document.converter.pool.ConverterPoolException;
import com.docmosis.document.converter.pool.ConverterPoolGroupStatus;
import com.docmosis.util.DMProperties;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

class ConverterPoolGroup {
    private static final Logger D = LogManager.getLogger(ConverterPoolGroup.class);
    private static final long F = DMProperties.getInt("docmosis.converter.pool.wait.max");
    private static final long H = DMProperties.getInt("docmosis.converter.pool.wait.warning");
    private static final boolean C = DMProperties.getBoolean("docmosis.converter.pool.networkDiag.logging.enabled", false);
    private static final long A = System.currentTimeMillis();
    private final ArrayList B;
    private final ArrayList G;
    private final ArrayList E;
    private final String I;
    private final String J;

    public ConverterPoolGroup(String string, String string2) {
        this.I = string;
        this.J = string2;
        this.B = new ArrayList();
        this.G = new ArrayList();
        this.E = new ArrayList();
    }

    public synchronized void addInstance(ConverterInstance converterInstance) {
        if (converterInstance.isAvailable()) {
            this.B.add(converterInstance);
        } else {
            this.G.add(converterInstance);
        }
    }

    public String getGroupName() {
        return this.I;
    }

    public String getGroupDescription() {
        return this.J;
    }

    public boolean hasOnlineConverters() {
        return this.getOnlineConverterCount() > 0;
    }

    public synchronized int getOnlineConverterCount() {
        return this.B.size() + this.E.size();
    }

    public synchronized ConverterPoolGroupStatus getGroupStatus() {
        return new ConverterPoolGroupStatus(this.B.size() + this.E.size(), this.G.size(), this.E.size(), (System.currentTimeMillis() - A) / 1000L);
    }

    public synchronized DocumentFormatConverter getConverterFromPool() throws ConverterPoolException {
        DocumentFormatConverter documentFormatConverter = null;
        try {
            long l = System.currentTimeMillis();
            boolean bl = false;
            boolean bl2 = false;
            while (this.B.size() == 0) {
                if (!bl2 && this.E.size() == 0) {
                    if (this.G.size() == 0) {
                        throw new ConverterPoolException("Converter Pool group named:" + this.I + " has no converters defined.");
                    }
                    D.warn("No functioning converters present for group:" + this.I + ".  Awaiting one to come online.");
                    bl2 = true;
                }
                this.wait(H);
                if (this.B.size() != 0) continue;
                long l2 = System.currentTimeMillis();
                long l3 = l2 - l;
                if (l3 > F) {
                    String string = "Took too long to get converter.  Max wait is (ms):" + F;
                    throw new ConverterPoolException(string);
                }
                if (bl || l3 <= H) continue;
                D.warn("Waiting longer than configured warning period (" + H + " ms) " + "to get a converter from group: " + this.I + ".  You might consider adding more " + "converters to the pool.");
                bl = true;
            }
            documentFormatConverter = (DocumentFormatConverter)this.B.remove(0);
            this.E.add(documentFormatConverter);
            if (C && D.isInfoEnabled()) {
                try {
                    D.info("time waited to get converter [" + documentFormatConverter.getDescription() + "] from pool:" + (System.currentTimeMillis() - l) + " ms");
                }
                catch (RuntimeException runtimeException) {
                    D.warn("Unable to get description from converter:", runtimeException);
                    D.info("time waited to get converter [] from pool:" + (System.currentTimeMillis() - l) + " ms");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return documentFormatConverter;
    }

    public synchronized void returnConverterToPool(DocumentFormatConverter documentFormatConverter, boolean bl) {
        boolean bl2 = this.E.remove(documentFormatConverter);
        if (bl2) {
            if (bl) {
                this.G.add(documentFormatConverter);
            } else {
                this.B.add(documentFormatConverter);
            }
        }
        if (!bl) {
            this.notify();
        }
    }

    public synchronized void shutdown() {
        this.shutdownInstances(this.B);
        this.shutdownInstances(this.E);
        this.shutdownInstances(this.G);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void repairBrokenInstances() {
        Object object;
        ArrayList arrayList = null;
        Object object2 = this;
        synchronized (object2) {
            if (this.G.size() > 0) {
                arrayList = new ArrayList(this.G.size());
                object = this.G.iterator();
                while (object.hasNext()) {
                    arrayList.add(object.next());
                    object.remove();
                }
            }
        }
        object2 = null;
        if (arrayList != null) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                DocumentFormatConverter documentFormatConverter = (DocumentFormatConverter)object.next();
                try {
                    if (!documentFormatConverter.repair()) continue;
                    if (object2 == null) {
                        object2 = new ArrayList();
                    }
                    object2.add(documentFormatConverter);
                    object.remove();
                }
                catch (RuntimeException runtimeException) {
                    D.warn("Error repairing converter", runtimeException);
                }
            }
        }
        if (object2 != null) {
            object = this;
            synchronized (object) {
                this.B.addAll(object2);
                this.notify();
            }
        }
        if (arrayList != null && arrayList.size() > 0) {
            object = this;
            synchronized (object) {
                this.G.addAll(arrayList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kickTheTyres() {
        int n;
        Object object = this;
        synchronized (object) {
            n = this.getOnlineConverterCount();
        }
        object = new HashSet();
        for (int i = 0; i < n; ++i) {
            DocumentFormatConverter documentFormatConverter = null;
            boolean bl = true;
            try {
                documentFormatConverter = this.getConverterFromPool();
                Integer n2 = new Integer(System.identityHashCode(documentFormatConverter));
                if (object.contains(n2)) break;
                object.add(n2);
                documentFormatConverter.kickTheTyres();
                bl = false;
                continue;
            }
            catch (ConverterPoolException converterPoolException) {
                D.info("Error detected waking converter", converterPoolException);
                continue;
            }
            catch (ConversionException conversionException) {
                D.info("Error detected waking converter", conversionException);
                continue;
            }
            catch (RuntimeException runtimeException) {
                D.info("Error detected waking converter", runtimeException);
                continue;
            }
            finally {
                this.returnConverterToPool(documentFormatConverter, bl);
            }
        }
    }

    private void shutdownInstances(List list) {
        if (list != null) {
            for (DocumentFormatConverter documentFormatConverter : list) {
                if (documentFormatConverter == null) continue;
                try {
                    documentFormatConverter.shutdown();
                }
                catch (RuntimeException runtimeException) {
                    D.warn("Error Shutting down a converter", runtimeException);
                }
            }
            list.clear();
        }
    }
}

