/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.document.converter.pool;

import com.docmosis.document.converter.pool.ConverterPoolException;
import com.docmosis.util.StringUtilities;
import com.docmosis.util.ssl.SSLClientSocketSettings;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;

public class ConverterPoolConfigOverride {
    private final _A C;
    private final String E;
    private int A;
    private RemoteSpec[] D;
    private String B;

    private ConverterPoolConfigOverride(int n) {
        this.C = _A.C;
        this.A = n;
        this.E = String.valueOf(n);
    }

    private ConverterPoolConfigOverride(String string) {
        this.C = _A.D;
        this.B = string;
        this.E = string;
    }

    private ConverterPoolConfigOverride(RemoteSpec[] remoteSpecArray, String string) {
        this.C = _A.A;
        this.D = remoteSpecArray;
        this.E = string;
    }

    public static ConverterPoolConfigOverride parse(String string) throws ConverterPoolException {
        try {
            int n = Integer.parseInt(string);
            return new ConverterPoolConfigOverride(n);
        }
        catch (NumberFormatException numberFormatException) {
            if (string.indexOf(58) != -1) {
                RemoteSpec[] remoteSpecArray;
                ArrayList<RemoteSpec> arrayList = new ArrayList<RemoteSpec>();
                OverrideTokenizer overrideTokenizer = new OverrideTokenizer(string);
                while (overrideTokenizer.hasNext()) {
                    String string2;
                    int n;
                    remoteSpecArray = overrideTokenizer.next();
                    SSLClientSocketSettings sSLClientSocketSettings = overrideTokenizer.getOverallSSLSettings();
                    if (remoteSpecArray.trim().equals("") || (n = remoteSpecArray.indexOf(58)) < 0) continue;
                    String string3 = remoteSpecArray.substring(0, n).trim();
                    String string4 = remoteSpecArray.substring(n + 1).trim();
                    String string5 = null;
                    n = string4.indexOf(58);
                    if (n == -1) {
                        string2 = string4;
                    } else {
                        string2 = string4.substring(0, n);
                        string5 = string4.substring(n + 1);
                    }
                    try {
                        Integer n2 = Integer.valueOf(string2);
                        arrayList.add(new RemoteSpec(string3, n2, ConverterPoolConfigOverride.sslSettingsFromString(string5, string3, n2, sSLClientSocketSettings)));
                    }
                    catch (NumberFormatException numberFormatException2) {
                        throw new ConverterPoolException("Invalid port number: " + string2);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw new ConverterPoolException(fileNotFoundException.getMessage());
                    }
                }
                if (arrayList.size() == 0) {
                    throw new ConverterPoolException("Invalid remote converters specification: " + string);
                }
                remoteSpecArray = new RemoteSpec[arrayList.size()];
                arrayList.toArray(remoteSpecArray);
                return new ConverterPoolConfigOverride(remoteSpecArray, string);
            }
            return new ConverterPoolConfigOverride(string);
        }
    }

    private static SSLClientSocketSettings sslSettingsFromString(String string, String string2, Integer n, SSLClientSocketSettings sSLClientSocketSettings) throws FileNotFoundException {
        if (StringUtilities.isEmpty(string)) {
            if (sSLClientSocketSettings == null) {
                return null;
            }
            return SSLClientSocketSettings.derive(sSLClientSocketSettings, null, string2, n, null, null, null, null, null, null, null, null);
        }
        String[] stringArray = string.split(";");
        String string3 = stringArray[0];
        File file = null;
        char[] cArray = null;
        if (stringArray.length > 1 && !(file = new File(stringArray[1])).canRead()) {
            throw new FileNotFoundException("Cannot find trust store at \"" + stringArray[1] + "\"");
        }
        if (stringArray.length > 2) {
            cArray = stringArray[2] == null ? null : stringArray[2].toCharArray();
        }
        SSLClientSocketSettings sSLClientSocketSettings2 = sSLClientSocketSettings == null ? new SSLClientSocketSettings(string3, string2, n, null, null, null, null, file, cArray, null, null) : SSLClientSocketSettings.derive(sSLClientSocketSettings, string3, string2, n, null, null, null, null, file, cArray, null, null);
        return sSLClientSocketSettings2;
    }

    public String getOriginalSpec() {
        return this.E;
    }

    public int getEmbeddedCount() throws IllegalArgumentException {
        if (!this.isEmbeddedCount()) {
            throw new IllegalArgumentException("Cannot get the count for config type:" + this.C);
        }
        return this.A;
    }

    public RemoteSpec[] getRemoteSpec() throws IllegalArgumentException {
        if (!this.isRemoteSpec()) {
            throw new IllegalArgumentException("Cannot get the remote spec for config type:" + this.C);
        }
        return this.D;
    }

    public String getResourceSpec() throws IllegalArgumentException {
        if (!this.isResourcePath()) {
            throw new IllegalArgumentException("Cannot get the resource spec for config type:" + this.C);
        }
        return this.B;
    }

    public boolean isEmbeddedCount() {
        return _A.C == this.C;
    }

    public boolean isRemoteSpec() {
        return _A.A == this.C;
    }

    public boolean isResourcePath() {
        return _A.D == this.C;
    }

    public static class RemoteSpec {
        private final String C;
        private final Integer A;
        private final SSLClientSocketSettings B;

        public RemoteSpec(String string, Integer n, SSLClientSocketSettings sSLClientSocketSettings) {
            this.C = string;
            this.A = n;
            this.B = sSLClientSocketSettings;
        }

        public String getHost() {
            return this.C;
        }

        public Integer getPort() {
            return this.A;
        }

        public SSLClientSocketSettings getSslSettings() {
            return this.B;
        }
    }

    public static class OverrideTokenizer {
        private static final String A = "^\\s*ssl\\s*=.*";
        private List C = new ArrayList();
        private int B = 0;
        private SSLClientSocketSettings D;

        public OverrideTokenizer(String string) {
            String string2;
            if (string == null) {
                return;
            }
            int n = string.indexOf(44);
            if (n != -1) {
                int n2;
                string2 = string.substring(0, n);
                System.out.println("part:" + string2);
                this.C.add(string2.trim());
                while (n != -1 && (n2 = string.indexOf(44, n + 1)) != -1) {
                    string2 = string.substring(n + 1, n2);
                    System.out.println("part:" + string2);
                    string2 = string2.trim();
                    this.C.add(string2.trim());
                    n = n2;
                }
            }
            string2 = string.substring(n + 1);
            System.out.println("tail:" + string2);
            if (string2.matches(A)) {
                this.D = OverrideTokenizer.extractGeneralSSLSettings(string2);
            } else {
                this.C.add(string2.trim());
            }
        }

        public static void main(String[] stringArray) {
            System.out.println("ssl=TLS;c:/projects/xyz.trustStore.jks;abc123".matches(A));
        }

        public String next() {
            if (this.B > this.C.size() - 1) {
                throw new IllegalStateException("no elements to fetch");
            }
            return (String)this.C.get(this.B++);
        }

        public boolean hasNext() {
            return this.B < this.C.size();
        }

        public SSLClientSocketSettings getOverallSSLSettings() {
            return this.D;
        }

        private static SSLClientSocketSettings extractGeneralSSLSettings(String string) {
            String string2 = "Bad general SSL specification.  Expected \"ssl=<sslProtocol>[;<trustStorePath>[;<trustStorePw>]]\"";
            int n = string.indexOf(61);
            if (n == -1) {
                throw new IllegalArgumentException("Bad general SSL specification.  Expected \"ssl=<sslProtocol>[;<trustStorePath>[;<trustStorePw>]]\"");
            }
            String[] stringArray = (string = string.substring(n + 1)).split(";");
            if (stringArray.length < 1 || stringArray.length > 3) {
                throw new IllegalArgumentException("Bad general SSL specification.  Expected \"ssl=<sslProtocol>[;<trustStorePath>[;<trustStorePw>]]\"");
            }
            String string3 = stringArray[0].trim();
            File file = stringArray.length > 1 ? new File(stringArray[1]) : null;
            char[] cArray = stringArray.length > 2 ? stringArray[2].toCharArray() : null;
            return new SSLClientSocketSettings(string3, null, 0, null, null, null, null, file, cArray, null, null);
        }
    }

    private static class _A {
        private static final _A C = new _A("EMBEDDED_COUNT");
        private static final _A A = new _A("REMOTE_SPEC");
        private static final _A D = new _A("RESOURCE_PATH");
        private final String B;

        private _A(String string) {
            this.B = string;
        }

        public String toString() {
            return this.B;
        }
    }
}

