/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.document.converter.pool;

import com.docmosis.document.converter.DocumentFormatConverter;
import com.docmosis.document.converter.NoConvertersRunningException;
import com.docmosis.document.converter.pool.ConverterInstance;
import com.docmosis.document.converter.pool.ConverterPoolConfigOverride;
import com.docmosis.document.converter.pool.ConverterPoolException;
import com.docmosis.document.converter.pool.ConverterPoolGroup;
import com.docmosis.document.converter.pool.ConverterPoolGroupStatus;
import com.docmosis.document.converter.pool.ConverterPoolProperties;
import com.docmosis.util.Configuration;
import com.docmosis.util.DMProperties;
import com.docmosis.util.EngineDetails;
import com.docmosis.util.EngineVersion;
import com.docmosis.util.Equivalence;
import com.docmosis.util.PlatformUtilities;
import com.docmosis.util.StringUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import com.docmosis.util.ssl.SSLClientSocketSettings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ConverterPool {
    private static final Logger I = LogManager.getLogger(ConverterPool.class);
    private static final String G = "name";
    private static final String _ = "description";
    private static final String H = "enableOnlyIfSysPropSet";
    private static final String P = "officeConverterClass";
    private static final String Z = "path";
    private static final String Y = "hostname";
    private static final String S = "port";
    private static final String T = "sslProtocol";
    private static final String M = "sslTrustStore";
    private static final String L = "sslTrustStorePw";
    private static final String Q = "count";
    public static final String PROPERTY_POOL_CONFIG_RESOURCE = "docmosis.document.converter.pool.config.resource";
    public static final String PROPERTY_POOL_CONFIG_OVERRIDE = Configuration.P_CONVERTER_POOL_CONFIG;
    private static final String V = "embedded";
    private static final String X = "remote";
    private static final String A = "com.docmosis.converter.openoffice.LocalOpenOfficeConverter";
    private static final String F = "com.docmosis.document.converter.RemoteConverterGateway";
    private static final String D = "com.docmosis.document.converter.RemoteConverterGateway";
    private static final String B = "com.docmosis.converter.openoffice.LocalOpenOfficeConverter";
    public static final String MANUFACTURED_DEFAULT_GROUP_NAME = "default";
    private static final AtomicReference<EngineDetails> K = new AtomicReference();
    private static ConverterPool U;
    private final boolean W = DMProperties.getBoolean("docmosis.converter.pool.remote.management.enabled", true);
    private String E = null;
    private String O = null;
    private _A N;
    private _C R;
    private Map J;
    private int C = 0;

    public static void initialise(int n) throws ConverterPoolException {
        String string = DMProperties.getString(PROPERTY_POOL_CONFIG_OVERRIDE);
        String string2 = DMProperties.getString(PROPERTY_POOL_CONFIG_RESOURCE);
        try {
            ConverterPoolConfigOverride converterPoolConfigOverride;
            ConverterPoolConfigOverride converterPoolConfigOverride2 = converterPoolConfigOverride = StringUtilities.isEmpty(string) ? null : ConverterPoolConfigOverride.parse(string);
            if (converterPoolConfigOverride != null && converterPoolConfigOverride.isResourcePath()) {
                if (I.isDebugEnabled()) {
                    I.debug("Override resource:" + string);
                }
                string2 = string;
                string = null;
                converterPoolConfigOverride = null;
            }
            U = new ConverterPool(string2, converterPoolConfigOverride, n);
        }
        catch (ConverterPoolException converterPoolException) {
            throw converterPoolException;
        }
        catch (RuntimeException runtimeException) {
            throw new ConverterPoolException("An error occurred initializing the converter pool:" + runtimeException.getMessage(), runtimeException);
        }
    }

    private ConverterPool(String string, ConverterPoolConfigOverride converterPoolConfigOverride, int n) throws ConverterPoolException {
        this.O = string;
        _B _B2 = null;
        boolean bl = false;
        if (converterPoolConfigOverride != null) {
            try {
                I.debug("Using overriding values for converter pool from property " + PROPERTY_POOL_CONFIG_OVERRIDE + "=[" + converterPoolConfigOverride.getOriginalSpec() + "]");
                _B2 = this.loadOverrideConfig(converterPoolConfigOverride, n);
                bl = true;
            }
            catch (ConverterPoolException converterPoolException) {
                I.error("An error occurred using override values (property \"" + PROPERTY_POOL_CONFIG_OVERRIDE + "\" is not set properly).  Using XML file instead.", converterPoolException);
            }
        }
        if (!bl) {
            _B2 = this.loadXMLConfig(string);
        }
        if (_B2 == null || _B2.A.size() == 0) {
            throw new IllegalArgumentException("Converter pool configuration is empty");
        }
        this.E = _B2.B;
        ArrayList arrayList = _B2.A;
        this.J = new HashMap();
        boolean bl2 = false;
        for (ConverterPoolGroup converterPoolGroup : arrayList) {
            if (converterPoolGroup.getGroupName().equals(this.E)) {
                bl2 = true;
            }
            this.J.put(converterPoolGroup.getGroupName(), converterPoolGroup);
        }
        if (!bl2) {
            this.J.put(this.E, arrayList.get(0));
            I.warn("Your default group \"" + this.E + "\" for the converter pool is not configured/enabled.  " + "Default group set to first active:" + ((ConverterPoolGroup)this.J.get(this.E)).getGroupName());
        } else {
            I.debug("Default converter group:" + ((ConverterPoolGroup)this.J.get(this.E)).getGroupName());
        }
        this.N = new _A(this.J);
        if (this.W) {
            this.R = new _C(this.J);
        }
    }

    public static DocumentFormatConverter getConverter() throws ConverterPoolException {
        try {
            return ConverterPool.getConverter(true);
        }
        catch (NoConvertersRunningException noConvertersRunningException) {
            throw new ConverterPoolException(noConvertersRunningException);
        }
    }

    public static DocumentFormatConverter getConverter(boolean bl) throws ConverterPoolException, NoConvertersRunningException {
        return ConverterPool.getConverter(null, bl);
    }

    private static ConverterPoolGroup getGroup(String string) throws ConverterPoolException {
        if (U == null) {
            throw new ConverterPoolException("Pool failed to initialize");
        }
        ConverterPoolGroup converterPoolGroup = (ConverterPoolGroup)ConverterPool.U.J.get(string == null ? ConverterPool.U.E : string);
        if (converterPoolGroup == null) {
            String string2 = string == null ? "No default group has been specified" : "Specified group is not known:" + string;
            throw new ConverterPoolException(string2);
        }
        return converterPoolGroup;
    }

    public static DocumentFormatConverter getConverter(String string) throws ConverterPoolException {
        try {
            return ConverterPool.getConverter(string, true);
        }
        catch (NoConvertersRunningException noConvertersRunningException) {
            throw new ConverterPoolException(noConvertersRunningException);
        }
    }

    public static DocumentFormatConverter getConverter(String string, boolean bl) throws ConverterPoolException, NoConvertersRunningException {
        if (U == null) {
            throw new ConverterPoolException("Pool failed to initialize");
        }
        ConverterPoolGroup converterPoolGroup = ConverterPool.getGroup(string);
        if (!bl && !converterPoolGroup.hasOnlineConverters()) {
            throw new NoConvertersRunningException("No functioning converters present for group: " + (string == null ? ConverterPool.U.E : string) + " and allowWait is false.");
        }
        return converterPoolGroup.getConverterFromPool();
    }

    private void returnConverterToPool(DocumentFormatConverter documentFormatConverter, boolean bl) {
        if (documentFormatConverter == null) {
            return;
        }
        if (!(documentFormatConverter instanceof ConverterInstance)) {
            I.warn("Unknown converter returned to pool.  Ignored");
        } else {
            documentFormatConverter.setModuleTiming(null);
            ((ConverterInstance)documentFormatConverter).getPoolGroup().returnConverterToPool(documentFormatConverter, bl);
        }
    }

    public static void returnConverter(DocumentFormatConverter documentFormatConverter, boolean bl) {
        if (U != null) {
            U.returnConverterToPool(documentFormatConverter, bl);
        }
    }

    public static boolean hasOnlineConverters() throws ConverterPoolException {
        return U == null ? false : ConverterPool.hasOnlineConverters(ConverterPool.U.E);
    }

    public static boolean hasOnlineConverters(String string) throws ConverterPoolException {
        return ConverterPool.getOnlineConverterCount(string) > 0;
    }

    public static int getOnlineConverterCount() throws ConverterPoolException {
        return ConverterPool.getOnlineConverterCount(null);
    }

    public static int getOnlineConverterCount(String string) throws ConverterPoolException {
        return ConverterPool.getGroup(string).getOnlineConverterCount();
    }

    public static ConverterPoolGroupStatus getGroupStatus() throws ConverterPoolException {
        return ConverterPool.getGroupStatus(null);
    }

    public static ConverterPoolGroupStatus getGroupStatus(String string) throws ConverterPoolException {
        return ConverterPool.getGroup(string).getGroupStatus();
    }

    public static void release() {
        if (U != null) {
            U.shutdownInstance();
            U = null;
        }
    }

    public static int getConverterCount() {
        return U == null ? -1 : ConverterPool.U.C;
    }

    public void shutdownInstance() {
        if (this.J == null) {
            return;
        }
        HashMap hashMap = new HashMap(this.J);
        this.J.clear();
        this.J = null;
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            ((ConverterPoolGroup)iterator.next()).shutdown();
        }
        if (this.N != null) {
            this.N.A();
            this.N = null;
        }
        if (this.R != null) {
            this.R.A();
            this.R = null;
        }
        K.set(null);
    }

    public static String getConverterVersion() {
        EngineDetails engineDetails = K.get();
        EngineVersion engineVersion = engineDetails == null ? null : engineDetails.getEngineVersion();
        String string = "";
        if (engineVersion != null) {
            string = (engineVersion.getEngineType() != null && engineVersion.getEngineType().equals((Object)EngineVersion.EngineType.LIBRE_OFFICE) ? "LibreOffice " : "Other ") + engineVersion.getVersionNumberString() + (engineDetails.isRemote() ? " (remote)" : "");
        }
        return string;
    }

    public static EngineDetails getConverterEngineDetails() {
        EngineDetails engineDetails = K.get();
        return engineDetails;
    }

    private _B loadOverrideConfig(ConverterPoolConfigOverride converterPoolConfigOverride, int n) throws ConverterPoolException {
        ConverterPoolGroup converterPoolGroup = new ConverterPoolGroup(MANUFACTURED_DEFAULT_GROUP_NAME, "Single overriding group.");
        if (converterPoolConfigOverride.isEmbeddedCount()) {
            boolean bl;
            int n2 = converterPoolConfigOverride.getEmbeddedCount();
            if (n2 == 0) {
                throw new ConverterPoolException("Override configuration is not valid: maxConverters ==0");
            }
            if (n2 < 1) {
                n2 = Math.min(n, 99);
            }
            String string = (bl = PlatformUtilities.isWindows()) ? "soffice.exe" : "soffice";
            for (int i = 0; i < n2; ++i) {
                if (n > -1 && this.C >= n) {
                    I.info("Maximum converters launched:" + this.C);
                    break;
                }
                ConverterInstance converterInstance = new ConverterInstance(new ConverterPoolProperties(string, "com.docmosis.converter.openoffice.LocalOpenOfficeConverter", null), i == 0);
                ConverterPool.plugConverterInstance(converterInstance, converterPoolGroup);
                ++this.C;
            }
        } else {
            ConverterPoolConfigOverride.RemoteSpec[] remoteSpecArray = converterPoolConfigOverride.getRemoteSpec();
            for (int i = 0; i < remoteSpecArray.length; ++i) {
                ConverterInstance converterInstance = new ConverterInstance(new ConverterPoolProperties(remoteSpecArray[i].getHost(), remoteSpecArray[i].getPort(), remoteSpecArray[i].getSslSettings(), "com.docmosis.document.converter.RemoteConverterGateway", null), i == 0);
                ConverterPool.plugConverterInstance(converterInstance, converterPoolGroup);
                ++this.C;
            }
        }
        _B _B2 = new _B();
        _B2.B = MANUFACTURED_DEFAULT_GROUP_NAME;
        _B2.A = new ArrayList(1);
        _B2.A.add(converterPoolGroup);
        I.debug("Launched converter pool group with " + this.C + " instances of a total allowed:" + (n < 1 ? "unlimited" : String.valueOf(n)));
        return _B2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private _B loadXMLConfig(String string) {
        Object object;
        ArrayList<Object> arrayList = null;
        String string2 = null;
        if (string == null) {
            throw new IllegalStateException("There is no converter pool configuration specified.  Make sure your docmosis.properties (or System properties) specifies \"docmosis.document.converter.pool.config.resource\"");
        }
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            throw new IllegalStateException("Unable to load resource config: " + string);
        }
        try {
            SSLClientSocketSettings sSLClientSocketSettings;
            Object object2;
            object = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object).setValidating(false);
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            NodeList nodeList = document.getElementsByTagName("converter-pool");
            Node node = nodeList.item(0);
            string2 = this.getAttribute(node, "defaultGroup");
            ConverterPoolProperties converterPoolProperties = new ConverterPoolProperties();
            String string3 = ConverterPool.getConverterClassFor(this.getAttribute(node, P));
            converterPoolProperties.setOfficeConverterClass(string3);
            if (!StringUtilities.isEmpty(this.getAttribute(node, T))) {
                object2 = StringUtilities.isEmpty(this.getAttribute(node, M)) ? null : new File(this.getAttribute(node, M));
                sSLClientSocketSettings = StringUtilities.isEmpty(this.getAttribute(node, L)) ? null : this.getAttribute(node, L).toCharArray();
                converterPoolProperties.setSslSettings(new SSLClientSocketSettings(this.getAttribute(node, T), null, 0, null, null, null, null, (File)object2, (char[])sSLClientSocketSettings, null, null));
            }
            object2 = document.getElementsByTagName("group");
            sSLClientSocketSettings = SSLClientSocketSettings.nonSecure();
            for (int i = 0; i < object2.getLength(); ++i) {
                Object object3;
                Object object4;
                String string4;
                Object object5;
                Node node2 = object2.item(i);
                String string5 = this.getAttribute(node2, G);
                String string6 = this.getAttribute(node2, _);
                String string7 = this.getAttribute(node2, H);
                boolean bl = false;
                boolean bl2 = false;
                if (string7 != null && !"".equals(string7.trim())) {
                    bl = true;
                    object5 = new StringTokenizer(string7.trim(), "=");
                    string4 = ((StringTokenizer)object5).nextToken();
                    if (((StringTokenizer)object5).hasMoreTokens()) {
                        object4 = System.getProperty(string4);
                        if (object4 != null) {
                            object3 = null;
                            object3 = ((StringTokenizer)object5).nextToken();
                            bl2 = Equivalence.equivalentObjects(object4, object3);
                        }
                    } else {
                        I.error("Group \"" + string5 + "\" specifies an invalid value for " + "\"" + H + "\" " + "(expected value of form key=value).  GROUP DISABLED");
                    }
                }
                if (bl) {
                    I.info("Converter Pool Group " + string5 + " is conditional (" + string7.trim() + "). Enabled ? " + bl2);
                }
                if (bl && !bl2) continue;
                object5 = new ConverterPoolProperties(converterPoolProperties);
                string4 = this.getAttribute(node2, Y);
                ((ConverterPoolProperties)object5).setOfficeConverterClass(ConverterPool.getConverterClassFor(this.getAttribute(node2, P)));
                ((ConverterPoolProperties)object5).setHostname(string4);
                ((ConverterPoolProperties)object5).setPort(this.getIntAttribute(node2, S));
                if ("".equals(this.getAttribute(node2, T))) {
                    ((ConverterPoolProperties)object5).setSslSettings(sSLClientSocketSettings);
                } else {
                    object4 = this.getAttribute(node2, M) == null ? null : new File(this.getAttribute(node2, M));
                    object3 = StringUtilities.isEmpty(this.getAttribute(node2, L)) ? null : this.getAttribute(node2, L).toCharArray();
                    ((ConverterPoolProperties)object5).setSslSettings(SSLClientSocketSettings.derive(converterPoolProperties.getSslSettings(), this.getAttribute(node2, T), null, null, null, null, null, null, (File)object4, (char[])object3, null, null));
                }
                ((ConverterPoolProperties)object5).setPath(this.getAttribute(node2, Z));
                if (string2 == null) {
                    I.debug("Default converter group defaulted to:" + string5);
                    string2 = string5;
                }
                object4 = new ConverterPoolGroup(string5, string6);
                if (arrayList == null) {
                    arrayList = new ArrayList<Object>();
                }
                arrayList.add(object4);
                object3 = node2.getChildNodes();
                for (int j = 0; j < object3.getLength(); ++j) {
                    ConverterInstance converterInstance;
                    String string8;
                    Node node3 = object3.item(j);
                    if (node3.getNodeType() != 1) continue;
                    String string9 = this.getAttribute(node3, Q);
                    if (string9 != null) {
                        try {
                            int n = Integer.parseInt(string9);
                            string8 = PlatformUtilities.getExeName("soffice");
                            for (int k = 0; k < n; ++k) {
                                converterInstance = new ConverterInstance(new ConverterPoolProperties(string8, ConverterPool.getConverterClassFor(this.getAttribute(node3, P)), (ConverterPoolProperties)object5), this.C == 0);
                                ConverterPool.plugConverterInstance(converterInstance, (ConverterPoolGroup)object4);
                                ++this.C;
                            }
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IllegalStateException("Group \"" + string5 + "\" specifies an invalid value for " + "\"" + Q + "\" which may be -1, 1, 2,...");
                        }
                    }
                    String string10 = this.getAttribute(node3, Z);
                    if (string10 != null) {
                        converterInstance = new ConverterInstance(new ConverterPoolProperties(string10, ConverterPool.getConverterClassFor(this.getAttribute(node3, P)), (ConverterPoolProperties)object5), this.C == 0);
                    } else {
                        SSLClientSocketSettings sSLClientSocketSettings2;
                        string8 = this.getAttribute(node3, Y);
                        Integer n = this.getIntAttribute(node3, S);
                        if ("".equals(this.getAttribute(node3, T))) {
                            sSLClientSocketSettings2 = sSLClientSocketSettings;
                        } else {
                            String string11 = this.getAttribute(node3, T) == null ? null : this.getAttribute(node3, T);
                            File file = this.getAttribute(node3, M) == null ? null : new File(this.getAttribute(node3, M));
                            char[] cArray = StringUtilities.isEmpty(this.getAttribute(node3, L)) ? null : this.getAttribute(node3, L).toCharArray();
                            sSLClientSocketSettings2 = SSLClientSocketSettings.derive(((ConverterPoolProperties)object5).getSslSettings(), string11, string8, n, null, null, null, null, file, cArray, null, null);
                            ConverterPool.validateInstanceSSLSettings(sSLClientSocketSettings2);
                        }
                        converterInstance = new ConverterInstance(new ConverterPoolProperties(string8, n, sSLClientSocketSettings2, ConverterPool.getConverterClassFor(this.getAttribute(node3, P)), (ConverterPoolProperties)object5), this.C == 0);
                    }
                    ConverterPool.plugConverterInstance(converterInstance, (ConverterPoolGroup)object4);
                    ++this.C;
                }
            }
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            I.fatal("Unable to load config file:" + string, exception);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            I.fatal("Unable to load config file:" + string, parserConfigurationException);
        }
        catch (IOException iOException) {
            I.fatal("Unable to load config file:" + string, iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                I.warn("Warning: unable to close the config file:" + string, iOException);
            }
        }
        object = null;
        if (arrayList != null) {
            object = new _B();
            ((_B)object).B = string2;
            ((_B)object).A = arrayList;
        }
        return object;
    }

    private static void validateInstanceSSLSettings(SSLClientSocketSettings sSLClientSocketSettings) throws IOException {
        if (sSLClientSocketSettings.getTrustStoreFile() != null && !sSLClientSocketSettings.getTrustStoreFile().canRead()) {
            throw new FileNotFoundException("Cannot find trust store at \"" + sSLClientSocketSettings.getTrustStoreFile().getCanonicalPath() + "\"");
        }
    }

    private static void plugConverterInstance(ConverterInstance converterInstance, ConverterPoolGroup converterPoolGroup) {
        converterInstance.setPoolGroup(converterPoolGroup);
        converterInstance.dump();
        converterInstance.initialize();
        converterPoolGroup.addInstance(converterInstance);
        if (K.get() == null) {
            K.set(converterInstance.getEngineDetails());
        }
    }

    private static String getConverterClassFor(String string) {
        String string2 = StringUtilities.isEmpty(string) ? null : (V.equals(string.toLowerCase()) ? "com.docmosis.converter.openoffice.LocalOpenOfficeConverter" : (X.equals(string.toLowerCase()) ? "com.docmosis.document.converter.RemoteConverterGateway" : string));
        return string2;
    }

    private String getAttribute(Node node, String string) {
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 != null) {
            return node2.getNodeValue();
        }
        return null;
    }

    private Integer getIntAttribute(Node node, String string) {
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 != null) {
            try {
                return Integer.decode(node2.getNodeValue());
            }
            catch (NumberFormatException numberFormatException) {
                I.warn("Invalid configured value for port (" + node2.getNodeValue() + ") in config:" + this.O);
            }
        }
        return null;
    }

    private static class _C
    implements Runnable {
        private static final long D = DMProperties.getInt("docmosis.converter.pool.remote.management.sweepInterval");
        private final Map C;
        private final Thread B;
        private boolean A = true;

        public _C(Map map) {
            this.C = map;
            this.B = new Thread((Runnable)this, "DocmosisConverterPoolKeepRemoteAlive");
            this.B.setDaemon(true);
            this.B.start();
            if (I.isInfoEnabled()) {
                I.info("Remote converter pool management enabled");
            }
        }

        public void A() {
            this.A = false;
            this.B.interrupt();
        }

        @Override
        public void run() {
            long l;
            long l2 = l = D > 5000L ? D : 5000L;
            while (this.A) {
                try {
                    Thread.sleep(l);
                    for (String string : this.C.keySet()) {
                        ConverterPoolGroup converterPoolGroup = (ConverterPoolGroup)this.C.get(string);
                        converterPoolGroup.kickTheTyres();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            I.debug("Shutting down");
        }
    }

    private static class _A
    implements Runnable {
        private static final long D = DMProperties.getInt("docmosis.converter.pool.sweepInterval");
        private final Map C;
        private final Thread B;
        private boolean A = true;

        public _A(Map map) {
            this.C = map;
            this.B = new Thread((Runnable)this, "DocmosisConverterPoolManager");
            this.B.setDaemon(true);
            this.B.start();
        }

        public void A() {
            this.A = false;
            this.B.interrupt();
        }

        @Override
        public void run() {
            long l;
            long l2 = l = D > 5000L ? D : 5000L;
            while (this.A) {
                try {
                    Thread.sleep(l);
                    for (String string : this.C.keySet()) {
                        ConverterPoolGroup converterPoolGroup = (ConverterPoolGroup)this.C.get(string);
                        converterPoolGroup.repairBrokenInstances();
                    }
                }
                catch (RuntimeException runtimeException) {
                    I.warn("Unexpected error when repairing instances", runtimeException);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            I.debug("Shutting down");
        }
    }

    private static class _B {
        private String B;
        private ArrayList A;

        private _B() {
        }
    }
}

