/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.document.converter.pool;

import com.docmosis.document.converter.A;
import com.docmosis.document.converter.ConversionException;
import com.docmosis.document.converter.ConversionInstruction;
import com.docmosis.document.converter.ConversionSettings;
import com.docmosis.document.converter.DocumentFormatConverter;
import com.docmosis.document.converter.pool.ConverterPoolGroup;
import com.docmosis.document.converter.pool.ConverterPoolProperties;
import com.docmosis.template.BasicDocument;
import com.docmosis.template.population.PopulatedFilesCollection;
import com.docmosis.util.DMProperties;
import com.docmosis.util.EngineDetails;
import com.docmosis.util.ExceptionUtils;
import com.docmosis.util.I;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import com.docmosis.util.ssl.SSLClientSocketSettings;
import java.io.File;
import java.net.ConnectException;
import java.net.SocketTimeoutException;

class ConverterInstance
implements DocumentFormatConverter {
    private static final Logger x = LogManager.getLogger(ConverterInstance.class);
    private static final String q = "docmosis.openoffice.location";
    private static final String u = "docmosis.openoffice.useCustomLoader";
    private final String m = DMProperties.getString("docmosis.openoffice.location");
    private final boolean o = A.C;
    private ConverterPoolProperties t;
    private DocumentFormatConverter p;
    private boolean n;
    private boolean l;
    private Throwable v;
    private ConverterPoolGroup r;
    private boolean s;
    private boolean w = true;

    public ConverterInstance(ConverterPoolProperties converterPoolProperties, boolean bl) {
        this.t = converterPoolProperties;
        this.s = bl;
    }

    public void initialize() {
        boolean bl = this.l;
        this.l = false;
        this.v = null;
        this.n = false;
        Integer n = null;
        String string = null;
        SSLClientSocketSettings sSLClientSocketSettings = null;
        String string2 = null;
        boolean bl2 = false;
        try {
            n = this.t.getPort();
            string = this.t.getHostname();
            if (this.t.getSslSettings() != null && !this.t.getSslSettings().isNonSecure()) {
                sSLClientSocketSettings = this.t.getSslSettings();
            }
            string2 = this.t.getPath();
            boolean bl3 = bl2 = string == null || n == null;
            if (bl2) {
                if (this.m == null) {
                    throw new IllegalStateException("Location of Open Office is not set.  Make sure the property docmosis.openoffice.location is set correctly.");
                }
                String[] stringArray = DMProperties.getStringArray("docmosis.openoffice.location.binary.searchpath", ";");
                File file = null;
                for (int i = 0; i < stringArray.length && !(file = new File(this.m + "/" + stringArray[i] + "/" + string2)).canRead(); ++i) {
                }
                if (file == null || !file.canRead()) {
                    throw new IllegalArgumentException("Could not find the executable \"" + string2 + "\" in the searchpath \"" + DMProperties.getString("docmosis.openoffice.location.binary.searchpath") + "\" under \"" + this.m + "\"");
                }
                if (x.isDebugEnabled()) {
                    x.debug("Executable:" + file.getPath());
                }
                this.p = A.A(this.t.getOfficeConverterClass(), file, this.w && this.s);
                this.w = false;
                x.debug("Converter created:" + this.t.getOfficeConverterClass() + " using path:" + file.getPath());
            } else {
                this.p = A.A(this.t.getOfficeConverterClass(), string, n, sSLClientSocketSettings);
                if (x.isDebugEnabled()) {
                    x.debug("Converter created:" + this.t.getOfficeConverterClass() + " using host:port:sslProtocl = " + this.t.getHostname() + ":" + this.t.getPort() + ":" + this.t.getSslSettings());
                }
            }
            this.n = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            x.error("Converter class not specified or not valid \"" + this.t.getOfficeConverterClass() + "\".  Make sure your convert pool configuration corrctly specifies the converter class");
            this.l = true;
            this.v = classNotFoundException;
        }
        catch (Exception exception) {
            if (exception.getCause() instanceof SocketTimeoutException || exception.getCause() instanceof ConnectException) {
                if (!bl) {
                    if (bl2) {
                        x.warn("Unable to instantiate class:" + this.t.getOfficeConverterClass() + ":" + exception.getCause().getMessage() + " using path " + string2 + " and ClassLoader " + this.getClass().getClassLoader(), exception.getMessage() == null ? exception : null);
                    } else {
                        x.warn("Unable to instantiate class:" + this.t.getOfficeConverterClass() + ":" + exception.getCause().getMessage() + " connecting to " + string + ":" + n + ":" + sSLClientSocketSettings, exception.getMessage() == null ? exception : null);
                    }
                }
            } else if (!bl) {
                String string3 = ExceptionUtils.getUnqualifiedExceptionClassName(exception) + ":" + (exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage());
                if (bl2) {
                    x.error(string3 + " using path " + string2 + " and ClassLoader " + this.getClass().getClassLoader() + " check other reported errors (above), check your converterPoolConfig.xml file and" + " consider setting \"" + u + "=" + !this.o + "\" in your docmosis.properties file." + " Consider also setting \"" + "docmosis.openoffice.libraries.loadIntoSystemCL" + "=true\" in your docmosis.properties file" + " but make sure \"" + u + "=false\" if you do so.", exception.getMessage() == null ? exception : null);
                } else {
                    x.error(string3 + " connecting to " + string + ":" + n + ":" + sSLClientSocketSettings, exception);
                }
            }
            this.l = true;
            this.v = exception;
        }
        catch (LinkageError linkageError) {
            this.l = true;
            this.v = linkageError;
            x.error("Unable to instantiate class:" + this.t.getOfficeConverterClass() + " check other reported errors (above), check your converterPoolConfig.xml file and" + " consider setting \"" + u + "=" + !this.o + "\" in your docmosis.properties file." + " Consider also setting \"" + "docmosis.openoffice.libraries.loadIntoSystemCL" + "=true\" in your docmosis.properties file" + " but make sure \"" + u + "=false\" if you do so.", linkageError);
        }
    }

    @Override
    public BasicDocument convert(PopulatedFilesCollection populatedFilesCollection, ConversionInstruction conversionInstruction, ConversionSettings conversionSettings) throws ConversionException {
        if (this.p == null) {
            throw new ConversionException("this converter is not ready!" + this.t);
        }
        return this.p.convert(populatedFilesCollection, conversionInstruction, conversionSettings);
    }

    @Override
    public void shutdown() {
        if (this.p != null) {
            try {
                this.p.shutdown();
            }
            catch (RuntimeException runtimeException) {
                x.warn("Error shutting down converter", runtimeException);
            }
            this.p = null;
        }
    }

    ConverterPoolProperties getProperties() {
        return this.t;
    }

    public void dump() {
    }

    public boolean isFailedToConnect() {
        return this.l;
    }

    public Throwable getFailureThrowable() {
        return this.v;
    }

    public boolean isAvailable() {
        return this.n;
    }

    public ConverterPoolGroup getPoolGroup() {
        return this.r;
    }

    public void setPoolGroup(ConverterPoolGroup converterPoolGroup) {
        this.r = converterPoolGroup;
    }

    @Override
    public void setModuleTiming(I i) {
        if (this.p != null) {
            this.p.setModuleTiming(i);
        }
    }

    @Override
    public boolean repair() {
        if (this.p != null) {
            return this.p.repair();
        }
        this.initialize();
        return false;
    }

    @Override
    public boolean isLocal() {
        return this.p != null && this.p.isLocal();
    }

    @Override
    public String getDescription() {
        return this.p == null ? null : this.p.getDescription();
    }

    @Override
    public void kickTheTyres() throws ConversionException {
        if (this.p != null) {
            this.p.kickTheTyres();
        }
    }

    @Override
    public EngineDetails getEngineDetails() {
        return this.p == null ? null : this.p.getEngineDetails();
    }
}

