/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.document.converter;

import com.docmosis.document.converter.ConversionException;
import com.docmosis.document.converter.ConversionInstruction;
import com.docmosis.document.converter.ConversionServiceFailureException;
import com.docmosis.document.converter.ConversionSettings;
import com.docmosis.document.converter.DocumentFormatConverter;
import com.docmosis.document.converter.RemoteConvertRequest;
import com.docmosis.document.converter.RemoteConvertResponse;
import com.docmosis.document.converter.RemoteConverterHandshakeRequest;
import com.docmosis.document.converter.RemoteConverterHandshakeResponse;
import com.docmosis.template.BasicDocument;
import com.docmosis.template.population.PopulatedFilesCollection;
import com.docmosis.util.DMProperties;
import com.docmosis.util.EngineDetails;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.I;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import com.docmosis.util.ssl.SSLClientSocketSettings;
import com.docmosis.util.ssl.SSLClientSocketWrapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;

public class RemoteConverterGateway
implements DocumentFormatConverter {
    private static final Logger E = LogManager.getLogger(RemoteConverterGateway.class);
    private static final int L = DMProperties.getInt("docmosis.converter.remote.socket.timeout");
    private static final int K = DMProperties.getInt("docmosis.converter.pool.remote.management.triggerAge", 30000);
    private static final int B = DMProperties.getInt("docmosis.converter.pool.remote.management.lifeSpan", 240000);
    private static final boolean C = DMProperties.getBoolean("docmosis.converter.pool.networkDiag.logging.enabled", false);
    private String M;
    private int D;
    private _A J;
    private ObjectOutputStream F;
    private ObjectInputStream H;
    private I I;
    private SSLClientSocketSettings A;
    private EngineDetails G;

    public RemoteConverterGateway(String string, int n) throws IOException {
        this.M = string;
        this.D = n;
        this.establishConnection(false);
    }

    public RemoteConverterGateway(String string, int n, SSLClientSocketSettings sSLClientSocketSettings) throws IOException {
        this.M = string;
        this.D = n;
        this.A = sSLClientSocketSettings;
        this.establishConnection(false);
    }

    @Override
    public synchronized BasicDocument convert(PopulatedFilesCollection populatedFilesCollection, ConversionInstruction conversionInstruction, ConversionSettings conversionSettings) throws ConversionException {
        return this.convert(new RemoteConvertRequest(populatedFilesCollection, conversionInstruction, conversionSettings));
    }

    private synchronized BasicDocument convert(RemoteConvertRequest remoteConvertRequest) throws ConversionServiceFailureException {
        if (C && E.isInfoEnabled()) {
            if (remoteConvertRequest.isTyreKick()) {
                E.info("Sending keep alive to " + this.M + ":" + this.D);
            } else {
                E.info("About to convert a document.");
            }
        }
        try {
            if (this.J == null) {
                this.establishConnection(false);
            }
            this.F = new ObjectOutputStream(this.J.C.getOutputStream());
            if (!remoteConvertRequest.isTyreKick() && !this.J.D) {
                remoteConvertRequest.getDocuments().setStreamingFiles(true);
            }
            this.F.writeObject(remoteConvertRequest);
            if (C && E.isInfoEnabled() && !remoteConvertRequest.isTyreKick()) {
                E.info("About to read the converted document");
            }
            this.H = new ObjectInputStream(this.J.C.getInputStream());
            if (C && E.isInfoEnabled() && !remoteConvertRequest.isTyreKick()) {
                E.info("Stream obtained");
            }
            RemoteConvertResponse remoteConvertResponse = (RemoteConvertResponse)this.H.readObject();
            if (C && E.isInfoEnabled() && !remoteConvertRequest.isTyreKick()) {
                E.info("ReadObject complete");
            }
            this.J.A = System.currentTimeMillis();
            if (remoteConvertResponse.isTyreKick()) {
                if (C && E.isInfoEnabled()) {
                    E.info("Got response to hello.");
                }
                BasicDocument basicDocument = null;
                return basicDocument;
            }
            BasicDocument basicDocument = remoteConvertResponse.getDocumentResult();
            if (C && E.isInfoEnabled()) {
                E.info("Finished converting the document.");
                E.info("Wait time at remote converter:" + basicDocument.getRemoteWaitTime() + " ms");
            }
            BasicDocument basicDocument2 = basicDocument;
            return basicDocument2;
        }
        catch (IOException iOException) {
            throw new ConversionServiceFailureException("Unable to convert document on " + this.M + ":" + this.D, iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConversionServiceFailureException("Unable to convert document on " + this.M + ":" + this.D, classNotFoundException);
        }
        finally {
            if (C && E.isInfoEnabled() && !remoteConvertRequest.isTyreKick()) {
                E.info("Conversion complete");
            }
        }
    }

    @Override
    public void shutdown() {
        E.debug("Shutting down");
        this.closeInputStream();
        this.closeOutputStream();
        this.closeSocket();
    }

    private void closeInputStream() {
        try {
            if (this.H != null) {
                this.H.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.H = null;
    }

    private void closeOutputStream() {
        try {
            if (this.F != null) {
                this.F.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.F = null;
    }

    private void closeSocket() {
        try {
            if (this.J != null) {
                this.J.A();
            }
        }
        catch (IOException iOException) {
            E.error(iOException);
            iOException.printStackTrace();
        }
        this.J = null;
    }

    private void establishConnection(boolean bl) throws IOException {
        this.closeSocket();
        Socket socket = new Socket();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.M, this.D);
        try {
            socket.connect(inetSocketAddress, L);
            if (this.A != null) {
                socket = SSLClientSocketWrapper.wrap(socket, this.A);
            }
            boolean bl2 = this.handShake(socket);
            E.info("Connected to " + (this.A == null ? "plain" : "SSL") + " endpoint [" + this.M + ":" + this.D + "]");
            long l = System.currentTimeMillis();
            this.J = new _A(socket, bl2, l);
        }
        catch (IOException iOException) {
            if (bl) {
                E.warn("Unable to connect to remote converter: (" + this.M + ":" + this.D + ")");
            }
            throw iOException;
        }
        catch (GeneralSecurityException generalSecurityException) {
            if (bl) {
                E.warn("Unable to create secure connection to remote converter: (" + this.M + ":" + this.D + ")");
            }
            throw new IOException("Unable to create secure connection:" + generalSecurityException.getMessage());
        }
    }

    private boolean handShake(Socket socket) throws IOException {
        if (C && E.isInfoEnabled()) {
            E.info("Connected to remote:" + socket.getRemoteSocketAddress());
        }
        File file = FileUtilities.createTempFile("dmHS", String.valueOf(System.currentTimeMillis()));
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write("DM FLAG FILE\nThis is some data with random elements to facilitate converter locality testing\n".getBytes());
            fileOutputStream.write(String.valueOf(System.currentTimeMillis()).getBytes());
            fileOutputStream.write(String.valueOf(Math.random() * 100000.0).getBytes());
            fileOutputStream.flush();
            fileOutputStream.close();
            fileOutputStream = null;
            RemoteConverterHandshakeRequest remoteConverterHandshakeRequest = new RemoteConverterHandshakeRequest(file);
            objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
            objectOutputStream.writeObject(remoteConverterHandshakeRequest);
            objectInputStream = new ObjectInputStream(socket.getInputStream());
            try {
                boolean bl;
                RemoteConverterHandshakeResponse remoteConverterHandshakeResponse = (RemoteConverterHandshakeResponse)objectInputStream.readObject();
                if (remoteConverterHandshakeResponse.warnings != null) {
                    for (bl = false; bl < remoteConverterHandshakeResponse.warnings.length; bl += 1) {
                        E.warn(remoteConverterHandshakeResponse.warnings[bl]);
                    }
                }
                this.G = remoteConverterHandshakeResponse.converterEngine;
                bl = remoteConverterHandshakeResponse.isLocalToSameHost;
                return bl;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("Class versioning error attempting to handshake with remote converter " + classNotFoundException.getClass() + ":" + classNotFoundException.getMessage());
            }
        }
        finally {
            objectOutputStream = null;
            objectInputStream = null;
            FileUtilities.close(fileOutputStream);
            FileUtilities.delete(file);
        }
    }

    public I getModuleTiming() {
        return this.I;
    }

    @Override
    public void setModuleTiming(I i) {
        this.I = i;
    }

    @Override
    public boolean repair() {
        try {
            if (E.isDebugEnabled()) {
                E.debug("Attempting to repair remote converter (" + this.M + ":" + this.D + ")");
            }
            this.establishConnection(false);
            if (E.isInfoEnabled()) {
                E.info("Converter now online (" + this.M + ":" + this.D + ")");
            }
            return true;
        }
        catch (IOException iOException) {
            if (E.isDebugEnabled()) {
                E.debug("Attempt to repair remote converter (" + this.M + ":" + this.D + ") failed: " + iOException.getMessage());
            }
            return false;
        }
    }

    @Override
    public void kickTheTyres() throws ConversionException {
        long l = System.currentTimeMillis();
        if (this.J == null) {
            return;
        }
        if (l - this.J.B > (long)B) {
            try {
                if (C && E.isInfoEnabled()) {
                    E.info("Connection passed life-span, re-establishing to " + this.M + ":" + this.D);
                }
                this.establishConnection(false);
            }
            catch (IOException iOException) {
                throw new ConversionServiceFailureException("Unable to establish connection to " + this.M + ":" + this.D, iOException);
            }
        } else if (l - this.J.A > (long)K) {
            this.convert(new RemoteConvertRequest(true));
        }
    }

    @Override
    public boolean isLocal() {
        return this.J != null && this.J.D;
    }

    @Override
    public String getDescription() {
        return "remote " + this.M + ":" + this.D + "";
    }

    @Override
    public EngineDetails getEngineDetails() {
        return this.G;
    }

    private static class _A {
        private final Socket C;
        private final boolean D;
        private final long B;
        private long A;

        public _A(Socket socket, boolean bl, long l) {
            this.C = socket;
            this.D = bl;
            this.B = l;
            this.A = l;
        }

        public void A() throws IOException {
            this.C.close();
        }
    }
}

