/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.document.converter;

import com.docmosis.Version;
import com.docmosis.document.converter.A;
import com.docmosis.document.converter.ChecksummedFile;
import com.docmosis.document.converter.ConversionException;
import com.docmosis.document.converter.ConversionInstruction;
import com.docmosis.document.converter.ConversionServiceFailureException;
import com.docmosis.document.converter.ConversionSettings;
import com.docmosis.document.converter.DocumentFormatConverter;
import com.docmosis.document.converter.RemoteConvertRequest;
import com.docmosis.document.converter.RemoteConvertResponse;
import com.docmosis.document.converter.RemoteConverterHandshakeRequest;
import com.docmosis.document.converter.RemoteConverterHandshakeResponse;
import com.docmosis.template.BasicDocument;
import com.docmosis.template.population.PopulatedFilesCollection;
import com.docmosis.util.DMProperties;
import com.docmosis.util.EngineDetails;
import com.docmosis.util.ExceptionUtils;
import com.docmosis.util.PlatformUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import com.docmosis.util.ssl.SSLServerSocketWrapper;
import com.docmosis.util.ssl.SSLSocketSettings;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.lang.reflect.InvocationTargetException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLException;

public class RemoteConverter
implements Runnable {
    private static final Logger E = LogManager.getLogger(RemoteConverter.class);
    private static final String H = "usage: java " + RemoteConverter.class.getName() + "\n" + "usage: java " + RemoteConverter.class.getName() + " <-h>" + "\n" + "usage: java " + RemoteConverter.class.getName() + " <port> [ssl=alg] " + "\n" + "usage: java " + RemoteConverter.class.getName() + " <exe> <converterClass> <port> [ssl=alg]" + "\n" + "  -h                                   : print this usage" + "\n" + "  <no args>                            : run the converter on port 2100" + "\n" + "  port                                 : run the converter on the given port" + "\n" + "  port ssl=protocol                    : run the converter on the given port and enable SSL with specified protocol" + "\n" + "  exe converterClass port              : set the executable, converter class and port to use" + "\n" + "  exe converterClass port ssl=protocol : set the executable, converter class and port to use and enable SSL with specified protocol" + "\n";
    private static final String M = PlatformUtilities.getExeName("soffice");
    private static final int G = 2100;
    private static final String K = "com.docmosis.converter.openoffice.LocalOpenOfficeConverter";
    private static final String D = null;
    private DocumentFormatConverter C;
    private int B;
    private ServerSocket N;
    private SSLSocketSettings A;
    private boolean F;
    private Thread J;
    private String L;
    private File O;
    private EngineDetails I;

    public RemoteConverter(int n) throws IllegalArgumentException, SecurityException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
        this(K, RemoteConverter.findExe(M), n, null);
    }

    public RemoteConverter(String string, File file, int n, SSLSocketSettings sSLSocketSettings) throws IllegalArgumentException, SecurityException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
        this.B = n;
        this.O = file;
        this.L = string;
        this.A = sSLSocketSettings;
        Runtime.getRuntime().addShutdownHook(new Thread("Shutdown"){

            @Override
            public void run() {
                E.info("Shutting down converter [shutdown hook]");
                RemoteConverter.this.shutdown();
            }
        });
        this.F = true;
        this.initialize();
    }

    protected void initialize() throws IllegalArgumentException, SecurityException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
        if (this.N == null) {
            this.openSocket();
        }
        this.initConverter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this;
        synchronized (object) {
            this.F = true;
            this.J = Thread.currentThread();
        }
        object = null;
        while (this.F) {
            try {
                E.trace("Waiting for a connection...");
                object = this.N.accept();
                E.debug("Accepted a connection.");
                this.doProcess((Socket)object);
            }
            catch (IOException iOException) {}
        }
        RemoteConverter remoteConverter = this;
        synchronized (remoteConverter) {
            this.F = false;
            this.J = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean handShake(Socket socket, EngineDetails engineDetails) throws IOException {
        ObjectInputStream objectInputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            Object object;
            String[] stringArray;
            boolean bl;
            objectInputStream = new ObjectInputStream(socket.getInputStream());
            RemoteConverterHandshakeRequest remoteConverterHandshakeRequest = null;
            try {
                remoteConverterHandshakeRequest = (RemoteConverterHandshakeRequest)objectInputStream.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("Class versioning error attempting to handshake with remote converter gateway " + classNotFoundException.getClass() + ":" + classNotFoundException.getMessage());
            }
            ChecksummedFile checksummedFile = remoteConverterHandshakeRequest.file;
            boolean bl2 = bl = checksummedFile.flagFile.canRead() && new ChecksummedFile(checksummedFile.flagFile).equals(checksummedFile);
            if (E.isDebugEnabled()) {
                if (bl) {
                    E.debug("Connection from LOCAL converter");
                } else {
                    stringArray = "";
                    try {
                        stringArray = " (" + socket.getInetAddress().toString() + ")";
                    }
                    catch (Exception exception) {
                        E.warn("Could not get client IP addr", exception);
                    }
                    E.debug("Connection from REMOTE converter" + (String)stringArray);
                }
            }
            stringArray = null;
            if (!Version.getVersion().equals(remoteConverterHandshakeRequest.docmosisVersion)) {
                object = "Warning: version mismatch.  Docmosis core [" + remoteConverterHandshakeRequest.docmosisVersion + "] whereas converter [" + Version.getVersion() + "].  Not a good configuration.";
                stringArray = new String[]{object};
                E.warn(object);
            }
            object = new RemoteConverterHandshakeResponse(stringArray, bl, engineDetails);
            objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
            objectOutputStream.writeObject(object);
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            objectInputStream = null;
            objectOutputStream = null;
        }
    }

    private void doProcess(final Socket socket) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                Object object;
                ObjectInputStream objectInputStream = null;
                ObjectOutputStream objectOutputStream = null;
                try {
                    BasicDocument basicDocument;
                    boolean bl = RemoteConverter.handShake(socket, RemoteConverter.this.I);
                    E.debug("Handshake Completed");
                    while (RemoteConverter.this.F) {
                        block120: {
                            block118: {
                                block119: {
                                    block116: {
                                        block117: {
                                            objectInputStream = new ObjectInputStream(socket.getInputStream());
                                            objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
                                            object = (RemoteConvertRequest)objectInputStream.readObject();
                                            basicDocument = null;
                                            if (!((RemoteConvertRequest)object).isTyreKick()) break block116;
                                            if (E.isDebugEnabled()) {
                                                E.debug("responding to hello");
                                            }
                                            objectOutputStream.writeObject(new RemoteConvertResponse(true));
                                            if (E.isDebugEnabled()) {
                                                E.debug("Convert complete");
                                            }
                                            if (bl) break block117;
                                            PopulatedFilesCollection.cleanup(((RemoteConvertRequest)object).getDocuments());
                                        }
                                        BasicDocument.cleanup(basicDocument, true);
                                        if (!E.isDebugEnabled()) continue;
                                        E.debug("Convert cleanup done");
                                        continue;
                                    }
                                    try {
                                        RemoteConverter.this.initConverter();
                                    }
                                    catch (Exception exception) {
                                        throw new ConversionServiceFailureException(exception);
                                    }
                                    if (RemoteConverter.this.F) break block118;
                                    if (E.isDebugEnabled()) {
                                        E.debug("Convert complete");
                                    }
                                    if (bl) break block119;
                                    PopulatedFilesCollection.cleanup(((RemoteConvertRequest)object).getDocuments());
                                }
                                BasicDocument.cleanup(basicDocument, true);
                                if (!E.isDebugEnabled()) return;
                                E.debug("Convert cleanup done");
                                return;
                            }
                            PopulatedFilesCollection populatedFilesCollection = ((RemoteConvertRequest)object).getDocuments();
                            ConversionInstruction conversionInstruction = ((RemoteConvertRequest)object).getInstruction();
                            ConversionSettings conversionSettings = ((RemoteConvertRequest)object).getSettings();
                            long l = System.currentTimeMillis();
                            DocumentFormatConverter documentFormatConverter = RemoteConverter.this.C;
                            synchronized (documentFormatConverter) {
                                long l2 = System.currentTimeMillis() - l;
                                if (E.isDebugEnabled()) {
                                    E.debug("wait for converter:" + l2 + " ms");
                                }
                                basicDocument = RemoteConverter.this.C.convert(populatedFilesCollection, conversionInstruction, conversionSettings);
                                basicDocument.setRemoteWaitTime(l2);
                            }
                            objectOutputStream.writeObject(new RemoteConvertResponse(basicDocument));
                            if (E.isDebugEnabled()) {
                                E.debug("Convert complete");
                            }
                            if (bl) break block120;
                            PopulatedFilesCollection.cleanup(((RemoteConvertRequest)object).getDocuments());
                        }
                        BasicDocument.cleanup(basicDocument, true);
                        if (!E.isDebugEnabled()) continue;
                        E.debug("Convert cleanup done");
                    }
                    return;
                    catch (Throwable throwable) {
                        if (E.isDebugEnabled()) {
                            E.debug("Convert complete");
                        }
                        if (!bl) {
                            PopulatedFilesCollection.cleanup(((RemoteConvertRequest)object).getDocuments());
                        }
                        BasicDocument.cleanup(basicDocument, true);
                        if (!E.isDebugEnabled()) throw throwable;
                        E.debug("Convert cleanup done");
                        throw throwable;
                    }
                }
                catch (EOFException eOFException) {
                    E.info("No more data to read.  Closing client socket.");
                    return;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    E.error("Unexpected error in doProcess", classNotFoundException);
                    return;
                }
                catch (SocketException socketException) {
                    E.warn("Socket Communication lost: " + socketException.getMessage());
                    return;
                }
                catch (StreamCorruptedException streamCorruptedException) {
                    object = socket.getInetAddress() + ":" + socket.getPort();
                    E.error("Bad handshake from [remote caller " + (String)object + "]", streamCorruptedException);
                    return;
                }
                catch (SSLException sSLException) {
                    object = socket.getInetAddress() + ":" + socket.getPort();
                    E.error("SSL error [remote caller " + (String)object + "]:" + sSLException.getMessage() + ".  Ignoring connection.");
                    return;
                }
                catch (IOException iOException) {
                    object = socket.getInetAddress() + ":" + socket.getPort();
                    E.error("Unexpected error in doProcess [remote caller " + (String)object + "]", iOException);
                    return;
                }
                catch (ConversionServiceFailureException conversionServiceFailureException) {
                    if (conversionServiceFailureException.isDueToServiceFailure()) {
                        try {
                            object = conversionServiceFailureException.getCause() == null ? conversionServiceFailureException : ExceptionUtils.getRootCause(conversionServiceFailureException);
                            E.info("underlying service failure [" + object.getClass().getName() + ":" + conversionServiceFailureException.getMessage() + "].  Restarting.");
                            RemoteConverter.this.shutdownConverter();
                            RemoteConverter.this.initConverter();
                            return;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            E.error("Error initializing converter", illegalArgumentException);
                            return;
                        }
                        catch (SecurityException securityException) {
                            E.error("Error initializing converter", securityException);
                            return;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            E.error("Error initializing converter.  Please check your setting for \"docmosis.openoffice.location\" (currently \"" + DMProperties.getString("docmosis.openoffice.location") + "\")", classNotFoundException);
                            return;
                        }
                        catch (InstantiationException instantiationException) {
                            E.error("Error initializing converter", instantiationException);
                            return;
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            E.error("Error initializing converter", illegalAccessException);
                            return;
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            E.error("Error initializing converter.  Please check your setting for \"docmosis.openoffice.location\" (currently \"" + DMProperties.getString("docmosis.openoffice.location") + "\")", invocationTargetException);
                            return;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            E.error("Error initializing converter", noSuchMethodException);
                            return;
                        }
                        catch (IOException iOException) {
                            E.error("Error initializing converter", iOException);
                        }
                        return;
                    } else {
                        E.error("Unexpected error in doProcess", conversionServiceFailureException);
                    }
                    return;
                }
                catch (ConversionException conversionException) {
                    E.error("Unexpected error in doProcess", conversionException);
                    return;
                }
                finally {
                    try {
                        if (objectOutputStream != null) {
                            objectOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    objectOutputStream = null;
                    try {
                        if (objectInputStream != null) {
                            objectInputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    objectInputStream = null;
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }, "DMClientAgent").start();
    }

    public synchronized void shutdown() {
        E.info("Shutting down");
        this.F = false;
        if (this.J != null) {
            this.J.interrupt();
            this.J = null;
        }
        if (this.N != null) {
            try {
                this.N.close();
            }
            catch (IOException iOException) {
                E.error("An error occurred closing the server socket.", iOException);
                iOException.printStackTrace();
            }
        }
        this.shutdownConverter();
    }

    private void openSocket() throws IOException {
        if (this.N != null) {
            this.N.close();
        }
        this.N = RemoteConverter.createSocket(this.B, this.A);
    }

    private static ServerSocket createSocket(int n, SSLSocketSettings sSLSocketSettings) throws IOException {
        ServerSocket serverSocket;
        if (sSLSocketSettings == null) {
            E.info("starting socket:" + n);
            serverSocket = new ServerSocket(n);
        } else {
            E.info("starting ssl socket:" + n);
            try {
                serverSocket = SSLServerSocketWrapper.create(sSLSocketSettings);
            }
            catch (GeneralSecurityException generalSecurityException) {
                E.error("Unable to create encrypted server socket", generalSecurityException);
                throw new IOException("Unable to create encrypted server socket:" + generalSecurityException.getMessage());
            }
        }
        return serverSocket;
    }

    private synchronized void shutdownConverter() {
        E.info("Shutdown initiated");
        if (this.C != null) {
            try {
                this.C.shutdown();
            }
            catch (RuntimeException runtimeException) {
                E.warn("Error shutting down converter", runtimeException);
            }
            this.C = null;
        }
    }

    private synchronized void initConverter() throws IllegalArgumentException, SecurityException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
        if (!this.F) {
            return;
        }
        if (this.C == null) {
            this.C = com.docmosis.document.converter.A.A(this.L, this.O, Boolean.FALSE);
            E.info("Converter init");
            EngineDetails engineDetails = this.C.getEngineDetails();
            this.I = null;
            if (engineDetails != null) {
                this.I = new EngineDetails(engineDetails.getEngineVersion(), true);
            }
        }
    }

    private static File findExe(String string) throws IllegalArgumentException {
        String string2 = "docmosis.openoffice.location";
        String string3 = DMProperties.getString("docmosis.openoffice.location");
        if (string3 == null) {
            throw new IllegalArgumentException("Could not find property:\"docmosis.openoffice.location\"");
        }
        if (!new File(string3).exists()) {
            throw new IllegalArgumentException("Could not find Open Office.  Property:\"docmosis.openoffice.location\" set incorrectly?  value=" + string3);
        }
        String[] stringArray = DMProperties.getStringArray("docmosis.openoffice.location.binary.searchpath", ";");
        File file = null;
        for (int i = 0; i < stringArray.length && !(file = new File(string3 + "/" + stringArray[i] + "/" + string)).canRead(); ++i) {
        }
        if (file == null || !file.canRead()) {
            throw new IllegalArgumentException("Could not find the executable \"" + string + "\" in the searchpath \"" + DMProperties.getString("docmosis.openoffice.location.binary.searchpath") + "\" under \"" + string3 + "\"");
        }
        return file;
    }

    public static void main(String[] stringArray) throws ClassNotFoundException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
        try {
            String string = Version.getVersion();
            if (E.isInfoEnabled()) {
                E.info("Docmosis version [" + string + "] initialising at Remote Converter");
                E.info("Please wait...");
            }
            _A _A2 = _A.B(stringArray);
            File file = RemoteConverter.findExe(_A2.B);
            if (E.isDebugEnabled()) {
                E.debug("Executable:" + file.getPath());
            }
            SSLSocketSettings sSLSocketSettings = null;
            if (_A2.C != null) {
                sSLSocketSettings = new SSLSocketSettings();
                sSLSocketSettings.setSslProtocol(_A2.C);
                sSLSocketSettings.setPort(_A2.A);
            }
            RemoteConverter remoteConverter = new RemoteConverter(_A2.D, file, _A2.A, sSLSocketSettings);
            E.info("Remote Converter listening on port " + _A2.A);
            remoteConverter.run();
        }
        catch (BindException bindException) {
            E.error("Converter terminating: " + bindException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() == null) {
                E.error("Converter terminating:", invocationTargetException);
            } else if (invocationTargetException.getCause() instanceof NoClassDefFoundError) {
                E.error("Error initializing converter.  Please check your setting for \"docmosis.openoffice.location\" (currently \"" + DMProperties.getString("docmosis.openoffice.location") + "\")", invocationTargetException.getCause());
            } else if (invocationTargetException.getCause() instanceof ConversionException) {
                E.error("Converter terminating:", invocationTargetException.getCause());
            } else {
                E.error("Converter terminating:", invocationTargetException);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            E.error(illegalArgumentException.getMessage());
        }
        catch (Exception exception) {
            E.error("Converter terminating", exception);
        }
    }

    private static class _A {
        private final String D;
        private final String B;
        private final int A;
        private final String C;

        public _A(String string, String string2, int n, String string3) {
            this.D = string2;
            this.B = string;
            this.A = n;
            this.C = string3;
        }

        private static _A B(String[] stringArray) throws IllegalArgumentException {
            if (stringArray.length == 0) {
                return new _A(M, RemoteConverter.K, 2100, D);
            }
            if (stringArray.length == 1) {
                if ("-h".equalsIgnoreCase(stringArray[0].trim())) {
                    throw new IllegalArgumentException(H);
                }
                int n = _A.A(stringArray[0]);
                return new _A(M, RemoteConverter.K, n, D);
            }
            if (stringArray.length == 2) {
                int n = _A.A(stringArray[0]);
                String string = _A.B(stringArray[1]);
                return new _A(M, RemoteConverter.K, n, string);
            }
            if (stringArray.length == 3) {
                int n = _A.A(stringArray[2]);
                return new _A(stringArray[0], stringArray[1], n, D);
            }
            if (stringArray.length == 4) {
                int n = _A.A(stringArray[2]);
                String string = _A.B(stringArray[3]);
                return new _A(stringArray[0], stringArray[1], n, string);
            }
            throw new IllegalArgumentException("Invalid parameters\n" + H);
        }

        private static int A(String string) {
            try {
                return Integer.parseInt(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Invalid port number [" + string + "]" + "\n" + H);
            }
        }

        private static String B(String string) {
            try {
                if (!string.trim().startsWith("ssl=")) {
                    throw new IllegalArgumentException("Invalid ssl spec [" + string + "]" + ".  Must be \"ssl=xxx\"\n" + H);
                }
                return string.trim().substring("ssl=".length());
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Invalid port number [" + string + "]" + "\n" + H);
            }
        }
    }
}

