/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.document.converter;

import com.docmosis.document.converter.ConversionFormat;
import com.docmosis.template.population.render.FieldRenderer;
import com.docmosis.template.population.render.RendererRegistry;
import com.docmosis.util.DMProperties;
import com.docmosis.util.StringUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ConversionInstruction
implements Serializable {
    private static final Logger F = LogManager.getLogger(ConversionInstruction.class);
    private static final long E = 12L;
    public static final int PDF_INITIAL_VIEW_DEFAULT = 0;
    public static final int PDF_INITIAL_VIEW_OUTLINE = 1;
    public static final int PDF_INITIAL_VIEW_THUMBNAIL = 2;
    public static final int PDF_RESTRICTED_PRINTING_CANNOT_BE_PRINTED = 0;
    public static final int PDF_RESTRICTED_PRINTING_LOW_RESOLUTION = 1;
    public static final int PDF_RESTRICTED_PRINTING_MAX_RESOLUTION = 2;
    public static final int PDF_RESTRICTED_CHANGES_NO_CHANGES_ALLOWED = 0;
    public static final int PDF_RESTRICTED_CHANGES_INSERT_DELETE_ROTATE_PAGES = 1;
    public static final int PDF_RESTRICTED_CHANGES_FILLING_OF_FORM_FIELDS = 2;
    public static final int PDF_RESTRICTED_CHANGES_FILLING_OF_FORM_FIELDS_AND_COMMENTING = 3;
    public static final int PDF_RESTRICTED_CHANGES_PAGE_EXTRACTION_RESTRICTED = 4;
    private boolean A;
    private ConversionFormat[] C;
    private Map L;
    private String G;
    private ConversionFormat[] H;
    private String J;
    private boolean B = true;
    private boolean I;
    private transient RendererRegistry K;
    static final String PROP_DEFAULT_PDF_IMAGE_QUALITY = "docmosis.output.pdf.image.quality";
    static final String PROP_DEFAULT_PDF_IMAGE_DPI = "docmosis.output.pdf.image.dpi";
    static final String PROP_DEFAULT_PDF_CREATE_FORM = "docmosis.output.pdf.form.enabled";
    public static final boolean DEFAULT_PDF_CREATE_FORM = DMProperties.getBoolean("docmosis.output.pdf.form.enabled", false);
    private static boolean D = false;

    private static int hashCode(Object[] objectArray) {
        int n = 31;
        if (objectArray == null) {
            return 0;
        }
        int n2 = 1;
        for (int i = 0; i < objectArray.length; ++i) {
            n2 = n * n2 + (objectArray[i] == null ? 0 : objectArray[i].hashCode());
        }
        return n2;
    }

    public ConversionInstruction() {
        this.setPdfImageCompressionQualityFromString(DMProperties.getString(PROP_DEFAULT_PDF_IMAGE_QUALITY));
        this.setPdfImageReduceResolutionFromString(DMProperties.getString(PROP_DEFAULT_PDF_IMAGE_DPI));
        this.setPdfCreateForm(DEFAULT_PDF_CREATE_FORM);
    }

    public ConversionInstruction(ConversionInstruction conversionInstruction) {
        this.A = conversionInstruction.A;
        if (conversionInstruction.C != null) {
            this.C = new ConversionFormat[conversionInstruction.C.length];
            System.arraycopy(conversionInstruction.C, 0, this.C, 0, this.C.length);
        }
        if (conversionInstruction.L != null) {
            this.L = new HashMap(conversionInstruction.L);
        }
        this.setOutputFileName(conversionInstruction.G);
        this.J = conversionInstruction.J;
        this.B = conversionInstruction.B;
        this.I = conversionInstruction.I;
        if (conversionInstruction.K != null) {
            this.K = new RendererRegistry(conversionInstruction.K);
        }
    }

    public String getOutputFileName() {
        return this.G;
    }

    public String getOutputFileNameWithFormats() {
        String string = this.G;
        if (this.producesZippedDocument()) {
            if (!string.toLowerCase().endsWith(".zip")) {
                string = string + ".zip";
            }
        } else if (this.C != null && this.C.length == 1 && !ConversionFormat.fileNameMatchesFormat(string, this.C[0])) {
            string = string + this.C[0].getExtension();
        }
        return string;
    }

    public ConversionInstruction setOutputFileName(String string) {
        this.G = string;
        ConversionFormat conversionFormat = ConversionFormat.getFormatForFileName(string);
        this.H = conversionFormat == null ? null : new ConversionFormat[]{conversionFormat};
        return this;
    }

    public boolean isCompressingSingleDocument() {
        return this.A;
    }

    public ConversionFormat[] getConversionFormats() {
        if (this.C == null || this.C.length == 0) {
            return this.H;
        }
        return this.C;
    }

    public ConversionInstruction setWordPasswordProtect(String string) {
        this.addConversionProperty(ConversionFormat.FORMAT_WORD, OfficeEngineProperties.PASSWORD, string);
        return this;
    }

    public ConversionInstruction setWordTextHighlight(Boolean bl) {
        if (bl == null) {
            for (ConversionFormat conversionFormat : ConversionFormat.getWordFormats()) {
                this.removeConversionProperty(conversionFormat, OfficeEngineProperties.WORD_TEXT_HIGHLIGHTING);
            }
            this.removeConversionProperty(ConversionFormat.FORMAT_RTF, OfficeEngineProperties.WORD_TEXT_HIGHLIGHTING);
        } else {
            for (ConversionFormat conversionFormat : ConversionFormat.getWordFormats()) {
                this.addConversionProperty(conversionFormat, OfficeEngineProperties.WORD_TEXT_HIGHLIGHTING, bl);
            }
            this.addConversionProperty(ConversionFormat.FORMAT_RTF, OfficeEngineProperties.WORD_TEXT_HIGHLIGHTING, bl);
        }
        return this;
    }

    public ConversionInstruction setPdfPasswordProtect(String string) {
        this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.ENCRYPT_FILE, string != null);
        this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.DOCUMENT_OPEN_PASSWORD, string);
        return this;
    }

    public ConversionInstruction setPdfMagnification(int n, int n2) throws IllegalArgumentException {
        this.validateParameterRange(OfficeEngineProperties.MAGNIFICATION, n, 0, 4);
        this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.MAGNIFICATION, n);
        this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.ZOOM, n2);
        return this;
    }

    public ConversionInstruction setPdfArchiveMode(boolean bl) throws IllegalArgumentException {
        this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.SELECT_PDF_VERSION, bl ? PdfVersion.PDF_A_1B.D : PdfVersion.PDF_DEFAULT.D);
        return this;
    }

    public ConversionInstruction setPdfVersion(PdfVersion pdfVersion) throws IllegalArgumentException {
        this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.SELECT_PDF_VERSION, pdfVersion.D);
        return this;
    }

    public ConversionInstruction setPdfUniversalAccessibility(boolean bl) throws IllegalArgumentException {
        this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.PDF_UA_COMPLIANCE, bl);
        return this;
    }

    public ConversionInstruction setPdfImageCompressionQuality(int n) throws IllegalArgumentException {
        this.validateParameterRange(OfficeEngineProperties.QUALITY, n, 1, 100);
        this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.QUALITY, n);
        this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.USE_LOSSLESS_COMPRESSION, false);
        return this;
    }

    public ConversionInstruction setPdfImageCompressionQualityFromString(String string) {
        if (StringUtilities.isEmpty(string) || "default".equals(string)) {
            this.removeConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.QUALITY);
            this.removeConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.USE_LOSSLESS_COMPRESSION);
        } else if ("lossless".contentEquals(string)) {
            this.setPdfLosslessConversion(true);
        } else {
            try {
                int n = Integer.parseInt(string);
                this.setPdfImageCompressionQuality(n);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("value is not valid [" + string + "]");
            }
        }
        return this;
    }

    public ConversionInstruction setPdfInitialView(int n) throws IllegalArgumentException {
        this.validateParameterRange(OfficeEngineProperties.INITIAL_VIEW, n, 0, 2);
        this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.INITIAL_VIEW, n);
        return this;
    }

    public ConversionInstruction setPdfLosslessConversion(boolean bl) {
        this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.USE_LOSSLESS_COMPRESSION, bl);
        this.removeConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.QUALITY);
        return this;
    }

    public ConversionInstruction setPdfImageReduceResolution(PDFImageReduceResolutionSetting pDFImageReduceResolutionSetting) {
        if (pDFImageReduceResolutionSetting != null) {
            pDFImageReduceResolutionSetting.applyToConversionProperty(this);
        }
        return this;
    }

    public ConversionInstruction setPdfImageReduceResolutionFromString(String string) {
        if (StringUtilities.isEmpty(string) || "default".equals(string)) {
            this.removeConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.REDUCE_IMAGE_RESOLUTION);
            this.removeConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.MAX_IMAGE_RESOLUTION);
        } else if ("disabled".contentEquals(string)) {
            this.setPdfImageReduceResolution(PDFImageReduceResolutionSetting.NONE);
        } else {
            PDFImageReduceResolutionSetting pDFImageReduceResolutionSetting;
            if ("75".equals(string)) {
                pDFImageReduceResolutionSetting = PDFImageReduceResolutionSetting.DPI_75;
            } else if ("150".equals(string)) {
                pDFImageReduceResolutionSetting = PDFImageReduceResolutionSetting.DPI_150;
            } else if ("300".equals(string)) {
                pDFImageReduceResolutionSetting = PDFImageReduceResolutionSetting.DPI_300;
            } else if ("600".equals(string)) {
                pDFImageReduceResolutionSetting = PDFImageReduceResolutionSetting.DPI_600;
            } else if ("1200".equals(string)) {
                pDFImageReduceResolutionSetting = PDFImageReduceResolutionSetting.DPI_1200;
            } else {
                throw new IllegalArgumentException("value is not valid [" + string + "]");
            }
            this.setPdfImageReduceResolution(pDFImageReduceResolutionSetting);
        }
        return this;
    }

    public ConversionInstruction setPdfEmbedStandardFonts(boolean bl) {
        this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.EMBED_STANDARD_FONTS, bl);
        return this;
    }

    public ConversionInstruction setPdfWatermark(String string) {
        this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.WATERMARK, string);
        return this;
    }

    public ConversionInstruction setPdfWatermarkColor(String string) throws IllegalArgumentException {
        if (!StringUtilities.hasValue(string)) {
            this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.WATERMARK_COLOR, null);
            return this;
        }
        if (!StringUtilities.validateHexColourFormat(string)) {
            throw new IllegalArgumentException("Invalid watermark color value, should be a valid hex colour, eg \"#FF0000\"");
        }
        try {
            int n = string.startsWith("#") ? Integer.parseInt(string.substring(1), 16) : Integer.parseInt(string.substring(2), 16);
            this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.WATERMARK_COLOR, n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Could not parse watermark color value, should be a valid hex colour, eg '#FF0000'", numberFormatException);
        }
        return this;
    }

    public ConversionInstruction setPdfWatermarkFontSize(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid watermark font size value, should be a positive number");
        }
        this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.WATERMARK_FONT_HEIGHT, n);
        return this;
    }

    public ConversionInstruction setPdfWatermarkFontName(String string) throws IllegalArgumentException {
        this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.WATERMARK_FONT_NAME, string);
        return this;
    }

    public ConversionInstruction setPdfWatermarkRotation(int n) throws IllegalArgumentException {
        this.validateParameterRange(OfficeEngineProperties.WATERMARK_ROTATE_ANGLE, n, 0, 360);
        this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.WATERMARK_ROTATE_ANGLE, n * 10);
        return this;
    }

    public ConversionInstruction setPdfOpenInFullScreen(boolean bl) {
        this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.OPEN_IN_FULL_SCREEN_MODE, bl);
        return this;
    }

    public ConversionInstruction setPdfDisplayTitle(boolean bl) {
        this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.DISPLAY_PDF_DOCUMENT_TITLE, bl);
        return this;
    }

    public ConversionInstruction setPdfHideViewerMenubar(boolean bl) {
        this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.HIDE_VIEWER_MENUBAR, bl);
        return this;
    }

    public ConversionInstruction setPdfHideViewerToolbar(boolean bl) {
        this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.HIDE_VIEWER_TOOLBAR, bl);
        return this;
    }

    public ConversionInstruction setPdfHideViewerWindowControls(boolean bl) {
        this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.HIDE_VIEWER_WINDOW_CONTROLS, bl);
        return this;
    }

    public ConversionInstruction setPdfTagged(boolean bl) {
        this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.TAGGED_PDF, bl);
        return this;
    }

    public ConversionInstruction setPdfRestrictPassword(String string) {
        this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.RESTRICT_PERMISSIONS, string != null);
        this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.PERMISSION_PASSWORD, string);
        return this;
    }

    public ConversionInstruction setPdfRestrictPrinting(int n) throws IllegalArgumentException {
        this.validateParameterRange(OfficeEngineProperties.PRINTING, n, 0, 2);
        this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.PRINTING, n);
        return this;
    }

    public ConversionInstruction setPdfRestrictEditing(int n) throws IllegalArgumentException {
        this.validateParameterRange(OfficeEngineProperties.CHANGES, n, 0, 4);
        this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.CHANGES, n);
        return this;
    }

    public ConversionInstruction setPdfRestrictCopy(boolean bl) {
        this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.ENABLE_COPYING_OF_CONTENT, !bl);
        return this;
    }

    public ConversionInstruction setPdfRestrictAllowAccessibilty(boolean bl) {
        this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.ENABLE_TEXT_ACCESS_FOR_ACCESSIBILITY_TOOLS, !bl);
        return this;
    }

    public ConversionInstruction setPdfSkipEmptyPages(boolean bl) {
        this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.SKIP_EMPTY_PAGES, bl);
        return this;
    }

    public ConversionInstruction setPdfCreateForm(boolean bl) {
        this.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.EXPORT_FORM_FIELDS, bl);
        return this;
    }

    private void validateParameterRange(String string, int n, int n2, int n3) throws IllegalArgumentException {
        if (n < n2 || n > n3) {
            throw new IllegalArgumentException("The '" + string + "' parameter must be between " + n2 + " and " + n3 + " inclusive.");
        }
    }

    private void addConversionProperty(ConversionFormat conversionFormat, String string, String string2) {
        HashMap<String, String> hashMap;
        if (this.L == null) {
            this.L = new HashMap();
        }
        if ((hashMap = (HashMap<String, String>)this.L.get(conversionFormat)) == null) {
            hashMap = new HashMap<String, String>();
        }
        hashMap.put(string, string2);
        this.L.put(conversionFormat, hashMap);
    }

    private void addConversionProperty(ConversionFormat conversionFormat, String string, int n) {
        HashMap<String, Integer> hashMap;
        if (this.L == null) {
            this.L = new HashMap();
        }
        if ((hashMap = (HashMap<String, Integer>)this.L.get(conversionFormat)) == null) {
            hashMap = new HashMap<String, Integer>();
        }
        hashMap.put(string, new Integer(n));
        this.L.put(conversionFormat, hashMap);
    }

    private void addConversionProperty(ConversionFormat conversionFormat, String string, boolean bl) {
        HashMap<String, Boolean> hashMap;
        if (this.L == null) {
            this.L = new HashMap();
        }
        if ((hashMap = (HashMap<String, Boolean>)this.L.get(conversionFormat)) == null) {
            hashMap = new HashMap<String, Boolean>();
        }
        hashMap.put(string, new Boolean(bl));
        this.L.put(conversionFormat, hashMap);
    }

    private void removeConversionProperty(ConversionFormat conversionFormat, String string) {
        Map map;
        if (this.L != null && (map = (Map)this.L.get(conversionFormat)) != null) {
            map.remove(string);
        }
    }

    public Map getConversionProperties(ConversionFormat conversionFormat) {
        if (this.L == null) {
            return null;
        }
        return (Map)this.L.get(conversionFormat);
    }

    public boolean compressSingleDocument() {
        return this.A;
    }

    public ConversionInstruction setCompressingSingleDocument(boolean bl) {
        this.A = bl;
        return this;
    }

    public ConversionInstruction setConversionFormats(ConversionFormat[] conversionFormatArray) {
        this.C = conversionFormatArray;
        return this;
    }

    public String getConverterGroupName() {
        return this.J;
    }

    public ConversionInstruction setConverterGroupName(String string) {
        this.J = string;
        return this;
    }

    public boolean cleanupDataProvider() {
        return this.B;
    }

    public ConversionInstruction setCleanupDataProvider(boolean bl) {
        this.B = bl;
        return this;
    }

    public boolean isConvertOnly() {
        return this.I;
    }

    public ConversionInstruction setConvertOnly(boolean bl) {
        this.I = bl;
        return this;
    }

    public ConversionInstruction setRenderer(String string, FieldRenderer fieldRenderer) {
        if (this.K == null) {
            this.K = new RendererRegistry();
        }
        this.K.setRendererByName(string, fieldRenderer);
        return this;
    }

    public ConversionInstruction setRenderer(Class clazz, FieldRenderer fieldRenderer) {
        if (this.K == null) {
            this.K = new RendererRegistry();
        }
        this.K.setRendererByClass(clazz, fieldRenderer);
        return this;
    }

    public RendererRegistry getRendererRegistry() {
        return this.K;
    }

    public boolean includesFormat(ConversionFormat conversionFormat) {
        ConversionFormat[] conversionFormatArray = this.getConversionFormats();
        if (conversionFormatArray != null) {
            for (int i = 0; i < conversionFormatArray.length; ++i) {
                if (!conversionFormat.equals(conversionFormatArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean producesZippedDocument() {
        return this.A || this.C != null && this.C.length > 1;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.B ? 1231 : 1237);
        n2 = 31 * n2 + (this.A ? 1231 : 1237);
        n2 = 31 * n2 + ConversionInstruction.hashCode(this.C);
        n2 = 31 * n2 + (this.I ? 1231 : 1237);
        n2 = 31 * n2 + (this.J == null ? 0 : this.J.hashCode());
        n2 = 31 * n2 + (this.L == null ? 0 : ((Object)this.L).hashCode());
        n2 = 31 * n2 + (this.G == null ? 0 : this.G.hashCode());
        n2 = 31 * n2 + ConversionInstruction.hashCode(this.H);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ConversionInstruction conversionInstruction = (ConversionInstruction)object;
        if (this.B != conversionInstruction.B) {
            return false;
        }
        if (this.A != conversionInstruction.A) {
            return false;
        }
        if (!Arrays.equals(this.C, conversionInstruction.C)) {
            return false;
        }
        if (this.I != conversionInstruction.I) {
            return false;
        }
        if (this.J == null ? conversionInstruction.J != null : !this.J.equals(conversionInstruction.J)) {
            return false;
        }
        if (this.L == null ? conversionInstruction.L != null : !((Object)this.L).equals(conversionInstruction.L)) {
            return false;
        }
        if (this.G == null ? conversionInstruction.G != null : !this.G.equals(conversionInstruction.G)) {
            return false;
        }
        return Arrays.equals(this.H, conversionInstruction.H);
    }

    static {
        if (!D) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("pdf - default image quality      :").append(DMProperties.getString(PROP_DEFAULT_PDF_IMAGE_QUALITY)).append('\n');
            stringBuilder.append("pdf - default image resample dpi :").append(DMProperties.getString(PROP_DEFAULT_PDF_IMAGE_DPI)).append('\n');
            stringBuilder.append("pdf - default create form        :").append(DEFAULT_PDF_CREATE_FORM).append('\n');
            F.info(stringBuilder.toString());
            D = true;
        }
    }

    public static class OfficeEngineProperties
    implements Serializable {
        private static final Set A = new HashSet();
        public static final String DISPLAY_PDF_DOCUMENT_TITLE = OfficeEngineProperties.register("DisplayPDFDocumentTitle");
        public static final String EMBED_STANDARD_FONTS = OfficeEngineProperties.register("EmbedStandardFonts");
        public static final String HIDE_VIEWER_MENUBAR = OfficeEngineProperties.register("HideViewerMenubar");
        public static final String HIDE_VIEWER_TOOLBAR = OfficeEngineProperties.register("HideViewerToolbar");
        public static final String HIDE_VIEWER_WINDOW_CONTROLS = OfficeEngineProperties.register("HideViewerWindowControls");
        public static final String INITIAL_VIEW = OfficeEngineProperties.register("InitialView");
        public static final String OPEN_IN_FULL_SCREEN_MODE = OfficeEngineProperties.register("OpenInFullScreenMode");
        public static final String QUALITY = OfficeEngineProperties.register("Quality");
        public static final String SELECT_PDF_VERSION = OfficeEngineProperties.register("SelectPdfVersion");
        public static final String USE_LOSSLESS_COMPRESSION = OfficeEngineProperties.register("UseLosslessCompression");
        public static final String REDUCE_IMAGE_RESOLUTION = OfficeEngineProperties.register("ReduceImageResolution");
        public static final String MAX_IMAGE_RESOLUTION = OfficeEngineProperties.register("MaxImageResolution");
        public static final String WATERMARK = OfficeEngineProperties.register("Watermark");
        public static final String WATERMARK_COLOR = OfficeEngineProperties.register("WatermarkColor");
        public static final String WATERMARK_FONT_HEIGHT = OfficeEngineProperties.register("WatermarkFontHeight");
        public static final String WATERMARK_FONT_NAME = OfficeEngineProperties.register("WatermarkFontName");
        public static final String WATERMARK_ROTATE_ANGLE = OfficeEngineProperties.register("WatermarkRotateAngle");
        public static final String MAGNIFICATION = OfficeEngineProperties.register("Magnification");
        public static final String ZOOM = OfficeEngineProperties.register("Zoom");
        public static final String ENCRYPT_FILE = OfficeEngineProperties.register("EncryptFile");
        public static final String DOCUMENT_OPEN_PASSWORD = OfficeEngineProperties.register("DocumentOpenPassword");
        public static final String PASSWORD = OfficeEngineProperties.register("Password");
        public static final String TAGGED_PDF = OfficeEngineProperties.register("UseTaggedPDF");
        public static final String RESTRICT_PERMISSIONS = OfficeEngineProperties.register("RestrictPermissions");
        public static final String PERMISSION_PASSWORD = OfficeEngineProperties.register("PermissionPassword");
        public static final String PRINTING = OfficeEngineProperties.register("Printing");
        public static final String CHANGES = OfficeEngineProperties.register("Changes");
        public static final String ENABLE_COPYING_OF_CONTENT = OfficeEngineProperties.register("EnableCopyingOfContent");
        public static final String ENABLE_TEXT_ACCESS_FOR_ACCESSIBILITY_TOOLS = OfficeEngineProperties.register("EnableTextAccessForAccessibilityTools");
        public static final String PDF_UA_COMPLIANCE = OfficeEngineProperties.register("PDFUACompliance");
        public static final String SKIP_EMPTY_PAGES = OfficeEngineProperties.register("IsSkipEmptyPages");
        public static final String EXPORT_FORM_FIELDS = OfficeEngineProperties.register("ExportFormFields");
        public static final String WORD_TEXT_HIGHLIGHTING = OfficeEngineProperties.register("msExportTextHighlighting");

        private static String register(String string) {
            if (A.contains(string)) {
                throw new IllegalStateException("Property is not unique:" + string);
            }
            A.add(string);
            return string;
        }
    }

    public static class PDFImageReduceResolutionSetting {
        public static PDFImageReduceResolutionSetting NONE = new PDFImageReduceResolutionSetting();
        public static PDFImageReduceResolutionSetting DPI_75 = new PDFImageReduceResolutionSetting(75);
        public static PDFImageReduceResolutionSetting DPI_150 = new PDFImageReduceResolutionSetting(150);
        public static PDFImageReduceResolutionSetting DPI_300 = new PDFImageReduceResolutionSetting(300);
        public static PDFImageReduceResolutionSetting DPI_600 = new PDFImageReduceResolutionSetting(600);
        public static PDFImageReduceResolutionSetting DPI_1200 = new PDFImageReduceResolutionSetting(1200);
        private boolean B = false;
        private int A = -1;

        private PDFImageReduceResolutionSetting() {
            this.B = true;
        }

        private PDFImageReduceResolutionSetting(int n) {
            this.A = n;
        }

        public void applyToConversionProperty(ConversionInstruction conversionInstruction) {
            if (this.B) {
                conversionInstruction.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.REDUCE_IMAGE_RESOLUTION, Boolean.FALSE);
                conversionInstruction.removeConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.MAX_IMAGE_RESOLUTION);
            } else if (this.A != -1) {
                conversionInstruction.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.REDUCE_IMAGE_RESOLUTION, Boolean.TRUE);
                conversionInstruction.addConversionProperty(ConversionFormat.FORMAT_PDF, OfficeEngineProperties.MAX_IMAGE_RESOLUTION, this.A);
            }
        }

        public String toString() {
            if (this.B) {
                return "disabled";
            }
            return String.valueOf(this.A);
        }
    }

    public static enum PdfVersion {
        PDF_DEFAULT(0, "0"),
        PDF_1_5(15, "1.5"),
        PDF_1_6(16, "1.6"),
        PDF_1_7(17, "1.7"),
        PDF_A_1B(1, "a-1b"),
        PDF_A_2B(2, "a-2b"),
        PDF_A_3B(3, "a-3b");

        private static Map<String, PdfVersion> A;
        private final int D;
        private final String B;

        private PdfVersion(int n2, String string2) {
            this.D = n2;
            this.B = string2;
        }

        public int getMode() {
            return this.D;
        }

        public static PdfVersion fromParamString(String string) {
            if (string == null) {
                return null;
            }
            if ((string = string.toLowerCase()).startsWith("pdf")) {
                string = string.substring(3).trim();
            }
            if (string.startsWith("/")) {
                string = string.substring(1).trim();
            }
            return A.get(string);
        }

        static {
            A = new HashMap<String, PdfVersion>();
            for (PdfVersion pdfVersion : EnumSet.allOf(PdfVersion.class)) {
                A.put(pdfVersion.B, pdfVersion);
            }
        }
    }
}

