/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.document.converter;

import com.docmosis.util.Equivalence;
import com.docmosis.util.StringUtilities;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class ConversionFormat
implements Serializable {
    private static final HashMap B = new HashMap();
    private static final HashSet H = new HashSet();
    private static final HashSet<ConversionFormat> E = new HashSet();
    public static final ConversionFormat FORMAT_PDF = new ConversionFormat("PDF", "pdf", false);
    public static final ConversionFormat FORMAT_WORD = new ConversionFormat("WORD97", "doc", true);
    public static final ConversionFormat FORMAT_WORD_XML = new ConversionFormat("WORD2003XML", "xml", true);
    public static final ConversionFormat FORMAT_DOCX = new ConversionFormat("DOCX", "docx", true);
    public static final ConversionFormat FORMAT_ODT = new ConversionFormat("ODT", "odt", "odf", false);
    public static final ConversionFormat FORMAT_FODT = new ConversionFormat("FODT", "fodt", false);
    public static final ConversionFormat FORMAT_RTF = new ConversionFormat("RTF", "rtf", false);
    public static final ConversionFormat FORMAT_HTML = new ConversionFormat("HTML", "html", "htm", false);
    public static final ConversionFormat FORMAT_XHTML = new ConversionFormat("XHTML", "xhtml", "xhtm", false);
    public static final ConversionFormat FORMAT_TEXT = new ConversionFormat("TEXT", "txt", "text", false);
    public static final ConversionFormat FORMAT_XLS = new ConversionFormat("XLS", "xls", false);
    public static final ConversionFormat FORMAT_XLSX = new ConversionFormat("XLSX", "xlsx", false);
    public static final ConversionFormat FORMAT_PPT = new ConversionFormat("PPT", "ppt", false);
    public static final ConversionFormat FORMAT_ODG = new ConversionFormat("ODG", "odg", false);
    public static final ConversionFormat FORMAT_ODS = new ConversionFormat("ODS", "ods", false);
    public static final ConversionFormat FORMAT_ODP = new ConversionFormat("ODP", "odp", false);
    public static final ConversionFormat FORMAT_PNG = new ConversionFormat("PNG", "png", false);
    public static final ConversionFormat FORMAT_JPG = new ConversionFormat("JPG", "jpg", false);
    public static final ConversionFormat FORMAT_CSV = new ConversionFormat("CSV", "csv", false);
    private static ConversionFormat[] A = E.toArray(new ConversionFormat[E.size()]);
    private final String F;
    private final String C;
    private final String D;
    private final boolean G;

    private ConversionFormat(String string, String string2, boolean bl) {
        this(string, string2, null, bl);
    }

    private ConversionFormat(String string, String string2, String string3, boolean bl) {
        this.F = string;
        this.C = "." + string2;
        this.D = string3 == null ? null : "." + string3;
        this.G = bl;
        this.addExtensionLookup(string2);
        this.addExtensionLookup(string3);
        H.add(this);
        if (bl) {
            E.add(this);
        }
    }

    private void addExtensionLookup(String string) {
        if (string != null) {
            if (B.containsKey(string = string.toLowerCase())) {
                throw new IllegalArgumentException("KEY:" + string + " is already assigned.");
            }
            B.put(string, this);
        }
    }

    public String getFormatName() {
        return this.F;
    }

    public boolean isWord() {
        return this.G;
    }

    public static ConversionFormat getFormatForFileName(String string) {
        ConversionFormat conversionFormat = null;
        if (string != null) {
            String string2 = null;
            int n = string.lastIndexOf(46);
            if (n != -1 && n < string.length() - 2) {
                string2 = string.substring(n + 1);
            }
            conversionFormat = ConversionFormat.getFormat(string2);
        }
        return conversionFormat;
    }

    public static ConversionFormat getFormat(String string) {
        ConversionFormat conversionFormat = null;
        if (string != null) {
            string = string.toLowerCase();
            conversionFormat = (ConversionFormat)B.get(string);
        }
        return conversionFormat;
    }

    public static ConversionFormat[] getFormatArray(String string) {
        String[] stringArray;
        ConversionFormat[] conversionFormatArray = null;
        if (!StringUtilities.isEmpty(string) && (stringArray = string.split(",")).length > 0) {
            conversionFormatArray = new ConversionFormat[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                conversionFormatArray[i] = ConversionFormat.getFormat(stringArray[i].trim());
            }
        }
        return conversionFormatArray;
    }

    public static boolean hasCorrectExtension(String string, ConversionFormat conversionFormat) {
        boolean bl = false;
        if (string != null && conversionFormat != null) {
            String string2;
            if ((string = string.toLowerCase()).endsWith(string2 = conversionFormat.getExtension())) {
                bl = true;
            } else {
                String string3 = conversionFormat.getAlternateExtension();
                if (string3 != null && string.endsWith(string3)) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static ConversionFormat[] getWordFormats() {
        return A;
    }

    public String getExtension() {
        return this.C;
    }

    public String getAlternateExtension() {
        return this.D;
    }

    public static boolean fileNameMatchesFormat(String string, ConversionFormat conversionFormat) {
        ConversionFormat conversionFormat2 = ConversionFormat.getFormatForFileName(string);
        return conversionFormat2 != null && conversionFormat != null && conversionFormat2.equals(conversionFormat);
    }

    static Set getAllFormats() {
        return new HashSet(H);
    }

    public int hashCode() {
        return this.F == null ? 0 : this.F.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof ConversionFormat && Equivalence.equivalentObjects(this.F, ((ConversionFormat)object).F);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ConversionFormat@").append(System.identityHashCode(this)).append("[");
        stringBuffer.append(this.F).append(",");
        stringBuffer.append(this.C).append(",");
        stringBuffer.append(this.D == null ? "" : this.D);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

