/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.document;

import com.docmosis.document.DocumentProcessor;
import com.docmosis.document.ExternalResourcePermissions;
import com.docmosis.document.ImageScalingDefault;
import com.docmosis.document.converter.ConversionFormat;
import com.docmosis.document.converter.ConversionInstruction;
import com.docmosis.document.converter.ConversionSettings;
import com.docmosis.template.population.DataProvider;
import com.docmosis.template.population.DataProviderBuilder;
import com.docmosis.template.population.ImageSupplier;
import com.docmosis.template.store.TemplateIdentifier;
import com.docmosis.template.store.TemplateStore;
import com.docmosis.template.store.TemplateStoreFactory;
import com.docmosis.util.NamedInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;

public class RenderRequest {
    private ImageSupplier D;
    private ImageScalingDefault G;
    private TemplateStore O;
    private ConversionInstruction A;
    private DataProvider E;
    private Boolean M;
    private ExternalResourcePermissions I;
    private ConversionSettings C;
    private Boolean F;
    private TemplateIdentifier N;
    private File B;
    private NamedInputStream K;
    private boolean J;
    private OutputStream L;
    private File H;

    public ImageSupplier getImageSupplier() {
        return this.D;
    }

    public RenderRequest setImageSupplier(ImageSupplier imageSupplier) {
        this.D = imageSupplier;
        return this;
    }

    public ImageScalingDefault getImageScalingDefault() {
        return this.G;
    }

    public RenderRequest setImageScalingDefault(ImageScalingDefault imageScalingDefault) {
        this.G = imageScalingDefault;
        return this;
    }

    public TemplateStore getTemplateStore() {
        if (this.O == null) {
            return TemplateStoreFactory.getStore();
        }
        return this.O;
    }

    public RenderRequest setTemplateStore(TemplateStore templateStore) {
        this.O = templateStore;
        return this;
    }

    public ConversionInstruction getConversionInstruction() {
        return this.A;
    }

    public RenderRequest setConversionInstruction(ConversionInstruction conversionInstruction) {
        this.A = conversionInstruction;
        return this;
    }

    public TemplateIdentifier getTemplateIdentifier() {
        return this.N;
    }

    public RenderRequest setTemplateIdentifier(TemplateIdentifier templateIdentifier) {
        this.N = templateIdentifier;
        this.B = null;
        this.K = null;
        return this;
    }

    public RenderRequest setTemplateFile(File file) {
        this.B = file;
        this.N = null;
        this.K = null;
        return this;
    }

    public RenderRequest setTemplateStream(InputStream inputStream, String string, boolean bl) {
        this.K = new NamedInputStream(inputStream, string);
        this.setRemoveTemplateAfterUse(bl);
        this.B = null;
        this.N = null;
        return this;
    }

    public NamedInputStream getTemplateStream() {
        return this.K;
    }

    public RenderRequest setRemoveTemplateAfterUse(boolean bl) {
        this.J = bl;
        return this;
    }

    public boolean getRemoveTemplateAfterUse() {
        return this.J;
    }

    public File getTemplateFile() {
        return this.B;
    }

    public DataProvider getDataProvider() {
        return this.E;
    }

    public RenderRequest setDataProvider(DataProvider dataProvider) {
        this.E = dataProvider;
        return this;
    }

    public Boolean getPopulationErrorsFatal() {
        return this.M;
    }

    public RenderRequest setPopulationErrorsFatal(Boolean bl) {
        this.M = bl;
        return this;
    }

    public Boolean getProcessStylesInText() {
        return this.F;
    }

    public RenderRequest setProcessStylesInText(Boolean bl) {
        this.F = bl;
        return this;
    }

    public OutputStream getOutputStream() {
        return this.L;
    }

    public RenderRequest setOutputStream(OutputStream outputStream) {
        this.L = outputStream;
        return this;
    }

    public File getOutputFile() {
        return this.H;
    }

    public RenderRequest setOutputFile(File file) {
        this.H = file;
        return this;
    }

    public ExternalResourcePermissions getExternalResourcePermissions() {
        return this.I;
    }

    public RenderRequest setExternalResourcePermissions(ExternalResourcePermissions externalResourcePermissions) {
        this.I = externalResourcePermissions;
        return this;
    }

    public ConversionSettings getConversionSettings() {
        return this.C;
    }

    public RenderRequest setConversionSettings(ConversionSettings conversionSettings) {
        this.C = conversionSettings;
        return this;
    }

    static void exampleCodeForJavaDoc() throws Exception {
        RenderRequest renderRequest = new RenderRequest();
        renderRequest.setTemplateFile(new File("myTemplate.doc"));
        renderRequest.setOutputFile(new File("myResult.pdf"));
        Object object = new DataProviderBuilder();
        renderRequest.setDataProvider(((DataProviderBuilder)object).getDataProvider());
        DocumentProcessor.renderDoc(renderRequest);
        renderRequest = new RenderRequest();
        renderRequest.setTemplateIdentifier(new TemplateIdentifier("myTemplate.doc"));
        object = new ConversionInstruction();
        ((ConversionInstruction)object).setOutputFileName("myResult");
        ((ConversionInstruction)object).setConversionFormats(new ConversionFormat[]{ConversionFormat.FORMAT_PDF, ConversionFormat.FORMAT_WORD});
        renderRequest.setConversionInstruction((ConversionInstruction)object);
        renderRequest.setOutputFile(new File("myResult.zip"));
        DataProviderBuilder dataProviderBuilder = new DataProviderBuilder();
        renderRequest.setDataProvider(dataProviderBuilder.getDataProvider());
        DocumentProcessor.renderDoc(renderRequest);
    }
}

