/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.document;

import com.docmosis.document.ExternalResourceCollection;
import com.docmosis.document.ExternalResourcePermissionsCheckResult;
import com.docmosis.util.UrlUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ExternalResourcePermissions
implements Serializable {
    private static final Logger C = LogManager.getLogger(ExternalResourcePermissions.class);
    private static final ExternalResourcePermissionsCheckResult B = new ExternalResourcePermissionsCheckResult(true, null);
    public static final ExternalResourcePermissions ALL = new ExternalResourcePermissions(_A.A, null);
    public static final ExternalResourcePermissions NONE = new ExternalResourcePermissions(_A.D, null);
    private final _A A;
    private final String[] D;

    private ExternalResourcePermissions(_A _A2, String[] stringArray) {
        this.A = _A2;
        this.D = stringArray;
    }

    public static ExternalResourcePermissions whitelist(String[] stringArray) {
        return new ExternalResourcePermissions(_A.B, stringArray);
    }

    public static ExternalResourcePermissionsCheckResult permitted(ExternalResourcePermissions externalResourcePermissions, ExternalResourceCollection externalResourceCollection, boolean bl, boolean bl2) {
        ExternalResourcePermissionsCheckResult externalResourcePermissionsCheckResult = externalResourcePermissions == null ? (externalResourceCollection != null && !externalResourceCollection.getResources().isEmpty() ? new ExternalResourcePermissionsCheckResult(false, externalResourceCollection.getResources().get(0)) : new ExternalResourcePermissionsCheckResult(true, null)) : externalResourcePermissions.permitted(externalResourceCollection, bl, bl2);
        return externalResourcePermissionsCheckResult;
    }

    public ExternalResourcePermissionsCheckResult permitted(ExternalResourceCollection externalResourceCollection, boolean bl, boolean bl2) {
        ExternalResourcePermissionsCheckResult externalResourcePermissionsCheckResult = B;
        if (externalResourceCollection != null) {
            for (String string : externalResourceCollection.getResources()) {
                if (this.permitted(string, bl, bl2)) continue;
                externalResourcePermissionsCheckResult = new ExternalResourcePermissionsCheckResult(false, string);
                break;
            }
        }
        return externalResourcePermissionsCheckResult;
    }

    public boolean permitted(String string, boolean bl, boolean bl2) {
        boolean bl3;
        if (this.A == _A.A) {
            bl3 = true;
        } else if (this.A == _A.D) {
            bl3 = false;
        } else {
            bl3 = false;
            if (this.D != null) {
                try {
                    if (string.indexOf("../") != -1) {
                        string = ExternalResourcePermissions.simpleNormalize(string);
                    }
                    string = ExternalResourcePermissions.getCaseSetDecodedUrl(string, bl, bl2);
                    for (String string2 : this.D) {
                        if (!this.matches(string, string2, bl, bl2)) continue;
                        bl3 = true;
                        break;
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    C.error("bad url:[" + string + "]", uRISyntaxException);
                }
            }
        }
        return bl3;
    }

    static final String simpleNormalize(String string) throws URISyntaxException {
        String string2;
        URI uRI = new URI(string);
        if (uRI.isOpaque()) {
            string2 = uRI.toString();
        } else {
            String string3 = ExternalResourcePermissions.normalizePath(uRI.getPath());
            StringBuilder stringBuilder = new StringBuilder();
            if (uRI.getScheme() != null) {
                stringBuilder.append(uRI.getScheme()).append(':');
                stringBuilder.append("//");
            }
            if (uRI.getAuthority() != null) {
                stringBuilder.append(uRI.getAuthority());
            }
            if (string3 != null) {
                stringBuilder.append(string3);
            }
            if (uRI.getQuery() != null) {
                stringBuilder.append('?').append(uRI.getQuery());
            }
            if (uRI.getFragment() != null) {
                stringBuilder.append('#').append(uRI.getFragment());
            }
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    private static String normalizePath(String string) {
        CharSequence charSequence;
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        while (stringTokenizer.hasMoreTokens()) {
            charSequence = stringTokenizer.nextToken();
            if (((String)charSequence).trim().equals("..")) {
                if (arrayList.isEmpty()) break;
                arrayList.remove(arrayList.size() - 1);
                continue;
            }
            arrayList.add(charSequence);
        }
        if (!arrayList.isEmpty()) {
            charSequence = new StringBuilder();
            for (String string3 : arrayList) {
                if (((StringBuilder)charSequence).length() == 0) {
                    if (string.startsWith("/")) {
                        ((StringBuilder)charSequence).append('/');
                    }
                } else {
                    ((StringBuilder)charSequence).append('/');
                }
                ((StringBuilder)charSequence).append(string3);
            }
            if (string.endsWith("/")) {
                ((StringBuilder)charSequence).append('/');
            }
            string2 = ((StringBuilder)charSequence).toString();
        }
        return string2;
    }

    boolean matches(String string, String string2, boolean bl, boolean bl2) {
        boolean bl3 = false;
        if ((string2 = ExternalResourcePermissions.getCaseSetDecodedUrl(string2, bl, bl2)).contains("*")) {
            if (UrlUtilities.matchesWildcardPrefix(string, string2)) {
                bl3 = true;
            }
        } else if (string.startsWith(string2)) {
            bl3 = true;
        }
        return bl3;
    }

    private static String getCaseSetDecodedUrl(String string, boolean bl, boolean bl2) {
        if (bl) {
            string = string.toLowerCase();
        }
        if (bl2) {
            try {
                string = URLDecoder.decode(string, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                C.warn("URL decoding not possible because utf-8 encoding is not supported");
            }
        }
        return string;
    }

    private static enum _A {
        D,
        A,
        B;

    }
}

