/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.document;

import com.docmosis.document.ExternalResourceCollection;
import com.docmosis.document.externalresource.DocxXmlContentHandler;
import com.docmosis.document.externalresource.OdtXmlContentHandler;
import com.docmosis.document.externalresource.XmlContentHandler;
import com.docmosis.document.externalresource.XmlStreamReader;
import com.docmosis.util.DMProperties;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ExternalResourceExtractor {
    private static final Logger G = LogManager.getLogger(ExternalResourceExtractor.class);
    private static final String D = "docmosis.analyzer.preprocessor.externalResource.formats.process";
    private static final String I = "docmosis.analyzer.preprocessor.externalResource.odt.entriesToProcess";
    private static final String[] H = new String[]{"^content.xml$", "^styles.xml$"};
    private static final String[] C = DMProperties.getStringArray("docmosis.analyzer.preprocessor.externalResource.odt.entriesToProcess", ";");
    private static final String[] F = C != null ? C : H;
    private static final String B = "docmosis.analyzer.preprocessor.externalResource.odt.entriesToProcess";
    private static final String[] J = new String[]{"(.*)_rels/(.*).rels"};
    private static final String[] E = DMProperties.getStringArray("docmosis.analyzer.preprocessor.externalResource.odt.entriesToProcess", ";");
    private static final String[] A = E != null ? E : J;

    public static ExternalResourceCollection extract(File file) throws IOException {
        ExternalResourceCollection externalResourceCollection = null;
        if (ExternalResourceExtractor.processDocxEnabled() && FileUtilities.isDocxFormat(file)) {
            externalResourceCollection = ExternalResourceExtractor.getResources(file, true);
        } else if (ExternalResourceExtractor.processOdtEnabled() && FileUtilities.isOdtFormat(file)) {
            externalResourceCollection = ExternalResourceExtractor.getResources(file, false);
        }
        return externalResourceCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static ExternalResourceCollection getResources(File file, boolean bl) throws IOException {
        _A _A2 = bl ? ExternalResourceExtractor.explode(file, "docx", A) : ExternalResourceExtractor.explode(file, "odt", F);
        File file2 = _A2.A;
        try {
            void var7_11;
            File[] fileArray = _A2.B;
            if (fileArray == null || fileArray.length == 0) {
                ExternalResourceCollection externalResourceCollection = null;
                return externalResourceCollection;
            }
            XmlStreamReader xmlStreamReader = new XmlStreamReader();
            XmlContentHandler xmlContentHandler = bl ? new DocxXmlContentHandler() : new OdtXmlContentHandler();
            for (File file3 : fileArray) {
                xmlStreamReader.process(file3, xmlContentHandler);
            }
            Object var7_9 = null;
            if (xmlContentHandler.getLinks() != null && xmlContentHandler.getLinks().length > 0) {
                ExternalResourceCollection externalResourceCollection = new ExternalResourceCollection(xmlContentHandler.getLinks());
            }
            void var8_13 = var7_11;
            return var8_13;
        }
        finally {
            FileUtilities.deleteRecursively(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static _A explode(File file, String string, String[] stringArray) throws IOException {
        FileInputStream fileInputStream = null;
        ZipInputStream zipInputStream = null;
        File file2 = null;
        byte[] byArray = new byte[2048];
        ArrayList<File> arrayList = new ArrayList<File>();
        if (stringArray == null || stringArray.length == 0) {
            String string2 = "No zip entries specified in search params.";
            G.error(string2);
            throw new IOException(string2);
        }
        int n = 1;
        try {
            ZipEntry zipEntry;
            fileInputStream = new FileInputStream(file);
            zipInputStream = new ZipInputStream(fileInputStream);
            file2 = FileUtilities.createTempDir("dm_" + string + "_", "xpl");
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string3 = zipEntry.getName();
                boolean bl = false;
                for (String string2 : stringArray) {
                    if (!string3.matches(string2)) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                File file3 = new File(file2, String.valueOf(n));
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                try {
                    ExternalResourceExtractor.writeOut(zipInputStream, zipEntry, fileOutputStream, byArray);
                }
                finally {
                    fileOutputStream.close();
                }
                arrayList.add(file3);
                ++n;
            }
        }
        catch (IOException iOException) {
            try {
                FileUtilities.deleteRecursively(file2);
                String string5 = "Failed to extract external resources, error:" + iOException.getMessage();
                G.error(string5, iOException);
                throw iOException;
            }
            catch (Throwable throwable) {
                FileUtilities.close(zipInputStream);
                FileUtilities.close(fileInputStream);
                throw throwable;
            }
        }
        FileUtilities.close(zipInputStream);
        FileUtilities.close(fileInputStream);
        return new _A(file2, arrayList.toArray(new File[0]));
    }

    private static void writeOut(ZipInputStream zipInputStream, ZipEntry zipEntry, OutputStream outputStream, byte[] byArray) throws IOException {
        int n;
        byte[] byArray2 = byArray;
        while ((n = zipInputStream.read(byArray2)) != -1) {
            outputStream.write(byArray2, 0, n);
        }
    }

    public static boolean processDocxEnabled() {
        boolean bl = false;
        String[] stringArray = DMProperties.getStringArray(D, ",");
        if (stringArray != null) {
            for (String string : stringArray) {
                if (!"docx".equalsIgnoreCase(string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static boolean processOdtEnabled() {
        boolean bl = false;
        String[] stringArray = DMProperties.getStringArray(D, ",");
        if (stringArray != null) {
            for (String string : stringArray) {
                if (!"odt".equalsIgnoreCase(string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private static class _A {
        protected File A;
        protected File[] B;

        protected _A(File file, File[] fileArray) {
            this.A = file;
            this.B = fileArray;
        }
    }
}

