/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.document;

import com.docmosis.SystemManager;
import com.docmosis.document.CoordinatedRenderResult;
import com.docmosis.document.CoordinatedRenderResults;
import com.docmosis.document.DocumentRenderResult;
import com.docmosis.document.DocumentRenderResultBase;
import com.docmosis.document.ExternalResourcePermissions;
import com.docmosis.document.ImageScalingDefault;
import com.docmosis.document.ProcessingException;
import com.docmosis.document.RenderRequest;
import com.docmosis.document.converter.B;
import com.docmosis.document.converter.ConversionDataTask;
import com.docmosis.document.converter.ConversionException;
import com.docmosis.document.converter.ConversionFormat;
import com.docmosis.document.converter.ConversionInstruction;
import com.docmosis.document.converter.ConversionSettings;
import com.docmosis.document.converter.ConversionSettingsHelper;
import com.docmosis.document.converter.NoConvertersRunningException;
import com.docmosis.document.converter.pool.ConverterPool;
import com.docmosis.document.converter.pool.ConverterPoolException;
import com.docmosis.template.BasicDocument;
import com.docmosis.template.Document;
import com.docmosis.template.Template;
import com.docmosis.template.TemplateDetails;
import com.docmosis.template.TemplateNotFoundException;
import com.docmosis.template.TemplateStoreException;
import com.docmosis.template.analysis.TemplateAnalysis;
import com.docmosis.template.analysis.sensitivitylabel.SensitivityLabelInfo;
import com.docmosis.template.analysis.sensitivitylabel.SensitivityLabelItem;
import com.docmosis.template.population.Cleanable;
import com.docmosis.template.population.DataProvider;
import com.docmosis.template.population.DataProviderBuilder;
import com.docmosis.template.population.ImageSupplier;
import com.docmosis.template.population.PopulatedFilesCollection;
import com.docmosis.template.population.PopulationException;
import com.docmosis.template.population.PopulationTask;
import com.docmosis.template.population.PopulatorFactory;
import com.docmosis.template.population.render.FieldRenderer;
import com.docmosis.template.population.render.RendererRegistry;
import com.docmosis.template.store.StoreHelper;
import com.docmosis.template.store.TemplateIdentifier;
import com.docmosis.template.store.TemplateStore;
import com.docmosis.template.store.TemplateStoreFactory;
import com.docmosis.util.DMProperties;
import com.docmosis.util.ExceptionUtils;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.StringUtilities;
import com.docmosis.util.UniqueFileNameGenerator;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import com.docmosis.util.pipeline.DataWorker;
import com.docmosis.util.pipeline.InvalidDataTaskException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class DocumentProcessor {
    private static final Logger B = LogManager.getLogger(DocumentProcessor.class);
    private static final int A = DMProperties.getInt("docmosis.render.maxRetries");
    public static final String PROP_NAME_GENERATED_FILES_PRESERVE = "docmosis.populator.file.preserveGenerated";

    public static DocumentRenderResult renderDoc(TemplateIdentifier templateIdentifier, DataProvider dataProvider, ConversionInstruction conversionInstruction, OutputStream outputStream) throws IOException, ProcessingException, TemplateStoreException {
        return DocumentProcessor.renderDoc(templateIdentifier, dataProvider, conversionInstruction, outputStream, null);
    }

    public static DocumentRenderResult renderDoc(TemplateIdentifier templateIdentifier, DataProvider dataProvider, ConversionInstruction conversionInstruction, OutputStream outputStream, ExternalResourcePermissions externalResourcePermissions) throws IOException, ProcessingException, TemplateStoreException {
        return DocumentProcessor.retryingRender(templateIdentifier, dataProvider, conversionInstruction, outputStream, DocumentProcessor.defaultPopulationErrorsFatal(), TemplateStoreFactory.getStore(), null, ImageScalingDefault.SYSTEM_SETTINGS, DocumentProcessor.defaultProcessTextMarkup(), externalResourcePermissions, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DocumentRenderResult renderDoc(RenderRequest renderRequest) throws IOException, ProcessingException, TemplateStoreException, ConversionException, NoConvertersRunningException {
        DocumentRenderResult documentRenderResult;
        if (renderRequest == null) {
            throw new NullPointerException("Given request is null");
        }
        Object object = null;
        File file = null;
        TemplateStore templateStore = null;
        TemplateIdentifier templateIdentifier = null;
        boolean bl = renderRequest.getRemoveTemplateAfterUse();
        try {
            Object object2;
            templateStore = renderRequest.getTemplateStore();
            File file2 = renderRequest.getTemplateFile();
            if (file2 != null) {
                templateIdentifier = DocumentProcessor.storeFileAsTemplate(file2, templateStore, renderRequest.getExternalResourcePermissions());
            } else if (renderRequest.getTemplateStream() != null) {
                file = FileUtilities.createTempFile("rend", "tmpl");
                FileUtilities.streamOut(renderRequest.getTemplateStream().getStream(), file);
                if (StringUtilities.isEmpty(renderRequest.getTemplateStream().getName())) {
                    templateIdentifier = TemplateIdentifier.createUniqueTempTemplateIdentifier();
                    bl = true;
                } else {
                    templateIdentifier = TemplateIdentifier.fromPath(renderRequest.getTemplateStream().getName());
                }
                DocumentProcessor.storeFileAsTemplate(file, templateStore, templateIdentifier, renderRequest.getExternalResourcePermissions());
            } else {
                templateIdentifier = renderRequest.getTemplateIdentifier();
            }
            if (templateIdentifier == null) {
                throw new ProcessingException("No TemplateIdentifier or Template File specified");
            }
            ConversionInstruction conversionInstruction = renderRequest.getConversionInstruction();
            if (conversionInstruction == null) {
                if (renderRequest.getOutputFile() == null) throw new ConversionException("The RenderRequest must specify a Conversion Instruction or an Output File");
                object2 = DocumentProcessor.getConversionFormat(renderRequest.getOutputFile());
                conversionInstruction = new ConversionInstruction();
                conversionInstruction.setOutputFileName(renderRequest.getOutputFile().getName());
                conversionInstruction.setConversionFormats(new ConversionFormat[]{object2});
            } else if (renderRequest.getOutputFile() != null && (conversionInstruction.getConversionFormats() == null || conversionInstruction.getOutputFileName() == null)) {
                if ((conversionInstruction = new ConversionInstruction(conversionInstruction)).getConversionFormats() == null && (object2 = ConversionFormat.getFormatForFileName(renderRequest.getOutputFile().getName())) != null) {
                    conversionInstruction.setConversionFormats(new ConversionFormat[]{object2});
                }
                if (conversionInstruction.getOutputFileName() == null) {
                    conversionInstruction.setOutputFileName(renderRequest.getOutputFile().getName());
                }
            }
            object2 = renderRequest.getOutputStream();
            if (object2 == null) {
                if (renderRequest.getOutputFile() == null) throw new ProcessingException("No Stream To or Result File specified");
                object = object2 = DocumentProcessor.getOutputStream(renderRequest.getOutputFile());
            }
            documentRenderResult = DocumentProcessor.retryingRender(templateIdentifier, renderRequest.getDataProvider(), conversionInstruction, (OutputStream)object2, DocumentProcessor.arePopulationErrorsFatal(renderRequest), templateStore, renderRequest.getImageSupplier(), renderRequest.getImageScalingDefault(), DocumentProcessor.isProcessingTextMarkup(renderRequest), renderRequest.getExternalResourcePermissions(), renderRequest.getConversionSettings());
        }
        catch (Throwable throwable) {
            FileUtilities.close(object);
            FileUtilities.delete(file);
            if (templateStore == null || templateIdentifier == null || !bl) throw throwable;
            templateStore.deleteTemplate(templateIdentifier);
            throw throwable;
        }
        FileUtilities.close((OutputStream)object);
        FileUtilities.delete(file);
        if (templateStore == null || templateIdentifier == null || !bl) return documentRenderResult;
        templateStore.deleteTemplate(templateIdentifier);
        return documentRenderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DocumentRenderResult retryingRender(TemplateIdentifier templateIdentifier, DataProvider dataProvider, ConversionInstruction conversionInstruction, OutputStream outputStream, boolean bl, TemplateStore templateStore, ImageSupplier imageSupplier, ImageScalingDefault imageScalingDefault, boolean bl2, ExternalResourcePermissions externalResourcePermissions, ConversionSettings conversionSettings) throws IOException, ProcessingException, TemplateStoreException {
        Document document = null;
        try {
            boolean bl3 = true;
            int n = 0;
            long l = System.currentTimeMillis();
            DocumentRenderResult documentRenderResult = null;
            while (bl3) {
                bl3 = false;
                try {
                    document = DocumentProcessor.getTemplateWithReStore(templateStore, templateIdentifier, externalResourcePermissions);
                    documentRenderResult = DocumentProcessor.executeRender((Template)document, dataProvider, conversionInstruction, outputStream, bl, templateStore, imageSupplier, imageScalingDefault, bl2, conversionSettings);
                    if (!B.isDebugEnabled()) continue;
                    B.debug("Document rendered in millis:" + (System.currentTimeMillis() - l));
                }
                catch (ProcessingException processingException) {
                    if (processingException.canRetry() && n < A) {
                        bl3 = true;
                        B.info("Retrying document: attempt number " + ++n);
                        continue;
                    }
                    throw processingException;
                }
                finally {
                    if (document == null) continue;
                    document.cleanup();
                    document = null;
                }
            }
            DocumentRenderResult documentRenderResult2 = documentRenderResult;
            return documentRenderResult2;
        }
        catch (RuntimeException runtimeException) {
            throw new ProcessingException(runtimeException);
        }
        finally {
            if (document != null) {
                document.cleanup();
            }
            if (conversionInstruction.cleanupDataProvider() && dataProvider instanceof Cleanable) {
                ((Cleanable)((Object)dataProvider)).cleanup();
            }
        }
    }

    private static Template getTemplateWithReStore(TemplateStore templateStore, TemplateIdentifier templateIdentifier, ExternalResourcePermissions externalResourcePermissions) throws IOException, TemplateNotFoundException, TemplateStoreException {
        try {
            return templateStore.getTemplate(templateIdentifier);
        }
        catch (TemplateStoreException templateStoreException) {
            if (templateStoreException.isAnalysisCorruptError()) {
                Throwable throwable = ExceptionUtils.getRootCause(templateStoreException);
                B.warn("retrieving the template failed (cause=" + throwable.getClass() + ":" + (throwable.getMessage() == null ? "<no message>" : throwable.getMessage()) + ". Attempting to re-register the template");
                DocumentProcessor.reStoreTemplate(templateIdentifier, templateStore, externalResourcePermissions);
                return templateStore.getTemplate(templateIdentifier);
            }
            throw templateStoreException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DocumentRenderResult executeRender(Template template, DataProvider dataProvider, ConversionInstruction conversionInstruction, OutputStream outputStream, boolean bl, TemplateStore templateStore, ImageSupplier imageSupplier, ImageScalingDefault imageScalingDefault, boolean bl2, ConversionSettings conversionSettings) throws IOException, TemplateNotFoundException, ProcessingException {
        DataWorker dataWorker = null;
        PopulationTask populationTask = null;
        ConversionFormat[] conversionFormatArray = conversionInstruction.getConversionFormats();
        if (conversionFormatArray == null || conversionFormatArray.length == 0) {
            throw new ProcessingException("No output formats have been specified and no output file name with a recognised extension.  Check your conversion instruction or output file name.");
        }
        try {
            Object object;
            Object object2;
            block27: {
                Serializable serializable;
                int n;
                block29: {
                    block28: {
                        block26: {
                            TemplateAnalysis templateAnalysis;
                            dataWorker = PopulatorFactory.getPopulator(template, dataProvider);
                            populationTask = new PopulationTask(template.getInputStream(), null, template, dataProvider, conversionInstruction.getRendererRegistry(), bl, templateStore, imageSupplier, imageScalingDefault, conversionFormatArray, bl2);
                            try {
                                dataWorker.addTask(populationTask);
                            }
                            catch (InvalidDataTaskException invalidDataTaskException) {
                                throw new ProcessingException(invalidDataTaskException);
                            }
                            try {
                                object2 = populationTask;
                                synchronized (object2) {
                                    while (!populationTask.isComplete()) {
                                        populationTask.wait();
                                    }
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                throw new ProcessingException(interruptedException);
                            }
                            if (populationTask.hasFailed()) {
                                throw new ProcessingException(populationTask.getFailureMessage(), populationTask.getFailureThrowable());
                            }
                            if (populationTask.getPopulatedFilesCollection() != null) {
                                com.docmosis.document.converter.B.B(populationTask.getPopulatedFilesCollection().size());
                            }
                            if ((templateAnalysis = template.getAnalysis()).isCoordinatorTemplate()) break block26;
                            DocumentProcessor.mergeSensitivityLabelInfo(populationTask.getPopulatedFilesCollection());
                            object = DocumentProcessor.doConversion(populationTask.getPopulatedFilesCollection(), outputStream, conversionInstruction, conversionSettings);
                            outputStream.flush();
                            object2 = new DocumentRenderResult(((BasicDocument)object).getLength(), ((BasicDocument)object).getDocumentPageCount(), populationTask.isErrorsDetectedInDocument(), template.getId(), conversionInstruction.producesZippedDocument());
                            break block27;
                        }
                        n = populationTask.getPopulatedFilesCollection().size();
                        if (n != 1) break block28;
                        serializable = DocumentProcessor.doConversion(populationTask.getPopulatedFilesCollection(), outputStream, conversionInstruction, conversionSettings);
                        outputStream.flush();
                        object2 = new DocumentRenderResult(((BasicDocument)serializable).getLength(), ((BasicDocument)serializable).getDocumentPageCount(), populationTask.isErrorsDetectedInDocument(), template.getId(), false, new CoordinatedRenderResults(null));
                        break block27;
                    }
                    if (!populationTask.isErrorsDetectedInDocument()) break block29;
                    serializable = new PopulatedFilesCollection();
                    for (PopulatedFilesCollection.PopulatedFile populatedFile : populationTask.getPopulatedFilesCollection().getFiles()) {
                        ((PopulatedFilesCollection)serializable).add(populatedFile);
                    }
                    DocumentProcessor.mergeSensitivityLabelInfo((PopulatedFilesCollection)serializable);
                    BasicDocument basicDocument = DocumentProcessor.doConversion((PopulatedFilesCollection)serializable, outputStream, conversionInstruction, conversionSettings);
                    outputStream.flush();
                    object2 = new DocumentRenderResult(basicDocument.getLength(), basicDocument.getDocumentPageCount(), populationTask.isErrorsDetectedInDocument(), template.getId(), false, new CoordinatedRenderResults(null));
                    break block27;
                }
                outputStream = new ZipOutputStream(outputStream);
                serializable = new ArrayList();
                long l = 0L;
                int n2 = 0;
                UniqueFileNameGenerator.KnownFormatProvider knownFormatProvider = new UniqueFileNameGenerator.KnownFormatProvider(){

                    @Override
                    public boolean isKnownExtension(String string) {
                        return ConversionFormat.getFormat(string) != null;
                    }
                };
                UniqueFileNameGenerator uniqueFileNameGenerator = new UniqueFileNameGenerator(knownFormatProvider);
                _A _A2 = _A.A(populationTask.getPopulatedFilesCollection().getFiles()[0]);
                int n3 = 1;
                while (n3 < n) {
                    PopulatedFilesCollection.PopulatedFile populatedFile;
                    block31: {
                        Object object3;
                        Object object4;
                        Object object5;
                        PopulatedFilesCollection populatedFilesCollection;
                        block30: {
                            populatedFilesCollection = new PopulatedFilesCollection();
                            populatedFile = populationTask.getPopulatedFilesCollection().getFiles()[n3];
                            populatedFilesCollection.add(populatedFile);
                            ++n3;
                            while (n3 < n && !populationTask.getPopulatedFilesCollection().getFiles()[n3].isBeingCoordinated()) {
                                populatedFile = populationTask.getPopulatedFilesCollection().getFiles()[n3];
                                populatedFilesCollection.add(populatedFile);
                                ++n3;
                            }
                            DocumentProcessor.mergeSensitivityLabelInfo(populatedFilesCollection);
                            if (!conversionInstruction.producesZippedDocument()) break block30;
                            object5 = null;
                            object4 = null;
                            object3 = null;
                            try {
                                ZipEntry zipEntry;
                                object5 = FileUtilities.createTempFile("dmz", "zpp");
                                object4 = new FileOutputStream((File)object5);
                                BasicDocument basicDocument = DocumentProcessor.doConversion(populatedFilesCollection, (OutputStream)object4, conversionInstruction, conversionSettings);
                                object3 = new ZipInputStream(new FileInputStream((File)object5));
                                byte[] byArray = new byte[8192];
                                boolean bl3 = true;
                                while ((zipEntry = ((ZipInputStream)object3).getNextEntry()) != null) {
                                    String string = uniqueFileNameGenerator.generate(zipEntry.getName());
                                    ((ZipOutputStream)outputStream).putNextEntry(new ZipEntry(string));
                                    FileUtilities.streamOut((InputStream)object3, outputStream, byArray);
                                    outputStream.flush();
                                    ((ZipOutputStream)outputStream).closeEntry();
                                    CoordinatedRenderResult coordinatedRenderResult = new CoordinatedRenderResult(basicDocument.getLength(), basicDocument.getDocumentPageCount(), populationTask.isErrorsDetectedInDocument(), populatedFile.getBasedOnTemplateId(), false, _A2.D, _A2.B, _A2.A, _A2.C, !bl3);
                                    serializable.add(coordinatedRenderResult);
                                    if (!bl3) continue;
                                    l += coordinatedRenderResult.getLength();
                                    n2 += coordinatedRenderResult.getDocumentPageCount();
                                    bl3 = false;
                                }
                            }
                            catch (Throwable throwable) {
                                FileUtilities.close(object4);
                                FileUtilities.close(object3);
                                FileUtilities.delete((File)object5);
                                throw throwable;
                            }
                            FileUtilities.close((OutputStream)object4);
                            FileUtilities.close((InputStream)object3);
                            FileUtilities.delete((File)object5);
                            break block31;
                        }
                        object5 = conversionInstruction.getOutputFileNameWithFormats();
                        ((ZipOutputStream)outputStream).putNextEntry(new ZipEntry(uniqueFileNameGenerator.generate((String)object5)));
                        object4 = DocumentProcessor.doConversion(populatedFilesCollection, outputStream, conversionInstruction, conversionSettings);
                        outputStream.flush();
                        ((ZipOutputStream)outputStream).closeEntry();
                        object3 = new CoordinatedRenderResult(((BasicDocument)object4).getLength(), ((BasicDocument)object4).getDocumentPageCount(), populationTask.isErrorsDetectedInDocument(), populatedFile.getBasedOnTemplateId(), conversionInstruction.producesZippedDocument(), _A2.D, _A2.B, _A2.A, _A2.C, false);
                        serializable.add(object3);
                        l += ((DocumentRenderResultBase)object3).getLength();
                        n2 += ((DocumentRenderResultBase)object3).getDocumentPageCount();
                    }
                    _A2 = _A.A(populatedFile);
                }
                ((ZipOutputStream)outputStream).finish();
                object2 = new DocumentRenderResult(l, n2, populationTask.isErrorsDetectedInDocument(), template.getId(), true, new CoordinatedRenderResults((List<CoordinatedRenderResult>)((Object)serializable)));
            }
            object = object2;
            return object;
        }
        catch (PopulationException populationException) {
            throw new ProcessingException(populationException);
        }
        finally {
            if (populationTask != null && populationTask.getPopulatedFilesCollection() != null) {
                PopulatedFilesCollection populatedFilesCollection = populationTask.getPopulatedFilesCollection();
                if (DMProperties.getBoolean(PROP_NAME_GENERATED_FILES_PRESERVE, false)) {
                    B.info("The following files have been preserved:" + populatedFilesCollection.toString());
                } else {
                    populatedFilesCollection.cleanup();
                }
            }
            PopulatorFactory.returnPopulator(dataWorker);
        }
    }

    private static void mergeSensitivityLabelInfo(PopulatedFilesCollection populatedFilesCollection) {
        ArrayList<SensitivityLabelItem> arrayList = new ArrayList<SensitivityLabelItem>();
        if (populatedFilesCollection.size() > 1) {
            for (PopulatedFilesCollection.PopulatedFile populatedFile : populatedFilesCollection.getFiles()) {
                if (populatedFile.getSensitivityLabelInfo() == null) continue;
                arrayList.addAll(Arrays.asList(populatedFile.getSensitivityLabelInfo().getSensitivityLabels()));
            }
            if (arrayList.size() > 0) {
                populatedFilesCollection.getFiles()[0].setSensitivityLabelInfo(new SensitivityLabelInfo(arrayList.toArray(new SensitivityLabelItem[0])));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BasicDocument doConversion(PopulatedFilesCollection populatedFilesCollection, OutputStream outputStream, ConversionInstruction conversionInstruction, ConversionSettings conversionSettings) throws ProcessingException, IOException {
        DataWorker dataWorker = null;
        ConversionDataTask conversionDataTask = new ConversionDataTask(null, populatedFilesCollection, outputStream);
        conversionDataTask.setConversionInstruction(conversionInstruction);
        if (conversionSettings == null) {
            conversionSettings = ConversionSettingsHelper.getDefaultConversionSettings();
        }
        conversionDataTask.setConversionSettings(conversionSettings);
        try {
            Object object;
            dataWorker = com.docmosis.document.converter.B.B();
            try {
                dataWorker.addTask(conversionDataTask);
            }
            catch (InvalidDataTaskException invalidDataTaskException) {
                throw new ProcessingException(invalidDataTaskException);
            }
            if (conversionDataTask != null) {
                try {
                    object = conversionDataTask;
                    synchronized (object) {
                        if (!conversionDataTask.isComplete()) {
                            conversionDataTask.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new ProcessingException(interruptedException);
                }
            }
            if (conversionDataTask.hasFailed()) {
                B.error("Converter:" + conversionDataTask.getFailureMessage(), conversionDataTask.getFailureThrowable());
            }
            if (conversionDataTask.hasFailed()) {
                object = conversionDataTask.getFailureThrowable();
                ProcessingException processingException = new ProcessingException(conversionDataTask.getFailureMessage(), (Throwable)object);
                if (object != null && ((Throwable)object).getCause() instanceof ConversionException && ((ConversionException)((Throwable)object).getCause()).isDueToServiceFailure()) {
                    processingException.setCanRetry(true);
                }
                throw processingException;
            }
            object = conversionDataTask.getResult();
            return object;
        }
        finally {
            com.docmosis.document.converter.B.A(dataWorker);
        }
    }

    public static DocumentRenderResult renderDoc(File file, File file2, DataProvider dataProvider) throws IOException, ProcessingException, TemplateStoreException, ConversionException, NoConvertersRunningException {
        return DocumentProcessor.renderDoc(file, file2, dataProvider, null);
    }

    public static DocumentRenderResult renderDoc(File file, File file2, DataProvider dataProvider, ExternalResourcePermissions externalResourcePermissions) throws IOException, ProcessingException, TemplateStoreException, ConversionException, NoConvertersRunningException {
        return DocumentProcessor.renderDoc(file, file2, dataProvider, true, externalResourcePermissions);
    }

    public static DocumentRenderResult renderDoc(File file, File file2, DataProvider dataProvider, boolean bl) throws IOException, ProcessingException, TemplateStoreException, ConversionException, NoConvertersRunningException {
        return DocumentProcessor.renderDoc(file, file2, dataProvider, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocumentRenderResult renderDoc(File file, File file2, DataProvider dataProvider, boolean bl, ExternalResourcePermissions externalResourcePermissions) throws IOException, ProcessingException, TemplateStoreException, ConversionException, NoConvertersRunningException {
        OutputStream outputStream = DocumentProcessor.getOutputStream(file2);
        boolean bl2 = false;
        try {
            DocumentRenderResult documentRenderResult = DocumentProcessor.renderDoc(file, outputStream, DocumentProcessor.getConversionFormat(file2), dataProvider, bl, externalResourcePermissions);
            bl2 = true;
            DocumentRenderResult documentRenderResult2 = documentRenderResult;
            return documentRenderResult2;
        }
        finally {
            FileUtilities.close(outputStream);
            if (!bl2) {
                FileUtilities.delete(file2);
            }
        }
    }

    static ConversionFormat getConversionFormat(File file) throws IOException, ProcessingException {
        if (file == null) {
            throw new IOException("Output file <null> is illegal");
        }
        ConversionFormat conversionFormat = ConversionFormat.getFormatForFileName(file.getName());
        if (conversionFormat == null) {
            throw new ProcessingException("Unable to determine output format for file named:" + file.getName());
        }
        return conversionFormat;
    }

    private static OutputStream getOutputStream(File file) throws IOException {
        if (file == null) {
            throw new IOException("Output file <null> is illegal");
        }
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        return new FileOutputStream(file);
    }

    public static DocumentRenderResult renderDoc(File file, OutputStream outputStream, ConversionFormat conversionFormat, DataProvider dataProvider, ExternalResourcePermissions externalResourcePermissions) throws IOException, ProcessingException, TemplateStoreException, ConversionException, NoConvertersRunningException {
        return DocumentProcessor.renderDoc(file, outputStream, conversionFormat, dataProvider, true, externalResourcePermissions);
    }

    public static DocumentRenderResult renderDoc(File file, OutputStream outputStream, ConversionFormat conversionFormat, DataProvider dataProvider, boolean bl, ExternalResourcePermissions externalResourcePermissions) throws IOException, ProcessingException, TemplateStoreException, ConversionException, NoConvertersRunningException {
        TemplateStore templateStore = TemplateStoreFactory.getStore();
        try {
            if (conversionFormat == null) {
                throw new ProcessingException("Invalid null conversion format");
            }
            if (outputStream == null) {
                throw new ProcessingException("Invalid null output stream");
            }
            TemplateIdentifier templateIdentifier = DocumentProcessor.storeFileAsTemplate(file, templateStore, externalResourcePermissions);
            ConversionInstruction conversionInstruction = new ConversionInstruction();
            conversionInstruction.setConversionFormats(new ConversionFormat[]{conversionFormat});
            conversionInstruction.setCleanupDataProvider(bl);
            return DocumentProcessor.retryingRender(templateIdentifier, dataProvider, conversionInstruction, outputStream, DocumentProcessor.defaultPopulationErrorsFatal(), templateStore, null, ImageScalingDefault.SYSTEM_SETTINGS, DocumentProcessor.defaultProcessTextMarkup(), externalResourcePermissions, null);
        }
        catch (RuntimeException runtimeException) {
            throw new ProcessingException(runtimeException);
        }
    }

    private static TemplateIdentifier storeFileAsTemplate(File file, TemplateStore templateStore, ExternalResourcePermissions externalResourcePermissions) throws IOException, TemplateStoreException, ConversionException, NoConvertersRunningException {
        TemplateIdentifier templateIdentifier = new TemplateIdentifier(file.getName());
        return DocumentProcessor.storeFileAsTemplate(file, templateStore, templateIdentifier, externalResourcePermissions);
    }

    private static TemplateIdentifier storeFileAsTemplate(File file, TemplateStore templateStore, TemplateIdentifier templateIdentifier, ExternalResourcePermissions externalResourcePermissions) throws IOException, TemplateStoreException, ConversionException, NoConvertersRunningException {
        if (file == null) {
            throw new IOException("Template <null> is illegal");
        }
        if (!file.canRead() || !file.isFile()) {
            throw new IOException("Template not found:" + file.getPath());
        }
        long l = templateStore.getTemplateStoredTime(templateIdentifier);
        if (l == -1L || l < file.lastModified()) {
            StoreHelper.storeTemplate(templateIdentifier, file, templateStore, externalResourcePermissions);
        }
        return templateIdentifier;
    }

    public static boolean hasOnlineConverters() throws ConverterPoolException {
        return DocumentProcessor.hasOnlineConverters(null);
    }

    public static boolean hasOnlineConverters(String string) throws ConverterPoolException {
        return DocumentProcessor.getOnlineConverterCount(string) > 0;
    }

    public static int getOnlineConverterCount() throws ConverterPoolException {
        return DocumentProcessor.getOnlineConverterCount(null);
    }

    public static int getOnlineConverterCount(String string) throws ConverterPoolException {
        if (!SystemManager.isInitialized()) {
            return -1;
        }
        return ConverterPool.getOnlineConverterCount(string);
    }

    public static void setDefaultRenderer(String string, FieldRenderer fieldRenderer) {
        RendererRegistry.setDefaultRendererByName(string, fieldRenderer);
    }

    public static void setDefaultRenderer(Class<?> clazz, FieldRenderer fieldRenderer) {
        RendererRegistry.setDefaultRendererByClass(clazz, fieldRenderer);
    }

    private static void reStoreTemplate(TemplateIdentifier templateIdentifier, TemplateStore templateStore, ExternalResourcePermissions externalResourcePermissions) throws IOException, TemplateNotFoundException, TemplateStoreException {
        B.debug("Analysis is out of date.  Re-storing the template first.");
        InputStream inputStream = null;
        File file = FileUtilities.createTempFile("restore", ".orig");
        try {
            inputStream = templateStore.getOriginalTemplate(templateIdentifier);
            FileUtilities.storeToFile(inputStream, file);
            FileUtilities.close(inputStream);
            StoreHelper.storeTemplate(templateIdentifier, file, templateStore, externalResourcePermissions);
        }
        catch (ConversionException conversionException) {
            throw new TemplateStoreException("An error occurred re-storing the template", conversionException);
        }
        catch (NoConvertersRunningException noConvertersRunningException) {
            throw new TemplateStoreException("An error occurred re-storing the template", noConvertersRunningException);
        }
        finally {
            FileUtilities.delete(file);
            FileUtilities.close(inputStream);
        }
    }

    private static boolean arePopulationErrorsFatal(RenderRequest renderRequest) {
        Boolean bl = renderRequest.getPopulationErrorsFatal();
        if (bl == null) {
            return DocumentProcessor.defaultPopulationErrorsFatal();
        }
        return Boolean.TRUE.equals(bl);
    }

    private static boolean defaultPopulationErrorsFatal() {
        return DMProperties.getBoolean("docmosis.populator.error.fatal", false);
    }

    private static boolean isProcessingTextMarkup(RenderRequest renderRequest) {
        Boolean bl = renderRequest.getProcessStylesInText();
        if (bl == null) {
            return DocumentProcessor.defaultProcessTextMarkup();
        }
        return Boolean.TRUE.equals(bl);
    }

    private static boolean defaultProcessTextMarkup() {
        return DMProperties.getBoolean("docmosis.populator.field.markup.process", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void example1() throws IOException, ProcessingException, TemplateStoreException, ConversionException, NoConvertersRunningException {
        SystemManager.initialise();
        try {
            DataProviderBuilder dataProviderBuilder = new DataProviderBuilder();
            dataProviderBuilder.add("name", "James");
            dataProviderBuilder.add("state", "CA");
            DocumentProcessor.renderDoc(new File("myTemplate.docx"), new File("myResult.pdf"), dataProviderBuilder.getDataProvider(), ExternalResourcePermissions.NONE);
        }
        finally {
            SystemManager.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void example2() throws IOException, ConversionException, TemplateStoreException, NoConvertersRunningException, ProcessingException {
        SystemManager.initialise();
        try {
            TemplateStore templateStore = TemplateStoreFactory.getStore();
            TemplateDetails templateDetails = StoreHelper.storeTemplate("FirstTest", new File("c:/docs/testDoc.docx"), templateStore);
            DataProviderBuilder dataProviderBuilder = new DataProviderBuilder();
            dataProviderBuilder.add("Name", "Person Alpha");
            dataProviderBuilder.add("Addr", "10 The Pond, Froggsville");
            dataProviderBuilder.add("DOB", "16 Mar 2002");
            dataProviderBuilder.add("dateReported", "10/3/07");
            dataProviderBuilder.add("recordNumber", "1638.4");
            ConversionInstruction conversionInstruction = new ConversionInstruction();
            conversionInstruction.setConversionFormats(new ConversionFormat[]{ConversionFormat.FORMAT_PDF, ConversionFormat.FORMAT_WORD});
            conversionInstruction.setOutputFileName("testResult");
            FileOutputStream fileOutputStream = null;
            try {
                String string = "c:/docs/firstTest.zip";
                try {
                    fileOutputStream = new FileOutputStream("c:/docs/firstTest.zip");
                    DocumentProcessor.renderDoc(templateDetails, dataProviderBuilder.getDataProvider(), conversionInstruction, fileOutputStream);
                }
                catch (Throwable throwable) {
                    FileUtilities.close(fileOutputStream);
                    throw throwable;
                }
                FileUtilities.close(fileOutputStream);
            }
            catch (Throwable throwable) {
                FileUtilities.close(fileOutputStream);
                throw throwable;
            }
            FileUtilities.close(fileOutputStream);
        }
        finally {
            SystemManager.release();
        }
    }

    private static class _A {
        private boolean D;
        private boolean B;
        private boolean A;
        private String C;

        private _A(boolean bl, boolean bl2, boolean bl3, String string) {
            this.D = bl;
            this.B = bl2;
            this.A = bl3;
            this.C = string;
        }

        public static _A A(PopulatedFilesCollection.PopulatedFile populatedFile) {
            return new _A(populatedFile.isPadToEvenPageRequested(), populatedFile.isPadToOddPageRequested(), populatedFile.isNewFileRequested(), populatedFile.getNewFileName());
        }
    }
}

