/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.document;

import com.docmosis.SystemManager;
import com.docmosis.document.DocumentConversionResult;
import com.docmosis.document.ExternalResourceCollection;
import com.docmosis.document.ExternalResourceExtractor;
import com.docmosis.document.ExternalResourcePermissions;
import com.docmosis.document.ExternalResourcePermissionsCheckResult;
import com.docmosis.document.converter.ConversionException;
import com.docmosis.document.converter.ConversionFormat;
import com.docmosis.document.converter.ConversionInstruction;
import com.docmosis.document.converter.ConversionSettings;
import com.docmosis.document.converter.DocumentFormatConverter;
import com.docmosis.document.converter.pool.ConverterPool;
import com.docmosis.document.converter.pool.ConverterPoolException;
import com.docmosis.template.BasicDocument;
import com.docmosis.template.population.PopulatedFilesCollection;
import com.docmosis.template.store.StoreHelper;
import com.docmosis.util.DMProperties;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.StringUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DocumentConverter {
    private static final Logger A = LogManager.getLogger(DocumentConverter.class);
    private static final int B = DMProperties.getInt("docmosis.stream.buffer.size", 8192);

    public static DocumentConversionResult convert(File file, File[] fileArray) throws IOException, ConverterPoolException {
        if (fileArray == null || fileArray.length == 0) {
            throw new IllegalArgumentException("No output files specified");
        }
        long l = 0L;
        int n = 0;
        DocumentConversionResult documentConversionResult = null;
        for (int i = 0; i < fileArray.length; ++i) {
            documentConversionResult = DocumentConverter.convert(file, fileArray[i]);
            l += documentConversionResult.getLength();
            n += documentConversionResult.getPageCount();
        }
        return new DocumentConversionResult(l, n, documentConversionResult == null ? null : documentConversionResult.getExternalResources());
    }

    public static DocumentConversionResult convert(File file, File file2) throws IOException, ConverterPoolException {
        return DocumentConverter.convert(file, file2, null);
    }

    public static DocumentConversionResult convert(File file, File file2, ConversionInstruction conversionInstruction) throws IOException, ConverterPoolException {
        return DocumentConverter.convert(file, file2, conversionInstruction, null);
    }

    /*
     * Loose catch block
     */
    public static DocumentConversionResult convert(File file, File file2, ConversionInstruction conversionInstruction, ExternalResourcePermissions externalResourcePermissions) throws IOException, ConverterPoolException {
        boolean bl;
        boolean bl2;
        ExternalResourcePermissionsCheckResult externalResourcePermissionsCheckResult;
        if (file == null) {
            throw new IllegalArgumentException("The input file must be specified");
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException("Unable to read input file \"" + file.getName() + "\"");
        }
        if (file2 == null) {
            throw new IllegalArgumentException("The output file must be specified");
        }
        ConversionFormat conversionFormat = ConversionFormat.getFormatForFileName(file2.getName());
        if (conversionFormat == null) {
            throw new IllegalArgumentException("Cannot determine output format for file name \"" + file2.getName() + "\"");
        }
        ExternalResourceCollection externalResourceCollection = null;
        if (DMProperties.getBoolean("docmosis.analyzer.preprocessor.externalResource.extract.enabled", true)) {
            externalResourceCollection = ExternalResourceExtractor.extract(file);
        }
        if (!(externalResourcePermissionsCheckResult = ExternalResourcePermissions.permitted(externalResourcePermissions == null ? StoreHelper.getDefaultExternalResourcePermission() : externalResourcePermissions, externalResourceCollection, bl2 = DMProperties.getBoolean("docmosis.analyzer.preprocessor.externalResource.compare.caseInsensitive", true), bl = DMProperties.getBoolean("docmosis.analyzer.preprocessor.externalResource.compare.decodeUrls", true))).isPermitted()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Document contains links to non-permitted resources [").append(externalResourcePermissionsCheckResult.getFirstFailedResource()).append("]");
            throw new IOException(stringBuilder.toString());
        }
        PopulatedFilesCollection populatedFilesCollection = new PopulatedFilesCollection();
        try {
            ConversionInstruction conversionInstruction2;
            populatedFilesCollection.add(null, file, true, null, null, null);
            ConversionInstruction conversionInstruction3 = conversionInstruction2 = conversionInstruction == null ? new ConversionInstruction() : new ConversionInstruction(conversionInstruction);
            if (StringUtilities.isEmpty(conversionInstruction2.getOutputFileName())) {
                conversionInstruction2.setOutputFileName(file2.getName());
                conversionInstruction2.setConversionFormats(new ConversionFormat[]{conversionFormat});
            }
            boolean bl3 = false;
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[B];
            BasicDocument basicDocument = null;
            DocumentFormatConverter documentFormatConverter = ConverterPool.getConverter();
            try {
                basicDocument = documentFormatConverter.convert(populatedFilesCollection, conversionInstruction2, new ConversionSettings());
                FileUtilities.streamOut(basicDocument.getInputStream(), (OutputStream)fileOutputStream, byArray);
                DocumentConversionResult documentConversionResult = new DocumentConversionResult(basicDocument.getLength(), basicDocument.getDocumentPageCount(), externalResourceCollection);
                return documentConversionResult;
            }
            catch (ConversionException conversionException) {
                if (conversionException.isDueToServiceFailure()) {
                    bl3 = true;
                }
                A.error("Conversion failed :", conversionException);
                throw new IOException("Conversion failed :" + conversionException.getMessage());
            }
            finally {
                ConverterPool.returnConverter(documentFormatConverter, bl3);
                FileUtilities.close(fileOutputStream);
                BasicDocument.cleanup(basicDocument, true);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            populatedFilesCollection.cleanup();
        }
    }

    private static void printUsageAndExit() {
        System.err.println("usage: java " + DocumentConverter.class.getName() + " <infile> <outfile> [<outfile2> [<outfile3>...]]");
        System.err.println("  <infile> : the input file");
        System.err.println("  <outfile> : the file to create");
        System.err.println("  <outfile2> <outfile3>... : other files to create");
        System.err.println("Convert the given input file and store it in the given outfile(s).  The format of the result file is determined from the outfile name");
        System.exit(1);
    }

    private static _A processArgs(String[] stringArray) {
        if (stringArray == null || stringArray.length < 2) {
            DocumentConverter.printUsageAndExit();
        }
        File[] fileArray = new File[stringArray.length - 1];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i] = new File(stringArray[i + 1]);
        }
        return new _A(new File(stringArray[0]), fileArray);
    }

    public static void main(String[] stringArray) throws Exception {
        _A _A2 = DocumentConverter.processArgs(stringArray);
        File file = _A2.B;
        File[] fileArray = _A2.A;
        SystemManager.initialise();
        try {
            DocumentConverter.convert(file, fileArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            DocumentConverter.printUsageAndExit();
        }
    }

    private static class _A {
        final File B;
        final File[] A;

        public _A(File file, File[] fileArray) {
            this.B = file;
            this.A = fileArray;
        }
    }
}

