/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.converter.openoffice.sensitivitylabel;

import com.docmosis.converter.openoffice.sensitivitylabel.SensitivityLabelInjector;
import com.docmosis.template.TemplateParseException;
import com.docmosis.template.analysis.openoffice.ODFContentAnalyzer;
import com.docmosis.template.analysis.sensitivitylabel.SensitivityLabelInfo;
import com.docmosis.template.analysis.sensitivitylabel.SensitivityLabelItem;
import com.docmosis.template.analysis.sensitivitylabel.SensitivityLabelType;
import com.docmosis.util.DMProperties;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import com.docmosis.util.zip.ZipEntryProcessor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SensitivityLabelHelper {
    private static final Logger B = LogManager.getLogger(SensitivityLabelHelper.class);
    private static _B A = new _B(){

        @Override
        public boolean A(ZipEntry zipEntry) {
            String string = zipEntry.getName();
            return string.equals("word/document.xml") || string.startsWith("word/footer") || string.startsWith("word/header");
        }
    };

    public static SensitivityLabelInfo extractSensitivityLabels(File file) throws IOException {
        SensitivityLabelInfo sensitivityLabelInfo = null;
        final ArrayList arrayList = new ArrayList();
        ZipEntryProcessor zipEntryProcessor = new ZipEntryProcessor(){

            @Override
            public ZipEntryProcessor.ProcessResult process(ZipEntry zipEntry, InputStream inputStream) throws IOException {
                boolean bl = A.A(zipEntry);
                if (bl) {
                    try {
                        _C _C2 = new _C(inputStream);
                        SensitivityLabelHelper.parseSensitivityLabels(_C2, arrayList);
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                        throw new IOException(parserConfigurationException);
                    }
                    catch (SAXException sAXException) {
                        throw new IOException(sAXException);
                    }
                }
                return ZipEntryProcessor.ProcessResult.SCAN_ONLY_PROCESS_RESULT;
            }
        };
        FileUtilities.scanZip(file, zipEntryProcessor);
        if (arrayList.size() > 0) {
            sensitivityLabelInfo = new SensitivityLabelInfo(arrayList.toArray(new SensitivityLabelItem[0]));
        }
        return sensitivityLabelInfo;
    }

    private static void parseSensitivityLabels(InputStream inputStream, List<SensitivityLabelItem> list) throws ParserConfigurationException, SAXException, IOException {
        Document document;
        NodeList nodeList;
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        if (DMProperties.getBoolean("docmosis.data.xml.blockExternalEntities", true)) {
            documentBuilder.setEntityResolver(new _A());
        }
        if ((nodeList = (document = documentBuilder.parse(inputStream)).getElementsByTagName("aclsh:classification")).getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node;
                Node node2;
                Node node3 = nodeList.item(i);
                SensitivityLabelItem sensitivityLabelItem = null;
                Node node4 = node3.getParentNode();
                if (node4 != null && node4.getNodeName().equals("a:ext") && (node2 = node4.getParentNode()) != null && node2.getNodeName().equals("a:extLst") && (node = node2.getParentNode()) != null && node.getNodeName().equals("wp:docPr")) {
                    Node node5 = node.getAttributes() != null ? node.getAttributes().getNamedItem("name") : null;
                    String string = node5 != null ? node5.getNodeValue() : null;
                    String string2 = SensitivityLabelHelper.xmlNodeToString(node2);
                    if (string != null && string2 != null) {
                        sensitivityLabelItem = new SensitivityLabelItem(SensitivityLabelType.TEXTBOX, string, string2);
                    }
                }
                if (sensitivityLabelItem != null) {
                    list.add(sensitivityLabelItem);
                    continue;
                }
                B.warn("Encountered sensitivity label format not seen before.");
            }
        }
    }

    public static void insertSensitivityLabels(File file, final SensitivityLabelInfo sensitivityLabelInfo) throws IOException {
        if (sensitivityLabelInfo == null || !sensitivityLabelInfo.hasSensitivityLabels()) {
            return;
        }
        ZipEntryProcessor zipEntryProcessor = new ZipEntryProcessor(){

            @Override
            public ZipEntryProcessor.ProcessResult process(ZipEntry zipEntry, InputStream inputStream) throws IOException {
                File file;
                boolean bl = A.A(zipEntry);
                ZipEntryProcessor.ProcessResult.ResultAction resultAction = ZipEntryProcessor.ProcessResult.ResultAction.NO_CHANGE;
                FileInputStream fileInputStream = null;
                Runnable runnable = null;
                if (bl && (file = SensitivityLabelHelper.injectSensitivityLabels(inputStream, sensitivityLabelInfo.getSensitivityLabels())) != null) {
                    fileInputStream = new FileInputStream(file);
                    resultAction = ZipEntryProcessor.ProcessResult.ResultAction.UPDATE;
                    final FileInputStream fileInputStream2 = fileInputStream;
                    runnable = new Runnable(){

                        @Override
                        public void run() {
                            FileUtilities.close(fileInputStream2);
                            FileUtilities.delete(file);
                        }
                    };
                }
                return new ZipEntryProcessor.ProcessResult(resultAction, fileInputStream, runnable);
            }
        };
        FileUtilities.updateZip(file, zipEntryProcessor);
    }

    private static File injectSensitivityLabels(InputStream inputStream, SensitivityLabelItem[] sensitivityLabelItemArray) throws IOException {
        SensitivityLabelInjector sensitivityLabelInjector = new SensitivityLabelInjector(sensitivityLabelItemArray);
        ODFContentAnalyzer.XMLStreamReader xMLStreamReader = new ODFContentAnalyzer.XMLStreamReader();
        File file = FileUtilities.createTempFile("dms", "senslbl");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        try {
            sensitivityLabelInjector.setWriter(outputStreamWriter);
            xMLStreamReader.process(inputStream, sensitivityLabelInjector);
        }
        catch (TemplateParseException templateParseException) {
            throw new IOException(templateParseException);
        }
        finally {
            FileUtilities.close(outputStreamWriter);
        }
        return file;
    }

    private static String xmlNodeToString(Node node) {
        StringWriter stringWriter = new StringWriter();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "no");
            transformer.transform(new DOMSource(node), new StreamResult(stringWriter));
        }
        catch (TransformerException transformerException) {
            B.warn("Failed to convert node to string");
            return null;
        }
        return stringWriter.toString();
    }

    private static interface _B {
        public boolean A(ZipEntry var1);
    }

    private static class _A
    implements EntityResolver {
        private _A() {
        }

        @Override
        public InputSource resolveEntity(String string, String string2) {
            B.warn("XML external entity resolution ignored:[" + string + "],[" + string2 + "]");
            InputSource inputSource = new InputSource(new ByteArrayInputStream("".getBytes()));
            return inputSource;
        }
    }

    private static class _C
    extends FilterInputStream {
        private _C(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

