/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.converter.openoffice;

import com.docmosis.converter.openoffice.AbstractOpenOfficeConnection;
import com.docmosis.converter.openoffice.OOUtilities;
import com.docmosis.document.converter.ConversionException;
import com.docmosis.util.DMProperties;
import com.docmosis.util.EngineVersion;
import com.docmosis.util.EngineVersionExtractor;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.io.IOException;
import java.util.List;

public class RemoteOpenOfficeConnection
extends AbstractOpenOfficeConnection {
    private static final Logger J = LogManager.getLogger(RemoteOpenOfficeConnection.class);
    private XComponentContext H;
    private XComponentLoader G;
    private EngineVersion I;

    public RemoteOpenOfficeConnection(String string, int n) throws ConversionException {
        String string2 = "uno:socket,host=" + string + ",port=" + n + ";urp;StarOffice.ServiceManager";
        try {
            this.H = Bootstrap.createInitialComponentContext(null);
            XMultiComponentFactory xMultiComponentFactory = this.H.getServiceManager();
            Object object = xMultiComponentFactory.createInstanceWithContext("com.sun.star.bridge.UnoUrlResolver", this.H);
            XUnoUrlResolver xUnoUrlResolver = (XUnoUrlResolver)UnoRuntime.queryInterface(XUnoUrlResolver.class, (Object)object);
            Object object2 = xUnoUrlResolver.resolve(string2);
            if (null != object2) {
                J.debug("initial object successfully retrieved");
            } else {
                J.error("given initial-object name unknown at server side");
            }
            XMultiComponentFactory xMultiComponentFactory2 = (XMultiComponentFactory)UnoRuntime.queryInterface(XMultiComponentFactory.class, (Object)object2);
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMultiComponentFactory2);
            Object object3 = xPropertySet.getPropertyValue("DefaultContext");
            XComponentContext xComponentContext = (XComponentContext)UnoRuntime.queryInterface(XComponentContext.class, (Object)object3);
            Object object4 = xMultiComponentFactory2.createInstanceWithContext("com.sun.star.frame.Desktop", xComponentContext);
            this.G = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)object4);
            String string3 = null;
            try {
                string3 = this.getOfficeVersionNumber();
            }
            catch (com.sun.star.uno.Exception exception) {
                J.warn("Unable to determine engine version info.  IO error:" + exception.getMessage());
            }
            try {
                this.I = new EngineVersionExtractor().getEngineVersionInfo(string3);
            }
            catch (IllegalStateException illegalStateException) {
                J.warn("Unable to determine engine version info.  Docmosis not initialized");
            }
            catch (IOException iOException) {
                J.warn("Unable to determine engine version info.  IO error:" + iOException.getMessage());
            }
        }
        catch (Exception exception) {
            throw new ConversionException("Error creating open office connection to " + string2, exception);
        }
    }

    @Override
    protected XComponentContext getComponentContext() {
        return this.H;
    }

    @Override
    protected XComponentLoader getComponentLoader() {
        return this.G;
    }

    private String getOfficeVersionNumber() throws com.sun.star.uno.Exception {
        String string = null;
        String[] stringArray = DMProperties.getStringArray("docmosis.openoffice.bootstrap.connection.properties.log.versionPropertiesSearch", ";");
        List<String> list = OOUtilities.getConfigurationSettings(this.H, stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (list.get(i) == null) continue;
            string = list.get(i);
            break;
        }
        return string;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.G = null;
    }

    @Override
    public EngineVersion getEngineVersionInfo() {
        return this.I;
    }
}

