/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.converter.openoffice;

import com.docmosis.document.converter.ConversionException;
import com.docmosis.util.DMProperties;
import com.docmosis.util.StringUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class OpenOfficeServerLauncher {
    public static final int CONNECT_TYPE_PIPE = 1;
    public static final int CONNECT_TYPE_SOCKET = 2;
    public static final String PROPERTY_OFFICE_LOCATION = "docmosis.openoffice.location";
    private static final Logger B = LogManager.getLogger(OpenOfficeServerLauncher.class);
    private static final String D = "com.docmosis.util.openoffice.OpenOfficeLibraryLoader";
    private static final boolean C = DMProperties.getBoolean("docmosis.converter.engine.launchParams.doubleDash.enabled", true);
    private static final String A = DMProperties.getString("docmosis.converter.engine.launchParams.doubleDash.pathContains");
    private static final String[] E = DMProperties.getStringArray(new String[]{"docmosis.converter.engine.messages.safelyIgnoreInfixesBase", "docmosis.converter.engine.messages.safelyIgnoreInfixes"}, ";");

    private OpenOfficeServerLauncher() {
    }

    public static final NonBlockingProcess createPipeInstance(File file, String string, String string2) throws ConversionException {
        return OpenOfficeServerLauncher.createInstance(file, 1, string, string2);
    }

    public static final NonBlockingProcess createSocketInstance(File file, int n, String string) throws ConversionException {
        return OpenOfficeServerLauncher.createInstance(file, 2, Integer.toString(n), string);
    }

    private static final NonBlockingProcess createInstance(File file, int n, String string, String string2) throws ConversionException {
        if (2 != n && 1 != n) {
            throw new IllegalArgumentException("Invalid connect type");
        }
        if (!file.exists()) {
            throw new ConversionException("Cannot find Open Office:" + file.getPath() + ". Please check your setting for " + "\"docmosis.openoffice.location\" (currently \"" + DMProperties.getString(PROPERTY_OFFICE_LOCATION) + "\").");
        }
        String[] stringArray = OpenOfficeServerLauncher.getServerCommand(file, n, string, string2);
        if (B.isDebugEnabled()) {
            B.debug("------------------");
            B.debug(OpenOfficeServerLauncher.serverCommandToString(stringArray));
            B.debug("------------------");
        }
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(stringArray);
            IOThread iOThread = OpenOfficeServerLauncher.pipe(process.getInputStream(), System.out, "process out> ");
            IOThread iOThread2 = OpenOfficeServerLauncher.pipe(process.getErrorStream(), System.err, "process err> ");
            return new NonBlockingProcess(process, iOThread, iOThread2);
        }
        catch (IOException iOException) {
            throw new ConversionException(iOException);
        }
    }

    private static final String serverCommandToString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private static final String[] getServerCommand(File file, int n, String string, String string2) throws ConversionException {
        String[] stringArray;
        boolean bl = !StringUtilities.isEmpty(A) && file.getPath().toLowerCase().indexOf(A.toLowerCase()) != -1;
        String string3 = "-";
        if (C) {
            if (StringUtilities.isEmpty(A) || "null".equalsIgnoreCase(A)) {
                string3 = "--";
            } else if (bl) {
                string3 = "--";
            }
        }
        if (B.isDebugEnabled()) {
            B.debug("LibreOffice detected:" + bl);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(file.getPath());
        arrayList.add(OpenOfficeServerLauncher.createAcceptString(n, string, string3));
        arrayList.add(string3 + "norestore");
        arrayList.add(string3 + "nologo");
        arrayList.add(string3 + "nolockcheck");
        arrayList.add(string3 + "nodefault");
        arrayList.add(string3 + "nofirststartwizard");
        arrayList.add("-env:UserInstallation=" + string2);
        String string4 = DMProperties.getString("docmosis.converter.launch.args");
        if (string4 != null && !"".equals(string4)) {
            stringArray = new StringTokenizer(string4);
            while (stringArray.hasMoreTokens()) {
                String string5 = stringArray.nextToken();
                arrayList.add(string3 + string5);
            }
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private static final String createAcceptString(int n, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string2 + "accept=");
        if (n == 2) {
            stringBuffer.append("socket,host=127.0.0.1,port=");
        } else if (n == 1) {
            stringBuffer.append("pipe,name=");
        }
        stringBuffer.append(string);
        stringBuffer.append(";urp;");
        return stringBuffer.toString();
    }

    private static final IOThread pipe(InputStream inputStream, PrintStream printStream, final String string) {
        final BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        IOThread iOThread = new IOThread("OO Connection Pipe: " + string, bufferedReader){

            @Override
            public void run() {
                try {
                    while (true) {
                        if (bufferedReader.ready()) {
                            String string2 = bufferedReader.readLine();
                            if (string2 != null) {
                                if (((IOThread)Thread.currentThread()).B || OpenOfficeServerLauncher.isProcessOutputToIgnore(string2)) continue;
                                B.info(string + string2);
                                continue;
                            }
                            break;
                        }
                        Thread.sleep(50L);
                    }
                }
                catch (IOException iOException) {
                    if (!((IOThread)Thread.currentThread()).B) {
                        B.error("Error launching process", iOException);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        iOThread.setDaemon(true);
        iOThread.start();
        return iOThread;
    }

    private static boolean isProcessOutputToIgnore(String string) {
        boolean bl = false;
        if (E != null && string != null) {
            for (int i = 0; i < E.length; ++i) {
                if (string.indexOf(E[i]) == -1) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    static {
        try {
            Class.forName(D);
        }
        catch (ClassNotFoundException classNotFoundException) {
            B.error("Unable to load the class : com.docmosis.util.openoffice.OpenOfficeLibraryLoader", classNotFoundException);
        }
    }

    public static final class NonBlockingProcess {
        private final Process B;
        private final IOThread A;
        private final IOThread C;

        public NonBlockingProcess(Process process, IOThread iOThread, IOThread iOThread2) {
            this.B = process;
            this.A = iOThread;
            this.C = iOThread2;
        }

        public void goSilent() {
            if (this.A != null) {
                this.A.goSilent(true);
            }
            if (this.C != null) {
                this.C.goSilent(true);
            }
        }

        public void destroy() {
            if (this.B != null) {
                this.B.destroy();
                try {
                    this.B.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    B.warn("interrupted whilst waiting for process to shutdown", interruptedException);
                }
            }
            if (this.A != null) {
                this.A.interrupt();
                this.A.shutdown();
            }
            if (this.C != null) {
                this.C.interrupt();
                this.C.shutdown();
            }
        }
    }

    public static class IOThread
    extends Thread {
        private boolean B = false;
        private final Reader A;

        public IOThread(String string, Reader reader) {
            super(string);
            this.A = reader;
        }

        public void goSilent(boolean bl) {
            this.B = bl;
        }

        public void shutdown() {
            if (this.A != null) {
                try {
                    this.A.close();
                }
                catch (IOException iOException) {
                    B.warn("Non-critical IO problem closing stream", iOException);
                }
            }
        }
    }
}

