/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.converter.openoffice;

import com.docmosis.document.converter.ConversionDataTask;
import com.docmosis.document.converter.ConversionException;
import com.docmosis.document.converter.ConversionInstruction;
import com.docmosis.document.converter.DocumentFormatConverter;
import com.docmosis.document.converter.pool.ConverterPool;
import com.docmosis.document.converter.pool.ConverterPoolException;
import com.docmosis.template.BasicDocument;
import com.docmosis.util.DMProperties;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import com.docmosis.util.pipeline.DataTask;
import com.docmosis.util.pipeline.InvalidDataTaskException;
import com.docmosis.util.pipeline.TaskException;
import com.docmosis.util.pipeline.impl.BasicStreamDataWorker;
import java.io.IOException;

public class OpenOfficeConversionWorker
extends BasicStreamDataWorker {
    private static final Logger N = LogManager.getLogger(OpenOfficeConversionWorker.class);

    @Override
    protected void validateDataTask(DataTask dataTask) throws InvalidDataTaskException {
        if (!(dataTask instanceof ConversionDataTask)) {
            throw new InvalidDataTaskException("The data task INPUT channel must be a ConversionDataTask");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void processTask(DataTask dataTask) throws IOException, TaskException {
        Object object;
        ConversionDataTask conversionDataTask = (ConversionDataTask)dataTask;
        DocumentFormatConverter documentFormatConverter = null;
        BasicDocument basicDocument = null;
        boolean bl = false;
        try {
            object = conversionDataTask.getConversionInstruction();
            documentFormatConverter = ConverterPool.getConverter(((ConversionInstruction)object).getConverterGroupName());
            try {
                basicDocument = documentFormatConverter.convert(conversionDataTask.getFilesToConvert(), (ConversionInstruction)object, conversionDataTask.getConversionSettings());
            }
            finally {
                if (!DMProperties.getBoolean("docmosis.populator.file.preserveGenerated", false)) {
                    conversionDataTask.getFilesToConvert().cleanup();
                } else {
                    N.info("The following files have been preserved:" + conversionDataTask.getFilesToConvert().toString());
                }
            }
            if (basicDocument != null) {
                FileUtilities.streamOut(basicDocument.getInputStream(), conversionDataTask.getOutputStream(), this.buffer);
            }
            conversionDataTask.setResult(basicDocument);
        }
        catch (ConversionException conversionException) {
            try {
                if (!conversionException.isDueToServiceFailure()) throw new TaskException("Conversion Failed: " + conversionException.getMessage(), conversionException);
                bl = true;
                throw new TaskException("Conversion Failed: " + conversionException.getMessage(), conversionException);
                catch (ConverterPoolException converterPoolException) {
                    throw new TaskException("Conversion Failed: " + converterPoolException.getMessage(), converterPoolException);
                }
            }
            catch (Throwable throwable) {
                ConverterPool.returnConverter(documentFormatConverter, bl);
                String string = "docmosis.converter.cleanup.enabled";
                if (!DMProperties.getBoolean("docmosis.converter.cleanup.enabled", true)) throw throwable;
                BasicDocument.cleanup(basicDocument, true);
                throw throwable;
            }
        }
        ConverterPool.returnConverter(documentFormatConverter, bl);
        object = "docmosis.converter.cleanup.enabled";
        if (!DMProperties.getBoolean("docmosis.converter.cleanup.enabled", true)) return;
        BasicDocument.cleanup(basicDocument, true);
    }

    @Override
    protected String getModuleTimingId() {
        return "Conversion";
    }
}

