/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.converter.openoffice;

import com.docmosis.converter.openoffice.BadDocumentException;
import com.docmosis.converter.openoffice.BadDocumentLocationException;
import com.docmosis.converter.openoffice.BadFormatException;
import com.docmosis.converter.openoffice.DocmosisDocumentEventListener;
import com.docmosis.converter.openoffice.FormatStrings;
import com.docmosis.converter.openoffice.OODocumentHandle;
import com.docmosis.converter.openoffice.ServiceUnavailableException;
import com.docmosis.document.converter.ConversionFormat;
import com.docmosis.document.converter.ConversionInstruction;
import com.docmosis.template.analysis.fontmapping.FontInfo;
import com.docmosis.template.analysis.openoffice.fontmapping.FontInfoExtractor;
import com.docmosis.template.analysis.openoffice.fontmapping.FontInfoExtractorException;
import com.docmosis.template.analysis.openoffice.fontmapping.FontInfoExtractorFactory;
import com.docmosis.util.DMProperties;
import com.docmosis.util.EngineVersion;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.StringUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XContentEnumerationAccess;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.document.XDocumentInsertable;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XController;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XTypeProvider;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.sheet.XUsedAreaCursor;
import com.sun.star.style.XStyle;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.table.XCell;
import com.sun.star.table.XColumnRowRange;
import com.sun.star.task.ErrorCodeIOException;
import com.sun.star.text.XBookmarksSupplier;
import com.sun.star.text.XDocumentIndex;
import com.sun.star.text.XDocumentIndexesSupplier;
import com.sun.star.text.XParagraphCursor;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextFieldsSupplier;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextRangeCompare;
import com.sun.star.text.XTextTable;
import com.sun.star.uno.Any;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XChangesBatch;
import com.sun.star.util.XCloseable;
import com.sun.star.util.XRefreshable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OOUtilities {
    private static final Logger G = LogManager.getLogger(OOUtilities.class);
    private static final boolean L = DMProperties.getBoolean("docmosis.populator.html.injection.stripTrailingPara", true);
    private static final boolean P = DMProperties.getBoolean("docmosis.converter.file.load.autorefresh", true);
    private static final boolean H = DMProperties.getBoolean("docmosis.converter.events.load.autorefresh.events.awaitEvents", true);
    private static final long I = DMProperties.getLong("docmosis.converter.events.load.autorefresh.events.checkDelayMs", 30L);
    private static final long M = DMProperties.getLong("docmosis.converter.events.load.autorefresh.events.maxWaitMs", 2000L);
    private static final boolean Q = DMProperties.getBoolean("docmosis.converter.events.load.events.awaitEvents", true);
    private static final long D = DMProperties.getLong("docmosis.converter.events.load.events.checkDelayMs", 30L);
    private static final long B = DMProperties.getLong("docmosis.converter.events.load.events.maxWaitMs", 2000L);
    private static final boolean A = DMProperties.getBoolean("docmosis.converter.updateFields", true);
    private static final String O = DMProperties.getString("docmosis.converter.file.insert.repairSequence.chars", "repair2\n");
    private static final boolean J = DMProperties.getBoolean("docmosis.converter.file.insert.repairNumbered.enabled", true);
    private static final String F = "docmosis.converter.file.insert.events.minEngineVersion";
    private static final String R = DMProperties.getString("docmosis.converter.file.insert.events.minEngineVersion");
    private static final long K = DMProperties.getLong("docmosis.converter.file.insert.events.checkDelayMs", 30L);
    private static final long C = DMProperties.getLong("docmosis.converter.file.insert.events.maxWaitMs", 2000L);
    private static final String N = "docmosis.converter.format.txt.encoded.settings";
    private static final String E = "docmosis.converter.format.txt.encoded.stripBOM";

    public static OODocumentHandle loadDoc(XComponentContext xComponentContext, XComponentLoader xComponentLoader, String string, boolean bl, EngineVersion engineVersion) throws ServiceUnavailableException, BadDocumentException, BadDocumentLocationException {
        return OOUtilities.loadDoc(xComponentContext, xComponentLoader, string, null, bl, engineVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OODocumentHandle loadDoc(XComponentContext xComponentContext, XComponentLoader xComponentLoader, String string, Map map, boolean bl, EngineVersion engineVersion) throws ServiceUnavailableException, BadDocumentException, BadDocumentLocationException {
        boolean bl2 = DMProperties.getBoolean("docmosis.converter.file.load.autorepair");
        boolean bl3 = DMProperties.getBoolean("docmosis.converter.file.load.readOnly");
        boolean bl4 = DMProperties.getBoolean("docmosis.converter.file.load.disableMacros");
        boolean bl5 = DMProperties.getBoolean("docmosis.converter.file.load.workVisibly", false);
        boolean bl6 = DMProperties.getBoolean("docmosis.converter.file.load.fontExtractionEnabled", true);
        try {
            XComponent xComponent;
            FontInfo fontInfo;
            block21: {
                ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
                PropertyValue propertyValue = new PropertyValue();
                propertyValue.Name = "Hidden";
                propertyValue.Value = bl5 ? Boolean.FALSE : Boolean.TRUE;
                arrayList.add(propertyValue);
                if (bl3) {
                    propertyValue = new PropertyValue();
                    propertyValue.Name = "ReadOnly";
                    propertyValue.Value = Boolean.TRUE;
                    arrayList.add(propertyValue);
                }
                if (bl2) {
                    propertyValue = new PropertyValue();
                    propertyValue.Name = "RepairPackage";
                    propertyValue.Value = Boolean.TRUE;
                    arrayList.add(propertyValue);
                }
                if (bl4) {
                    propertyValue = new PropertyValue();
                    propertyValue.Name = "MacroExecutionMode";
                    propertyValue.Value = new Short(0);
                    arrayList.add(propertyValue);
                }
                if (map != null) {
                    OOUtilities.addProperties(arrayList, map);
                }
                FontInfoExtractor fontInfoExtractor = FontInfoExtractorFactory.getDummyImpl();
                if (bl6 && bl) {
                    fontInfoExtractor = FontInfoExtractorFactory.getImpl(xComponentContext, engineVersion);
                }
                fontInfo = null;
                xComponent = null;
                fontInfoExtractor.start();
                try {
                    Object object;
                    PropertyValue[] propertyValueArray = new PropertyValue[arrayList.size()];
                    arrayList.toArray(propertyValueArray);
                    xComponent = xComponentLoader.loadComponentFromURL(string, "_blank", 0, propertyValueArray);
                    if (Q) {
                        object = null;
                        try {
                            object = new DocmosisDocumentEventListener("loadDoc1", D, B, xComponent);
                            DocmosisDocumentEventListener.awaitLayout((DocmosisDocumentEventListener)object);
                        }
                        catch (Throwable throwable) {
                            DocmosisDocumentEventListener.cleanup(object);
                            throw throwable;
                        }
                        DocmosisDocumentEventListener.cleanup((DocmosisDocumentEventListener)object);
                    }
                    if (!P || (object = (XRefreshable)UnoRuntime.queryInterface(XRefreshable.class, (Object)xComponent)) == null) break block21;
                    DocmosisDocumentEventListener docmosisDocumentEventListener = null;
                    try {
                        if (H) {
                            docmosisDocumentEventListener = new DocmosisDocumentEventListener("refresh1", I, M, xComponent);
                        }
                        object.refresh();
                        DocmosisDocumentEventListener.awaitRefresh(docmosisDocumentEventListener);
                    }
                    finally {
                        DocmosisDocumentEventListener.cleanup(docmosisDocumentEventListener);
                    }
                }
                finally {
                    fontInfo = fontInfoExtractor.stop();
                }
            }
            return new OODocumentHandle(xComponent, fontInfo, xComponentContext);
        }
        catch (com.sun.star.io.IOException iOException) {
            throw new BadDocumentLocationException("Unexpected error from Open Office", iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BadDocumentException("Unexpected error from Open Office", illegalArgumentException);
        }
        catch (com.sun.star.uno.RuntimeException runtimeException) {
            throw new ServiceUnavailableException("Unexpected error from Open Office", runtimeException);
        }
        catch (FontInfoExtractorException fontInfoExtractorException) {
            throw new ServiceUnavailableException("Unnable to execute font mapping", fontInfoExtractorException);
        }
    }

    public static void storeDocComponent(XComponent xComponent, XComponentContext xComponentContext, String string, ConversionFormat conversionFormat) throws ServiceUnavailableException, BadFormatException, com.sun.star.uno.Exception {
        OOUtilities.storeDocComponent(xComponent, xComponentContext, string, conversionFormat, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void storeDocComponent(XComponent xComponent, XComponentContext xComponentContext, String string, ConversionFormat conversionFormat, Map map) throws ServiceUnavailableException, BadFormatException, com.sun.star.uno.Exception {
        Boolean bl;
        Object object;
        XStorable xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)xComponent);
        boolean bl2 = false;
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.Name = "Overwrite";
        propertyValue.Value = Boolean.TRUE;
        arrayList.add(propertyValue);
        propertyValue = new PropertyValue();
        propertyValue.Name = "FilterName";
        propertyValue.Value = FormatStrings.getFormatString(conversionFormat);
        arrayList.add(propertyValue);
        if (conversionFormat.equals(ConversionFormat.FORMAT_TEXT) && FormatStrings.outputEncodedText() && !StringUtilities.isEmpty((String)(object = DMProperties.getString(N)))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "FilterOptions";
            propertyValue.Value = object;
            boolean bl3 = DMProperties.getBoolean(E, ((String)object).startsWith("UTF8"));
            if (bl3) {
                bl2 = true;
            }
            arrayList.add(propertyValue);
        }
        object = null;
        if (map != null) {
            Boolean bl4;
            if (map.containsKey(ConversionInstruction.OfficeEngineProperties.WORD_TEXT_HIGHLIGHTING) && (bl4 = (Boolean)map.get(ConversionInstruction.OfficeEngineProperties.WORD_TEXT_HIGHLIGHTING)) != null) {
                object = bl4;
            }
            if (conversionFormat.equals(ConversionFormat.FORMAT_PDF)) {
                propertyValue = new PropertyValue();
                propertyValue.Name = "FilterData";
                propertyValue.Value = OOUtilities.getFilterDataProperties(conversionFormat, map);
                arrayList.add(propertyValue);
            } else if (conversionFormat.equals(ConversionFormat.FORMAT_WORD)) {
                OOUtilities.addProperties(arrayList, map);
            }
        }
        PropertyValue[] propertyValueArray = new PropertyValue[arrayList.size()];
        arrayList.toArray(propertyValueArray);
        if (xStorable == null) throw new ServiceUnavailableException("Error storing document: " + string);
        boolean bl5 = OOUtilities.setMsExportTextHighlighting((Boolean)object, xComponentContext);
        try {
            xStorable.storeToURL(string, propertyValueArray);
            if (bl2) {
                FileUtilities.stripByteOrderMark(new File(new URL(string).getFile()));
            }
            if (!bl5) return;
            bl = object == null ? null : Boolean.valueOf(Boolean.FALSE.equals(object));
        }
        catch (ErrorCodeIOException errorCodeIOException) {
            try {
                if (2074 != errorCodeIOException.ErrCode) throw new ServiceUnavailableException("Error saving " + conversionFormat.getFormatName() + " [" + errorCodeIOException.ErrCode + "]", errorCodeIOException);
                throw new BadFormatException("Error saving: format not supported:" + conversionFormat.getFormatName(), errorCodeIOException);
                catch (com.sun.star.io.IOException iOException) {
                    throw new ServiceUnavailableException("Error storing document", iOException);
                }
                catch (IOException iOException) {
                    throw new ServiceUnavailableException("Error storing document", iOException);
                }
            }
            catch (Throwable throwable) {
                if (!bl5) throw throwable;
                Boolean bl6 = object == null ? null : Boolean.valueOf(Boolean.FALSE.equals(object));
                try {
                    OOUtilities.setMsExportTextHighlighting(bl6, xComponentContext);
                    throw throwable;
                }
                catch (com.sun.star.uno.Exception exception) {
                    G.warn("Unable to reverse text hightlight setting:" + exception.getMessage());
                }
                throw throwable;
            }
        }
        Boolean bl7 = bl;
        try {
            OOUtilities.setMsExportTextHighlighting(bl7, xComponentContext);
            return;
        }
        catch (com.sun.star.uno.Exception exception) {
            G.warn("Unable to reverse text hightlight setting:" + exception.getMessage());
            return;
        }
    }

    private static boolean setMsExportTextHighlighting(Boolean bl, XComponentContext xComponentContext) throws com.sun.star.uno.Exception {
        Boolean bl2;
        boolean bl3 = false;
        if (bl == null) {
            return bl3;
        }
        XMultiComponentFactory xMultiComponentFactory = xComponentContext.getServiceManager();
        String string = "com.sun.star.configuration.ConfigurationProvider";
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xMultiComponentFactory.createInstanceWithContext(string, xComponentContext));
        String string2 = "com.sun.star.configuration.ConfigurationUpdateAccess";
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.Name = "nodepath";
        propertyValue.Value = "org.openoffice.Office.Common/Filter/Microsoft/Export";
        Object[] objectArray = new Object[]{propertyValue};
        Object object = xMultiServiceFactory.createInstanceWithArguments(string2, objectArray);
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object);
        if (xPropertySet != null && !bl.equals(bl2 = Boolean.valueOf(Boolean.TRUE.equals(xPropertySet.getPropertyValue("CharBackgroundToHighlighting"))))) {
            xPropertySet.setPropertyValue("CharBackgroundToHighlighting", (Object)bl);
            XChangesBatch xChangesBatch = (XChangesBatch)UnoRuntime.queryInterface(XChangesBatch.class, (Object)object);
            xChangesBatch.commitChanges();
            bl3 = true;
        }
        return bl3;
    }

    private static void addProperties(List list, Map map) {
        if (map != null) {
            for (String string : map.keySet()) {
                PropertyValue propertyValue = new PropertyValue();
                propertyValue.Name = string;
                propertyValue.Value = map.get(string);
                list.add(propertyValue);
            }
        }
    }

    private static PropertyValue[] getFilterDataProperties(ConversionFormat conversionFormat, Map map) {
        PropertyValue[] propertyValueArray = null;
        if (map != null) {
            propertyValueArray = new PropertyValue[map.size()];
            Iterator iterator = map.keySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                propertyValueArray[n] = new PropertyValue();
                propertyValueArray[n].Name = string;
                propertyValueArray[n].Value = map.get(string);
                ++n;
            }
        }
        return propertyValueArray;
    }

    public static void updateTOC(XComponent xComponent) throws ServiceUnavailableException {
        XRefreshable xRefreshable;
        XEnumerationAccess xEnumerationAccess;
        XTextFieldsSupplier xTextFieldsSupplier;
        if (A && (xTextFieldsSupplier = (XTextFieldsSupplier)UnoRuntime.queryInterface(XTextFieldsSupplier.class, (Object)xComponent)) != null && (xEnumerationAccess = xTextFieldsSupplier.getTextFields()) != null && (xRefreshable = (XRefreshable)UnoRuntime.queryInterface(XRefreshable.class, (Object)xEnumerationAccess)) != null) {
            xRefreshable.refresh();
        }
        xTextFieldsSupplier = null;
        xEnumerationAccess = null;
        try {
            xTextFieldsSupplier = (XDocumentIndexesSupplier)UnoRuntime.queryInterface(XDocumentIndexesSupplier.class, (Object)xComponent);
            if (xTextFieldsSupplier == null) {
                return;
            }
            xEnumerationAccess = xTextFieldsSupplier.getDocumentIndexes();
            for (int i = 0; i < 2; ++i) {
                int n = xEnumerationAccess.getCount();
                if (n <= 0) continue;
                for (int j = 0; j < n; ++j) {
                    Object object = xEnumerationAccess.getByIndex(j);
                    if (object == null) continue;
                    XDocumentIndex xDocumentIndex = (XDocumentIndex)UnoRuntime.queryInterface(XDocumentIndex.class, (Object)object);
                    xDocumentIndex.update();
                    ((XRefreshable)UnoRuntime.queryInterface(XRefreshable.class, (Object)xComponent)).refresh();
                }
            }
        }
        catch (WrappedTargetException wrappedTargetException) {
            throw new ServiceUnavailableException("Error updating TOC", wrappedTargetException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ServiceUnavailableException("Error updating TOC", indexOutOfBoundsException);
        }
        catch (com.sun.star.uno.RuntimeException runtimeException) {
            throw new ServiceUnavailableException("Unexpected error from Open Office", runtimeException);
        }
    }

    public static void closeDoc(XComponent xComponent) throws ServiceUnavailableException {
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xComponent);
        try {
            if (xModel != null) {
                XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)xModel);
                if (xCloseable != null) {
                    try {
                        xCloseable.close(false);
                    }
                    catch (CloseVetoException closeVetoException) {
                        G.warn("Document close was vetoed", closeVetoException);
                    }
                } else {
                    XComponent xComponent2 = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xModel);
                    xComponent2.dispose();
                }
            }
        }
        catch (com.sun.star.uno.RuntimeException runtimeException) {
            throw new ServiceUnavailableException("Unexpected error from Open Office", runtimeException);
        }
    }

    public static String getPlainText(XComponent xComponent) throws ServiceUnavailableException {
        try {
            XTextDocument xTextDocument = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)xComponent);
            XText xText = xTextDocument.getText();
            XTextCursor xTextCursor = xText.createTextCursor();
            xTextCursor.gotoStart(false);
            xTextCursor.gotoEnd(true);
            return xTextCursor.getString();
        }
        catch (com.sun.star.uno.RuntimeException runtimeException) {
            throw new ServiceUnavailableException("Unexpected error from Open Office", runtimeException);
        }
    }

    static void dumpOOTypeInterfaces(Object object) {
        Object object2 = UnoRuntime.queryInterface(XTypeProvider.class, (Object)object);
        if (object2 != null) {
            Type[] typeArray = ((XTypeProvider)object2).getTypes();
            for (int i = 0; i < typeArray.length; ++i) {
                System.out.println("SUPPORTS:" + typeArray[i].getTypeName());
            }
        }
    }

    static void dumpOOProperties(Object object) {
        Property[] propertyArray;
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object);
        if (xPropertySet != null && (propertyArray = xPropertySet.getPropertySetInfo().getProperties()) != null) {
            for (int i = 0; i < propertyArray.length; ++i) {
                System.out.println("Property:" + propertyArray[i].Name);
            }
        }
    }

    public static void dumpSupportedServices(Object object) {
        XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)object);
        if (xServiceInfo == null) {
            System.out.println("NO SERVICES");
        } else {
            String[] stringArray = xServiceInfo.getSupportedServiceNames();
            System.out.println(xServiceInfo.getImplementationName() + "supports:");
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println("  " + stringArray[i]);
            }
        }
    }

    public static void dumpConfigurationSettings(XComponentContext xComponentContext, String string, String[] stringArray, String[] stringArray2) throws Exception {
        block14: {
            String string2 = "com.sun.star.configuration.ConfigurationProvider";
            XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xComponentContext.getServiceManager().createInstanceWithContext("com.sun.star.configuration.ConfigurationProvider", xComponentContext));
            if (xMultiServiceFactory != null) {
                String string3 = "com.sun.star.configuration.ConfigurationAccess";
                Object[] objectArray = new PropertyValue[]{new PropertyValue()};
                objectArray[0].Name = "nodepath";
                objectArray[0].Value = string == null ? "/" : string;
                try {
                    Object object = xMultiServiceFactory.createInstanceWithArguments("com.sun.star.configuration.ConfigurationAccess", objectArray);
                    XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)object);
                    String[] stringArray3 = xNameAccess.getElementNames();
                    for (int i = 0; i < stringArray3.length; ++i) {
                        int n;
                        String string4;
                        int n2;
                        String string5;
                        Object object2 = xNameAccess.getByName(stringArray3[i]);
                        boolean bl = true;
                        if (stringArray != null) {
                            bl = false;
                            string5 = stringArray3[i].toLowerCase();
                            for (n2 = 0; n2 < stringArray.length; ++n2) {
                                if (string5.indexOf(stringArray[n2].toLowerCase()) == -1) continue;
                                bl = true;
                                break;
                            }
                        }
                        if (object2 instanceof String || object2 instanceof Boolean || object2 instanceof Number || object2 instanceof Character || object2 instanceof CharSequence) {
                            if (!bl) continue;
                            string5 = String.valueOf(object2);
                            n2 = 1;
                            if (stringArray2 != null) {
                                n2 = 0;
                                string4 = string5.toLowerCase();
                                for (n = 0; n < stringArray2.length; ++n) {
                                    if (string4.indexOf(stringArray2[n].toLowerCase()) == -1) continue;
                                    n2 = 1;
                                    break;
                                }
                            }
                            if (n2 == 0) continue;
                            System.out.println(string + "/" + stringArray3[i] + ": " + object2);
                            continue;
                        }
                        if (object2 instanceof String[]) {
                            if (!bl) continue;
                            string5 = Arrays.asList((String[])object2).toString();
                            n2 = 1;
                            if (stringArray2 != null) {
                                n2 = 0;
                                string4 = string5.toLowerCase();
                                for (n = 0; n < stringArray2.length; ++n) {
                                    if (string4.indexOf(stringArray2[n].toLowerCase()) == -1) continue;
                                    n2 = 1;
                                    break;
                                }
                            }
                            if (n2 == 0) continue;
                            System.out.println(string + "/" + stringArray3[i] + ": " + string5);
                            continue;
                        }
                        if (object2 instanceof Any) continue;
                        OOUtilities.dumpConfigurationSettings(xComponentContext, (string == null ? "" : string + "/") + stringArray3[i], stringArray, stringArray2);
                    }
                }
                catch (com.sun.star.uno.Exception exception) {
                    if (exception.getMessage() == null || exception.getMessage().indexOf("there is a leaf value at nodepath") == -1) {
                        throw exception;
                    }
                }
                catch (com.sun.star.uno.RuntimeException runtimeException) {
                    if (runtimeException.getMessage() != null && runtimeException.getMessage().indexOf("cannot find") != -1) break block14;
                    throw runtimeException;
                }
            }
        }
    }

    public static List<String> getConfigurationSettings(XComponentContext xComponentContext, String[] stringArray) throws com.sun.star.uno.Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray == null || stringArray.length == 0) {
            return arrayList;
        }
        String string = "com.sun.star.configuration.ConfigurationProvider";
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xComponentContext.getServiceManager().createInstanceWithContext("com.sun.star.configuration.ConfigurationProvider", xComponentContext));
        if (xMultiServiceFactory == null) {
            throw new com.sun.star.uno.Exception("Engine does not support the configuration query");
        }
        String string2 = "com.sun.star.configuration.ConfigurationAccess";
        Object[] objectArray = new PropertyValue[]{new PropertyValue()};
        objectArray[0].Name = "nodepath";
        for (int i = 0; i < stringArray.length; ++i) {
            String string3;
            String string4;
            int n = stringArray[i].lastIndexOf("/");
            if (n == -1) {
                string4 = stringArray[i];
                string3 = "";
            } else {
                string4 = stringArray[i].substring(0, n);
                string3 = stringArray[i].substring(n + 1);
            }
            objectArray[0].Value = string4;
            try {
                Object object = xMultiServiceFactory.createInstanceWithArguments("com.sun.star.configuration.ConfigurationAccess", objectArray);
                XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)object);
                Object object2 = xNameAccess.getByName(string3);
                if (object2 == null) {
                    arrayList.add(null);
                    continue;
                }
                if (object2 instanceof String || object2 instanceof Boolean || object2 instanceof Number || object2 instanceof Character || object2 instanceof CharSequence) {
                    arrayList.add(String.valueOf(object2));
                    continue;
                }
                if (object2 instanceof String[]) {
                    arrayList.add(Arrays.asList((String[])object2).toString());
                    continue;
                }
                if (object2 instanceof Any) continue;
                G.warn("Unknown result type for config param [" + string4 + "] :" + object2.getClass().getName());
                arrayList.add(null);
                continue;
            }
            catch (Exception exception) {
                if (G.isDebugEnabled()) {
                    G.warn("can't read office engine configuration setting:" + string4 + "/" + string3);
                }
                arrayList.add(null);
            }
        }
        return arrayList;
    }

    public static int getPageCount(XComponent xComponent) throws ServiceUnavailableException {
        int n = 0;
        XTextDocument xTextDocument = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)xComponent);
        if (xTextDocument != null) {
            n = OOUtilities.getPageCountDocument(xTextDocument);
        } else {
            XSpreadsheetDocument xSpreadsheetDocument = (XSpreadsheetDocument)UnoRuntime.queryInterface(XSpreadsheetDocument.class, (Object)xComponent);
            if (xSpreadsheetDocument != null) {
                n = OOUtilities.getPageCountSpreadsheet(xSpreadsheetDocument);
            } else {
                XDrawPagesSupplier xDrawPagesSupplier = (XDrawPagesSupplier)UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)xComponent);
                if (xDrawPagesSupplier != null) {
                    int n2 = n = xDrawPagesSupplier.getDrawPages() == null ? 1 : xDrawPagesSupplier.getDrawPages().getCount();
                }
            }
        }
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    public static int getPageCountDocument(XTextDocument xTextDocument) throws ServiceUnavailableException {
        try {
            XController xController = xTextDocument.getCurrentController();
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xController);
            long l = System.currentTimeMillis();
            String string = String.valueOf(xPropertySet.getPropertyValue("PageCount"));
            if (G.isDebugEnabled()) {
                G.debug("Get page count took:" + (System.currentTimeMillis() - l));
            }
            int n = Integer.parseInt(string);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            G.error("Unable to get page count", numberFormatException);
            return 0;
        }
        catch (com.sun.star.uno.RuntimeException runtimeException) {
            throw new ServiceUnavailableException("Unexpected error from Open Office", runtimeException);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            throw new ServiceUnavailableException("Unexpected error from Open Office", unknownPropertyException);
        }
        catch (WrappedTargetException wrappedTargetException) {
            throw new ServiceUnavailableException("Unexpected error from Open Office", wrappedTargetException);
        }
    }

    public static int getPageCountSpreadsheet(XSpreadsheetDocument xSpreadsheetDocument) throws ServiceUnavailableException {
        int n;
        block12: {
            n = 0;
            try {
                String[] stringArray;
                if (xSpreadsheetDocument == null) break block12;
                XSpreadsheet xSpreadsheet = null;
                XSpreadsheets xSpreadsheets = xSpreadsheetDocument.getSheets();
                String[] stringArray2 = stringArray = xSpreadsheets == null ? null : xSpreadsheets.getElementNames();
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        XSpreadsheet xSpreadsheet2 = (XSpreadsheet)UnoRuntime.queryInterface(XSpreadsheet.class, (Object)xSpreadsheets.getByName(stringArray[i]));
                        if (xSpreadsheet2 == null) continue;
                        if (i == 0) {
                            xSpreadsheet = xSpreadsheet2;
                        }
                        XUsedAreaCursor xUsedAreaCursor = (XUsedAreaCursor)UnoRuntime.queryInterface(XUsedAreaCursor.class, (Object)xSpreadsheet2.createCursor());
                        xUsedAreaCursor.gotoEndOfUsedArea(true);
                        XColumnRowRange xColumnRowRange = (XColumnRowRange)UnoRuntime.queryInterface(XColumnRowRange.class, (Object)xUsedAreaCursor);
                        int n2 = xColumnRowRange.getColumns().getCount();
                        int n3 = xColumnRowRange.getRows().getCount();
                        if (n2 > 1 || n3 > 1) {
                            ++n;
                            continue;
                        }
                        XCell xCell = null;
                        try {
                            xCell = xSpreadsheet2.getCellByPosition(0, 0);
                            if (xCell == null || StringUtilities.isEmpty(xCell.getFormula())) continue;
                            ++n;
                            continue;
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                    }
                }
                if (n != 0 || xSpreadsheet == null || !DMProperties.getBoolean("docmosis.converter.sheets.repair.injectBlankCellInBlankDocument", true)) break block12;
                try {
                    XCell xCell = xSpreadsheet.getCellByPosition(0, 0);
                    if (xCell != null) {
                        xCell.setFormula(" ");
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new ServiceUnavailableException("Unexpected error from Open Office", noSuchElementException);
            }
            catch (WrappedTargetException wrappedTargetException) {
                throw new ServiceUnavailableException("Unexpected error from Open Office", wrappedTargetException);
            }
        }
        return n == 0 ? 1 : n;
    }

    public static String getStructuredText(XComponent xComponent, String string, boolean bl) throws ServiceUnavailableException {
        try {
            XStyleFamiliesSupplier xStyleFamiliesSupplier;
            XNameAccess xNameAccess;
            XNameContainer xNameContainer;
            StringBuffer stringBuffer = new StringBuffer();
            if (bl && (xNameContainer = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)(xNameAccess = (xStyleFamiliesSupplier = (XStyleFamiliesSupplier)UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, (Object)xComponent)).getStyleFamilies()).getByName("PageStyles"))) != null) {
                String[] stringArray = xNameContainer.getElementNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    XText xText;
                    XStyle xStyle = (XStyle)UnoRuntime.queryInterface(XStyle.class, (Object)xNameContainer.getByName(stringArray[i]));
                    XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xStyle);
                    if (!xStyle.isInUse()) continue;
                    if (i == 0) {
                        // empty if block
                    }
                    String string2 = (xText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xPropertySet.getPropertyValue("HeaderText"))) == null ? "null" : xText.getString();
                    stringBuffer.append("header=" + string2).append('\n');
                    XText xText2 = (XText)UnoRuntime.queryInterface(XText.class, (Object)xPropertySet.getPropertyValue("FooterText"));
                    String string3 = xText2 == null ? "null" : xText2.getString();
                    stringBuffer.append("footer=" + string3).append('\n');
                }
            }
            xStyleFamiliesSupplier = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)xComponent);
            xNameAccess = xStyleFamiliesSupplier.getText();
            OOUtilities.getStructuredTextBody(xNameAccess, string, stringBuffer);
            return stringBuffer.toString();
        }
        catch (com.sun.star.uno.RuntimeException runtimeException) {
            throw new ServiceUnavailableException("Unexpected error from Open Office", runtimeException);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new ServiceUnavailableException("Unexpected error from Open Office", noSuchElementException);
        }
        catch (WrappedTargetException wrappedTargetException) {
            throw new ServiceUnavailableException("Unexpected error from Open Office", wrappedTargetException);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            throw new ServiceUnavailableException("Unexpected error from Open Office", unknownPropertyException);
        }
    }

    public static void getStructuredTextBody(Object object, String string, StringBuffer stringBuffer) throws NoSuchElementException, WrappedTargetException {
        XEnumerationAccess xEnumerationAccess = (XEnumerationAccess)UnoRuntime.queryInterface(XEnumerationAccess.class, (Object)object);
        if (xEnumerationAccess == null) {
            return;
        }
        XEnumeration xEnumeration = xEnumerationAccess.createEnumeration();
        while (xEnumeration.hasMoreElements()) {
            Object object2;
            XCell xCell;
            Object object3;
            XEnumeration xEnumeration2;
            XTextTable xTextTable;
            XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)xEnumeration.nextElement());
            XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)xTextContent);
            if (xServiceInfo.supportsService("com.sun.star.text.TextTable")) {
                xTextTable = (XTextTable)UnoRuntime.queryInterface(XTextTable.class, (Object)xTextContent);
                xEnumeration2 = xTextTable.getCellNames();
                object3 = null;
                for (int i = 0; i < ((XEnumeration)xEnumeration2).length; ++i) {
                    XEnumeration xEnumeration3 = xEnumeration2[i];
                    xCell = xTextTable.getCellByName((String)xEnumeration3);
                    if (!OOUtilities.splitCellName((String)xEnumeration3).A.equals(object3)) {
                        if (object3 != null) {
                            stringBuffer.append("|\n");
                        }
                        object3 = OOUtilities.splitCellName((String)xEnumeration3).A;
                    }
                    object2 = (XText)UnoRuntime.queryInterface(XText.class, (Object)xCell);
                    XEnumerationAccess xEnumerationAccess2 = (XEnumerationAccess)UnoRuntime.queryInterface(XEnumerationAccess.class, (Object)object2);
                    XEnumeration xEnumeration4 = xEnumerationAccess2.createEnumeration();
                    boolean bl = false;
                    boolean bl2 = true;
                    while (xEnumeration4.hasMoreElements()) {
                        XTextRange xTextRange = (XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)xEnumeration4.nextElement());
                        if (!bl) {
                            bl = true;
                            stringBuffer.append(string);
                        }
                        if (!bl2) {
                            stringBuffer.append("[CR]");
                        }
                        if (xTextRange != null) {
                            stringBuffer.append(xTextRange.getString());
                        }
                        bl2 = false;
                    }
                }
                stringBuffer.append("|\n");
                continue;
            }
            if (!xServiceInfo.supportsService("com.sun.star.text.Paragraph")) continue;
            xTextTable = (XEnumerationAccess)UnoRuntime.queryInterface(XEnumerationAccess.class, (Object)xTextContent);
            xEnumeration2 = xTextTable.createEnumeration();
            while (xEnumeration2.hasMoreElements()) {
                object3 = (XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)xEnumeration2.nextElement());
                stringBuffer.append(object3.getString());
            }
            stringBuffer.append('\n');
            object3 = (XContentEnumerationAccess)UnoRuntime.queryInterface(XContentEnumerationAccess.class, (Object)xTextContent);
            if (object3 == null) continue;
            String[] stringArray = object3.getAvailableServiceNames();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!"com.sun.star.text.TextContent".equals(stringArray[i])) continue;
                xCell = object3.createContentEnumeration("com.sun.star.text.TextContent");
                while (xCell.hasMoreElements()) {
                    object2 = xCell.nextElement();
                    OOUtilities.getStructuredTextBody(object2, string, stringBuffer);
                }
            }
        }
    }

    public static XTextCursor navigateToBookmark(XComponent xComponent, String string, boolean bl) throws ServiceUnavailableException, BadDocumentException {
        try {
            XBookmarksSupplier xBookmarksSupplier = (XBookmarksSupplier)UnoRuntime.queryInterface(XBookmarksSupplier.class, (Object)xComponent);
            XNameAccess xNameAccess = xBookmarksSupplier.getBookmarks();
            Object object = xNameAccess.getByName(string);
            XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)object);
            XTextRange xTextRange = xTextContent.getAnchor();
            XText xText = xTextRange.getText();
            XTextCursor xTextCursor = xText.createTextCursorByRange(xTextRange);
            if (bl) {
                xText.removeTextContent(xTextContent);
            }
            return xTextCursor;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new BadDocumentException("Unable to navigate to bookmark \"" + string + "\".", noSuchElementException);
        }
        catch (WrappedTargetException wrappedTargetException) {
            throw new ServiceUnavailableException("Unexpected error from Open Office", wrappedTargetException);
        }
    }

    private static boolean containsDmBookmark(XComponent xComponent, XTextCursor xTextCursor) throws ServiceUnavailableException {
        boolean bl = false;
        String string = "??";
        try {
            XBookmarksSupplier xBookmarksSupplier = (XBookmarksSupplier)UnoRuntime.queryInterface(XBookmarksSupplier.class, (Object)xComponent);
            XNameAccess xNameAccess = xBookmarksSupplier.getBookmarks();
            for (String string2 : xNameAccess.getElementNames()) {
                Object object;
                XTextContent xTextContent;
                XTextRange xTextRange;
                XTextRangeCompare xTextRangeCompare;
                string = string2;
                if (!string.startsWith("dmSubT") || (xTextRangeCompare = (XTextRangeCompare)UnoRuntime.queryInterface(XTextRangeCompare.class, (Object)(xTextRange = (xTextContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)(object = xNameAccess.getByName(string)))).getAnchor()).getText())) == null) continue;
                try {
                    short s = xTextRangeCompare.compareRegionStarts((XTextRange)xTextCursor, xTextRange);
                    short s2 = xTextRangeCompare.compareRegionEnds((XTextRange)xTextCursor, xTextRange);
                    if (s < 0 || s2 > 0) continue;
                    bl = true;
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return bl;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new ServiceUnavailableException("Unable to navigate to bookmark \"XXX\".", noSuchElementException);
        }
        catch (WrappedTargetException wrappedTargetException) {
            throw new ServiceUnavailableException("Unexpected error from Open Office", wrappedTargetException);
        }
    }

    private static boolean hasOtherContent(Object object) {
        XContentEnumerationAccess xContentEnumerationAccess;
        boolean bl = false;
        XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)object);
        if (xServiceInfo != null) {
            xContentEnumerationAccess = xServiceInfo.getSupportedServiceNames();
            for (int i = 0; i < ((XContentEnumerationAccess)xContentEnumerationAccess).length; ++i) {
                if (xContentEnumerationAccess[i].startsWith("com.sun.star.style") || xContentEnumerationAccess[i].equals("com.sun.star.text.TextContent") || xContentEnumerationAccess[i].equals("com.sun.star.text.Paragraph") || xContentEnumerationAccess[i].equals("com.sun.star.text.TextCursor") || xContentEnumerationAccess[i].equals("com.sun.star.text.TextSortable") || xContentEnumerationAccess[i].equals("com.sun.star.text.TextPortion")) continue;
                bl = true;
                break;
            }
        }
        if (!bl && (xContentEnumerationAccess = (XContentEnumerationAccess)UnoRuntime.queryInterface(XContentEnumerationAccess.class, (Object)object)) != null) {
            block7: for (String string : xContentEnumerationAccess.getAvailableServiceNames()) {
                XEnumeration xEnumeration = xContentEnumerationAccess.createContentEnumeration(string);
                while (xEnumeration.hasMoreElements()) {
                    try {
                        Object object2 = xEnumeration.nextElement();
                        bl = OOUtilities.hasOtherContent(object2);
                        if (!bl) continue;
                        continue block7;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                    }
                    catch (WrappedTargetException wrappedTargetException) {
                    }
                }
            }
        }
        if (!bl && (xContentEnumerationAccess = (XEnumerationAccess)UnoRuntime.queryInterface(XEnumerationAccess.class, (Object)object)) != null) {
            XEnumeration xEnumeration = xContentEnumerationAccess.createEnumeration();
            while (xEnumeration.hasMoreElements()) {
                try {
                    Object object3 = xEnumeration.nextElement();
                    bl = OOUtilities.hasOtherContent(object3);
                    if (!bl) continue;
                    break;
                }
                catch (NoSuchElementException noSuchElementException) {
                }
                catch (WrappedTargetException wrappedTargetException) {
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertDocument(XComponent xComponent, XTextCursor xTextCursor, String string, boolean bl, String string2, boolean bl2, boolean bl3, boolean bl4, boolean bl5, EngineVersion engineVersion) throws ServiceUnavailableException {
        DocmosisDocumentEventListener docmosisDocumentEventListener = null;
        try {
            XDocumentInsertable xDocumentInsertable;
            if (OOUtilities.awaitInsertEvents(engineVersion)) {
                docmosisDocumentEventListener = new DocmosisDocumentEventListener("insertDoc1", K, C, xComponent);
            }
            boolean bl6 = J && OOUtilities.isAtNumberedParagraph(xTextCursor);
            XTextCursor xTextCursor2 = null;
            if (bl6) {
                xTextCursor2 = xTextCursor.getText().createTextCursorByRange(xTextCursor.getStart());
                xTextCursor2.isCollapsed();
                xTextCursor2.setString("repair\r\rrepair");
                try {
                    xDocumentInsertable = xTextCursor.getText().createTextCursorByRange(xTextCursor2.getEnd());
                    xDocumentInsertable.collapseToEnd();
                    ((XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xDocumentInsertable)).setPropertyValue("NumberingStyleName", (Object)"");
                }
                catch (Exception exception) {
                    G.warn("Unable to check remove numbering property from paragraph", exception);
                }
                DocmosisDocumentEventListener.reset(docmosisDocumentEventListener);
                xTextCursor2.collapseToStart();
                DocmosisDocumentEventListener.awaitLayout(docmosisDocumentEventListener);
            }
            xDocumentInsertable = (XDocumentInsertable)UnoRuntime.queryInterface(XDocumentInsertable.class, (Object)xTextCursor);
            PropertyValue[] propertyValueArray = new PropertyValue[]{};
            boolean bl7 = DMProperties.getBoolean("docmosis.converter.file.insert.runAutoRefresh", true);
            try {
                String string3;
                Object object;
                XTextCursor xTextCursor3;
                DocmosisDocumentEventListener.reset(docmosisDocumentEventListener);
                xDocumentInsertable.insertDocumentFromURL(string, propertyValueArray);
                DocmosisDocumentEventListener.awaitLayout(docmosisDocumentEventListener);
                if (bl4) {
                    xTextCursor3 = xTextCursor.getText().createTextCursor();
                    xTextCursor3.gotoRange(xTextCursor.getStart(), false);
                    xTextCursor3.gotoRange(xTextCursor.getEnd(), true);
                    xTextCursor3.collapseToEnd();
                    xTextCursor3.goLeft((short)1, true);
                    object = xTextCursor3.getString();
                    if ("\r\n".equals(object) || "\n".equals(object)) {
                        if (!OOUtilities.containsDmBookmark(xComponent, xTextCursor3) && !OOUtilities.hasOtherContent(xTextCursor3)) {
                            DocmosisDocumentEventListener.reset(docmosisDocumentEventListener);
                            xTextCursor3.setString("");
                            DocmosisDocumentEventListener.awaitLayout(docmosisDocumentEventListener);
                        } else {
                            xTextCursor3.collapseToEnd();
                            xTextCursor3.goRight((short)1, true);
                            string3 = xTextCursor3.getString();
                            if (("\r\n".equals(string3) || "\n".equals(string3)) && !OOUtilities.containsDmBookmark(xComponent, xTextCursor3) && !OOUtilities.hasOtherContent(xTextCursor3)) {
                                DocmosisDocumentEventListener.reset(docmosisDocumentEventListener);
                                xTextCursor3.setString("");
                                DocmosisDocumentEventListener.awaitLayout(docmosisDocumentEventListener);
                            }
                        }
                    }
                }
                if (xTextCursor2 != null) {
                    boolean bl8 = false;
                    xTextCursor2.goRight((short)("repair".length() * 2), true);
                    for (int i = 0; i < 100; ++i) {
                        xTextCursor2.goRight((short)1, true);
                        if (!xTextCursor2.getString().equals("repair\r\rrepair") && !xTextCursor2.getString().equals("repair\n\nrepair") && !xTextCursor2.getString().equals("repair\r\n\r\nrepair")) continue;
                        bl8 = true;
                        break;
                    }
                    if (bl8) {
                        xTextCursor2.setString("");
                    } else {
                        String string4 = "Unable to recover from repairing numbered paragraph";
                        G.error("Unable to recover from repairing numbered paragraph");
                        throw new RuntimeException("Unable to recover from repairing numbered paragraph");
                    }
                }
                if (bl7 && (xTextCursor3 = (XRefreshable)UnoRuntime.queryInterface(XRefreshable.class, (Object)xComponent)) != null) {
                    DocmosisDocumentEventListener.reset(docmosisDocumentEventListener);
                    xTextCursor3.refresh();
                    DocmosisDocumentEventListener.awaitRefresh(docmosisDocumentEventListener);
                }
                if (bl2) {
                    G.trace("running repair2 sequence on inserted content");
                    xTextCursor3 = xTextCursor.getText().createTextCursor();
                    xTextCursor3.gotoRange(xTextCursor.getStart(), false);
                    xTextCursor3.gotoRange(xTextCursor.getEnd(), true);
                    xTextCursor3.collapseToStart();
                    DocmosisDocumentEventListener.reset(docmosisDocumentEventListener);
                    xTextCursor3.setString(O);
                    DocmosisDocumentEventListener.awaitLayout(docmosisDocumentEventListener);
                    DocmosisDocumentEventListener.reset(docmosisDocumentEventListener);
                    xTextCursor3.setString("");
                    DocmosisDocumentEventListener.awaitLayout(docmosisDocumentEventListener);
                }
                if (string2 != null && L) {
                    xTextCursor3 = xTextCursor.getText().createTextCursor();
                    xTextCursor3.gotoRange(xTextCursor.getStart(), false);
                    xTextCursor3.gotoRange(xTextCursor.getEnd(), true);
                    xTextCursor3.collapseToEnd();
                    xTextCursor3.goLeft((short)1, true);
                    object = xTextCursor3.getString();
                    if ("\r\n".equals(object) || "\n".equals(object)) {
                        DocmosisDocumentEventListener.reset(docmosisDocumentEventListener);
                        xTextCursor3.setString("");
                        DocmosisDocumentEventListener.awaitLayout(docmosisDocumentEventListener);
                    }
                }
                if (bl) {
                    xTextCursor.collapseToStart();
                    xTextCursor.goLeft((short)1, true);
                    if (" ".equals(xTextCursor.getString())) {
                        DocmosisDocumentEventListener.reset(docmosisDocumentEventListener);
                        xTextCursor.getText().insertString((XTextRange)xTextCursor, "", true);
                        DocmosisDocumentEventListener.awaitLayout(docmosisDocumentEventListener);
                    } else {
                        xTextCursor.goRight((short)1, false);
                    }
                }
                if (bl3) {
                    boolean bl9 = false;
                    object = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)xTextCursor);
                    if (object != null && !object.isStartOfParagraph()) {
                        bl9 = true;
                    }
                    xTextCursor.goRight((short)1, true);
                    string3 = xTextCursor.getString();
                    if (!(bl5 && bl9 || !"\r\n".equals(string3) && !"\n".equals(string3))) {
                        String string5;
                        DocmosisDocumentEventListener.reset(docmosisDocumentEventListener);
                        xTextCursor.getText().insertString((XTextRange)xTextCursor, "", true);
                        if (bl5 && xTextCursor.goRight((short)1, true) && ((string5 = xTextCursor.getString()).equals("\r\n") || string5.equals("\n")) && !OOUtilities.containsDmBookmark(xComponent, xTextCursor) && !OOUtilities.hasOtherContent(xTextCursor)) {
                            xTextCursor.getText().insertString((XTextRange)xTextCursor, "", true);
                        }
                        DocmosisDocumentEventListener.awaitLayout(docmosisDocumentEventListener);
                    }
                }
                if (string2 != null) {
                    if (xTextCursor.goRight((short)(string2.length() + 1), true)) {
                        String string6 = xTextCursor.getString();
                        if ((string2 + "\r\n").equals(string6) || (string2 + "\n").equals(string6)) {
                            DocmosisDocumentEventListener.reset(docmosisDocumentEventListener);
                            xTextCursor.setString("");
                            DocmosisDocumentEventListener.awaitLayout(docmosisDocumentEventListener);
                        } else {
                            xTextCursor.goLeft((short)1, true);
                            object = xTextCursor.getString();
                            if (string2.equals(object)) {
                                DocmosisDocumentEventListener.reset(docmosisDocumentEventListener);
                                xTextCursor.setString("");
                                DocmosisDocumentEventListener.awaitLayout(docmosisDocumentEventListener);
                            } else {
                                xTextCursor.goLeft((short)string2.length(), false);
                            }
                        }
                    } else if (xTextCursor.goRight((short)string2.length(), true)) {
                        String string7 = xTextCursor.getString();
                        if (string2.equals(string7)) {
                            DocmosisDocumentEventListener.reset(docmosisDocumentEventListener);
                            xTextCursor.setString("");
                            DocmosisDocumentEventListener.awaitLayout(docmosisDocumentEventListener);
                        } else {
                            xTextCursor.goLeft((short)string2.length(), false);
                        }
                    } else {
                        String string8 = xTextCursor.getString();
                        if (string2.equals(string8)) {
                            DocmosisDocumentEventListener.reset(docmosisDocumentEventListener);
                            xTextCursor.setString("");
                            DocmosisDocumentEventListener.awaitLayout(docmosisDocumentEventListener);
                        }
                    }
                }
            }
            finally {
                DocmosisDocumentEventListener.cleanup(docmosisDocumentEventListener);
            }
        }
        catch (com.sun.star.io.IOException iOException) {
            throw new ServiceUnavailableException("Unexpected error from Open Office", iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ServiceUnavailableException("Unexpected error from Open Office", illegalArgumentException);
        }
    }

    private static boolean isAtNumberedParagraph(XTextCursor xTextCursor) {
        boolean bl = false;
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextCursor);
            if (xPropertySet != null) {
                Object object = xPropertySet.getPropertyValue("NumberingStyleName");
                bl = object != null && !StringUtilities.isEmpty((String)object);
            }
        }
        catch (Exception exception) {
            G.warn("Unable to check cursor paragraph properties", exception);
        }
        return bl;
    }

    private static boolean awaitInsertEvents(EngineVersion engineVersion) {
        boolean bl = DMProperties.getBoolean("docmosis.converter.file.insert.events.awaitEvents", true);
        if (!bl) {
            return false;
        }
        if (R == null || "-1.".equals(R.trim())) {
            return true;
        }
        try {
            float f = Float.valueOf(R).floatValue();
            return engineVersion.isVersionAtLeast(null, f);
        }
        catch (NumberFormatException numberFormatException) {
            G.error("Bad value for property \"docmosis.converter.file.insert.events.minEngineVersion\" value=" + R);
            return true;
        }
    }

    public static void insertDocumentAtBookmark(XComponent xComponent, String string, String string2, boolean bl, boolean bl2, String string3, boolean bl3, boolean bl4, boolean bl5, boolean bl6, EngineVersion engineVersion) throws ServiceUnavailableException, BadDocumentException {
        XTextCursor xTextCursor = OOUtilities.navigateToBookmark(xComponent, string, bl2);
        OOUtilities.insertDocument(xComponent, xTextCursor, string2, bl, string3, bl3, bl4, bl5, bl6, engineVersion);
    }

    private static _A splitCellName(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isDigit(string.charAt(i))) continue;
            return new _A(string.substring(0, i), string.substring(i));
        }
        return new _A("?", "?");
    }

    private static class _A {
        String A;

        public _A(String string, String string2) {
            this.A = string2;
        }
    }
}

