/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.converter.openoffice;

import com.docmosis.converter.openoffice.BootstrapOpenOfficeConnectionPrimer;
import com.docmosis.converter.openoffice.OODocumentHandle;
import com.docmosis.converter.openoffice.OpenOfficeConnection;
import com.docmosis.converter.openoffice.RemoteOpenOfficeConnection;
import com.docmosis.converter.openoffice.sensitivitylabel.SensitivityLabelHelper;
import com.docmosis.document.converter.ConversionException;
import com.docmosis.document.converter.ConversionFormat;
import com.docmosis.document.converter.ConversionInstruction;
import com.docmosis.document.converter.ConversionSettings;
import com.docmosis.document.converter.DocumentFormatConverter;
import com.docmosis.document.converter.ExtendedConversionInstruction;
import com.docmosis.template.BasicDocument;
import com.docmosis.template.TemplateParseException;
import com.docmosis.template.analysis.list.ListStyles;
import com.docmosis.template.analysis.openoffice.ODFContentAnalyzer;
import com.docmosis.template.analysis.openoffice.XMLComponentHandler;
import com.docmosis.template.analysis.sensitivitylabel.SensitivityLabelInfo;
import com.docmosis.template.population.PopulatedFilesCollection;
import com.docmosis.util.DMProperties;
import com.docmosis.util.EngineDetails;
import com.docmosis.util.EngineVersion;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.I;
import com.docmosis.util.J;
import com.docmosis.util.StringUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import com.docmosis.util.xml.XMLIndexedAttribute;
import com.docmosis.util.xml.XMLIndexedTag;
import com.docmosis.util.xml.XMLIndexedTagParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class LocalOpenOfficeConverter
implements DocumentFormatConverter {
    private static final Logger V = LogManager.getLogger(LocalOpenOfficeConverter.class);
    private static final int X = DMProperties.getInt("docmosis.converter.cleanup.after");
    private static final String R = "docmosis.converter.file.preserveCorrupted";
    private static final boolean b = DMProperties.getBoolean("docmosis.populator.merge.insertMagicSpace", true);
    private static final boolean f = DMProperties.getBoolean("docmosis.converter.format.html.image.repairPaths", true);
    private static final boolean j = DMProperties.getBoolean("docmosis.converter.format.docx.internal.injectDefaultStyles", true);
    private static final String e = LocalOpenOfficeConverter.loadDocXDefaultStylesXML("docmosisDocxDefaultStyles.xml");
    private static final Pattern g = Pattern.compile("(<w:styles .*?>)");
    private static final long k = DMProperties.getLong("docmosis.external.converter.timeout.after", 60000L);
    private static final String S = "docmosis.converter.format.docx.external.path";
    private static final String i = "docmosis.converter.file.reloadAfterMerge";
    private final boolean N = DMProperties.getBoolean("docmosis.converter.file.insert.repairSequence.run", true);
    private final boolean _ = DMProperties.getBoolean("docmosis.converter.format.docx.internal.enabled", false);
    private final boolean T = DMProperties.getBoolean("docmosis.converter.format.docx.external.enabled", false);
    private final boolean Z = DMProperties.getBoolean("docmosis.converter.format.docx.external.repairStylesEnabled", true);
    private final int U = DMProperties.getInt("docmosis.converter.format.docx.external.repairStylesMaxRead", 1000000);
    private OpenOfficeConnection Y;
    private _B P = new _B();
    private final ArrayList<OpenOfficeConnection> O = new ArrayList(1);
    private I Q;
    private int d;
    private File c;
    private boolean h;
    private String a;
    private int W;

    public LocalOpenOfficeConverter(File file, Boolean bl) throws ConversionException {
        this.c = file;
        this.h = Boolean.TRUE.equals(bl);
        this.establishConnection();
    }

    public LocalOpenOfficeConverter(String string, Integer n) throws ConversionException {
        this(string, (int)n);
    }

    public LocalOpenOfficeConverter(String string, int n) throws ConversionException {
        this.a = string;
        this.W = n;
        this.establishConnection();
    }

    private void establishConnection() throws ConversionException {
        if (this.Y != null) {
            this.Y.shutdown();
        }
        this.Y = this.getNewConnection();
        if (this._) {
            V.debug("DocX INTERNAL conversion enabled.");
        } else if (this.T) {
            V.debug("DocX EXTERNAL conversion enabled.");
        } else {
            V.debug("DocX conversion not enabled");
        }
    }

    private OpenOfficeConnection getNewConnection() throws ConversionException {
        if (this.c != null) {
            return this.getBootstrapConnection(this.c);
        }
        return this.getRemoteConnection(this.a, this.W);
    }

    private OpenOfficeConnection getBootstrapConnection(File file) throws ConversionException {
        try {
            return new BootstrapOpenOfficeConnectionPrimer(file, this.h);
        }
        catch (IOException iOException) {
            throw new ConversionException(iOException);
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            throw new ConversionException("This version of Java is not compatible with the OpenOffice installation in use.  Consider running a newer version of Java.", unsupportedClassVersionError);
        }
    }

    private OpenOfficeConnection getRemoteConnection(String string, int n) throws ConversionException {
        return new RemoteOpenOfficeConnection(string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BasicDocument convert(PopulatedFilesCollection populatedFilesCollection, ConversionInstruction conversionInstruction, ConversionSettings conversionSettings) throws ConversionException {
        ++this.d;
        if (X > 0 && this.d % X == 0) {
            V.debug("Switching to new office connection after " + X + " runs");
            this.P.A();
        }
        File file = null;
        try {
            BasicDocument basicDocument;
            file = FileUtilities.createTempDir("dm_", "conv1");
            OpenOfficeConnection openOfficeConnection = this.Y;
            this.registerConnectionInUse(openOfficeConnection);
            try {
                basicDocument = this.convertFiles(file, populatedFilesCollection.getFiles(), conversionInstruction, openOfficeConnection, conversionSettings);
            }
            finally {
                this.deRegisterConnectionInUse(openOfficeConnection);
            }
            BasicDocument basicDocument2 = basicDocument;
            return basicDocument2;
        }
        catch (IOException iOException) {
            throw new ConversionException("Failure during format conversion:" + iOException.getMessage(), iOException);
        }
        finally {
            String string = "docmosis.converter.cleanup.enabled";
            if (DMProperties.getBoolean("docmosis.converter.cleanup.enabled", true)) {
                FileUtilities.deleteRecursively(file);
            } else {
                V.warn("Property \"docmosis.converter.cleanup.enabled\" set to false so working area not removed:" + file.getPath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BasicDocument convertFiles(File file, PopulatedFilesCollection.PopulatedFile[] populatedFileArray, ConversionInstruction conversionInstruction, OpenOfficeConnection openOfficeConnection, ConversionSettings conversionSettings) throws IOException, ConversionException {
        BasicDocument basicDocument;
        OODocumentHandle oODocumentHandle = null;
        File file2 = null;
        boolean bl = false;
        try {
            int n;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            I i = I.B("ooconv", this.Q);
            I.B("ooconv.LoadDoc", i);
            File file3 = populatedFileArray[0].getFile();
            ConversionFormat[] conversionFormatArray = conversionInstruction.getConversionFormats();
            if (conversionFormatArray == null || conversionFormatArray.length == 0) {
                throw new ConversionException("No output formats have been specified and no output file name with a recognised extension");
            }
            boolean bl5 = bl4 = !this._ && this.T;
            if (!this._) {
                for (int j = 0; j < conversionFormatArray.length; ++j) {
                    if (!ConversionFormat.FORMAT_DOCX.equals(conversionFormatArray[j]) || bl4) continue;
                    throw new ConversionException("DOCX output format is not configured.  See your docmosis.properties file for details.");
                }
            }
            SensitivityLabelInfo sensitivityLabelInfo = null;
            if (populatedFileArray[0].isTemplate() && FileUtilities.isDocxFormat(populatedFileArray[0].getFile())) {
                boolean bl6 = bl3 = conversionInstruction instanceof ExtendedConversionInstruction && ((ExtendedConversionInstruction)conversionInstruction).getForceInternalConverterForDocXTemplates();
                if (bl4 && !bl3) {
                    bl = true;
                    V.debug("Converting docx template using External Converter");
                    file2 = file3 = LocalOpenOfficeConverter.convertDocxToOdt(file3);
                } else {
                    V.debug("Converting docx template using Internal Converter");
                }
                if (conversionSettings.getExtractSensitivityLabels()) {
                    try {
                        sensitivityLabelInfo = SensitivityLabelHelper.extractSensitivityLabels(populatedFileArray[0].getFile());
                    }
                    catch (IOException iOException) {
                        throw new ConversionException("Failed to extract sensitivity labels from docx file.", iOException);
                    }
                }
            }
            bl3 = !conversionInstruction.isConvertOnly() && DMProperties.getBoolean("docmosis.converter.updateTOC", true);
            oODocumentHandle = this.loadAndPrime(file3, openOfficeConnection, populatedFileArray, file, bl3, conversionSettings.getExtractFonts());
            int n2 = 0;
            boolean bl7 = bl2 = !conversionInstruction.isConvertOnly() && DMProperties.getBoolean("docmosis.converter.pagecount.enabled", true);
            if (bl2) {
                n2 = openOfficeConnection.getPageCount(oODocumentHandle);
            }
            I.A("ooconv.LoadDoc", i);
            I i2 = I.B("ooconv.save", i);
            File file4 = File.createTempFile("dm_", "conv2", file);
            final ArrayList<Object> arrayList = new ArrayList<Object>();
            boolean bl8 = false;
            boolean bl9 = false;
            for (n = 0; n < conversionFormatArray.length; ++n) {
                if (conversionFormatArray[n].equals(ConversionFormat.FORMAT_ODT)) {
                    bl9 = true;
                    continue;
                }
                if (!conversionFormatArray[n].equals(ConversionFormat.FORMAT_DOCX)) continue;
                bl8 = true;
            }
            if (conversionFormatArray.length > 1 || conversionInstruction.compressSingleDocument()) {
                Object object;
                Serializable serializable;
                for (n = 0; n < conversionFormatArray.length; ++n) {
                    serializable = conversionFormatArray[n];
                    if (ConversionFormat.FORMAT_DOCX.equals(serializable) && this._) {
                        V.debug("reloading document for DocX internal conversion");
                        openOfficeConnection.closeDocument(oODocumentHandle);
                        V.debug("document closed");
                        oODocumentHandle = this.loadAndPrime(file3, openOfficeConnection, null, file, bl3, false);
                        V.debug("document reloaded");
                    }
                    if (!ConversionFormat.hasCorrectExtension((String)(object = conversionInstruction.getOutputFileName()), (ConversionFormat)serializable)) {
                        object = (String)object + ((ConversionFormat)serializable).getExtension();
                    }
                    if (ConversionFormat.FORMAT_ODT.equals(serializable) || ConversionFormat.FORMAT_DOCX.equals(serializable) && bl4) continue;
                    I.B("ooconv.save." + ((ConversionFormat)serializable).getFormatName(), i2);
                    final File file5 = new File(file, (String)object);
                    openOfficeConnection.saveDocument(oODocumentHandle, StringUtilities.fileToURLString(file5), (ConversionFormat)serializable, conversionInstruction.getConversionProperties((ConversionFormat)serializable));
                    arrayList.add(file5);
                    if (ConversionFormat.FORMAT_DOCX.equals(serializable) && this._) {
                        if (j) {
                            LocalOpenOfficeConverter.injectDefaultStylesIntoDocX(file5);
                        }
                        if (conversionSettings.getExtractSensitivityLabels() && populatedFileArray[0].getSensitivityLabelInfo() != null) {
                            try {
                                SensitivityLabelHelper.insertSensitivityLabels(file5, populatedFileArray[0].getSensitivityLabelInfo());
                            }
                            catch (IOException iOException) {
                                throw new ConversionException("Failed to insert sensitivity labels into docx file.", iOException);
                            }
                        }
                    }
                    if (ConversionFormat.FORMAT_HTML.equals(serializable)) {
                        StringBuffer stringBuffer = new StringBuffer(file5.getName());
                        int n3 = stringBuffer.lastIndexOf(".");
                        if (n3 != -1) {
                            stringBuffer.setCharAt(n3, '_');
                        }
                        final String string = stringBuffer.toString();
                        file5.getParentFile().listFiles(new FileFilter(){

                            @Override
                            public boolean accept(File file) {
                                String string2 = file.getName();
                                if (string2.startsWith(string)) {
                                    arrayList.add(file);
                                }
                                if (f && string2.endsWith(".html")) {
                                    try {
                                        ImagePathFixer.fixHTMLImagePaths(file5);
                                    }
                                    catch (IOException iOException) {
                                        V.error("Unable to apply html image path correction", iOException);
                                    }
                                }
                                return false;
                            }
                        });
                    }
                    I.A("ooconv.save." + ((ConversionFormat)serializable).getFormatName(), i2);
                }
                if (bl9 || bl8 && bl4) {
                    String string = conversionInstruction.getOutputFileName() + ConversionFormat.FORMAT_ODT.getExtension();
                    serializable = new File(file, string);
                    openOfficeConnection.saveDocument(oODocumentHandle, StringUtilities.filePathToURLString(((File)serializable).getPath()), ConversionFormat.FORMAT_ODT, null);
                    if (bl9) {
                        arrayList.add(serializable);
                    }
                    if (bl8 && bl4) {
                        object = this.convertOdtToDocx((File)serializable, new File(file, conversionInstruction.getOutputFileName() + ConversionFormat.FORMAT_DOCX.getExtension()), this.Z);
                        arrayList.add(object);
                    }
                }
                I.B("ooconv.save.zip", i2);
                FileUtilities.zip(file4, file, arrayList);
                I.A("ooconv.save.zip", i2);
            } else {
                ConversionFormat conversionFormat = conversionFormatArray[0];
                I.B("ooconv.save." + conversionFormat, i2);
                boolean bl10 = ConversionFormat.FORMAT_DOCX.equals(conversionFormat);
                if (bl10 && bl4) {
                    conversionFormat = ConversionFormat.FORMAT_ODT;
                }
                openOfficeConnection.saveDocument(oODocumentHandle, StringUtilities.fileToURLString(file4), conversionFormat, conversionInstruction.getConversionProperties(conversionFormat));
                I.A("ooconv.save." + conversionFormat, i2);
                if (bl10 && bl4) {
                    File file6 = file4;
                    try {
                        file4 = this.convertOdtToDocx(file6, null, this.Z);
                    }
                    finally {
                        FileUtilities.delete(file6);
                    }
                }
                if (bl10 && this._) {
                    if (j) {
                        LocalOpenOfficeConverter.injectDefaultStylesIntoDocX(file4);
                    }
                    if (conversionSettings.getExtractSensitivityLabels() && populatedFileArray[0].getSensitivityLabelInfo() != null) {
                        SensitivityLabelHelper.insertSensitivityLabels(file4, populatedFileArray[0].getSensitivityLabelInfo());
                    }
                }
                if (!bl10 && conversionSettings.getRemoveExternalChartReferences()) {
                    this.removeExternalChartReferences(file4);
                }
            }
            I.A("ooconv.save", i);
            I.A("ooconv", i);
            BasicDocument basicDocument2 = new BasicDocument(file4, true, n2, oODocumentHandle.getFontInfo(), sensitivityLabelInfo);
            basicDocument2.setProcessedByExternalConverter(bl);
            basicDocument = basicDocument2;
        }
        catch (Throwable throwable) {
            openOfficeConnection.closeDocument(oODocumentHandle);
            FileUtilities.delete(file2);
            throw throwable;
        }
        openOfficeConnection.closeDocument(oODocumentHandle);
        FileUtilities.delete(file2);
        return basicDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OODocumentHandle loadAndPrime(File file, OpenOfficeConnection openOfficeConnection, PopulatedFilesCollection.PopulatedFile[] populatedFileArray, File file2, boolean bl, boolean bl2) throws ConversionException, IOException {
        OODocumentHandle oODocumentHandle = openOfficeConnection.loadDocument(StringUtilities.fileToURLString(file), bl2);
        if (oODocumentHandle == null || oODocumentHandle.getDocument() == null) {
            String string = "The document cannot be converted: could not be loaded (invalid/corrupt?).";
            if (DMProperties.getBoolean(R)) {
                File file3 = File.createTempFile("dmConvert", ".odt");
                try {
                    String string2 = "<unknown>";
                    try {
                        InetAddress inetAddress = InetAddress.getLocalHost();
                        if (inetAddress != null) {
                            string2 = inetAddress.getHostName();
                        }
                    }
                    catch (UnknownHostException unknownHostException) {
                        V.warn("Unable to get host name, ignoring [" + unknownHostException.getMessage() + ":" + unknownHostException.getClass().getName() + "]");
                    }
                    FileUtilities.copyFile(file, file3);
                    string = string + "  Corrupt file preserved on host:" + string2 + " in file " + file3.getPath();
                    V.warn(string);
                }
                catch (IOException iOException) {
                    V.error("Unable to preserve corrupt file.", iOException);
                }
            } else {
                string = string + "  Setting property \"docmosis.converter.file.preserveCorrupted\" to \"true\" will preserve the file  for analysis.";
            }
            throw new ConversionException(string);
        }
        if (populatedFileArray != null && populatedFileArray.length > 1) {
            Object object;
            int n;
            boolean bl3 = V.isDebugEnabled();
            for (n = 1; n < populatedFileArray.length; ++n) {
                object = populatedFileArray[n].getFile().getPath();
                if (bl3) {
                    V.debug("inserting [" + (String)object + "] at bookmark [" + populatedFileArray[n].getBookmarkName() + "]");
                }
                boolean bl4 = populatedFileArray[n].getPopulationInjectedLeadingParaForMasterStyles() != null && populatedFileArray[n].getPopulationInjectedLeadingParaForMasterStyles().get();
                boolean bl5 = populatedFileArray[n].getPopulationInjectedTrailingParaForSingleLineSubTemplate() != null && populatedFileArray[n].getPopulationInjectedTrailingParaForSingleLineSubTemplate().get();
                openOfficeConnection.insertDocumentAtBookmark(oODocumentHandle, populatedFileArray[n].getBookmarkName(), StringUtilities.filePathToURLString((String)object), b, true, populatedFileArray[n].getMarkerLineToRemove(), this.N, bl4, bl5, populatedFileArray[n].isEmptyDocumentCreated());
            }
            n = DMProperties.getBoolean(i, true) ? 1 : 0;
            if (n != 0) {
                object = FileUtilities.createTempFile("dmm_", ".odt");
                try {
                    openOfficeConnection.saveDocument(oODocumentHandle, StringUtilities.fileToURLString((File)object), ConversionFormat.FORMAT_ODT, null);
                    openOfficeConnection.closeDocument(oODocumentHandle);
                    FileUtilities.copyFile((File)object, file);
                }
                finally {
                    FileUtilities.delete((File)object);
                }
                oODocumentHandle = openOfficeConnection.loadDocument(StringUtilities.fileToURLString(file), false);
                V.debug("Document reloaded after merging complete");
            }
        }
        if (bl) {
            openOfficeConnection.updateTOC(oODocumentHandle);
        }
        return oODocumentHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerConnectionInUse(OpenOfficeConnection openOfficeConnection) {
        ArrayList<OpenOfficeConnection> arrayList = this.O;
        synchronized (arrayList) {
            if (this.O.isEmpty()) {
                this.O.add(openOfficeConnection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deRegisterConnectionInUse(OpenOfficeConnection openOfficeConnection) {
        ArrayList<OpenOfficeConnection> arrayList = this.O;
        synchronized (arrayList) {
            if (!this.O.isEmpty() && openOfficeConnection == this.O.get(0)) {
                this.O.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectionInUse(OpenOfficeConnection openOfficeConnection) {
        ArrayList<OpenOfficeConnection> arrayList = this.O;
        synchronized (arrayList) {
            if (!this.O.isEmpty() && openOfficeConnection == this.O.get(0)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void shutdown() {
        if (this.Y != null) {
            V.debug("Converter Shutting down");
            if (this.P != null) {
                this.P.B();
            }
            this.Y.shutdown();
            this.Y = null;
        }
    }

    public I getModuleTiming() {
        return this.Q;
    }

    @Override
    public void setModuleTiming(I i) {
        this.Q = i;
    }

    @Override
    public boolean repair() {
        try {
            if (V.isDebugEnabled()) {
                if (this.c != null) {
                    V.debug("Attempting to repair local converter (exe:" + this.c.getPath() + ") ");
                } else {
                    V.debug("Attempt to repair local converter (" + this.a + ":" + this.W + ")");
                }
            }
            this.establishConnection();
            if (V.isDebugEnabled()) {
                if (this.c != null) {
                    V.debug("Successfully repaired local converter (exe:" + this.c.getPath() + ") ");
                } else {
                    V.debug("Successfully repaired local converter (" + this.a + ":" + this.W + ")");
                }
            }
            return true;
        }
        catch (ConversionException conversionException) {
            if (V.isDebugEnabled()) {
                if (this.c != null) {
                    V.debug("Attempt to repair local converter (exe:" + this.c.getPath() + ") failed: " + conversionException.getMessage());
                } else {
                    V.debug("Attempt to repair local converter (" + this.a + ":" + this.W + ") failed: " + conversionException.getMessage());
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExternalChartReferences(File file) throws IOException, ConversionException {
        I i;
        block17: {
            ZipInputStream zipInputStream = null;
            i = I.B("ooconv.repaircharts", this.Q);
            ArrayList<File> arrayList = new ArrayList<File>();
            try {
                Object object;
                Object object2;
                Object object3;
                HashMap hashMap = new HashMap();
                try {
                    ZipEntry object4;
                    zipInputStream = new ZipInputStream(new FileInputStream(file));
                    while ((object4 = zipInputStream.getNextEntry()) != null) {
                        if (!object4.getName().matches("Object \\d+\\/content\\.xml")) continue;
                        object3 = new _A();
                        object2 = new ODFContentAnalyzer.XMLStreamReader();
                        object = FileUtilities.createTempFile("dms", "chtrpr");
                        arrayList.add((File)object);
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), "UTF-8");
                        try {
                            ((_A)object3).A(outputStreamWriter);
                            ((ODFContentAnalyzer.XMLStreamReader)object2).process(zipInputStream, (XMLComponentHandler)object3);
                            if (!((_A)object3).A()) continue;
                            hashMap.put(object4.getName(), object);
                        }
                        catch (TemplateParseException templateParseException) {
                            throw new ConversionException(templateParseException);
                        }
                        finally {
                            FileUtilities.close(outputStreamWriter);
                        }
                    }
                }
                catch (Throwable throwable) {
                    FileUtilities.close(zipInputStream);
                    zipInputStream = null;
                    throw throwable;
                }
                FileUtilities.close(zipInputStream);
                zipInputStream = null;
                if (hashMap.size() <= 0) break block17;
                File file2 = FileUtilities.createTempFile("dmfu", "odtzip");
                object3 = null;
                try {
                    FileUtilities.copyFile(file, file2);
                    zipInputStream = new ZipInputStream(new FileInputStream(file2));
                    object3 = new ZipOutputStream(new FileOutputStream(file));
                    object = new byte[4096];
                    while ((object2 = zipInputStream.getNextEntry()) != null) {
                        ((ZipOutputStream)object3).putNextEntry(new ZipEntry(((ZipEntry)object2).getName()));
                        boolean bl = false;
                        for (String string : hashMap.keySet()) {
                            if (!string.equals(((ZipEntry)object2).getName())) continue;
                            FileUtilities.streamOut((File)hashMap.get(string), (OutputStream)object3, (byte[])object);
                            bl = true;
                        }
                        if (bl) continue;
                        FileUtilities.streamOut(zipInputStream, (OutputStream)object3, (byte[])object);
                    }
                }
                finally {
                    FileUtilities.close(zipInputStream);
                    FileUtilities.close((OutputStream)object3);
                    FileUtilities.delete(file2);
                }
            }
            finally {
                for (File file3 : arrayList) {
                    FileUtilities.delete(file3);
                }
            }
        }
        I.A("ooconv.repaircharts", i);
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    private static File convertDocxToOdt(File file) throws IOException {
        return LocalOpenOfficeConverter.convert(file, false, null);
    }

    private File convertOdtToDocx(File file, File file2, boolean bl) throws IOException {
        File file3 = LocalOpenOfficeConverter.convert(file, true, file2);
        if (bl) {
            this.repairDocXStyles(file3);
        }
        return file3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repairDocXStyles(File file) throws IOException {
        String string = "word/styles.xml";
        File file2 = FileUtilities.createTempFile("dmc", "sty");
        FileInputStream fileInputStream = null;
        try {
            if (!FileUtilities.extractFromZip(file, "word/styles.xml", file2)) {
                throw new IOException("Unable to extract styles from docx");
            }
            fileInputStream = new FileInputStream(file2);
            File file3 = this.repairDocXStyles(fileInputStream);
            if (file3 != null) {
                FileUtilities.addToZip(file, "word/styles.xml", file3);
            }
        }
        catch (Throwable throwable) {
            FileUtilities.close(fileInputStream);
            FileUtilities.delete(file2);
            throw throwable;
        }
        FileUtilities.close(fileInputStream);
        FileUtilities.delete(file2);
    }

    private File repairDocXStyles(InputStream inputStream) throws IOException {
        File file = null;
        Pattern pattern = Pattern.compile("<w:ilvl w:val=\"NaN\"");
        byte[] byArray = FileUtilities.readIntoMemory(inputStream, this.U, 4096);
        if (byArray == null) {
            throw new IOException("Unable to read styles from docx, too large?");
        }
        String string = new String(byArray, "UTF-8");
        String string2 = pattern.matcher(string).replaceAll("<w:ilvl w:val=\"0\"");
        pattern = Pattern.compile("<w:outlineLvl w:val=\"NaN\"");
        string2 = pattern.matcher(string2).replaceAll("<w:outlineLvl w:val=\"0\"");
        if (!string2.equals(string)) {
            file = FileUtilities.createTempFile("dmc", "xrs");
            FileUtilities.storeToFile(new StringReader(string2), file, (long)string2.length());
            V.debug("DocXFile styles.xml repaired");
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void injectDefaultStylesIntoDocX(File file) throws IOException {
        String string = "word/styles.xml";
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream(8192);
            if (!FileUtilities.extractFromZip(file, "word/styles.xml", byteArrayOutputStream)) {
                throw new IOException("Unable to extract styles from docx");
            }
            byte[] byArray = LocalOpenOfficeConverter.injectDefaultStylesIntoDocX(byteArrayOutputStream.toByteArray());
            if (byArray != null) {
                FileUtilities.addToZip(file, "word/styles.xml", new ByteArrayInputStream(byArray));
            }
        }
        catch (Throwable throwable) {
            FileUtilities.close(byteArrayOutputStream);
            throw throwable;
        }
        FileUtilities.close(byteArrayOutputStream);
    }

    private static byte[] injectDefaultStylesIntoDocX(byte[] byArray) throws IOException {
        String string;
        if (e == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("<w:docDefaults>");
        if (pattern.matcher(string = new String(byArray, "UTF-8")).find()) {
            if (V.isDebugEnabled()) {
                V.debug("DocX default styles exist.  Not adding.");
            }
            return null;
        }
        return g.matcher(string).replaceFirst("$1" + e).getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadDocXDefaultStylesXML(String string) {
        String string2 = null;
        InputStream inputStream = LocalOpenOfficeConverter.class.getResourceAsStream("/" + string);
        try {
            if (inputStream == null) {
                inputStream = LocalOpenOfficeConverter.class.getResourceAsStream("/docmosis/defaults/" + string);
            } else if (V.isDebugEnabled()) {
                V.debug("Loading custom docX default styles");
            }
            if (inputStream != null) {
                try {
                    string2 = new String(FileUtilities.readIntoMemory(inputStream, -1, 8192));
                }
                catch (IOException iOException) {
                    V.warn("Unable to load default DOCX corrective XML.  DocX corrections may be disabled.", iOException);
                }
            }
            String string3 = string2;
            return string3;
        }
        finally {
            FileUtilities.close(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File convert(File file, boolean bl, File file2) throws IOException {
        V.debug("Converting docX file using external converter");
        String string = DMProperties.getString(S);
        if (!new File(string).canRead()) {
            throw new IOException("cannot find configured DOCX converter [" + string + "]");
        }
        File file3 = file2 == null ? FileUtilities.createTempFile("dmx", "dmx") : file2;
        boolean bl2 = false;
        try {
            String[] stringArray = new String[]{string, bl ? "/ODT2DOCX" : "/DOCX2ODT", "/F", "/I", file.getPath(), "/O", file3.getPath()};
            Process process = Runtime.getRuntime().exec(stringArray);
            _D.C(process.getErrorStream());
            _D.C(process.getInputStream());
            int n = 0;
            long l = k;
            try {
                n = l < 1L ? process.waitFor() : LocalOpenOfficeConverter.runCrashableProcess(process, l);
                if (n != 0) {
                    throw new IOException("External DocX converter exited with status:" + n);
                }
                bl2 = true;
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("Processing docx failed to complete in time [" + l + " ms]");
            }
            finally {
                process.destroy();
                try {
                    process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    V.warn("interrupted during shutdown", interruptedException);
                }
                _D.A(process.getErrorStream());
                _D.A(process.getInputStream());
            }
        }
        finally {
            if (!bl2) {
                FileUtilities.delete(file3);
            }
        }
        return file3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int runCrashableProcess(final Process process, long l) throws InterruptedException {
        _C _C2 = new _C(){

            @Override
            public int A() throws InterruptedException {
                return process.waitFor();
            }
        };
        Thread thread = new Thread((Runnable)_C2, "DOCX crashable manager thread");
        thread.start();
        try {
            Thread thread2 = thread;
            synchronized (thread2) {
                thread.wait(l);
            }
            if (!_C2.B) {
                throw new InterruptedException("job didn't finish");
            }
            int n = _C2.A;
            return n;
        }
        finally {
            thread.interrupt();
        }
    }

    @Override
    public String getDescription() {
        if (this.a != null) {
            return "embedded [" + this.a + ":" + this.W + "]";
        }
        return "embedded";
    }

    @Override
    public void kickTheTyres() throws ConversionException {
    }

    @Override
    public EngineDetails getEngineDetails() {
        EngineDetails engineDetails = null;
        if (this.Y != null) {
            EngineVersion engineVersion = this.Y.getEngineVersionInfo();
            engineDetails = new EngineDetails(engineVersion, false);
        }
        return engineDetails;
    }

    private static class _D {
        private static _D C = null;
        private final Thread B;
        private Map<InputStream, Void> D = Collections.synchronizedMap(new IdentityHashMap());
        private boolean A = true;

        private _D() {
            this.B = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (_D.this.A) {
                        byte[] byArray = new byte[4096];
                        Map map = _D.this.D;
                        synchronized (map) {
                            Iterator iterator = _D.this.D.keySet().iterator();
                            while (iterator.hasNext()) {
                                InputStream inputStream = (InputStream)iterator.next();
                                try {
                                    int n;
                                    while ((n = inputStream.available()) > 0) {
                                        int n2 = inputStream.read(byArray, 0, Math.min(n, byArray.length));
                                        if (n2 == -1) {
                                            iterator.remove();
                                            continue;
                                        }
                                        if (!V.isDebugEnabled()) continue;
                                        V.debug("DOCX>" + new String(byArray, 0, n2));
                                    }
                                }
                                catch (IOException iOException) {
                                    iterator.remove();
                                }
                            }
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            _D.this.A = false;
                        }
                    }
                }
            });
            this.B.setDaemon(true);
            this.B.setName("DMExternGob");
            this.B.start();
        }

        private void D(InputStream inputStream) {
            this.D.put(inputStream, null);
        }

        private void B(InputStream inputStream) {
            this.D.remove(inputStream);
        }

        static synchronized void C(InputStream inputStream) {
            if (C == null) {
                C = new _D();
            }
            C.D(inputStream);
        }

        static synchronized void A(InputStream inputStream) {
            if (C != null) {
                C.B(inputStream);
            }
        }
    }

    private static abstract class _C
    implements Runnable {
        private int A;
        private boolean B;

        private _C() {
        }

        @Override
        public void run() {
            try {
                this.A = this.A();
                this.B = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public abstract int A() throws InterruptedException;
    }

    private class _B
    implements Runnable {
        private Thread B;
        private boolean E;
        private boolean C;
        private final ArrayList<OpenOfficeConnection> D = new ArrayList();

        public _B() {
            this.B = new Thread((Runnable)this, "DMConnectionReplacer");
            this.B.setDaemon(true);
            this.C = true;
            this.B.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void A() {
            _B _B2 = this;
            synchronized (_B2) {
                this.E = true;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.C) {
                try {
                    OpenOfficeConnection openOfficeConnection;
                    Object object;
                    _B _B2 = this;
                    synchronized (_B2) {
                        while (this.C && !this.E && this.D.size() == 0) {
                            this.wait(200L);
                        }
                    }
                    if (!this.C) continue;
                    boolean bl = false;
                    if (this.E) {
                        bl = true;
                        this.E = false;
                        object = LocalOpenOfficeConverter.this.Y;
                        openOfficeConnection = LocalOpenOfficeConverter.this.getNewConnection();
                        LocalOpenOfficeConverter.this.Y = openOfficeConnection;
                        this.D.add((OpenOfficeConnection)object);
                    }
                    if (this.D.size() > 0) {
                        object = this.D.iterator();
                        while (object.hasNext()) {
                            openOfficeConnection = (OpenOfficeConnection)object.next();
                            if (LocalOpenOfficeConverter.this.connectionInUse(openOfficeConnection)) continue;
                            try {
                                bl = true;
                                openOfficeConnection.shutdown();
                            }
                            catch (Throwable throwable) {}
                            continue;
                            finally {
                                object.remove();
                            }
                        }
                    }
                    if (bl) continue;
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ConversionException conversionException) {
                    V.error("Unable to establish new office connection", conversionException);
                }
            }
        }

        public void B() {
            this.C = false;
            this.B.interrupt();
        }
    }

    static class ImagePathFixer {
        ImagePathFixer() {
        }

        private static int readCharAndWrite(Reader reader, Writer writer) throws IOException {
            int n = reader.read();
            if (n != -1) {
                writer.write(n);
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void fixHTMLImagePaths(File file) throws IOException {
            if (V.isDebugEnabled()) {
                V.debug("Repairing image paths in file:" + file.getPath());
            }
            File file2 = FileUtilities.createTempFile("dm_", "htmlFix", file.getParentFile());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            BufferedWriter bufferedWriter = null;
            try {
                bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8"));
                int n = ImagePathFixer.readCharAndWrite(bufferedReader, bufferedWriter);
                while (n != -1) {
                    if (!(n != 60 || (n = ImagePathFixer.readCharAndWrite(bufferedReader, bufferedWriter)) != 73 && n != 105 || (n = ImagePathFixer.readCharAndWrite(bufferedReader, bufferedWriter)) != 77 && n != 109 || (n = ImagePathFixer.readCharAndWrite(bufferedReader, bufferedWriter)) != 71 && n != 103)) {
                        n = ImagePathFixer.readCharAndWrite(bufferedReader, bufferedWriter);
                        while (n != 62) {
                            if (!(n != 83 && n != 115 || (n = ImagePathFixer.readCharAndWrite(bufferedReader, bufferedWriter)) != 82 && n != 114 || (n = ImagePathFixer.readCharAndWrite(bufferedReader, bufferedWriter)) != 67 && n != 99)) {
                                n = ImagePathFixer.readCharAndWrite(bufferedReader, bufferedWriter);
                                while (Character.isWhitespace((char)n)) {
                                    n = ImagePathFixer.readCharAndWrite(bufferedReader, bufferedWriter);
                                }
                                if (n == 61) {
                                    n = ImagePathFixer.readCharAndWrite(bufferedReader, bufferedWriter);
                                    while (Character.isWhitespace((char)n)) {
                                        n = ImagePathFixer.readCharAndWrite(bufferedReader, bufferedWriter);
                                    }
                                    if (n == 34) {
                                        n = bufferedReader.read();
                                        if (n == 46) {
                                            n = bufferedReader.read();
                                            if (n == 46) {
                                                n = bufferedReader.read();
                                                if (n != 47) {
                                                    ((Writer)bufferedWriter).write(n);
                                                }
                                            } else {
                                                ((Writer)bufferedWriter).write(n);
                                            }
                                        } else {
                                            ((Writer)bufferedWriter).write(n);
                                        }
                                    }
                                }
                            }
                            n = ImagePathFixer.readCharAndWrite(bufferedReader, bufferedWriter);
                        }
                    }
                    n = ImagePathFixer.readCharAndWrite(bufferedReader, bufferedWriter);
                }
            }
            catch (Throwable throwable) {
                FileUtilities.close(bufferedReader);
                FileUtilities.close(bufferedWriter);
                throw throwable;
            }
            FileUtilities.close(bufferedReader);
            FileUtilities.close(bufferedWriter);
            FileUtilities.delete(file);
            file2.renameTo(file);
        }
    }

    private static class _A
    implements XMLComponentHandler {
        protected Writer B;
        private boolean A = false;

        public void A(Writer writer) {
            this.B = writer;
        }

        public boolean A() {
            return this.A;
        }

        @Override
        public void contentChunk(J j, long l, ODFContentAnalyzer.BufferedElementList bufferedElementList, ODFContentAnalyzer.BufferedElementList bufferedElementList2) throws IOException, TemplateParseException {
            if (this.B != null) {
                this.B.write(j.toString());
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void tag(J j, long l, ODFContentAnalyzer.BufferedElementList bufferedElementList, ODFContentAnalyzer.BufferedElementList bufferedElementList2) throws IOException, TemplateParseException {
            if (j.C("<?")) {
                if (this.B == null) return;
                this.B.write(j.toString());
                return;
            }
            if (j.C("<style:chart-properties")) {
                try {
                    XMLIndexedTag xMLIndexedTag = XMLIndexedTagParser.parse(j, 0L);
                    XMLIndexedAttribute xMLIndexedAttribute = xMLIndexedTag.getAttribute("loext:external-data");
                    if (xMLIndexedAttribute != null) {
                        this.A = true;
                        if (this.B == null) return;
                        String string = j.toString();
                        string = string.substring(0, (int)xMLIndexedAttribute.getKeyStartIdx()) + string.substring((int)xMLIndexedAttribute.getValueEndIdx() + 2);
                        this.B.write(string);
                        return;
                    }
                    if (this.B == null) return;
                    this.B.write(j.toString());
                    return;
                }
                catch (XMLIndexedTagParser.ParseException parseException) {
                    throw new TemplateParseException("Unable to process tag", parseException);
                }
            } else {
                if (this.B == null) return;
                this.B.write(j.toString());
            }
        }

        @Override
        public void finish(long l, ODFContentAnalyzer.BufferedElementList bufferedElementList) throws IOException, TemplateParseException {
            if (this.B != null) {
                this.B.flush();
            }
        }

        @Override
        public void setSkipFinalAnalysisValidation(boolean bl) {
        }

        @Override
        public J getStylesToPromoteToStylesXml() {
            return null;
        }

        @Override
        public void setStylesToPromoteToStylesXml(J j) {
        }

        @Override
        public ListStyles getListStylesOfInterest() {
            return null;
        }

        @Override
        public void setListStylesOfInterest(ListStyles listStyles) {
        }
    }
}

