/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.converter.openoffice;

import com.docmosis.document.converter.ConversionFormat;
import com.docmosis.util.DMProperties;
import com.docmosis.util.EngineVersion;
import java.util.HashMap;
import java.util.Map;

public class FormatStrings {
    public static final String PROP_ENCODED_TEXT_OUTPUT = "docmosis.converter.format.txt.encoded.enabled";
    public static final String PROP_DOCX_DEFAULT_VERSION = "docmosis.converter.format.docx.defaultVersion";
    private static final String A = "writer_pdf_Export";
    private static final String C = "writer8";
    private static final String H = "OpenDocument Text Flat XML";
    private static final String K = "MS Word 97";
    private static final String M = "Rich Text Format";
    private static final String L = "MS Word 2003 XML";
    private static final String G = "MS Word 2007 XML";
    private static final String F = "Office Open XML Text";
    private static final String E = "HTML (StarWriter)";
    private static final String D = "XHTML Writer File";
    private static final String J = "Text";
    private static final String B = "Text (encoded)";
    private static final Map I = new HashMap();

    public static String getFormatString(ConversionFormat conversionFormat) {
        return (String)I.get(conversionFormat);
    }

    public static void setEngineVersion(EngineVersion engineVersion) {
        String string = DMProperties.getString(PROP_DOCX_DEFAULT_VERSION, "latest");
        String string2 = null;
        string2 = string.equals("2007") ? G : (string.equals("2010") ? F : (engineVersion != null && engineVersion.isLibreOffice() && engineVersion.isVersionAtLeast("7.6") ? F : G));
        I.put(ConversionFormat.FORMAT_DOCX, string2);
    }

    public static boolean outputEncodedText() {
        return DMProperties.getBoolean(PROP_ENCODED_TEXT_OUTPUT, true);
    }

    static {
        I.put(ConversionFormat.FORMAT_PDF, A);
        I.put(ConversionFormat.FORMAT_WORD, K);
        I.put(ConversionFormat.FORMAT_WORD_XML, L);
        I.put(ConversionFormat.FORMAT_DOCX, G);
        I.put(ConversionFormat.FORMAT_ODT, C);
        I.put(ConversionFormat.FORMAT_FODT, H);
        I.put(ConversionFormat.FORMAT_RTF, M);
        I.put(ConversionFormat.FORMAT_HTML, E);
        I.put(ConversionFormat.FORMAT_XHTML, D);
        if (FormatStrings.outputEncodedText()) {
            I.put(ConversionFormat.FORMAT_TEXT, B);
        } else {
            I.put(ConversionFormat.FORMAT_TEXT, J);
        }
        I.put(ConversionFormat.FORMAT_ODS, "calc8");
        I.put(ConversionFormat.FORMAT_XLS, "MS Excel 97");
        I.put(ConversionFormat.FORMAT_XLSX, "MS Excel 97");
        I.put(ConversionFormat.FORMAT_PPT, "MS PowerPoint 97");
        I.put(ConversionFormat.FORMAT_ODG, "draw8");
        I.put(ConversionFormat.FORMAT_ODP, "impress8");
        I.put(ConversionFormat.FORMAT_JPG, "writer_jpg_Export");
        I.put(ConversionFormat.FORMAT_PNG, "writer_png_Export");
        I.put(ConversionFormat.FORMAT_CSV, "Text - txt - csv (StarCalc)");
    }
}

