/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.converter.openoffice;

import com.docmosis.util.DMProperties;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import com.sun.star.document.DocumentEvent;
import com.sun.star.document.XDocumentEventBroadcaster;
import com.sun.star.document.XDocumentEventListener;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XComponent;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XRefreshListener;
import com.sun.star.util.XRefreshable;

public class DocmosisDocumentEventListener
implements XDocumentEventListener,
XRefreshListener {
    private static final Logger E = LogManager.getLogger(DocmosisDocumentEventListener.class);
    private static final boolean H = DMProperties.getBoolean("docmosis.converter.event.listener.timeout.showEventTrace", false);
    private boolean F = false;
    private boolean D = false;
    private final String C;
    private final long I;
    private final long A;
    private XDocumentEventBroadcaster B;
    private XRefreshable G;

    public DocmosisDocumentEventListener(String string, long l, long l2, XComponent xComponent) {
        this.C = string;
        this.I = l;
        this.A = l2;
        this.B = (XDocumentEventBroadcaster)UnoRuntime.queryInterface(XDocumentEventBroadcaster.class, (Object)xComponent);
        if (this.B == null) {
            E.warn(string + " Unable to add event listener for document events");
        } else {
            this.B.addDocumentEventListener((XDocumentEventListener)this);
        }
        this.G = (XRefreshable)UnoRuntime.queryInterface(XRefreshable.class, (Object)xComponent);
        if (this.G == null) {
            E.warn(string + " Unable to add event listener for refresh events");
        } else {
            this.G.addRefreshListener((XRefreshListener)this);
        }
    }

    public void cleanup() {
        if (this.B != null) {
            this.B.removeDocumentEventListener((XDocumentEventListener)this);
            this.B = null;
        }
        if (this.G != null) {
            this.G.removeRefreshListener((XRefreshListener)this);
            this.G = null;
        }
    }

    public static void cleanup(DocmosisDocumentEventListener docmosisDocumentEventListener) {
        if (docmosisDocumentEventListener != null) {
            docmosisDocumentEventListener.cleanup();
        }
    }

    public void disposing(EventObject eventObject) {
    }

    public void documentEventOccured(DocumentEvent documentEvent) {
        if ("OnLayoutFinished".equals(documentEvent.EventName) || "OnPageCountChange".equals(documentEvent.EventName)) {
            this.F = true;
        }
    }

    public void refreshed(EventObject eventObject) {
        this.D = true;
    }

    public boolean awaitLayout() {
        long l = System.currentTimeMillis();
        try {
            long l2 = l + this.A;
            while (!this.F) {
                Thread.sleep(this.I);
                if (System.currentTimeMillis() < l2) continue;
                if (E.isDebugEnabled()) {
                    if (H) {
                        E.debug(this.C + " event [" + this.C + "] Timeout waiting for layout event", new Throwable("Event trace"));
                    } else {
                        E.debug(this.C + " event [" + this.C + "] Timeout waiting for layout event");
                    }
                }
                return true;
            }
            if (E.isDebugEnabled()) {
                E.debug(this.C + " layout wait:" + (System.currentTimeMillis() - l));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    public static boolean awaitLayout(DocmosisDocumentEventListener docmosisDocumentEventListener) {
        if (docmosisDocumentEventListener != null) {
            return docmosisDocumentEventListener.awaitLayout();
        }
        return false;
    }

    public boolean awaitRefresh() {
        long l = System.currentTimeMillis();
        try {
            long l2 = l + this.A;
            while (!this.D) {
                Thread.sleep(this.I);
                if (System.currentTimeMillis() < l2) continue;
                if (E.isDebugEnabled()) {
                    if (H) {
                        E.debug(this.C + " event [" + this.C + "] Timeout waiting for refresh event", new Throwable("Event trace"));
                    } else {
                        E.debug(this.C + " event [" + this.C + "] Timeout waiting for refresh event");
                    }
                }
                return true;
            }
            if (E.isDebugEnabled()) {
                E.debug(this.C + " refresh wait:" + (System.currentTimeMillis() - l));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    public static boolean awaitRefresh(DocmosisDocumentEventListener docmosisDocumentEventListener) {
        if (docmosisDocumentEventListener != null) {
            return docmosisDocumentEventListener.awaitRefresh();
        }
        return false;
    }

    public void reset() {
        this.F = false;
        this.D = false;
    }

    public static void reset(DocmosisDocumentEventListener docmosisDocumentEventListener) {
        if (docmosisDocumentEventListener != null) {
            docmosisDocumentEventListener.reset();
        }
    }
}

