/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.converter.openoffice;

import com.docmosis.ApplicationProducerInfo;
import com.docmosis.converter.openoffice.AbstractOpenOfficeConnection;
import com.docmosis.converter.openoffice.FormatStrings;
import com.docmosis.converter.openoffice.OODocumentHandle;
import com.docmosis.converter.openoffice.OOUtilities;
import com.docmosis.converter.openoffice.OpenOfficeServerLauncher;
import com.docmosis.document.converter.ConversionException;
import com.docmosis.document.converter.ConversionFormat;
import com.docmosis.document.converter.ConversionServiceFailureException;
import com.docmosis.util.DMProperties;
import com.docmosis.util.EngineVersion;
import com.docmosis.util.EngineVersionExtractor;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.StringUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.UnoUrlResolver;
import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.comp.helper.BootstrapException;
import com.sun.star.connection.NoConnectException;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.XChangesBatch;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Random;

public class BootstrapOpenOfficeConnection
extends AbstractOpenOfficeConnection {
    private static final int W = DMProperties.getInt("docmosis.openoffice.bootstrap.sleep.millis");
    private static final int M = DMProperties.getInt("docmosis.openoffice.bootstrap.retries");
    private static final String _ = "pipe_";
    private static final int V = 24;
    private static final int Q = 10;
    private static final int P = 3;
    private static final Logger R = LogManager.getLogger(BootstrapOpenOfficeConnection.class);
    private static final String Y = "docmosis.openoffice.bootstrap.registry.registrymods.file.producerXml";
    private static final boolean S = DMProperties.getBoolean("docmosis.openoffice.server.convert.on.startup");
    private static final String O = DMProperties.getString("docmosis.openoffice.server.convert.on.startup.document");
    private static final String L = DMProperties.getString("docmosis.openoffice.bootstrap.registry.common.file");
    private static final String T = DMProperties.getString("docmosis.openoffice.bootstrap.registry.registrymods.file");
    private XComponentContext X;
    private XComponentLoader U;
    private OpenOfficeServerLauncher.NonBlockingProcess N;
    private XDesktop K;
    private EngineVersion Z;

    BootstrapOpenOfficeConnection(File file, File file2, boolean bl) throws ConversionException, BootstrapPrimerException {
        OpenOfficeServerLauncher.NonBlockingProcess nonBlockingProcess = null;
        boolean bl2 = false;
        try {
            R.debug("commencing bootstrap launch");
            nonBlockingProcess = OpenOfficeServerLauncher.createPipeInstance(file, file2.getName(), StringUtilities.filePathToURLString(file2.getPath()));
            R.debug("commencing initialisation");
            this.initialise(file2.getName(), nonBlockingProcess);
            String string = null;
            try {
                string = this.getOfficeVersionNumber();
            }
            catch (com.sun.star.uno.Exception exception) {
                R.warn("Unable to determine engine version info.  IO error:" + exception.getMessage());
            }
            try {
                this.Z = new EngineVersionExtractor().getEngineVersionInfo(string);
            }
            catch (IllegalStateException illegalStateException) {
                R.warn("Unable to determine engine version info.  Docmosis not initialized");
            }
            catch (IOException iOException) {
                R.warn("Unable to determine engine version info.  IO error:" + iOException.getMessage());
            }
            try {
                this.logConnectionDetails(bl);
            }
            catch (Exception exception) {
                throw new ConversionException(exception);
            }
            FormatStrings.setEngineVersion(this.Z);
            try {
                this.updateApplicationProducerInfo();
            }
            catch (com.sun.star.uno.Exception exception) {
                R.warn("Could not update engine application property", exception);
            }
            if (S) {
                try {
                    this.doInitialConvert();
                }
                catch (Exception exception) {
                    throw new ConversionException(exception);
                }
            }
            R.debug("initialisation done");
            bl2 = true;
        }
        catch (IOException iOException) {
            R.debug("initialisation failed", iOException);
            throw new ConversionException(iOException);
        }
        catch (ConversionException conversionException) {
            R.debug("initialisation failed", conversionException);
            throw new ConversionException(conversionException);
        }
        finally {
            if (!bl2) {
                this.shutdown();
            }
        }
    }

    private void initialise(String string, OpenOfficeServerLauncher.NonBlockingProcess nonBlockingProcess) throws ConversionException, BootstrapPrimerException {
        this.N = nonBlockingProcess;
        try {
            Object object;
            XComponentContext xComponentContext = Bootstrap.createInitialComponentContext(null);
            R.debug("Connecting to a running office ...");
            XUnoUrlResolver xUnoUrlResolver = UnoUrlResolver.create((XComponentContext)xComponentContext);
            String string2 = "uno:pipe,name=" + string + ";urp;StarOffice.ComponentContext";
            for (int i = 0; i < M; ++i) {
                try {
                    object = xUnoUrlResolver.resolve(string2);
                    this.X = (XComponentContext)UnoRuntime.queryInterface(XComponentContext.class, (Object)object);
                    if (this.X == null) {
                        throw new BootstrapException("Unable to obtain a connection to Open Office");
                    }
                    R.debug("Connected");
                    break;
                }
                catch (NoConnectException noConnectException) {
                    Thread.sleep(W);
                    continue;
                }
            }
            if (this.X == null) {
                throw new ConversionException("Unable to connect to Open Office.  It has not started correctly.\nCheck:\n  - your \"docmosis.openoffice.location\" setting (currently \"" + DMProperties.getString("docmosis.openoffice.location") + "\")\n" + "  - you have write-permission to your home dir and temp dir\n" + "  - whether you have .crash-report files in your home dir from Open Office\n" + "  - whether installing another Java version helps (this has been noted for Open Office on some\n" + "    headless installations).\n" + "  - http://www.docmosis.com FAQ");
            }
            XMultiComponentFactory xMultiComponentFactory = this.X.getServiceManager();
            object = xMultiComponentFactory.createInstanceWithContext("com.sun.star.frame.Desktop", this.X);
            this.U = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)object);
            this.K = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)object);
        }
        catch (BootstrapPrimerException bootstrapPrimerException) {
            throw bootstrapPrimerException;
        }
        catch (Exception exception) {
            throw new ConversionException(exception);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if ("64".equals(System.getProperty("sun.arch.data.model"))) {
                R.warn("64 bit Java is only compatible with 64 bit LibreOffice/OpenOffice installations.  On Solaris and OSX you could try running Java with -d32.  On other platforms use a 32 bit Java installation.");
                throw new ConversionException("Your Java is 64 bit but perhaps your LibreOffice/OpenOffice is not.", unsatisfiedLinkError);
            }
            R.warn("32 bit Java is only compatible with 32 bit LibreOffice/OpenOffice installations.");
            throw new ConversionException("Your Java is 32 bit but perhaps your LibreOffice/OpenOffice is not.", unsatisfiedLinkError);
        }
    }

    private String getOfficeVersionNumber() throws com.sun.star.uno.Exception {
        String string = null;
        String[] stringArray = DMProperties.getStringArray("docmosis.openoffice.bootstrap.connection.properties.log.versionPropertiesSearch", ";");
        List<String> list = OOUtilities.getConfigurationSettings(this.X, stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (list.get(i) == null) continue;
            string = list.get(i);
            break;
        }
        return string;
    }

    private void logConnectionDetails(boolean bl) throws com.sun.star.uno.Exception {
        if (bl) {
            OOUtilities.getConfigurationSettings(this.X, new String[0]);
            String string = this.getOfficeVersionNumber();
            String string2 = null;
            String string3 = this.Z.getVendor();
            Object object = DMProperties.getStringArray("docmosis.openoffice.bootstrap.connection.properties.log.namePropertiesSearch", ";");
            Object object2 = OOUtilities.getConfigurationSettings(this.X, (String[])object);
            for (int i = 0; i < ((String[])object).length; ++i) {
                if (object2.get(i) == null) continue;
                string2 = object2.get(i);
                break;
            }
            object = new StringBuffer();
            if (!StringUtilities.isEmpty(string2)) {
                ((StringBuffer)object).append(string2);
            }
            if (!StringUtilities.isEmpty(string)) {
                ((StringBuffer)object).append(" version " + string);
            }
            if (!StringUtilities.isEmpty(string3)) {
                ((StringBuffer)object).append(" (" + string3 + ")");
            }
            if (((StringBuffer)object).length() > 0) {
                ((StringBuffer)object).insert(0, "Connected to engine:");
            }
            R.info(((StringBuffer)object).toString());
            if (R.isInfoEnabled()) {
                try {
                    object2 = "org.openoffice.Office.Common/VCL/UseOpenGL";
                    String string4 = "org.openoffice.Office.Common/VCL/ForceOpenGL";
                    String[] stringArray = new String[]{"org.openoffice.Office.Common/VCL/UseOpenGL", "org.openoffice.Office.Common/VCL/ForceOpenGL"};
                    List<String> list = OOUtilities.getConfigurationSettings(this.X, stringArray);
                    String string5 = null;
                    String string6 = null;
                    if (list.size() != stringArray.length) {
                        R.warn("Could not determine open GL settings.  Got list size " + list.size() + " expected " + stringArray.length);
                    } else {
                        string5 = String.valueOf(list.get(0));
                        string6 = String.valueOf(list.get(1));
                    }
                    R.info("OpenGL active:" + string5);
                    R.info("OpenGL forced:" + string6);
                }
                catch (Exception exception) {
                    R.warn("Error testing OPENGL configuration", exception);
                }
            }
        }
    }

    @Override
    protected XComponentContext getComponentContext() {
        return this.X;
    }

    @Override
    protected XComponentLoader getComponentLoader() {
        return this.U;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.N != null) {
            this.N.goSilent();
        }
        OfficeGracefulTerminator officeGracefulTerminator = new OfficeGracefulTerminator(this.K);
        officeGracefulTerminator.await(10000L);
        if (!officeGracefulTerminator.completed()) {
            R.debug("office shutdown not gracefully completed");
        } else {
            R.debug("office shutdown gracefully completed");
        }
        officeGracefulTerminator = null;
        if (this.N != null) {
            this.N.destroy();
        }
    }

    static synchronized File createUniquePipeDir() throws IOException {
        int n = 100;
        File file = new File(System.getProperty("java.io.tmpdir"));
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.canWrite()) {
            throw new IOException("Unable to write into temp area:" + file.getPath());
        }
        if ((file = new File(file, "docmosis")).exists() && !file.canWrite()) {
            throw new IOException("Unable to write into temp area:" + file.getPath());
        }
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            String string = BootstrapOpenOfficeConnection.getUniquePipeDirString(random);
            File file2 = new File(file, string);
            if (file2.exists()) continue;
            if (!file2.mkdirs()) {
                throw new IOException("Unable to create tmp dir:" + file2.getPath());
            }
            if (!BootstrapOpenOfficeConnection.createRegistryCommonFile(file2)) {
                R.warn("Unable to create registry common file.");
            }
            return file2;
        }
        throw new IOException("Unable to create unique pipe dir in \"" + file.getPath() + "\" after " + 100 + " attempts");
    }

    static String getUniquePipeDirString(Random random) {
        String string = BootstrapOpenOfficeConnection.getValidPipePrefix();
        int n = 24 - string.length();
        String string2 = Long.toString(random.nextLong() & Long.MAX_VALUE);
        int n2 = string2.length() - n;
        if (n2 > 0) {
            string2 = string2.substring(n2);
        } else if (n2 < 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < 0 - n2; ++i) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string2);
            string2 = stringBuffer.toString();
        }
        return string + string2;
    }

    static String getValidPipePrefix() {
        String string = DMProperties.getString("docmosis.openoffice.bootstrap.random.pipe.prefix");
        if (string == null || string.equals("")) {
            R.warn("Cannot use null or empty string as a prefix for the pipe directory.  Found: " + string + ".  Using default value: " + _);
            string = _;
        } else if (string.length() > 10) {
            R.warn("Prefix for the pipe directory cannot be more than 10 characters.  Found: " + string + ".  Using default value: " + _);
            string = _;
        } else if (string.length() < 3) {
            R.warn("Prefix for the pipe directory cannot be less than 3 characters.  Found: " + string + ".  Using default value: " + _);
            string = _;
        } else if (!string.matches("[0-9a-zA-Z\\-\\.\\_]*")) {
            R.warn("String must be alpha numeric and/or containing '-' (hyphen), '.' (period), '_' (underscore).  Found: " + string + ".  Using default value: " + _);
            string = _;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean createRegistryCommonFile(File file) throws IOException {
        boolean bl;
        block9: {
            StringBuffer stringBuffer;
            block8: {
                Object object;
                Object object2;
                String string;
                String string2;
                bl = false;
                stringBuffer = new StringBuffer(file.getCanonicalPath());
                stringBuffer.append(File.separator);
                stringBuffer.append("user");
                stringBuffer.append(File.separator);
                stringBuffer.append("registry");
                stringBuffer.append(File.separator);
                stringBuffer.append("data");
                stringBuffer.append(File.separator);
                stringBuffer.append("org");
                stringBuffer.append(File.separator);
                stringBuffer.append("openoffice");
                stringBuffer.append(File.separator);
                stringBuffer.append("Office");
                String string3 = stringBuffer.toString();
                File file2 = new File(string3);
                bl = file2.mkdirs();
                if (!bl) break block8;
                if (DMProperties.getBoolean("docmosis.openoffice.bootstrap.registry.common.file.preInstall", true)) {
                    string2 = "Common.xcu";
                    string = string3 + File.separator + "Common.xcu";
                    R.debug("Installing " + string);
                    object2 = new File(string);
                    object = BootstrapOpenOfficeConnection.class.getClassLoader().getResourceAsStream(L);
                    try {
                        FileUtilities.storeToFile((InputStream)object, (File)object2);
                    }
                    finally {
                        FileUtilities.close((InputStream)object);
                    }
                }
                if (!DMProperties.getBoolean("docmosis.openoffice.bootstrap.registry.registrymods.file.preInstall", true)) break block9;
                string2 = "docmosis.openoffice.bootstrap.registry.registrymods.file.openGLEnabled";
                string = "docmosis.openoffice.bootstrap.registry.registrymods.file.openGLForced";
                object2 = "docmosis.openoffice.bootstrap.registry.registrymods.file.charBackgroundToHighlighting";
                object = DMProperties.getBoolean("docmosis.openoffice.bootstrap.registry.registrymods.file.openGLEnabled", false);
                Boolean bl2 = DMProperties.getBoolean("docmosis.openoffice.bootstrap.registry.registrymods.file.openGLForced", false);
                Boolean bl3 = DMProperties.getBoolean("docmosis.openoffice.bootstrap.registry.registrymods.file.charBackgroundToHighlighting", true);
                String string4 = StringUtilities.escapeParsedXmlChars(ApplicationProducerInfo.getProducerString(null));
                String string5 = DMProperties.getString(Y, "<item oor:path=\"/org.openoffice.Office.Common/Save/Document\">  <prop oor:name=\"GeneratorOverride\" oor:op=\"fuse\"><value><<" + string4 + ">></value></prop>" + "</item>");
                String string6 = "registrymodifications.xcu";
                String string7 = string3 + File.separator + "registrymodifications.xcu";
                R.debug("Installing " + string7);
                File file3 = new File(string7);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(BootstrapOpenOfficeConnection.class.getClassLoader().getResourceAsStream(T), "UTF-8"));
                BufferedWriter bufferedWriter = null;
                try {
                    String string8;
                    bufferedWriter = new BufferedWriter(new FileWriter(file3));
                    while ((string8 = bufferedReader.readLine()) != null) {
                        string8 = string8.replaceAll("<<docmosis.openoffice.bootstrap.registry.registrymods.file.openGLEnabled>>", ((Boolean)object).toString());
                        string8 = string8.replaceAll("<<docmosis.openoffice.bootstrap.registry.registrymods.file.openGLForced>>", bl2.toString());
                        string8 = string8.replaceAll("<<docmosis.openoffice.bootstrap.registry.registrymods.file.charBackgroundToHighlighting>>", bl3.toString());
                        string8 = string8.replaceAll("<<docmosis.openoffice.bootstrap.registry.registrymods.file.producerXml>>", string5);
                        bufferedWriter.write(string8);
                    }
                }
                catch (Throwable throwable) {
                    FileUtilities.close(bufferedWriter);
                    FileUtilities.close(bufferedReader);
                    throw throwable;
                }
                FileUtilities.close(bufferedWriter);
                FileUtilities.close(bufferedReader);
                break block9;
            }
            R.warn("Could not create directory: " + stringBuffer.toString());
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInitialConvert() throws ConversionException, IOException, URISyntaxException, BootstrapPrimerException {
        InputStream inputStream;
        File file;
        File file2;
        File file3;
        File file4;
        block9: {
            long l = System.currentTimeMillis();
            file4 = null;
            file3 = null;
            file2 = null;
            file = null;
            inputStream = null;
            try {
                file4 = FileUtilities.createTempFile("dm_init", "odf");
                file3 = FileUtilities.createTempFile("dm_init", "doc");
                file2 = FileUtilities.createTempFile("dm_init", "pdf");
                file = FileUtilities.createTempFile("dummy", ".doc");
                inputStream = this.getClass().getClassLoader().getResourceAsStream(O);
                if (inputStream == null) {
                    R.warn("===========================================================================");
                    R.warn("Could not find " + O + ".  Your first conversion will be slower than usual.");
                    R.warn("===========================================================================");
                    break block9;
                }
                FileUtilities.storeToFile(inputStream, file);
                OODocumentHandle oODocumentHandle = null;
                try {
                    oODocumentHandle = this.loadDocument(StringUtilities.filePathToURLString(file.getPath()), false);
                    this.updateTOC(oODocumentHandle);
                    this.saveDocument(oODocumentHandle, StringUtilities.fileToURLString(file4), ConversionFormat.FORMAT_ODT, null);
                    this.saveDocument(oODocumentHandle, StringUtilities.fileToURLString(file3), ConversionFormat.FORMAT_WORD, null);
                    this.saveDocument(oODocumentHandle, StringUtilities.fileToURLString(file2), ConversionFormat.FORMAT_PDF, null);
                    this.closeDocument(oODocumentHandle);
                }
                catch (ConversionServiceFailureException conversionServiceFailureException) {
                    boolean bl = false;
                    for (Throwable throwable = conversionServiceFailureException; throwable != null; throwable = throwable.getCause()) {
                        if (throwable instanceof DisposedException) {
                            bl = true;
                            break;
                        }
                        if (throwable == throwable.getCause()) break;
                    }
                    if (bl) {
                        throw new BootstrapPrimerException(conversionServiceFailureException);
                    }
                    throw conversionServiceFailureException;
                }
                if (R.isDebugEnabled()) {
                    R.debug("Converter primed in millis:" + (System.currentTimeMillis() - l));
                }
            }
            catch (Throwable throwable) {
                FileUtilities.close(inputStream);
                FileUtilities.delete(file4);
                FileUtilities.delete(file3);
                FileUtilities.delete(file2);
                FileUtilities.delete(file);
                throw throwable;
            }
        }
        FileUtilities.close(inputStream);
        FileUtilities.delete(file4);
        FileUtilities.delete(file3);
        FileUtilities.delete(file2);
        FileUtilities.delete(file);
    }

    private void updateApplicationProducerInfo() throws com.sun.star.uno.Exception {
        if (ApplicationProducerInfo.isSetProducerEnabled()) {
            XMultiComponentFactory xMultiComponentFactory = this.X.getServiceManager();
            String string = "com.sun.star.configuration.ConfigurationProvider";
            XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xMultiComponentFactory.createInstanceWithContext(string, this.X));
            String string2 = "com.sun.star.configuration.ConfigurationUpdateAccess";
            PropertyValue propertyValue = new PropertyValue();
            propertyValue.Name = "nodepath";
            propertyValue.Value = "org.openoffice.Office.Common/Save/Document";
            Object[] objectArray = new Object[]{propertyValue};
            Object object = xMultiServiceFactory.createInstanceWithArguments(string2, objectArray);
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object);
            if (xPropertySet != null) {
                xPropertySet.setPropertyValue("GeneratorOverride", (Object)ApplicationProducerInfo.getProducerString(this.Z));
                XChangesBatch xChangesBatch = (XChangesBatch)UnoRuntime.queryInterface(XChangesBatch.class, (Object)object);
                xChangesBatch.commitChanges();
            }
        }
    }

    @Override
    public EngineVersion getEngineVersionInfo() {
        return this.Z;
    }

    static class BootstrapPrimerException
    extends Exception {
        public BootstrapPrimerException(Throwable throwable) {
            super(throwable);
        }
    }

    private static class OfficeGracefulTerminator
    implements Runnable {
        private Thread thread;
        private XDesktop xDesktop;
        private boolean completed;

        public OfficeGracefulTerminator(XDesktop xDesktop) {
            this.xDesktop = xDesktop;
            this.thread = new Thread((Runnable)this, "OfficeGracefulTerminator");
            this.thread.setDaemon(true);
            this.thread.start();
        }

        public boolean completed() {
            return this.completed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void await(long l) {
            try {
                OfficeGracefulTerminator officeGracefulTerminator = this;
                synchronized (officeGracefulTerminator) {
                    if (!this.completed) {
                        this.wait(l);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                R.info("wait interrupted");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.xDesktop != null) {
                    this.xDesktop.terminate();
                    Thread.sleep(2000L);
                }
            }
            catch (Exception exception) {
                R.debug("An error occurred during xDesktop.terminate().", exception);
            }
            finally {
                this.xDesktop = null;
                this.completed = true;
                OfficeGracefulTerminator officeGracefulTerminator = this;
                synchronized (officeGracefulTerminator) {
                    this.notify();
                }
            }
        }
    }
}

