/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.converter.openoffice;

import com.docmosis.converter.openoffice.BadDocumentException;
import com.docmosis.converter.openoffice.BadDocumentLocationException;
import com.docmosis.converter.openoffice.BadFormatException;
import com.docmosis.converter.openoffice.FormatStrings;
import com.docmosis.converter.openoffice.OODocumentHandle;
import com.docmosis.converter.openoffice.OOUtilities;
import com.docmosis.converter.openoffice.OpenOfficeConnection;
import com.docmosis.converter.openoffice.ServiceUnavailableException;
import com.docmosis.document.converter.ConversionFormat;
import com.docmosis.document.converter.ConversionServiceFailureException;
import com.docmosis.util.DMProperties;
import com.docmosis.util.EngineVersion;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.uno.Exception;
import com.sun.star.uno.XComponentContext;
import java.util.Map;

public abstract class AbstractOpenOfficeConnection
implements OpenOfficeConnection {
    private static final Logger F = LogManager.getLogger(AbstractOpenOfficeConnection.class);
    private final HangMonitor D = new HangMonitor(this);
    private boolean E;

    protected abstract XComponentContext getComponentContext();

    protected abstract XComponentLoader getComponentLoader();

    @Override
    public final OODocumentHandle loadDocument(String string, boolean bl) throws ConversionServiceFailureException {
        if (this.E) {
            return null;
        }
        return this.D.loadDocument(string, bl);
    }

    private final OODocumentHandle loadDocumentInternal(String string, boolean bl) throws ConversionServiceFailureException {
        long l = 0L;
        if (F.isTraceEnabled()) {
            l = System.currentTimeMillis();
        }
        try {
            OODocumentHandle oODocumentHandle = OOUtilities.loadDoc(this.getComponentContext(), this.getComponentLoader(), string, bl, this.getEngineVersionInfo());
            return oODocumentHandle;
        }
        catch (ServiceUnavailableException serviceUnavailableException) {
            throw new ConversionServiceFailureException("Unable to load document:" + string, serviceUnavailableException);
        }
        catch (BadDocumentException badDocumentException) {
            throw new ConversionServiceFailureException("Unable to load document:" + string, badDocumentException, false);
        }
        catch (BadDocumentLocationException badDocumentLocationException) {
            throw new ConversionServiceFailureException("Unable to load document:" + string, badDocumentLocationException, false);
        }
        finally {
            if (F.isTraceEnabled()) {
                F.trace("loadDocument took " + (System.currentTimeMillis() - l));
            }
        }
    }

    @Override
    public final int getPageCount(OODocumentHandle oODocumentHandle) throws ConversionServiceFailureException {
        if (this.E) {
            return 0;
        }
        return this.D.getPageCount(oODocumentHandle);
    }

    private final Integer getPageCountInternal(OODocumentHandle oODocumentHandle) throws ConversionServiceFailureException {
        long l = 0L;
        if (F.isTraceEnabled()) {
            l = System.currentTimeMillis();
        }
        try {
            Integer n = new Integer(OOUtilities.getPageCount(oODocumentHandle.getDocument()));
            return n;
        }
        catch (ServiceUnavailableException serviceUnavailableException) {
            throw new ConversionServiceFailureException("Unable to get page count", serviceUnavailableException);
        }
        finally {
            if (F.isTraceEnabled()) {
                F.trace("getPageCount took " + (System.currentTimeMillis() - l));
            }
        }
    }

    @Override
    public final void saveDocument(OODocumentHandle oODocumentHandle, String string, ConversionFormat conversionFormat, Map map) throws ConversionServiceFailureException {
        if (this.E) {
            return;
        }
        String string2 = FormatStrings.getFormatString(conversionFormat);
        if (string2 == null) {
            throw new ConversionServiceFailureException("format not supported:[" + conversionFormat.getFormatName() + "] [" + conversionFormat.getExtension() + "]", false);
        }
        this.D.saveDocument(oODocumentHandle, string, conversionFormat, map);
    }

    private final void saveDocumentInternal(OODocumentHandle oODocumentHandle, String string, ConversionFormat conversionFormat, Map map) throws ConversionServiceFailureException {
        long l = 0L;
        if (F.isTraceEnabled()) {
            l = System.currentTimeMillis();
        }
        try {
            String string2 = FormatStrings.getFormatString(conversionFormat);
            if (string2 == null) {
                throw new ConversionServiceFailureException("format not supported:[" + conversionFormat.getFormatName() + "] [" + conversionFormat.getExtension() + "]", false);
            }
            OOUtilities.storeDocComponent(oODocumentHandle.getDocument(), oODocumentHandle.getComponentContext(), string, conversionFormat, map);
        }
        catch (ServiceUnavailableException serviceUnavailableException) {
            throw new ConversionServiceFailureException("Unable to save document:" + string, serviceUnavailableException);
        }
        catch (BadFormatException badFormatException) {
            throw new ConversionServiceFailureException("Unable to save document, format not configured:" + conversionFormat.getFormatName(), badFormatException, false);
        }
        catch (Exception exception) {
            throw new ConversionServiceFailureException("Unable to save document, format not configured:" + conversionFormat.getFormatName(), exception, false);
        }
        finally {
            if (F.isTraceEnabled()) {
                F.trace("saveDocument (" + conversionFormat.getExtension() + ") took " + (System.currentTimeMillis() - l));
            }
        }
    }

    @Override
    public final void closeDocument(OODocumentHandle oODocumentHandle) throws ConversionServiceFailureException {
        if (this.E) {
            return;
        }
        this.D.closeDocument(oODocumentHandle);
    }

    private final void closeDocumentInternal(OODocumentHandle oODocumentHandle) throws ConversionServiceFailureException {
        long l = 0L;
        if (F.isTraceEnabled()) {
            l = System.currentTimeMillis();
        }
        try {
            if (oODocumentHandle != null) {
                OOUtilities.closeDoc(oODocumentHandle.getDocument());
            }
        }
        catch (ServiceUnavailableException serviceUnavailableException) {
            throw new ConversionServiceFailureException("Unable to close document.", serviceUnavailableException);
        }
        finally {
            if (F.isTraceEnabled()) {
                F.trace("closeDocument took " + (System.currentTimeMillis() - l));
            }
        }
    }

    @Override
    public final void updateTOC(OODocumentHandle oODocumentHandle) throws ConversionServiceFailureException {
        if (this.E) {
            return;
        }
        this.D.updateTOC(oODocumentHandle);
    }

    private final void updateTOCInternal(OODocumentHandle oODocumentHandle) throws ConversionServiceFailureException {
        long l = 0L;
        if (F.isTraceEnabled()) {
            l = System.currentTimeMillis();
        }
        try {
            OOUtilities.updateTOC(oODocumentHandle.getDocument());
        }
        catch (ServiceUnavailableException serviceUnavailableException) {
            throw new ConversionServiceFailureException(serviceUnavailableException);
        }
        finally {
            if (F.isTraceEnabled()) {
                F.trace("updateTOC took " + (System.currentTimeMillis() - l));
            }
        }
    }

    @Override
    public final void insertDocumentAtBookmark(OODocumentHandle oODocumentHandle, String string, String string2, boolean bl, boolean bl2, String string3, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws ConversionServiceFailureException {
        if (this.E) {
            return;
        }
        this.D.insertDocumentAtBookmark(oODocumentHandle, string, string2, bl, bl2, string3, bl3, bl4, bl5, bl6);
    }

    private final void insertDocInternal(OODocumentHandle oODocumentHandle, String string, String string2, boolean bl, boolean bl2, String string3, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws ConversionServiceFailureException {
        long l = 0L;
        if (F.isTraceEnabled()) {
            l = System.currentTimeMillis();
        }
        try {
            OOUtilities.insertDocumentAtBookmark(oODocumentHandle.getDocument(), string, string2, bl, bl2, string3, bl3, bl4, bl5, bl6, this.getEngineVersionInfo());
        }
        catch (ServiceUnavailableException serviceUnavailableException) {
            throw new ConversionServiceFailureException(serviceUnavailableException);
        }
        catch (BadDocumentException badDocumentException) {
            throw new ConversionServiceFailureException(badDocumentException.getMessage(), false);
        }
        finally {
            if (F.isTraceEnabled()) {
                F.trace("insertDoc took " + (System.currentTimeMillis() - l));
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.D != null) {
            this.D.shutdown();
        }
    }

    private static class HangMonitor
    implements Runnable,
    OpenOfficeConnection {
        private static final long OFFICE_OPERATION_TASK_TIMEOUT = DMProperties.getLong("docmosis.converter.timeout.after", 120000L);
        private boolean running = true;
        private Thread runningThread;
        private AbstractOpenOfficeConnection delegate;
        private boolean taskComplete;
        private Operation operation;
        private Object[] params;
        private Object results;
        private ConversionServiceFailureException exceptionThrown;

        public HangMonitor(AbstractOpenOfficeConnection abstractOpenOfficeConnection) {
            this.delegate = abstractOpenOfficeConnection;
            this.runningThread = new Thread(this);
            this.runningThread.setName("DMReliabilityService");
            this.runningThread.setDaemon(true);
            this.runningThread.start();
        }

        @Override
        public void shutdown() {
            this.running = false;
            if (this.runningThread != null) {
                this.runningThread.interrupt();
                this.runningThread = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                try {
                    HangMonitor hangMonitor = this;
                    synchronized (hangMonitor) {
                        while (this.operation == null) {
                            this.wait();
                        }
                        this.results = null;
                        this.exceptionThrown = null;
                        this.taskComplete = false;
                    }
                    try {
                        if (this.operation == Operation.LOAD) {
                            this.results = this.delegate.loadDocumentInternal((String)this.params[0], Boolean.TRUE.equals(this.params[1]));
                        } else if (this.operation == Operation.SAVE) {
                            this.delegate.saveDocumentInternal((OODocumentHandle)this.params[0], (String)this.params[1], (ConversionFormat)this.params[2], (Map)this.params[3]);
                        } else if (this.operation == Operation.CLOSE) {
                            this.delegate.closeDocumentInternal((OODocumentHandle)this.params[0]);
                        } else if (this.operation == Operation.UPDATE_TOC) {
                            this.delegate.updateTOCInternal((OODocumentHandle)this.params[0]);
                        } else if (this.operation == Operation.INSERT_DOC) {
                            this.delegate.insertDocInternal((OODocumentHandle)this.params[0], (String)this.params[1], (String)this.params[2], Boolean.TRUE.equals(this.params[3]), Boolean.TRUE.equals(this.params[4]), (String)this.params[5], Boolean.TRUE.equals(this.params[6]), Boolean.TRUE.equals(this.params[7]), Boolean.TRUE.equals(this.params[8]), Boolean.TRUE.equals(this.params[9]));
                        } else if (this.operation == Operation.GET_PAGE_COUNT) {
                            this.results = this.delegate.getPageCountInternal((OODocumentHandle)this.params[0]);
                        }
                        this.taskComplete = true;
                    }
                    catch (ConversionServiceFailureException conversionServiceFailureException) {
                        this.exceptionThrown = conversionServiceFailureException;
                    }
                    catch (RuntimeException runtimeException) {
                        this.exceptionThrown = new ConversionServiceFailureException("Unexpected RuntimeException", runtimeException);
                    }
                    this.operation = null;
                    this.params = null;
                    hangMonitor = this;
                    synchronized (hangMonitor) {
                        this.notify();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            F.debug("Shutting down");
        }

        @Override
        public OODocumentHandle loadDocument(String string, boolean bl) throws ConversionServiceFailureException {
            return (OODocumentHandle)this.enqueue(Operation.LOAD, new Object[]{string, bl ? Boolean.TRUE : Boolean.FALSE});
        }

        @Override
        public void closeDocument(OODocumentHandle oODocumentHandle) throws ConversionServiceFailureException {
            this.enqueue(Operation.CLOSE, new Object[]{oODocumentHandle});
        }

        @Override
        public void saveDocument(OODocumentHandle oODocumentHandle, String string, ConversionFormat conversionFormat, Map map) throws ConversionServiceFailureException {
            this.enqueue(Operation.SAVE, new Object[]{oODocumentHandle, string, conversionFormat, map});
        }

        @Override
        public void updateTOC(OODocumentHandle oODocumentHandle) throws ConversionServiceFailureException {
            this.enqueue(Operation.UPDATE_TOC, new Object[]{oODocumentHandle});
        }

        @Override
        public int getPageCount(OODocumentHandle oODocumentHandle) throws ConversionServiceFailureException {
            return (Integer)this.enqueue(Operation.GET_PAGE_COUNT, new Object[]{oODocumentHandle});
        }

        @Override
        public void insertDocumentAtBookmark(OODocumentHandle oODocumentHandle, String string, String string2, boolean bl, boolean bl2, String string3, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws ConversionServiceFailureException {
            this.enqueue(Operation.INSERT_DOC, new Object[]{oODocumentHandle, string, string2, bl ? Boolean.TRUE : Boolean.FALSE, bl2 ? Boolean.TRUE : Boolean.FALSE, string3, bl3 ? Boolean.TRUE : Boolean.FALSE, bl4 ? Boolean.TRUE : Boolean.FALSE, bl5 ? Boolean.TRUE : Boolean.FALSE, bl6 ? Boolean.TRUE : Boolean.FALSE});
        }

        @Override
        public EngineVersion getEngineVersionInfo() {
            return this.delegate.getEngineVersionInfo();
        }

        private synchronized Object enqueue(Operation operation, Object[] objectArray) throws ConversionServiceFailureException {
            long l;
            this.taskComplete = false;
            this.operation = operation;
            this.params = objectArray;
            boolean bl = F.isDebugEnabled();
            long l2 = bl ? System.currentTimeMillis() : 0L;
            this.notify();
            try {
                this.wait(OFFICE_OPERATION_TASK_TIMEOUT);
            }
            catch (InterruptedException interruptedException) {
                throw new ConversionServiceFailureException(operation + " aborted - interrupted", interruptedException);
            }
            long l3 = l = bl ? System.currentTimeMillis() : 0L;
            if (bl) {
                F.debug(operation + " took:" + (l - l2));
            }
            if (this.exceptionThrown != null) {
                throw this.exceptionThrown;
            }
            if (!this.taskComplete) {
                this.delegate.E = true;
                throw new ConversionServiceFailureException("request to open office to \"" + operation + "\" " + "took too long and has been aborted" + ".");
            }
            return this.results;
        }

        private static class Operation {
            public static final Operation LOAD = new Operation("load");
            public static final Operation SAVE = new Operation("save");
            public static final Operation CLOSE = new Operation("close");
            public static final Operation UPDATE_TOC = new Operation("update TOCs");
            public static final Operation INSERT_DOC = new Operation("insert DOC");
            public static final Operation GET_PAGE_COUNT = new Operation("get page count");
            private String name;

            private Operation(String string) {
                this.name = string;
            }

            public String toString() {
                return this.name;
            }
        }
    }
}

