/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis;

import com.docmosis.Version;
import com.docmosis.document.converter.B;
import com.docmosis.document.converter.pool.ConverterPool;
import com.docmosis.document.converter.pool.ConverterPoolException;
import com.docmosis.template.TemplateStoreException;
import com.docmosis.template.population.PopulatorFactory;
import com.docmosis.template.population.render.RendererRegistry;
import com.docmosis.template.store.TemplateStoreFactory;
import com.docmosis.util.Configuration;
import com.docmosis.util.DMProperties;
import com.docmosis.util.InvalidLicenseException;
import com.docmosis.util.M;
import com.docmosis.util.O;
import com.docmosis.util.StartupException;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.IOException;
import java.io.InputStream;

public final class SystemManager {
    private static boolean B = false;
    private static final Logger C = LogManager.getLogger(SystemManager.class);
    private static final String E = "com.docmosis.util.O";
    private static final String F = "docmosis.key";
    private static int D;
    private static final Thread A;

    public static synchronized void initialise() throws StartupException {
        SystemManager.initialise(null);
    }

    public static synchronized void initialise(Configuration configuration) throws StartupException {
        long l = System.currentTimeMillis();
        String string = Version.getVersion();
        if (C.isInfoEnabled()) {
            C.info("Docmosis version [" + string + "] initialising");
        }
        try {
            if (!B) {
                SystemManager.initConfig(configuration);
                int n = SystemManager.validateFeatureStatus(true);
                SystemManager.initConverterPool(n);
                SystemManager.validateFeatureStatus(false);
                SystemManager.initConverterWorkers(D);
                SystemManager.initPopulatorWorkers(D);
                SystemManager.initTemplateStore();
                RendererRegistry.initialise();
                Runtime.getRuntime().addShutdownHook(A);
                B = true;
                if (C.isDebugEnabled()) {
                    C.debug("Docmosis initialised in " + (System.currentTimeMillis() - l) + " ms");
                }
            }
        }
        catch (InvalidLicenseException invalidLicenseException) {
            throw invalidLicenseException;
        }
        catch (B._A _A2) {
            throw new StartupException(_A2.getMessage(), _A2);
        }
        catch (PopulatorFactory.PopulatorFactoryException populatorFactoryException) {
            throw new StartupException(populatorFactoryException.getMessage(), populatorFactoryException);
        }
        catch (TemplateStoreException templateStoreException) {
            throw new StartupException(templateStoreException.getMessage(), templateStoreException);
        }
        catch (ConverterPoolException converterPoolException) {
            throw new StartupException(converterPoolException.getMessage(), converterPoolException);
        }
    }

    public static synchronized void release() {
        C.info("Docmosis shutting down");
        RendererRegistry.shutdown();
        SystemManager.releaseTemplateStore();
        SystemManager.releaseConverterWorkers();
        SystemManager.releasePopulatorWorkers();
        SystemManager.releaseConverterPool();
        SystemManager.releaseConfig();
        try {
            Runtime.getRuntime().removeShutdownHook(A);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        B = false;
        if (C.isDebugEnabled()) {
            C.debug("Docmosis shut down");
        }
    }

    public static boolean isInitialized() {
        return B;
    }

    private static void initConfig(Configuration configuration) {
        DMProperties.initialise(configuration);
    }

    private static void initConverterPool(int n) throws ConverterPoolException {
        ConverterPool.initialise(n);
    }

    private static void initPopulatorWorkers(int n) throws PopulatorFactory.PopulatorFactoryException {
        PopulatorFactory.initialise(n);
    }

    private static void initConverterWorkers(int n) throws B._A {
        com.docmosis.document.converter.B.A(n);
    }

    private static void initTemplateStore() throws TemplateStoreException {
        TemplateStoreFactory.initialise();
    }

    private static void releaseConfig() {
        DMProperties.release();
    }

    private static void releaseConverterPool() {
        ConverterPool.release();
    }

    private static void releasePopulatorWorkers() {
        PopulatorFactory.release();
    }

    private static void releaseConverterWorkers() {
        com.docmosis.document.converter.B.A();
    }

    private static void releaseTemplateStore() {
        TemplateStoreFactory.release();
    }

    private static int validateFeatureStatus(boolean bl) throws InvalidLicenseException {
        int n = 0;
        boolean bl2 = false;
        Class<?> clazz = null;
        if (clazz == null) {
            try {
                clazz = Class.forName(E);
            }
            catch (ClassNotFoundException classNotFoundException) {
                SystemManager.releaseSafe();
                throw new InvalidLicenseException("No valid license available: no features definition found.");
            }
        }
        if (clazz != null) {
            Object object;
            try {
                object = SystemManager.class.getClassLoader().getResourceAsStream(F);
                if (object == null) {
                    C.debug("Using properties for key.");
                }
                O.A((InputStream)object);
            }
            catch (IOException iOException) {
                throw new InvalidLicenseException("An error occurred loading the license from docmosis.key", iOException);
            }
            try {
                object = (M)clazz.getConstructor(Boolean.class).newInstance(bl ? Boolean.TRUE : Boolean.FALSE);
                D = ((M)object).getThrottleLevel();
                if (((M)object).isExpired()) {
                    SystemManager.releaseSafe();
                    throw new InvalidLicenseException("No valid license available.");
                }
                n = ((M)object).getMaxConverters();
                if (n > 0 && n < SystemManager.getConfiguredConverterCount()) {
                    SystemManager.releaseSafe();
                    throw new InvalidLicenseException("No valid license available: Your Docmosis license does not permit you to configure as many converters as you have (max is " + n + ").  Docmosis will not start until the " + "license conditions are met.");
                }
                if (!((M)object).compatibleWithBuild()) {
                    SystemManager.releaseSafe();
                    throw new InvalidLicenseException("No valid license available: Your Docmosis license does not permit you run this version of Docmosis");
                }
                bl2 = true;
            }
            catch (InstantiationException instantiationException) {
                SystemManager.releaseSafe();
                throw new InvalidLicenseException("No valid license available: Unable to load the feature set", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                SystemManager.releaseSafe();
                throw new InvalidLicenseException("No valid license available: Unable to load the feature set", illegalAccessException);
            }
            catch (Exception exception) {
                SystemManager.releaseSafe();
                throw new InvalidLicenseException("Unable to process the license:" + exception.getClass().getName() + ":" + exception.getMessage(), exception);
            }
        }
        if (!bl2) {
            SystemManager.releaseSafe();
            throw new InvalidLicenseException("No valid license available.");
        }
        return n;
    }

    private static void releaseSafe() throws InvalidLicenseException {
        try {
            SystemManager.release();
        }
        catch (RuntimeException runtimeException) {
            C.warn("An error occurred while shutting down.", runtimeException);
        }
    }

    private static int getConfiguredConverterCount() {
        return ConverterPool.getConverterCount();
    }

    public static String getVersion() {
        return Version.getVersion();
    }

    static {
        A = new Thread(){

            @Override
            public void run() {
                SystemManager.release();
            }
        };
    }
}

