/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big.internal.docmosis;

import ch.obermuhlner.math.big.docmosis.BigRational;
import ch.obermuhlner.math.big.internal.docmosis.PowerIterator;
import ch.obermuhlner.math.big.internal.docmosis.PowerTwoNPlusOneIterator;
import ch.obermuhlner.math.big.internal.docmosis.SeriesCalculator;
import java.math.BigDecimal;
import java.math.MathContext;

public class SinhCalculator
extends SeriesCalculator {
    public static final SinhCalculator INSTANCE = new SinhCalculator();
    private int D = 0;
    private BigRational C = BigRational.ONE;

    private SinhCalculator() {
        super(true);
    }

    @Override
    protected BigRational getCurrentFactor() {
        return this.C.reciprocal();
    }

    @Override
    protected void calculateNextFactor() {
        ++this.D;
        this.C = this.C.multiply(2 * this.D);
        this.C = this.C.multiply(2 * this.D + 1);
    }

    @Override
    protected PowerIterator createPowerIterator(BigDecimal bigDecimal, MathContext mathContext) {
        return new PowerTwoNPlusOneIterator(bigDecimal, mathContext);
    }
}

