/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big.internal.docmosis;

import ch.obermuhlner.math.big.docmosis.BigRational;
import ch.obermuhlner.math.big.internal.docmosis.PowerIterator;
import ch.obermuhlner.math.big.internal.docmosis.PowerTwoNPlusOneIterator;
import ch.obermuhlner.math.big.internal.docmosis.SeriesCalculator;
import java.math.BigDecimal;
import java.math.MathContext;

public class SinCalculator
extends SeriesCalculator {
    public static final SinCalculator INSTANCE = new SinCalculator();
    private int N = 0;
    private boolean L = false;
    private BigRational M = BigRational.ONE;

    private SinCalculator() {
        super(true);
    }

    @Override
    protected BigRational getCurrentFactor() {
        BigRational bigRational = this.M.reciprocal();
        if (this.L) {
            bigRational = bigRational.negate();
        }
        return bigRational;
    }

    @Override
    protected void calculateNextFactor() {
        ++this.N;
        this.M = this.M.multiply(2 * this.N);
        this.M = this.M.multiply(2 * this.N + 1);
        this.L = !this.L;
    }

    @Override
    protected PowerIterator createPowerIterator(BigDecimal bigDecimal, MathContext mathContext) {
        return new PowerTwoNPlusOneIterator(bigDecimal, mathContext);
    }
}

