/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big.internal.docmosis;

import ch.obermuhlner.math.big.docmosis.BigRational;
import ch.obermuhlner.math.big.internal.docmosis.PowerIterator;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;

public abstract class SeriesCalculator {
    private final boolean A;
    private final List<BigRational> B = new ArrayList<BigRational>();

    protected SeriesCalculator() {
        this(false);
    }

    protected SeriesCalculator(boolean bl) {
        this.A = bl;
    }

    public BigDecimal calculate(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimal bigDecimal2;
        BigDecimal bigDecimal3 = BigDecimal.ONE.movePointLeft(mathContext.getPrecision() + 1);
        PowerIterator powerIterator = this.createPowerIterator(bigDecimal, mathContext);
        BigDecimal bigDecimal4 = BigDecimal.ZERO;
        int n = 0;
        do {
            BigRational bigRational = this.getFactor(n);
            BigDecimal bigDecimal5 = powerIterator.getCurrentPower();
            powerIterator.calculateNextPower();
            bigDecimal2 = bigRational.getNumerator().multiply(bigDecimal5).divide(bigRational.getDenominator(), mathContext);
            ++n;
            if (this.A) {
                bigRational = this.getFactor(n);
                bigDecimal5 = powerIterator.getCurrentPower();
                powerIterator.calculateNextPower();
                BigDecimal bigDecimal6 = bigRational.getNumerator().multiply(bigDecimal5).divide(bigRational.getDenominator(), mathContext);
                bigDecimal2 = bigDecimal2.add(bigDecimal6);
                ++n;
            }
            bigDecimal4 = bigDecimal4.add(bigDecimal2);
        } while (bigDecimal2.abs().compareTo(bigDecimal3) > 0);
        return bigDecimal4.round(mathContext);
    }

    protected abstract PowerIterator createPowerIterator(BigDecimal var1, MathContext var2);

    protected synchronized BigRational getFactor(int n) {
        while (this.B.size() <= n) {
            BigRational bigRational = this.getCurrentFactor();
            this.addFactor(bigRational);
            this.calculateNextFactor();
        }
        return this.B.get(n);
    }

    private void addFactor(BigRational bigRational) {
        this.B.add(SeriesCalculator.requireNonNull(bigRational, "Factor cannot be null"));
    }

    protected abstract BigRational getCurrentFactor();

    protected abstract void calculateNextFactor();

    private static <T> T requireNonNull(T t, String string) {
        if (t == null) {
            throw new NullPointerException(string);
        }
        return t;
    }
}

