/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big.internal.docmosis;

import ch.obermuhlner.math.big.docmosis.BigRational;
import ch.obermuhlner.math.big.internal.docmosis.PowerIterator;
import ch.obermuhlner.math.big.internal.docmosis.PowerTwoNIterator;
import ch.obermuhlner.math.big.internal.docmosis.SeriesCalculator;
import java.math.BigDecimal;
import java.math.MathContext;

public class CoshCalculator
extends SeriesCalculator {
    public static final CoshCalculator INSTANCE = new CoshCalculator();
    private int P = 0;
    private BigRational O = BigRational.ONE;

    private CoshCalculator() {
        super(true);
    }

    @Override
    protected BigRational getCurrentFactor() {
        return this.O.reciprocal();
    }

    @Override
    protected void calculateNextFactor() {
        ++this.P;
        this.O = this.O.multiply(2 * this.P - 1).multiply(2 * this.P);
    }

    @Override
    protected PowerIterator createPowerIterator(BigDecimal bigDecimal, MathContext mathContext) {
        return new PowerTwoNIterator(bigDecimal, mathContext);
    }
}

