/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big.internal.docmosis;

import ch.obermuhlner.math.big.docmosis.BigRational;
import ch.obermuhlner.math.big.internal.docmosis.PowerIterator;
import ch.obermuhlner.math.big.internal.docmosis.PowerTwoNIterator;
import ch.obermuhlner.math.big.internal.docmosis.SeriesCalculator;
import java.math.BigDecimal;
import java.math.MathContext;

public class CosCalculator
extends SeriesCalculator {
    public static final CosCalculator INSTANCE = new CosCalculator();
    private int G = 0;
    private boolean E = false;
    private BigRational F = BigRational.ONE;

    private CosCalculator() {
        super(true);
    }

    @Override
    protected BigRational getCurrentFactor() {
        BigRational bigRational = this.F.reciprocal();
        if (this.E) {
            bigRational = bigRational.negate();
        }
        return bigRational;
    }

    @Override
    protected void calculateNextFactor() {
        ++this.G;
        this.F = this.F.multiply(2 * this.G - 1).multiply(2 * this.G);
        this.E = !this.E;
    }

    @Override
    protected PowerIterator createPowerIterator(BigDecimal bigDecimal, MathContext mathContext) {
        return new PowerTwoNIterator(bigDecimal, mathContext);
    }
}

