/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big.internal.docmosis;

import ch.obermuhlner.math.big.docmosis.BigRational;
import ch.obermuhlner.math.big.internal.docmosis.PowerIterator;
import ch.obermuhlner.math.big.internal.docmosis.PowerTwoNPlusOneIterator;
import ch.obermuhlner.math.big.internal.docmosis.SeriesCalculator;
import java.math.BigDecimal;
import java.math.MathContext;

public class AtanhCalculator
extends SeriesCalculator {
    public static final AtanhCalculator INSTANCE = new AtanhCalculator();
    private int Q = 0;

    private AtanhCalculator() {
        super(true);
    }

    @Override
    protected BigRational getCurrentFactor() {
        return BigRational.valueOf(1, 2 * this.Q + 1);
    }

    @Override
    protected void calculateNextFactor() {
        ++this.Q;
    }

    @Override
    protected PowerIterator createPowerIterator(BigDecimal bigDecimal, MathContext mathContext) {
        return new PowerTwoNPlusOneIterator(bigDecimal, mathContext);
    }
}

