/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big.internal.docmosis;

import ch.obermuhlner.math.big.docmosis.BigRational;
import ch.obermuhlner.math.big.internal.docmosis.PowerIterator;
import ch.obermuhlner.math.big.internal.docmosis.PowerTwoNPlusOneIterator;
import ch.obermuhlner.math.big.internal.docmosis.SeriesCalculator;
import java.math.BigDecimal;
import java.math.MathContext;

public class AsinCalculator
extends SeriesCalculator {
    public static final AsinCalculator INSTANCE = new AsinCalculator();
    private int K = 0;
    private BigRational J = BigRational.ONE;
    private BigRational I = BigRational.ONE;
    private BigRational H = BigRational.ONE;

    private AsinCalculator() {
    }

    @Override
    protected BigRational getCurrentFactor() {
        BigRational bigRational = this.J.divide(this.H.multiply(this.I).multiply(this.I).multiply(2 * this.K + 1));
        return bigRational;
    }

    @Override
    protected void calculateNextFactor() {
        ++this.K;
        this.J = this.J.multiply(2 * this.K - 1).multiply(2 * this.K);
        this.I = this.I.multiply(this.K);
        this.H = this.H.multiply(4);
    }

    @Override
    protected PowerIterator createPowerIterator(BigDecimal bigDecimal, MathContext mathContext) {
        return new PowerTwoNPlusOneIterator(bigDecimal, mathContext);
    }
}

