/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big.docmosis;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;

public class BigRational
extends Number
implements Comparable<BigRational>,
Serializable {
    public static final BigRational ZERO = new BigRational(0);
    public static final BigRational ONE = new BigRational(1);
    public static final BigRational TWO = new BigRational(2);
    public static final BigRational TEN = new BigRational(10);
    private final BigDecimal A;
    private final BigDecimal B;

    private BigRational(int n) {
        this(BigDecimal.valueOf(n), BigDecimal.ONE);
    }

    private BigRational(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        BigDecimal bigDecimal3 = bigDecimal;
        BigDecimal bigDecimal4 = bigDecimal2;
        if (bigDecimal4.signum() == 0) {
            throw new ArithmeticException("Divide by zero");
        }
        if (bigDecimal4.signum() < 0) {
            bigDecimal3 = bigDecimal3.negate();
            bigDecimal4 = bigDecimal4.negate();
        }
        this.A = bigDecimal3;
        this.B = bigDecimal4;
    }

    public BigInteger getNumeratorBigInteger() {
        return this.A.toBigInteger();
    }

    public BigDecimal getNumerator() {
        return this.A;
    }

    public BigInteger getDenominatorBigInteger() {
        return this.B.toBigInteger();
    }

    public BigDecimal getDenominator() {
        return this.B;
    }

    public BigRational reduce() {
        BigInteger bigInteger = this.A.toBigInteger();
        BigInteger bigInteger2 = this.B.toBigInteger();
        BigInteger bigInteger3 = bigInteger.gcd(bigInteger2);
        bigInteger = bigInteger.divide(bigInteger3);
        bigInteger2 = bigInteger2.divide(bigInteger3);
        return BigRational.valueOf(bigInteger, bigInteger2);
    }

    public BigRational integerPart() {
        return BigRational.of(this.A.subtract(this.A.remainder(this.B)), this.B);
    }

    public BigRational fractionPart() {
        return BigRational.of(this.A.remainder(this.B), this.B);
    }

    public BigRational negate() {
        if (this.isZero()) {
            return this;
        }
        return BigRational.of(this.A.negate(), this.B);
    }

    public BigRational reciprocal() {
        return BigRational.of(this.B, this.A);
    }

    public BigRational abs() {
        return this.isPositive() ? this : this.negate();
    }

    public int signum() {
        return this.A.signum();
    }

    public BigRational increment() {
        return BigRational.of(this.A.add(this.B), this.B);
    }

    public BigRational decrement() {
        return BigRational.of(this.A.subtract(this.B), this.B);
    }

    public BigRational add(BigRational bigRational) {
        if (this.B.equals(bigRational.B)) {
            return BigRational.of(this.A.add(bigRational.A), this.B);
        }
        BigDecimal bigDecimal = this.A.multiply(bigRational.B).add(bigRational.A.multiply(this.B));
        BigDecimal bigDecimal2 = this.B.multiply(bigRational.B);
        return BigRational.of(bigDecimal, bigDecimal2);
    }

    private BigRational add(BigDecimal bigDecimal) {
        return BigRational.of(this.A.add(bigDecimal.multiply(this.B)), this.B);
    }

    public BigRational add(BigInteger bigInteger) {
        if (bigInteger.equals(BigInteger.ZERO)) {
            return this;
        }
        return this.add(new BigDecimal(bigInteger));
    }

    public BigRational add(int n) {
        if (n == 0) {
            return this;
        }
        return this.add(BigInteger.valueOf(n));
    }

    public BigRational subtract(BigRational bigRational) {
        if (this.B.equals(bigRational.B)) {
            return BigRational.of(this.A.subtract(bigRational.A), this.B);
        }
        BigDecimal bigDecimal = this.A.multiply(bigRational.B).subtract(bigRational.A.multiply(this.B));
        BigDecimal bigDecimal2 = this.B.multiply(bigRational.B);
        return BigRational.of(bigDecimal, bigDecimal2);
    }

    private BigRational subtract(BigDecimal bigDecimal) {
        return BigRational.of(this.A.subtract(bigDecimal.multiply(this.B)), this.B);
    }

    public BigRational subtract(BigInteger bigInteger) {
        if (bigInteger.equals(BigInteger.ZERO)) {
            return this;
        }
        return this.subtract(new BigDecimal(bigInteger));
    }

    public BigRational subtract(int n) {
        if (n == 0) {
            return this;
        }
        return this.subtract(BigInteger.valueOf(n));
    }

    public BigRational multiply(BigRational bigRational) {
        if (this.isZero() || bigRational.isZero()) {
            return ZERO;
        }
        if (this.equals(ONE)) {
            return bigRational;
        }
        if (bigRational.equals(ONE)) {
            return this;
        }
        BigDecimal bigDecimal = this.A.multiply(bigRational.A);
        BigDecimal bigDecimal2 = this.B.multiply(bigRational.B);
        return BigRational.of(bigDecimal, bigDecimal2);
    }

    private BigRational multiply(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = this.A.multiply(bigDecimal);
        BigDecimal bigDecimal3 = this.B;
        return BigRational.of(bigDecimal2, bigDecimal3);
    }

    public BigRational multiply(BigInteger bigInteger) {
        if (this.isZero() || bigInteger.signum() == 0) {
            return ZERO;
        }
        if (this.equals(ONE)) {
            return BigRational.valueOf(bigInteger);
        }
        if (bigInteger.equals(BigInteger.ONE)) {
            return this;
        }
        return this.multiply(new BigDecimal(bigInteger));
    }

    public BigRational multiply(int n) {
        return this.multiply(BigInteger.valueOf(n));
    }

    public BigRational divide(BigRational bigRational) {
        if (bigRational.equals(ONE)) {
            return this;
        }
        BigDecimal bigDecimal = this.A.multiply(bigRational.B);
        BigDecimal bigDecimal2 = this.B.multiply(bigRational.A);
        return BigRational.of(bigDecimal, bigDecimal2);
    }

    private BigRational divide(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = this.A;
        BigDecimal bigDecimal3 = this.B.multiply(bigDecimal);
        return BigRational.of(bigDecimal2, bigDecimal3);
    }

    public BigRational divide(BigInteger bigInteger) {
        if (bigInteger.equals(BigInteger.ONE)) {
            return this;
        }
        return this.divide(new BigDecimal(bigInteger));
    }

    public BigRational divide(int n) {
        return this.divide(BigInteger.valueOf(n));
    }

    public boolean isZero() {
        return this.A.signum() == 0;
    }

    private boolean isPositive() {
        return this.A.signum() > 0;
    }

    public boolean isInteger() {
        return this.isIntegerInternal() || this.reduce().isIntegerInternal();
    }

    private boolean isIntegerInternal() {
        return this.B.compareTo(BigDecimal.ONE) == 0;
    }

    public BigRational pow(int n) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        if (n == 0) {
            return ONE;
        }
        if (n == 1) {
            return this;
        }
        if (n > 0) {
            bigInteger2 = this.A.toBigInteger().pow(n);
            bigInteger = this.B.toBigInteger().pow(n);
        } else {
            bigInteger2 = this.B.toBigInteger().pow(-n);
            bigInteger = this.A.toBigInteger().pow(-n);
        }
        return BigRational.valueOf(bigInteger2, bigInteger);
    }

    private BigRational min(BigRational bigRational) {
        return this.compareTo(bigRational) <= 0 ? this : bigRational;
    }

    private BigRational max(BigRational bigRational) {
        return this.compareTo(bigRational) >= 0 ? this : bigRational;
    }

    public BigRational withPrecision(int n) {
        return BigRational.valueOf(this.toBigDecimal(new MathContext(n)));
    }

    public BigRational withScale(int n) {
        return BigRational.valueOf(this.toBigDecimal().setScale(n, RoundingMode.HALF_UP));
    }

    private static int countDigits(BigInteger bigInteger) {
        double d = Math.log(2.0) / Math.log(10.0);
        int n = (int)(d * (double)bigInteger.bitLength() + 1.0);
        if (BigInteger.TEN.pow(n - 1).compareTo(bigInteger) > 0) {
            return n - 1;
        }
        return n;
    }

    private int precision() {
        return BigRational.countDigits(this.A.toBigInteger()) + BigRational.countDigits(this.B.toBigInteger());
    }

    public double toDouble() {
        return this.toBigDecimal().doubleValue();
    }

    public float toFloat() {
        return this.toBigDecimal().floatValue();
    }

    public BigDecimal toBigDecimal() {
        int n = Math.max(this.precision(), MathContext.DECIMAL128.getPrecision());
        return this.toBigDecimal(new MathContext(n));
    }

    public BigDecimal toBigDecimal(MathContext mathContext) {
        return this.A.divide(this.B, mathContext);
    }

    @Override
    public int compareTo(BigRational bigRational) {
        if (this == bigRational) {
            return 0;
        }
        return this.A.multiply(bigRational.B).compareTo(this.B.multiply(bigRational.A));
    }

    public int hashCode() {
        if (this.isZero()) {
            return 0;
        }
        return this.A.hashCode() + this.B.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BigRational)) {
            return false;
        }
        BigRational bigRational = (BigRational)object;
        if (!this.A.equals(bigRational.A)) {
            return false;
        }
        return this.B.equals(bigRational.B);
    }

    public String toString() {
        if (this.isZero()) {
            return "0";
        }
        if (this.isIntegerInternal()) {
            return this.A.toString();
        }
        return this.toBigDecimal().toString();
    }

    public String toPlainString() {
        if (this.isZero()) {
            return "0";
        }
        if (this.isIntegerInternal()) {
            return this.A.toPlainString();
        }
        return this.toBigDecimal().toPlainString();
    }

    public String toRationalString() {
        if (this.isZero()) {
            return "0";
        }
        if (this.isIntegerInternal()) {
            return this.A.toString();
        }
        return this.A + "/" + this.B;
    }

    public String toIntegerRationalString() {
        BigDecimal bigDecimal = this.A.remainder(this.B);
        BigDecimal bigDecimal2 = this.A.subtract(bigDecimal);
        BigDecimal bigDecimal3 = bigDecimal2.divide(this.B);
        StringBuilder stringBuilder = new StringBuilder();
        if (bigDecimal3.signum() != 0) {
            stringBuilder.append(bigDecimal3);
        }
        if (bigDecimal.signum() != 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
                stringBuilder.append(bigDecimal.abs());
            } else {
                stringBuilder.append(bigDecimal);
            }
            stringBuilder.append('/');
            stringBuilder.append(this.B);
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append('0');
        }
        return stringBuilder.toString();
    }

    public static BigRational valueOf(int n) {
        if (n == 0) {
            return ZERO;
        }
        if (n == 1) {
            return ONE;
        }
        return new BigRational(n);
    }

    public static BigRational valueOf(int n, int n2) {
        return BigRational.of(BigDecimal.valueOf(n), BigDecimal.valueOf(n2));
    }

    public static BigRational valueOf(int n, int n2, int n3) {
        if (n2 < 0 || n3 < 0) {
            throw new ArithmeticException("Negative value");
        }
        BigRational bigRational = BigRational.valueOf(n);
        BigRational bigRational2 = BigRational.valueOf(n2, n3);
        return bigRational.isPositive() ? bigRational.add(bigRational2) : bigRational.subtract(bigRational2);
    }

    public static BigRational valueOf(BigInteger bigInteger, BigInteger bigInteger2) {
        return BigRational.of(new BigDecimal(bigInteger), new BigDecimal(bigInteger2));
    }

    public static BigRational valueOf(BigInteger bigInteger) {
        if (bigInteger.compareTo(BigInteger.ZERO) == 0) {
            return ZERO;
        }
        if (bigInteger.compareTo(BigInteger.ONE) == 0) {
            return ONE;
        }
        return BigRational.valueOf(bigInteger, BigInteger.ONE);
    }

    public static BigRational valueOf(double d) {
        if (d == 0.0) {
            return ZERO;
        }
        if (d == 1.0) {
            return ONE;
        }
        if (Double.isInfinite(d)) {
            throw new NumberFormatException("Infinite");
        }
        if (Double.isNaN(d)) {
            throw new NumberFormatException("NaN");
        }
        return BigRational.valueOf(new BigDecimal(String.valueOf(d)));
    }

    public static BigRational valueOf(BigDecimal bigDecimal) {
        if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
            return ZERO;
        }
        if (bigDecimal.compareTo(BigDecimal.ONE) == 0) {
            return ONE;
        }
        int n = bigDecimal.scale();
        if (n == 0) {
            return new BigRational(bigDecimal, BigDecimal.ONE);
        }
        if (n < 0) {
            BigDecimal bigDecimal2 = new BigDecimal(bigDecimal.unscaledValue()).multiply(BigDecimal.ONE.movePointLeft(bigDecimal.scale()));
            return new BigRational(bigDecimal2, BigDecimal.ONE);
        }
        BigDecimal bigDecimal3 = new BigDecimal(bigDecimal.unscaledValue());
        BigDecimal bigDecimal4 = BigDecimal.ONE.movePointRight(bigDecimal.scale());
        return new BigRational(bigDecimal3, bigDecimal4);
    }

    public static BigRational valueOf(String string) {
        String[] stringArray = string.split("/");
        BigRational bigRational = BigRational.valueOfSimple(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            bigRational = bigRational.divide(BigRational.valueOfSimple(stringArray[i]));
        }
        return bigRational;
    }

    private static BigRational valueOfSimple(String string) {
        return BigRational.valueOf(new BigDecimal(string));
    }

    public static BigRational valueOf(boolean bl, String string, String string2, String string3, String string4) {
        BigRational bigRational = ZERO;
        if (string3 != null && string3.length() > 0) {
            BigInteger bigInteger = BigInteger.TEN.pow(string3.length()).subtract(BigInteger.ONE);
            bigRational = BigRational.valueOf(new BigInteger(string3), bigInteger);
        }
        if (string2 != null && string2.length() > 0) {
            bigRational = bigRational.add(BigRational.valueOf(new BigInteger(string2)));
            bigRational = bigRational.divide(BigInteger.TEN.pow(string2.length()));
        }
        if (string != null && string.length() > 0) {
            bigRational = bigRational.add(new BigInteger(string));
        }
        if (string4 != null && string4.length() > 0) {
            int n = Integer.parseInt(string4);
            BigInteger bigInteger = BigInteger.TEN.pow(Math.abs(n));
            BigRational bigRational2 = bigRational = n >= 0 ? bigRational.multiply(bigInteger) : bigRational.divide(bigInteger);
        }
        if (!bl) {
            bigRational = bigRational.negate();
        }
        return bigRational;
    }

    public static BigRational valueOf(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return BigRational.valueOf(bigDecimal).divide(BigRational.valueOf(bigDecimal2));
    }

    private static BigRational of(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        if (bigDecimal.signum() == 0 && bigDecimal2.signum() != 0) {
            return ZERO;
        }
        if (bigDecimal.compareTo(BigDecimal.ONE) == 0 && bigDecimal2.compareTo(BigDecimal.ONE) == 0) {
            return ONE;
        }
        return new BigRational(bigDecimal, bigDecimal2);
    }

    public static BigRational min(BigRational ... bigRationalArray) {
        if (bigRationalArray.length == 0) {
            return ZERO;
        }
        BigRational bigRational = bigRationalArray[0];
        for (int i = 1; i < bigRationalArray.length; ++i) {
            bigRational = bigRational.min(bigRationalArray[i]);
        }
        return bigRational;
    }

    public static BigRational max(BigRational ... bigRationalArray) {
        if (bigRationalArray.length == 0) {
            return ZERO;
        }
        BigRational bigRational = bigRationalArray[0];
        for (int i = 1; i < bigRationalArray.length; ++i) {
            bigRational = bigRational.max(bigRationalArray[i]);
        }
        return bigRational;
    }

    @Override
    public int intValue() {
        return this.toBigDecimal().intValue();
    }

    @Override
    public long longValue() {
        return this.toBigDecimal().longValue();
    }

    @Override
    public float floatValue() {
        return this.toFloat();
    }

    @Override
    public double doubleValue() {
        return this.toDouble();
    }
}

