/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big.docmosis;

import ch.obermuhlner.math.big.internal.docmosis.AsinCalculator;
import ch.obermuhlner.math.big.internal.docmosis.CosCalculator;
import ch.obermuhlner.math.big.internal.docmosis.CoshCalculator;
import ch.obermuhlner.math.big.internal.docmosis.ExpCalculator;
import ch.obermuhlner.math.big.internal.docmosis.SinCalculator;
import ch.obermuhlner.math.big.internal.docmosis.SinhCalculator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BigDecimalMath {
    private static final BigDecimal H;
    private static final BigDecimal S;
    private static final BigDecimal T;
    private static final BigDecimal Q;
    private static final BigDecimal M;
    private static final BigDecimal F;
    private static volatile BigDecimal G;
    private static final Object U;
    private static volatile BigDecimal J;
    private static final Object E;
    private static volatile BigDecimal D;
    private static final Object C;
    private static volatile BigDecimal I;
    private static final Object R;
    private static volatile BigDecimal B;
    private static final Object N;
    private static final BigDecimal K;
    private static final int P = 15;
    private static BigDecimal[] L;
    private static final Map<Integer, List<BigDecimal>> A;
    private static final Object O;

    private BigDecimalMath() {
    }

    public static BigDecimal toBigDecimal(String string) {
        return BigDecimalMath.toBigDecimal(string, MathContext.UNLIMITED);
    }

    public static BigDecimal toBigDecimal(String string, MathContext mathContext) {
        int n = string.length();
        if (n < 600) {
            return new BigDecimal(string, mathContext);
        }
        int n2 = n / (n >= 10000 ? 8 : 5);
        return BigDecimalMath.toBigDecimal(string, mathContext, n2);
    }

    static BigDecimal toBigDecimal(String string, MathContext mathContext, int n) {
        Object object;
        int n2;
        int n3;
        int n4 = string.length();
        if (n4 < n) {
            return new BigDecimal(string, mathContext);
        }
        char[] cArray = string.toCharArray();
        boolean bl = false;
        boolean bl2 = false;
        int n5 = 0;
        int n6 = -1;
        int n7 = -1;
        boolean bl3 = false;
        int n8 = 0;
        block6: for (n3 = 0; n3 < n4; ++n3) {
            n2 = cArray[n3];
            switch (n2) {
                case 43: {
                    if (n7 >= 0) {
                        if (bl3) {
                            throw new NumberFormatException("Multiple signs in exponent");
                        }
                        bl3 = true;
                        continue block6;
                    }
                    if (bl) {
                        throw new NumberFormatException("Multiple signs in number");
                    }
                    bl = true;
                    n5 = n3 + 1;
                    continue block6;
                }
                case 45: {
                    if (n7 >= 0) {
                        if (bl3) {
                            throw new NumberFormatException("Multiple signs in exponent");
                        }
                        bl3 = true;
                        continue block6;
                    }
                    if (bl) {
                        throw new NumberFormatException("Multiple signs in number");
                    }
                    bl = true;
                    bl2 = true;
                    n5 = n3 + 1;
                    continue block6;
                }
                case 69: 
                case 101: {
                    if (n7 >= 0) {
                        throw new NumberFormatException("Multiple exponent markers");
                    }
                    n7 = n3;
                    continue block6;
                }
                case 46: {
                    if (n6 >= 0) {
                        throw new NumberFormatException("Multiple decimal points");
                    }
                    n6 = n3;
                    continue block6;
                }
                default: {
                    if (n6 < 0 || n7 != -1) continue block6;
                    ++n8;
                }
            }
        }
        n2 = 0;
        if (n7 >= 0) {
            n3 = n7;
            object = new String(cArray, n7 + 1, n4 - n7 - 1);
            n2 = Integer.parseInt((String)object);
            n8 = BigDecimalMath.adjustScale(n8, n2);
        } else {
            n3 = n4;
        }
        if (n6 >= 0) {
            int n9 = n6 - n5;
            BigDecimal bigDecimal = BigDecimalMath.toBigDecimalRecursive(cArray, n5, n9, n2, n);
            int n10 = n3 - n6 - 1;
            BigDecimal bigDecimal2 = BigDecimalMath.toBigDecimalRecursive(cArray, n6 + 1, n10, n2 - n10, n);
            object = bigDecimal.add(bigDecimal2);
        } else {
            object = BigDecimalMath.toBigDecimalRecursive(cArray, n5, n3 - n5, n2, n);
        }
        if (n8 != 0) {
            object = ((BigDecimal)object).setScale(n8);
        }
        if (bl2) {
            object = ((BigDecimal)object).negate();
        }
        if (mathContext.getPrecision() != 0) {
            object = ((BigDecimal)object).round(mathContext);
        }
        return object;
    }

    private static int adjustScale(int n, long l) {
        long l2 = (long)n - l;
        if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
            throw new NumberFormatException("Scale out of range: " + l2 + " while adjusting scale " + n + " to exponent " + l);
        }
        return (int)l2;
    }

    private static BigDecimal toBigDecimalRecursive(char[] cArray, int n, int n2, int n3, int n4) {
        if (n2 > n4) {
            int n5 = n2 / 2;
            BigDecimal bigDecimal = BigDecimalMath.toBigDecimalRecursive(cArray, n, n5, n3 + n2 - n5, n4);
            BigDecimal bigDecimal2 = BigDecimalMath.toBigDecimalRecursive(cArray, n + n5, n2 - n5, n3, n4);
            return bigDecimal.add(bigDecimal2);
        }
        if (n2 == 0) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(cArray, n, n2).movePointRight(n3);
    }

    public static boolean isIntValue(BigDecimal bigDecimal) {
        try {
            bigDecimal.intValueExact();
            return true;
        }
        catch (ArithmeticException arithmeticException) {
            return false;
        }
    }

    public static boolean isLongValue(BigDecimal bigDecimal) {
        try {
            bigDecimal.longValueExact();
            return true;
        }
        catch (ArithmeticException arithmeticException) {
            return false;
        }
    }

    public static boolean isDoubleValue(BigDecimal bigDecimal) {
        if (bigDecimal.compareTo(F) > 0) {
            return false;
        }
        return bigDecimal.compareTo(F.negate()) >= 0;
    }

    public static BigDecimal mantissa(BigDecimal bigDecimal) {
        int n = BigDecimalMath.exponent(bigDecimal);
        if (n == 0) {
            return bigDecimal;
        }
        return bigDecimal.movePointLeft(n);
    }

    public static int exponent(BigDecimal bigDecimal) {
        return bigDecimal.precision() - bigDecimal.scale() - 1;
    }

    public static int significantDigits(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = bigDecimal.stripTrailingZeros();
        if (bigDecimal2.scale() >= 0) {
            return bigDecimal2.precision();
        }
        return bigDecimal2.precision() - bigDecimal2.scale();
    }

    public static BigDecimal integralPart(BigDecimal bigDecimal) {
        return bigDecimal.setScale(0, 1);
    }

    public static BigDecimal fractionalPart(BigDecimal bigDecimal) {
        return bigDecimal.subtract(BigDecimalMath.integralPart(bigDecimal));
    }

    public static BigDecimal round(BigDecimal bigDecimal, MathContext mathContext) {
        return bigDecimal.round(mathContext);
    }

    public static BigDecimal roundWithTrailingZeroes(BigDecimal bigDecimal, MathContext mathContext) {
        if (bigDecimal.precision() == mathContext.getPrecision()) {
            return bigDecimal;
        }
        if (bigDecimal.signum() == 0) {
            return BigDecimal.ZERO.setScale(mathContext.getPrecision() - 1);
        }
        try {
            BigDecimal bigDecimal2 = bigDecimal.stripTrailingZeros();
            int n = BigDecimalMath.exponent(bigDecimal2);
            BigDecimal bigDecimal3 = n < -1 ? BigDecimal.ZERO.setScale(mathContext.getPrecision() - n) : BigDecimal.ZERO.setScale(mathContext.getPrecision() + n + 1);
            return bigDecimal2.add(bigDecimal3, mathContext);
        }
        catch (ArithmeticException arithmeticException) {
            return bigDecimal.round(mathContext);
        }
    }

    public static BigDecimal reciprocal(BigDecimal bigDecimal, MathContext mathContext) {
        return BigDecimal.ONE.divide(bigDecimal, mathContext);
    }

    public static BigDecimal factorial(int n) {
        if (n < 0) {
            throw new ArithmeticException("Illegal factorial(n) for n < 0: n = " + n);
        }
        if (n < L.length) {
            return L[n];
        }
        BigDecimal bigDecimal = L[L.length - 1];
        return bigDecimal.multiply(BigDecimalMath.factorialRecursion(L.length, n));
    }

    private static BigDecimal factorialLoop(int n, int n2) {
        long l = Long.MAX_VALUE / (long)n2;
        long l2 = 1L;
        BigDecimal bigDecimal = BigDecimal.ONE;
        while (n <= n2) {
            if (l2 <= l) {
                l2 *= (long)n;
            } else {
                bigDecimal = bigDecimal.multiply(BigDecimal.valueOf(l2));
                l2 = n;
            }
            ++n;
        }
        return bigDecimal.multiply(BigDecimal.valueOf(l2));
    }

    private static BigDecimal factorialRecursion(int n, int n2) {
        int n3;
        int n4 = n3 = n > 200 ? 80 : 150;
        if (n2 - n < n3) {
            return BigDecimalMath.factorialLoop(n, n2);
        }
        int n5 = n + n2 >> 1;
        return BigDecimalMath.factorialRecursion(n5 + 1, n2).multiply(BigDecimalMath.factorialRecursion(n, n5));
    }

    public static BigDecimal factorial(BigDecimal bigDecimal, MathContext mathContext) {
        if (BigDecimalMath.isIntValue(bigDecimal)) {
            return BigDecimalMath.round(BigDecimalMath.factorial(bigDecimal.intValueExact()), mathContext);
        }
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mathContext2 = new MathContext(mathContext.getPrecision() << 1, mathContext.getRoundingMode());
        int n = mathContext.getPrecision() * 13 / 10;
        List<BigDecimal> list = BigDecimalMath.getSpougeFactorialConstants(n);
        BigDecimal bigDecimal2 = BigDecimal.valueOf(n);
        boolean bl = false;
        BigDecimal bigDecimal3 = list.get(0);
        for (int i = 1; i < n; ++i) {
            BigDecimal bigDecimal4 = BigDecimal.valueOf(i);
            bigDecimal3 = bigDecimal3.add(list.get(i).divide(bigDecimal.add(bigDecimal4), mathContext2));
            bl = !bl;
        }
        BigDecimal bigDecimal5 = BigDecimalMath.pow(bigDecimal.add(bigDecimal2), bigDecimal.add(BigDecimal.valueOf(0.5)), mathContext2);
        bigDecimal5 = bigDecimal5.multiply(BigDecimalMath.exp(bigDecimal.negate().subtract(bigDecimal2), mathContext2));
        bigDecimal5 = bigDecimal5.multiply(bigDecimal3);
        return BigDecimalMath.round(bigDecimal5, mathContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<BigDecimal> getSpougeFactorialConstants(int n) {
        Object object = O;
        synchronized (object) {
            List<BigDecimal> list = A.get(n);
            if (list == null) {
                ArrayList<BigDecimal> arrayList = new ArrayList<BigDecimal>(n);
                MathContext mathContext = new MathContext(n * 15 / 10);
                BigDecimal bigDecimal = BigDecimalMath.sqrt(BigDecimalMath.pi(mathContext).multiply(H, mathContext), mathContext);
                arrayList.add(bigDecimal);
                boolean bl = false;
                for (int i = 1; i < n; ++i) {
                    BigDecimal bigDecimal2 = BigDecimal.valueOf(i);
                    long l = (long)n - (long)i;
                    BigDecimal bigDecimal3 = BigDecimalMath.pow(BigDecimal.valueOf(l), bigDecimal2.subtract(Q), mathContext);
                    bigDecimal3 = bigDecimal3.multiply(BigDecimalMath.exp(BigDecimal.valueOf(l), mathContext), mathContext);
                    bigDecimal3 = bigDecimal3.divide(BigDecimalMath.factorial(i - 1), mathContext);
                    if (bl) {
                        bigDecimal3 = bigDecimal3.negate();
                    }
                    arrayList.add(bigDecimal3);
                    bl = !bl;
                }
                list = Collections.unmodifiableList(arrayList);
                if (list != null) {
                    A.put(n, list);
                }
            }
            return list;
        }
    }

    public static BigDecimal gamma(BigDecimal bigDecimal, MathContext mathContext) {
        return BigDecimalMath.factorial(bigDecimal.subtract(BigDecimal.ONE), mathContext);
    }

    public static BigDecimal pow(BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        if (bigDecimal.signum() == 0) {
            switch (bigDecimal2.signum()) {
                case 0: {
                    return BigDecimalMath.round(BigDecimal.ONE, mathContext);
                }
                case 1: {
                    return BigDecimalMath.round(BigDecimal.ZERO, mathContext);
                }
            }
        }
        try {
            long l = bigDecimal2.longValueExact();
            return BigDecimalMath.pow(bigDecimal, l, mathContext);
        }
        catch (ArithmeticException arithmeticException) {
            if (BigDecimalMath.fractionalPart(bigDecimal2).signum() == 0) {
                return BigDecimalMath.powInteger(bigDecimal, bigDecimal2, mathContext);
            }
            MathContext mathContext2 = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
            BigDecimal bigDecimal3 = BigDecimalMath.exp(bigDecimal2.multiply(BigDecimalMath.log(bigDecimal, mathContext2), mathContext2), mathContext2);
            return BigDecimalMath.round(bigDecimal3, mathContext);
        }
    }

    public static BigDecimal pow(BigDecimal bigDecimal, long l, MathContext mathContext) {
        MathContext mathContext2;
        MathContext mathContext3 = mathContext2 = mathContext.getPrecision() == 0 ? mathContext : new MathContext(mathContext.getPrecision() + 10, mathContext.getRoundingMode());
        if (l < 0L) {
            BigDecimal bigDecimal2 = BigDecimalMath.reciprocal(BigDecimalMath.pow(bigDecimal, -l, mathContext2), mathContext2);
            return BigDecimalMath.round(bigDecimal2, mathContext);
        }
        BigDecimal bigDecimal3 = BigDecimal.ONE;
        while (l > 0L) {
            if ((l & 1L) == 1L) {
                bigDecimal3 = bigDecimal3.multiply(bigDecimal, mathContext2);
                --l;
            }
            if (l > 0L) {
                bigDecimal = bigDecimal.multiply(bigDecimal, mathContext2);
            }
            l >>= 1;
        }
        return BigDecimalMath.round(bigDecimal3, mathContext);
    }

    private static BigDecimal powInteger(BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext) {
        if (BigDecimalMath.fractionalPart(bigDecimal2).signum() != 0) {
            throw new IllegalArgumentException("Not integer value: " + bigDecimal2);
        }
        if (bigDecimal2.signum() < 0) {
            return BigDecimal.ONE.divide(BigDecimalMath.powInteger(bigDecimal, bigDecimal2.negate(), mathContext), mathContext);
        }
        MathContext mathContext2 = new MathContext(Math.max(mathContext.getPrecision(), -bigDecimal2.scale()) + 30, mathContext.getRoundingMode());
        BigDecimal bigDecimal3 = BigDecimal.ONE;
        while (bigDecimal2.signum() > 0) {
            BigDecimal bigDecimal4 = bigDecimal2.divide(H, mathContext2);
            if (BigDecimalMath.fractionalPart(bigDecimal4).signum() != 0) {
                bigDecimal3 = bigDecimal3.multiply(bigDecimal, mathContext2);
                bigDecimal2 = bigDecimal2.subtract(BigDecimal.ONE);
                bigDecimal4 = bigDecimal2.divide(H, mathContext2);
            }
            if (bigDecimal4.signum() > 0) {
                bigDecimal = bigDecimal.multiply(bigDecimal, mathContext2);
            }
            bigDecimal2 = bigDecimal4;
        }
        return BigDecimalMath.round(bigDecimal3, mathContext);
    }

    public static BigDecimal sqrt(BigDecimal bigDecimal, MathContext mathContext) {
        int n;
        BigDecimal bigDecimal2;
        BigDecimalMath.checkMathContext(mathContext);
        switch (bigDecimal.signum()) {
            case 0: {
                return BigDecimal.ZERO;
            }
            case -1: {
                throw new ArithmeticException("Illegal sqrt(x) for x < 0: x = " + bigDecimal);
            }
        }
        int n2 = mathContext.getPrecision() + 6;
        BigDecimal bigDecimal3 = BigDecimal.ONE.movePointLeft(mathContext.getPrecision() + 1);
        if (BigDecimalMath.isDoubleValue(bigDecimal)) {
            bigDecimal2 = BigDecimal.valueOf(Math.sqrt(bigDecimal.doubleValue()));
            n = 15;
        } else {
            bigDecimal2 = bigDecimal.multiply(Q, mathContext);
            n = 1;
        }
        if (n < n2) {
            BigDecimal bigDecimal4;
            if (bigDecimal2.multiply(bigDecimal2).compareTo(bigDecimal) == 0) {
                return BigDecimalMath.round(bigDecimal2, mathContext);
            }
            do {
                bigDecimal4 = bigDecimal2;
                if ((n <<= 1) > n2) {
                    n = n2;
                }
                MathContext mathContext2 = new MathContext(n, mathContext.getRoundingMode());
                bigDecimal2 = bigDecimal.divide(bigDecimal2, mathContext2).add(bigDecimal4).multiply(Q, mathContext2);
            } while (n < n2 || bigDecimal2.subtract(bigDecimal4).abs().compareTo(bigDecimal3) > 0);
        }
        return BigDecimalMath.round(bigDecimal2, mathContext);
    }

    public static BigDecimal root(BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext) {
        double d;
        BigDecimalMath.checkMathContext(mathContext);
        switch (bigDecimal2.signum()) {
            case -1: 
            case 0: {
                throw new ArithmeticException("Illegal root(x, n) for n <= 0: n = " + bigDecimal2);
            }
        }
        switch (bigDecimal.signum()) {
            case 0: {
                return BigDecimal.ZERO;
            }
            case -1: {
                throw new ArithmeticException("Illegal root(x, n) for x < 0: x = " + bigDecimal);
            }
        }
        if (BigDecimalMath.isDoubleValue(bigDecimal) && BigDecimalMath.isDoubleValue(bigDecimal2) && BigDecimalMath.isFinite(d = Math.pow(bigDecimal.doubleValue(), 1.0 / bigDecimal2.doubleValue()))) {
            return BigDecimalMath.rootUsingNewtonRaphson(bigDecimal, bigDecimal2, BigDecimal.valueOf(d), mathContext);
        }
        MathContext mathContext2 = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        return BigDecimalMath.pow(bigDecimal, BigDecimal.ONE.divide(bigDecimal2, mathContext2), mathContext);
    }

    private static BigDecimal rootUsingNewtonRaphson(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3, MathContext mathContext) {
        if (bigDecimal2.compareTo(BigDecimal.ONE) <= 0) {
            MathContext mathContext2 = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
            return BigDecimalMath.pow(bigDecimal, BigDecimal.ONE.divide(bigDecimal2, mathContext2), mathContext);
        }
        int n = mathContext.getPrecision() * 2;
        BigDecimal bigDecimal4 = BigDecimal.ONE.movePointLeft(mathContext.getPrecision() + 1);
        BigDecimal bigDecimal5 = bigDecimal2.subtract(BigDecimal.ONE);
        BigDecimal bigDecimal6 = bigDecimal3;
        int n2 = 12;
        if (n2 < n) {
            BigDecimal bigDecimal7;
            do {
                if ((n2 *= 3) > n) {
                    n2 = n;
                }
                MathContext mathContext3 = new MathContext(n2, mathContext.getRoundingMode());
                bigDecimal7 = bigDecimal.divide(BigDecimalMath.pow(bigDecimal6, bigDecimal5, mathContext3), mathContext3).subtract(bigDecimal6).divide(bigDecimal2, mathContext3);
                bigDecimal6 = bigDecimal6.add(bigDecimal7);
            } while (n2 < n || bigDecimal7.abs().compareTo(bigDecimal4) > 0);
        }
        return BigDecimalMath.round(bigDecimal6, mathContext);
    }

    public static BigDecimal log(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimal bigDecimal2;
        BigDecimalMath.checkMathContext(mathContext);
        if (bigDecimal.signum() <= 0) {
            throw new ArithmeticException("Illegal log(x) for x <= 0: x = " + bigDecimal);
        }
        if (bigDecimal.compareTo(BigDecimal.ONE) == 0) {
            return BigDecimal.ZERO;
        }
        switch (bigDecimal.compareTo(BigDecimal.TEN)) {
            case 0: {
                bigDecimal2 = BigDecimalMath.logTen(mathContext);
                break;
            }
            case 1: {
                bigDecimal2 = BigDecimalMath.logUsingExponent(bigDecimal, mathContext);
                break;
            }
            default: {
                bigDecimal2 = BigDecimalMath.logUsingTwoThree(bigDecimal, mathContext);
            }
        }
        return BigDecimalMath.round(bigDecimal2, mathContext);
    }

    public static BigDecimal log2(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mathContext2 = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        BigDecimal bigDecimal2 = BigDecimalMath.log(bigDecimal, mathContext2).divide(BigDecimalMath.logTwo(mathContext2), mathContext2);
        return BigDecimalMath.round(bigDecimal2, mathContext);
    }

    public static BigDecimal log10(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mathContext2 = new MathContext(mathContext.getPrecision() + 2, mathContext.getRoundingMode());
        BigDecimal bigDecimal2 = BigDecimalMath.log(bigDecimal, mathContext2).divide(BigDecimalMath.logTen(mathContext2), mathContext2);
        return BigDecimalMath.round(bigDecimal2, mathContext);
    }

    private static BigDecimal logUsingNewton(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimal bigDecimal2;
        int n;
        BigDecimal bigDecimal3;
        int n2 = mathContext.getPrecision() + 20;
        BigDecimal bigDecimal4 = BigDecimal.ONE.movePointLeft(mathContext.getPrecision() + 1);
        double d = bigDecimal.doubleValue();
        if (d > 0.0 && BigDecimalMath.isDoubleValue(bigDecimal)) {
            bigDecimal3 = BigDecimal.valueOf(Math.log(d));
            n = 15;
        } else {
            bigDecimal3 = bigDecimal.divide(H, mathContext);
            n = 1;
        }
        do {
            if ((n *= 3) > n2) {
                n = n2;
            }
            MathContext mathContext2 = new MathContext(n, mathContext.getRoundingMode());
            BigDecimal bigDecimal5 = BigDecimalMath.exp(bigDecimal3, mathContext2);
            bigDecimal2 = H.multiply(bigDecimal.subtract(bigDecimal5)).divide(bigDecimal.add(bigDecimal5), mathContext2);
            bigDecimal3 = bigDecimal3.add(bigDecimal2);
        } while (n < n2 || bigDecimal2.abs().compareTo(bigDecimal4) > 0);
        return bigDecimal3;
    }

    private static BigDecimal logUsingExponent(BigDecimal bigDecimal, MathContext mathContext) {
        MathContext mathContext2 = new MathContext(mathContext.getPrecision() << 1, mathContext.getRoundingMode());
        MathContext mathContext3 = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        int n = BigDecimalMath.exponent(bigDecimal);
        BigDecimal bigDecimal2 = BigDecimalMath.mantissa(bigDecimal);
        BigDecimal bigDecimal3 = BigDecimalMath.logUsingTwoThree(bigDecimal2, mathContext3);
        if (n != 0) {
            bigDecimal3 = bigDecimal3.add(BigDecimal.valueOf(n).multiply(BigDecimalMath.logTen(mathContext2), mathContext3));
        }
        return bigDecimal3;
    }

    private static BigDecimal logUsingTwoThree(BigDecimal bigDecimal, MathContext mathContext) {
        MathContext mathContext2 = new MathContext(mathContext.getPrecision() << 1, mathContext.getRoundingMode());
        MathContext mathContext3 = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        int n4 = 1;
        double d = bigDecimal.doubleValue();
        if (!(d < 0.01)) {
            if (d < 0.1) {
                while (d < 0.6) {
                    d *= 2.0;
                    --n;
                    n2 <<= 1;
                }
            } else if (d < 0.115) {
                n3 = -2;
                n4 = 9;
            } else if (d < 0.14) {
                n = -3;
                n2 = 8;
            } else if (d < 0.2) {
                n = -1;
                n2 = 2;
                n3 = -1;
                n4 = 3;
            } else if (d < 0.3) {
                n = -2;
                n2 = 4;
            } else if (d < 0.42) {
                n3 = -1;
                n4 = 3;
            } else if (d < 0.7) {
                n = -1;
                n2 = 2;
            } else if (!(d < 1.4)) {
                if (d < 2.5) {
                    n = 1;
                    n2 = 2;
                } else if (d < 3.5) {
                    n3 = 1;
                    n4 = 3;
                } else if (d < 5.0) {
                    n = 2;
                    n2 = 4;
                } else if (d < 7.0) {
                    n3 = 1;
                    n4 = 3;
                    n = 1;
                    n2 = 2;
                } else if (d < 8.5) {
                    n = 3;
                    n2 = 8;
                } else if (d < 10.0) {
                    n3 = 2;
                    n4 = 9;
                } else {
                    while (d > 1.4) {
                        d /= 2.0;
                        ++n;
                        n2 <<= 1;
                    }
                }
            }
        }
        BigDecimal bigDecimal2 = bigDecimal;
        BigDecimal bigDecimal3 = BigDecimal.ZERO;
        if (n > 0) {
            bigDecimal2 = bigDecimal2.divide(BigDecimal.valueOf(n2), mathContext3);
            bigDecimal3 = bigDecimal3.add(BigDecimalMath.logTwo(mathContext2).multiply(BigDecimal.valueOf(n), mathContext3));
        } else if (n < 0) {
            bigDecimal2 = bigDecimal2.multiply(BigDecimal.valueOf(n2), mathContext3);
            bigDecimal3 = bigDecimal3.subtract(BigDecimalMath.logTwo(mathContext2).multiply(BigDecimal.valueOf(-n), mathContext3));
        }
        if (n3 > 0) {
            bigDecimal2 = bigDecimal2.divide(BigDecimal.valueOf(n4), mathContext3);
            bigDecimal3 = bigDecimal3.add(BigDecimalMath.logThree(mathContext2).multiply(BigDecimal.valueOf(n3), mathContext3));
        } else if (n3 < 0) {
            bigDecimal2 = bigDecimal2.multiply(BigDecimal.valueOf(n4), mathContext3);
            bigDecimal3 = bigDecimal3.subtract(BigDecimalMath.logThree(mathContext2).multiply(BigDecimal.valueOf(-n3), mathContext3));
        }
        if (bigDecimal == bigDecimal2 && bigDecimal3 == BigDecimal.ZERO) {
            return BigDecimalMath.logUsingNewton(bigDecimal, mathContext);
        }
        bigDecimal3 = bigDecimal3.add(BigDecimalMath.logUsingNewton(bigDecimal2, mathContext3), mathContext3);
        return bigDecimal3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigDecimal pi(MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        BigDecimal bigDecimal = null;
        Object object = R;
        synchronized (object) {
            if (I == null || mathContext.getPrecision() > I.precision()) {
                I = BigDecimalMath.piChudnovski(mathContext);
                return I;
            }
            bigDecimal = I;
        }
        return BigDecimalMath.round(bigDecimal, mathContext);
    }

    private static BigDecimal piChudnovski(MathContext mathContext) {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2;
        MathContext mathContext2 = new MathContext(mathContext.getPrecision() + 10, mathContext.getRoundingMode());
        BigDecimal bigDecimal3 = BigDecimal.valueOf(24L);
        BigDecimal bigDecimal4 = BigDecimal.valueOf(640320L);
        BigDecimal bigDecimal5 = BigDecimal.valueOf(13591409L);
        BigDecimal bigDecimal6 = BigDecimal.valueOf(545140134L);
        BigDecimal bigDecimal7 = bigDecimal4.pow(3).divide(bigDecimal3, mathContext2);
        BigDecimal bigDecimal8 = BigDecimal.ONE;
        BigDecimal bigDecimal9 = BigDecimal.ZERO;
        BigDecimal bigDecimal10 = BigDecimal.ONE;
        long l = 5L;
        long l2 = -1L;
        long l3 = -1L;
        BigDecimal bigDecimal11 = BigDecimal.ZERO;
        long l4 = (mathContext2.getPrecision() + 13) / 14;
        for (long i = 1L; i <= l4; ++i) {
            bigDecimal2 = BigDecimal.valueOf(i);
            bigDecimal = BigDecimal.valueOf(l += -6L).multiply(BigDecimal.valueOf(l2 += 2L)).multiply(BigDecimal.valueOf(l3 += 6L));
            bigDecimal11 = bigDecimal2.pow(3);
            BigDecimal bigDecimal12 = bigDecimal11.multiply(bigDecimal7, mathContext2);
            bigDecimal10 = bigDecimal10.multiply(bigDecimal).divide(bigDecimal12, mathContext2);
            BigDecimal bigDecimal13 = bigDecimal2.multiply(bigDecimal10, mathContext2);
            bigDecimal8 = bigDecimal8.add(bigDecimal10);
            bigDecimal9 = bigDecimal9.add(bigDecimal13);
        }
        BigDecimal bigDecimal14 = BigDecimal.valueOf(426880L);
        BigDecimal bigDecimal15 = BigDecimal.valueOf(10005L);
        bigDecimal2 = bigDecimal14.multiply(BigDecimalMath.sqrt(bigDecimal15, mathContext2));
        bigDecimal = bigDecimal2.divide(bigDecimal5.multiply(bigDecimal8, mathContext2).add(bigDecimal6.multiply(bigDecimal9, mathContext2)), mathContext2);
        return BigDecimalMath.round(bigDecimal, mathContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigDecimal e(MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        BigDecimal bigDecimal = null;
        Object object = N;
        synchronized (object) {
            if (B == null || mathContext.getPrecision() > B.precision()) {
                B = BigDecimalMath.exp(BigDecimal.ONE, mathContext);
                return B;
            }
            bigDecimal = B;
        }
        return BigDecimalMath.round(bigDecimal, mathContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BigDecimal logTen(MathContext mathContext) {
        BigDecimal bigDecimal = null;
        Object object = C;
        synchronized (object) {
            if (D == null || mathContext.getPrecision() > D.precision()) {
                D = BigDecimalMath.logUsingNewton(BigDecimal.TEN, mathContext);
                return D;
            }
            bigDecimal = D;
        }
        return BigDecimalMath.round(bigDecimal, mathContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BigDecimal logTwo(MathContext mathContext) {
        BigDecimal bigDecimal = null;
        Object object = U;
        synchronized (object) {
            if (G == null || mathContext.getPrecision() > G.precision()) {
                G = BigDecimalMath.logUsingNewton(H, mathContext);
                return G;
            }
            bigDecimal = G;
        }
        return BigDecimalMath.round(bigDecimal, mathContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BigDecimal logThree(MathContext mathContext) {
        BigDecimal bigDecimal = null;
        Object object = E;
        synchronized (object) {
            if (J == null || mathContext.getPrecision() > J.precision()) {
                J = BigDecimalMath.logUsingNewton(S, mathContext);
                return J;
            }
            bigDecimal = J;
        }
        return BigDecimalMath.round(bigDecimal, mathContext);
    }

    public static BigDecimal exp(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        if (bigDecimal.signum() == 0) {
            return BigDecimal.ONE;
        }
        return BigDecimalMath.expIntegralFractional(bigDecimal, mathContext);
    }

    private static BigDecimal expIntegralFractional(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimal bigDecimal2 = BigDecimalMath.integralPart(bigDecimal);
        if (bigDecimal2.signum() == 0) {
            return BigDecimalMath.expTaylor(bigDecimal, mathContext);
        }
        BigDecimal bigDecimal3 = bigDecimal.subtract(bigDecimal2);
        MathContext mathContext2 = new MathContext(mathContext.getPrecision() + 10, mathContext.getRoundingMode());
        BigDecimal bigDecimal4 = BigDecimal.ONE.add(bigDecimal3.divide(bigDecimal2, mathContext2));
        BigDecimal bigDecimal5 = BigDecimalMath.expTaylor(bigDecimal4, mathContext2);
        BigDecimal bigDecimal6 = BigDecimalMath.pow(bigDecimal5, bigDecimal2.intValueExact(), mathContext2);
        return BigDecimalMath.round(bigDecimal6, mathContext);
    }

    private static BigDecimal expTaylor(BigDecimal bigDecimal, MathContext mathContext) {
        MathContext mathContext2 = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        bigDecimal = bigDecimal.divide(BigDecimal.valueOf(256L), mathContext2);
        BigDecimal bigDecimal2 = ExpCalculator.INSTANCE.calculate(bigDecimal, mathContext2);
        bigDecimal2 = BigDecimalMath.pow(bigDecimal2, 256L, mathContext2);
        return BigDecimalMath.round(bigDecimal2, mathContext);
    }

    public static BigDecimal sin(BigDecimal bigDecimal, MathContext mathContext) {
        Serializable serializable;
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mathContext2 = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        if (bigDecimal.abs().compareTo(K) > 0) {
            serializable = new MathContext(mathContext2.getPrecision() + 4, mathContext.getRoundingMode());
            BigDecimal bigDecimal2 = H.multiply(BigDecimalMath.pi((MathContext)serializable));
            bigDecimal = bigDecimal.remainder(bigDecimal2, (MathContext)serializable);
        }
        serializable = SinCalculator.INSTANCE.calculate(bigDecimal, mathContext2);
        return BigDecimalMath.round(serializable, mathContext);
    }

    public static BigDecimal asin(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        if (bigDecimal.compareTo(BigDecimal.ONE) > 0) {
            throw new ArithmeticException("Illegal asin(x) for x > 1: x = " + bigDecimal);
        }
        if (bigDecimal.compareTo(T) < 0) {
            throw new ArithmeticException("Illegal asin(x) for x < -1: x = " + bigDecimal);
        }
        if (bigDecimal.signum() == -1) {
            return BigDecimalMath.asin(bigDecimal.negate(), mathContext).negate();
        }
        MathContext mathContext2 = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        if (bigDecimal.compareTo(BigDecimal.valueOf(0.707107)) >= 0) {
            BigDecimal bigDecimal2 = BigDecimalMath.sqrt(BigDecimal.ONE.subtract(bigDecimal.multiply(bigDecimal)), mathContext2);
            return BigDecimalMath.acos(bigDecimal2, mathContext);
        }
        BigDecimal bigDecimal3 = AsinCalculator.INSTANCE.calculate(bigDecimal, mathContext2);
        return BigDecimalMath.round(bigDecimal3, mathContext);
    }

    public static BigDecimal cos(BigDecimal bigDecimal, MathContext mathContext) {
        Serializable serializable;
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mathContext2 = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        if (bigDecimal.abs().compareTo(K) > 0) {
            serializable = new MathContext(mathContext2.getPrecision() + 4, mathContext.getRoundingMode());
            BigDecimal bigDecimal2 = H.multiply(BigDecimalMath.pi((MathContext)serializable), (MathContext)serializable);
            bigDecimal = bigDecimal.remainder(bigDecimal2, (MathContext)serializable);
        }
        serializable = CosCalculator.INSTANCE.calculate(bigDecimal, mathContext2);
        return BigDecimalMath.round(serializable, mathContext);
    }

    public static BigDecimal acos(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        if (bigDecimal.compareTo(BigDecimal.ONE) > 0) {
            throw new ArithmeticException("Illegal acos(x) for x > 1: x = " + bigDecimal);
        }
        if (bigDecimal.compareTo(T) < 0) {
            throw new ArithmeticException("Illegal acos(x) for x < -1: x = " + bigDecimal);
        }
        MathContext mathContext2 = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        BigDecimal bigDecimal2 = BigDecimalMath.pi(mathContext2).divide(H, mathContext2).subtract(BigDecimalMath.asin(bigDecimal, mathContext2));
        return BigDecimalMath.round(bigDecimal2, mathContext);
    }

    public static BigDecimal tan(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        if (bigDecimal.signum() == 0) {
            return BigDecimal.ZERO;
        }
        MathContext mathContext2 = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        BigDecimal bigDecimal2 = BigDecimalMath.sin(bigDecimal, mathContext2).divide(BigDecimalMath.cos(bigDecimal, mathContext2), mathContext2);
        return BigDecimalMath.round(bigDecimal2, mathContext);
    }

    public static BigDecimal atan(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mathContext2 = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        bigDecimal = bigDecimal.divide(BigDecimalMath.sqrt(BigDecimal.ONE.add(bigDecimal.multiply(bigDecimal, mathContext2)), mathContext2), mathContext2);
        BigDecimal bigDecimal2 = BigDecimalMath.asin(bigDecimal, mathContext2);
        return BigDecimalMath.round(bigDecimal2, mathContext);
    }

    public static BigDecimal atan2(BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mathContext2 = new MathContext(mathContext.getPrecision() + 3, mathContext.getRoundingMode());
        if (bigDecimal2.signum() > 0) {
            return BigDecimalMath.atan(bigDecimal.divide(bigDecimal2, mathContext2), mathContext);
        }
        if (bigDecimal2.signum() < 0) {
            if (bigDecimal.signum() > 0) {
                return BigDecimalMath.atan(bigDecimal.divide(bigDecimal2, mathContext2), mathContext2).add(BigDecimalMath.pi(mathContext2), mathContext);
            }
            if (bigDecimal.signum() < 0) {
                return BigDecimalMath.atan(bigDecimal.divide(bigDecimal2, mathContext2), mathContext2).subtract(BigDecimalMath.pi(mathContext2), mathContext);
            }
            return BigDecimalMath.pi(mathContext);
        }
        if (bigDecimal.signum() > 0) {
            return BigDecimalMath.pi(mathContext2).divide(H, mathContext);
        }
        if (bigDecimal.signum() < 0) {
            return BigDecimalMath.pi(mathContext2).divide(H, mathContext).negate();
        }
        throw new ArithmeticException("Illegal atan2(y, x) for x = 0; y = 0");
    }

    public static BigDecimal cot(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        if (bigDecimal.signum() == 0) {
            throw new ArithmeticException("Illegal cot(x) for x = 0");
        }
        MathContext mathContext2 = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        BigDecimal bigDecimal2 = BigDecimalMath.cos(bigDecimal, mathContext2).divide(BigDecimalMath.sin(bigDecimal, mathContext2), mathContext2);
        return BigDecimalMath.round(bigDecimal2, mathContext);
    }

    public static BigDecimal acot(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mathContext2 = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        BigDecimal bigDecimal2 = BigDecimalMath.pi(mathContext2).divide(H, mathContext2).subtract(BigDecimalMath.atan(bigDecimal, mathContext2));
        return BigDecimalMath.round(bigDecimal2, mathContext);
    }

    public static BigDecimal sinh(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mathContext2 = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        BigDecimal bigDecimal2 = SinhCalculator.INSTANCE.calculate(bigDecimal, mathContext2);
        return BigDecimalMath.round(bigDecimal2, mathContext);
    }

    public static BigDecimal cosh(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mathContext2 = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        BigDecimal bigDecimal2 = CoshCalculator.INSTANCE.calculate(bigDecimal, mathContext2);
        return BigDecimalMath.round(bigDecimal2, mathContext);
    }

    public static BigDecimal tanh(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mathContext2 = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        BigDecimal bigDecimal2 = BigDecimalMath.sinh(bigDecimal, mathContext2).divide(BigDecimalMath.cosh(bigDecimal, mathContext2), mathContext2);
        return BigDecimalMath.round(bigDecimal2, mathContext);
    }

    public static BigDecimal coth(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mathContext2 = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        BigDecimal bigDecimal2 = BigDecimalMath.cosh(bigDecimal, mathContext2).divide(BigDecimalMath.sinh(bigDecimal, mathContext2), mathContext2);
        return BigDecimalMath.round(bigDecimal2, mathContext);
    }

    public static BigDecimal asinh(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mathContext2 = new MathContext(mathContext.getPrecision() + 10, mathContext.getRoundingMode());
        BigDecimal bigDecimal2 = BigDecimalMath.log(bigDecimal.add(BigDecimalMath.sqrt(bigDecimal.multiply(bigDecimal, mathContext2).add(BigDecimal.ONE, mathContext2), mathContext2)), mathContext2);
        return BigDecimalMath.round(bigDecimal2, mathContext);
    }

    public static BigDecimal acosh(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mathContext2 = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        BigDecimal bigDecimal2 = BigDecimalMath.log(bigDecimal.add(BigDecimalMath.sqrt(bigDecimal.multiply(bigDecimal).subtract(BigDecimal.ONE), mathContext2)), mathContext2);
        return BigDecimalMath.round(bigDecimal2, mathContext);
    }

    public static BigDecimal atanh(BigDecimal bigDecimal, MathContext mathContext) {
        if (bigDecimal.compareTo(BigDecimal.ONE) >= 0) {
            throw new ArithmeticException("Illegal atanh(x) for x >= 1: x = " + bigDecimal);
        }
        if (bigDecimal.compareTo(T) <= 0) {
            throw new ArithmeticException("Illegal atanh(x) for x <= -1: x = " + bigDecimal);
        }
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mathContext2 = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        BigDecimal bigDecimal2 = BigDecimalMath.log(BigDecimal.ONE.add(bigDecimal).divide(BigDecimal.ONE.subtract(bigDecimal), mathContext2), mathContext2).multiply(Q);
        return BigDecimalMath.round(bigDecimal2, mathContext);
    }

    public static BigDecimal acoth(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mathContext2 = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        BigDecimal bigDecimal2 = BigDecimalMath.log(bigDecimal.add(BigDecimal.ONE).divide(bigDecimal.subtract(BigDecimal.ONE), mathContext2), mathContext2).multiply(Q);
        return BigDecimalMath.round(bigDecimal2, mathContext);
    }

    public static BigDecimal toDegrees(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mathContext2 = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        BigDecimal bigDecimal2 = bigDecimal.multiply(M.divide(BigDecimalMath.pi(mathContext2), mathContext2), mathContext2);
        return BigDecimalMath.round(bigDecimal2, mathContext);
    }

    public static BigDecimal toRadians(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimalMath.checkMathContext(mathContext);
        MathContext mathContext2 = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        BigDecimal bigDecimal2 = bigDecimal.multiply(BigDecimalMath.pi(mathContext2).divide(M, mathContext2), mathContext2);
        return BigDecimalMath.round(bigDecimal2, mathContext);
    }

    private static void checkMathContext(MathContext mathContext) {
        if (mathContext.getPrecision() == 0) {
            throw new UnsupportedOperationException("Unlimited MathContext not supported");
        }
    }

    private static boolean isFinite(double d) {
        return Math.abs(d) <= Double.MAX_VALUE;
    }

    static {
        BigDecimal bigDecimal;
        H = BigDecimal.valueOf(2L);
        S = BigDecimal.valueOf(3L);
        T = BigDecimal.valueOf(-1L);
        Q = BigDecimal.valueOf(0.5);
        M = BigDecimal.valueOf(180L);
        F = BigDecimal.valueOf(Double.MAX_VALUE);
        U = new Object();
        E = new Object();
        C = new Object();
        R = new Object();
        N = new Object();
        K = new BigDecimal("3.141592653589793").multiply(H);
        L = new BigDecimal[100];
        BigDecimalMath.L[0] = bigDecimal = BigDecimal.ONE;
        for (int i = 1; i < L.length; ++i) {
            BigDecimalMath.L[i] = bigDecimal = bigDecimal.multiply(BigDecimal.valueOf(i));
        }
        A = new HashMap<Integer, List<BigDecimal>>();
        O = new Object();
    }
}

